/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoApiType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.mapper.VersionBoFieldExMapper;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionBoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBo;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoApi;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoApiDetail;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoDataRule;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApiDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRuleDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleDetailService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoApiDetailRepository;
import com.xforceplus.ultraman.metadata.repository.common.CommonService;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import io.vavr.Tuple6;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoVersionDiffQuery {
    private static final Logger log = LoggerFactory.getLogger(BoVersionDiffQuery.class);
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private CommonService commonService;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private VersionBoFieldExMapper versionBoFieldExMapper;
    @Autowired
    private BoApiDetailRepository boApiDetailRepository;
    @Autowired
    private IBoDataRuleDetailService boDataRuleDetailService;

    public HashMap<String, VersionBo> getVersionBos(Long appId, Long appVersionId, boolean sysExclusive) {
        String version = null == appVersionId ? (String)this.defaultModuleService.getModule(appId.longValue()).map(Module::getVersion).orElse(null) : (String)this.appVersionQuery.getAppVersionChange(appVersionId, MetadataType.BO).map(AppVersionChange::getResourceVersion).orElse(null);
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Maps.newHashMap();
        }
        return (HashMap)this.getVersionBos(appId, version, sysExclusive);
    }

    public HashMap<String, VersionBo> getVersionBos(Long appId, Long appVersionId) {
        return this.getVersionBos(appId, appVersionId, false);
    }

    public Map<String, VersionBo> getVersionBos(Long moduleId, PublishFlag publishFlag) {
        HashMap result = Maps.newHashMap();
        List boIds = this.defaultModuleService.getBoIds(moduleId);
        if (boIds.isEmpty()) {
            return result;
        }
        Tuple6 boTuple = this.commonService.getBoInfoTuple(boIds);
        Map<Long, Long> boIdMap = PublishFlag.PUBLISHED.equals((Object)publishFlag) ? ((List)boTuple._1).stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId)) : ((List)boTuple._1).stream().collect(Collectors.toMap(Bo::getId, Bo::getId));
        Map<Long, Long> boFieldIdMap = PublishFlag.PUBLISHED.equals((Object)publishFlag) ? ((Map)boTuple._5).values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoField::getId, BoField::getPublishFieldId)) : ((Map)boTuple._5).values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoField::getId, BoField::getId));
        ((List)boTuple._1).forEach(bo -> {
            bo.setParentBoId(boIdMap.getOrDefault(bo.getParentBoId(), bo.getParentBoId())).setRefBoId(boIdMap.getOrDefault(bo.getRefBoId(), bo.getRefBoId())).setSyncBoId(boIdMap.getOrDefault(bo.getSyncBoId(), bo.getSyncBoId()));
            VersionBo versionBo = VersionBoStructMapper.MAPPER.toVersionBo((Bo)bo);
            Optional.ofNullable(((Map)boTuple._2).get(bo.getId())).ifPresent(boApis -> {
                List boApiIds = boApis.stream().filter(boApi -> BoApiType.EXTERNAL.code().equals(boApi.getApiType())).map(BoApi::getId).collect(Collectors.toList());
                Map<Long, List<BoApiDetail>> boApiDetailMap = this.boApiDetailRepository.getBoApiDetailsByBoApiIds(boApiIds).stream().collect(Collectors.groupingBy(BoApiDetail::getBoApiId));
                boApis.forEach(boApi -> boApi.setBoId((Long)boIdMap.get(boApi.getBoId())));
                versionBo.setBoApis(boApis.stream().map(boApi -> {
                    VersionBoApi versionBoApi = VersionBoStructMapper.MAPPER.toVersionBoApi((BoApi)boApi);
                    versionBoApi.setDetails(Optional.ofNullable(boApiDetailMap.get(boApi.getId())).map(boApiDetails -> boApiDetails.stream().map(boApiDetail -> new VersionBoApiDetail().setMappingRule(boApiDetail.getMappingRule()).setMappingType(boApiDetail.getMappingType())).collect(Collectors.toMap(d -> String.valueOf(d.getMappingType()), Functions.identity()))).orElse(Maps.newHashMap()));
                    return versionBoApi;
                }).collect(Collectors.toMap(VersionBoApi::getCode, Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._3).get(bo.getId())).ifPresent(boRelationships -> {
                if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                    boRelationships.forEach(boRel -> {
                        boRel.setBoField(boRel.getBoField() == null ? null : (Long)boFieldIdMap.get(boRel.getBoField()));
                        boRel.setJoinField(boRel.getJoinField() == null ? null : boFieldIdMap.getOrDefault(boRel.getJoinField(), boRel.getJoinField()));
                        boRel.setBoId((Long)boIdMap.get(boRel.getBoId()));
                        boRel.setJoinBoId(boIdMap.getOrDefault(boRel.getJoinBoId(), boRel.getJoinBoId()));
                    });
                }
                versionBo.setBoRelationships(boRelationships.stream().map(VersionBoStructMapper.MAPPER::toVersionBoRelationship).collect(Collectors.toMap(vBoRel -> String.valueOf(vBoRel.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._4).get(bo.getId())).ifPresent(boIndexes -> {
                if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                    boIndexes.forEach(boIdx -> boIdx.setBoId((Long)boIdMap.get(boIdx.getBoId())));
                }
                versionBo.setBoIndexes(boIndexes.stream().map(VersionBoStructMapper.MAPPER::toVersionBoIndex).collect(Collectors.toMap(v -> String.valueOf(v.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._5).get(bo.getId())).ifPresent(boFields -> {
                List<VersionBoField> versionBoFields = this.versionBoFieldExMapper.getVersionBoFieldList(boFields.stream().map(BoField::getId).collect(Collectors.toList()));
                if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                    versionBoFields.forEach(vBoField -> vBoField.setBoId((Long)boIdMap.get(vBoField.getBoId())));
                }
                versionBoFields.forEach(vBoField -> {
                    if (FieldType.LOOKUP.code().equals(vBoField.getType())) {
                        vBoField.setLookupFieldId(vBoField.getLookupFieldId() == null ? null : boFieldIdMap.getOrDefault(vBoField.getLookupFieldId(), vBoField.getLookupFieldId()));
                    } else if (FieldType.AGGREGATION.code().equals(vBoField.getType())) {
                        vBoField.setAggregationFieldId(vBoField.getAggregationFieldId() == null ? null : boFieldIdMap.getOrDefault(vBoField.getAggregationFieldId(), vBoField.getAggregationFieldId()));
                    }
                });
                versionBo.setBoFields(versionBoFields.stream().collect(Collectors.toMap(vBoField -> String.valueOf(vBoField.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._6).get(bo.getId())).ifPresent(items -> {
                List boDataRuleIds;
                if (PublishFlag.PUBLISHED.equals((Object)publishFlag)) {
                    items.forEach(item -> item.setBoId((Long)boIdMap.get(item.getBoId())));
                }
                HashMap boDataRuleDetailMap = (boDataRuleIds = items.stream().map(BoDataRule::getId).collect(Collectors.toList())).isEmpty() ? Maps.newHashMap() : this.boDataRuleDetailService.list((Wrapper)Wrappers.lambdaQuery().in(BoDataRuleDetail::getDataRuleId, boDataRuleIds)).stream().collect(Collectors.groupingBy(BoDataRuleDetail::getDataRuleId));
                versionBo.setBoDataRules(items.stream().map(boDataRule -> {
                    VersionBoDataRule versionBoDataRule = VersionBoStructMapper.MAPPER.toVersionBoDataRule((BoDataRule)boDataRule);
                    versionBoDataRule.setDetails(Optional.ofNullable(boDataRuleDetailMap.get(boDataRule.getId())).map(boDataRuleDetails -> boDataRuleDetails.stream().map(VersionBoStructMapper.MAPPER::toVersionBoDataRuleDetail).collect(Collectors.toMap(d -> String.valueOf(d.getEntityAction()), Functions.identity()))).orElse(Maps.newHashMap()));
                    return versionBoDataRule;
                }).collect(Collectors.toMap(o -> String.valueOf(o.getId()), Functions.identity())));
            });
            result.put(String.valueOf(versionBo.getId()), versionBo);
        });
        return result;
    }

    public Map<String, VersionBo> getUnPublishedBos(Long appId) {
        Optional moduleOptional = this.defaultModuleService.getModule(appId.longValue());
        return moduleOptional.isPresent() ? this.getVersionBos(((Module)moduleOptional.get()).getId(), PublishFlag.UNPUBLISHED) : Maps.newHashMap();
    }

    public Map<String, VersionBo> getVersionBos(Long appId, String moduleVersion) {
        return this.getVersionBos(appId, moduleVersion, false);
    }

    public Map<String, VersionBo> getVersionBos(Long appId, String moduleVersion, boolean sysExclusive) {
        HashMap result = Maps.newHashMap();
        if (StringUtils.isEmpty((CharSequence)moduleVersion)) {
            return result;
        }
        Optional moduleOptl = this.defaultModuleService.getPublishedModuleByAppId(appId.longValue(), moduleVersion);
        if (!moduleOptl.isPresent()) {
            return result;
        }
        List boIds = this.defaultModuleService.getBoIds(((Module)moduleOptl.get()).getId());
        if (boIds.isEmpty()) {
            return result;
        }
        Tuple6 boTuple = sysExclusive ? this.commonService.getBoInfoSysExclusiveTuple(boIds) : this.commonService.getBoInfoTuple(boIds);
        Map<Long, Long> boIdMap = ((List)boTuple._1).stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId));
        Map<Long, Long> boFieldIdMap = ((Map)boTuple._5).values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoField::getId, BoField::getPublishFieldId));
        return ((List)boTuple._1).stream().map(bo -> {
            bo.setParentBoId(boIdMap.getOrDefault(bo.getParentBoId(), bo.getParentBoId())).setRefBoId(boIdMap.getOrDefault(bo.getRefBoId(), bo.getRefBoId())).setSyncBoId(boIdMap.getOrDefault(bo.getSyncBoId(), bo.getSyncBoId()));
            VersionBo versionBo = VersionBoStructMapper.MAPPER.toVersionBo((Bo)bo);
            Optional.ofNullable(((Map)boTuple._2).get(bo.getId())).ifPresent(boApis -> {
                List boApiIds = boApis.stream().filter(boApi -> BoApiType.EXTERNAL.code().equals(boApi.getApiType())).map(BoApi::getId).collect(Collectors.toList());
                Map<Long, List<BoApiDetail>> boApiDetailMap = this.boApiDetailRepository.getBoApiDetailsByBoApiIds(boApiIds).stream().collect(Collectors.groupingBy(BoApiDetail::getBoApiId));
                boApis.forEach(boApi -> boApi.setBoId((Long)boIdMap.get(boApi.getBoId())));
                versionBo.setBoApis(boApis.stream().map(boApi -> {
                    VersionBoApi versionBoApi = VersionBoStructMapper.MAPPER.toVersionBoApi((BoApi)boApi);
                    versionBoApi.setDetails(Optional.ofNullable(boApiDetailMap.get(boApi.getId())).map(boApiDetails -> boApiDetails.parallelStream().map(boApiDetail -> new VersionBoApiDetail().setMappingRule(boApiDetail.getMappingRule()).setMappingType(boApiDetail.getMappingType())).collect(Collectors.toMap(d -> String.valueOf(d.getMappingType()), Functions.identity()))).orElse(Maps.newHashMap()));
                    return versionBoApi;
                }).collect(Collectors.toMap(VersionBoApi::getCode, Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._3).get(bo.getId())).ifPresent(boRelationships -> {
                boRelationships.forEach(boRel -> {
                    boRel.setBoField(boRel.getBoField() == null ? null : (Long)boFieldIdMap.get(boRel.getBoField()));
                    boRel.setJoinField(boRel.getJoinField() == null ? null : boFieldIdMap.getOrDefault(boRel.getJoinField(), boRel.getJoinField()));
                    boRel.setBoId((Long)boIdMap.get(boRel.getBoId()));
                    boRel.setJoinBoId(boIdMap.getOrDefault(boRel.getJoinBoId(), boRel.getJoinBoId()));
                });
                versionBo.setBoRelationships(boRelationships.stream().map(VersionBoStructMapper.MAPPER::toVersionBoRelationship).collect(Collectors.toMap(vBoRel -> String.valueOf(vBoRel.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._4).get(bo.getId())).ifPresent(boIndexes -> {
                boIndexes.forEach(boIdx -> boIdx.setBoId((Long)boIdMap.get(boIdx.getBoId())));
                versionBo.setBoIndexes(boIndexes.stream().map(VersionBoStructMapper.MAPPER::toVersionBoIndex).collect(Collectors.toMap(v -> String.valueOf(v.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._5).get(bo.getId())).ifPresent(boFields -> {
                List<VersionBoField> versionBoFields = this.versionBoFieldExMapper.getVersionBoFieldList(boFields.stream().map(BoField::getId).collect(Collectors.toList()));
                versionBoFields.forEach(vBoField -> vBoField.setBoId((Long)boIdMap.get(vBoField.getBoId())));
                versionBoFields.forEach(vBoField -> {
                    if (FieldType.LOOKUP.code().equals(vBoField.getType())) {
                        vBoField.setLookupFieldId(vBoField.getLookupFieldId() == null ? null : boFieldIdMap.getOrDefault(vBoField.getLookupFieldId(), vBoField.getLookupFieldId()));
                    } else if (FieldType.AGGREGATION.code().equals(vBoField.getType())) {
                        vBoField.setAggregationFieldId(vBoField.getAggregationFieldId() == null ? null : boFieldIdMap.getOrDefault(vBoField.getAggregationFieldId(), vBoField.getAggregationFieldId()));
                    }
                });
                versionBo.setBoFields(versionBoFields.stream().collect(Collectors.toMap(vBoField -> String.valueOf(vBoField.getId()), Functions.identity())));
            });
            Optional.ofNullable(((Map)boTuple._6).get(bo.getId())).ifPresent(items -> {
                items.forEach(item -> item.setBoId((Long)boIdMap.get(item.getBoId())));
                List boDataRuleIds = items.stream().map(BoDataRule::getId).collect(Collectors.toList());
                HashMap boDataRuleDetailMap = boDataRuleIds.isEmpty() ? Maps.newHashMap() : this.boDataRuleDetailService.list((Wrapper)Wrappers.lambdaQuery().in(BoDataRuleDetail::getDataRuleId, boDataRuleIds)).stream().collect(Collectors.groupingBy(BoDataRuleDetail::getDataRuleId));
                versionBo.setBoDataRules(items.stream().map(boDataRule -> {
                    VersionBoDataRule versionBoDataRule = VersionBoStructMapper.MAPPER.toVersionBoDataRule((BoDataRule)boDataRule);
                    versionBoDataRule.setDetails(Optional.ofNullable(boDataRuleDetailMap.get(boDataRule.getId())).map(boDataRuleDetails -> boDataRuleDetails.stream().map(VersionBoStructMapper.MAPPER::toVersionBoDataRuleDetail).collect(Collectors.toMap(d -> String.valueOf(d.getEntityAction()), Functions.identity()))).orElse(Maps.newHashMap()));
                    return versionBoDataRule;
                }).collect(Collectors.toMap(o -> String.valueOf(o.getId()), Functions.identity())));
            });
            return versionBo;
        }).collect(Collectors.toMap(versionBo -> String.valueOf(versionBo.getId()), Functions.identity()));
    }
}

