/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionFlowStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionFlowAction;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionFlowActionParam;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowActionParam;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowActionVersionDiffQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IFlowActionService flowActionService;
    @Autowired
    private IFlowActionParamService flowActionParamService;

    public HashMap<String, VersionFlowAction> getVersionFlowActions(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionFlowActions(appId);
        }
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appVersionId, MetadataType.FLOW_ACTION).orElse(null);
        return versionChange == null ? Maps.newHashMap() : (HashMap)this.getPublishedVersionFlowActions(appId, versionChange.getResourceVersion());
    }

    public Map<String, VersionFlowAction> getLatestVersionFlowActions(Long appId) {
        ArrayList pFlowActions;
        List flowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).isNull(FlowAction::getPublishActionId)).eq(FlowAction::getDeleteFlag, (Object)"1"));
        if (flowActions.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper flowActionWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).isNotNull(FlowAction::getPublishActionId)).eq(FlowAction::getDeleteFlag, (Object)"1")).and(w -> flowActions.forEach(action -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.or()).eq(FlowAction::getPublishActionId, (Object)action.getId())).eq(FlowAction::getVersion, (Object)action.getVersion());
        }));
        List list = pFlowActions = flowActions.isEmpty() ? Lists.newArrayList() : this.flowActionService.list((Wrapper)flowActionWrapper);
        if (pFlowActions.isEmpty()) {
            return Maps.newHashMap();
        }
        List pFlowActionIds = pFlowActions.stream().map(FlowAction::getId).collect(Collectors.toList());
        Map<Long, List<FlowActionParam>> flowActionParamMap = this.flowActionParamService.list((Wrapper)Wrappers.lambdaQuery().in(FlowActionParam::getActionId, pFlowActionIds)).stream().collect(Collectors.groupingBy(FlowActionParam::getActionId));
        return pFlowActions.stream().map(pFlowAction -> {
            VersionFlowAction versionFlowAction = VersionFlowStructMapper.MAPPER.toVersionFlowAction((FlowAction)pFlowAction);
            Optional.ofNullable(flowActionParamMap.get(pFlowAction.getId())).ifPresent(flowActionParams -> {
                Map<String, VersionFlowActionParam> versionFlowActionParams = flowActionParams.parallelStream().map(VersionFlowStructMapper.MAPPER::toVersionFlowActionParam).collect(Collectors.toMap(v -> String.format("%s###%s", v.getParamType(), v.getParamIndex()), Functions.identity()));
                versionFlowAction.setFlowActionParams(versionFlowActionParams);
            });
            return versionFlowAction;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public String getLatestFlowActionVersion(Long appId) {
        List uFlowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getDeleteFlag, (Object)"1")).isNull(FlowAction::getPublishActionId)).orderByDesc(FlowAction::getId));
        return this.getLatestFlowActionVersion(appId, uFlowActions);
    }

    public String getLatestFlowActionVersion(Long appId, List<FlowAction> uFlowActions) {
        if (uFlowActions.isEmpty()) {
            List pFlowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getDeleteFlag, (Object)"1")).isNotNull(FlowAction::getPublishActionId)).orderByDesc(FlowAction::getId));
            return pFlowActions.isEmpty() ? null : ((FlowAction)pFlowActions.get(0)).getVersion();
        }
        return uFlowActions.get(0).getVersion();
    }

    public Map<String, VersionFlowAction> getUnPublishedFlowActions(Long appId) {
        List flowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getDeleteFlag, (Object)"1")).isNull(FlowAction::getPublishActionId));
        if (flowActions.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, List<FlowActionParam>> flowActionParamsMap = this.flowActionParamService.list((Wrapper)Wrappers.lambdaQuery().in(FlowActionParam::getActionId, (Collection)flowActions.stream().map(FlowAction::getId).collect(Collectors.toList()))).stream().collect(Collectors.groupingBy(FlowActionParam::getActionId));
        return flowActions.stream().map(flowAction -> {
            VersionFlowAction versionFlowAction = VersionFlowStructMapper.MAPPER.toVersionFlowAction((FlowAction)flowAction);
            Optional.ofNullable(flowActionParamsMap.get(flowAction.getId())).ifPresent(flowActionParams -> versionFlowAction.setFlowActionParams(flowActionParams.stream().map(VersionFlowStructMapper.MAPPER::toVersionFlowActionParam).collect(Collectors.toMap(v -> String.format("%s###%s", v.getParamType(), v.getParamIndex()), Functions.identity()))));
            return versionFlowAction;
        }).collect(Collectors.toMap(flowAction -> String.valueOf(flowAction.getId()), Functions.identity()));
    }

    public Map<String, VersionFlowAction> getPublishedVersionFlowActions(Long appId, String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Maps.newHashMap();
        }
        List flowActions = this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getDeleteFlag, (Object)"1")).isNotNull(FlowAction::getPublishActionId)).eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getVersion, (Object)version));
        if (flowActions.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, List<FlowActionParam>> flowActionParamsMap = this.flowActionParamService.list((Wrapper)Wrappers.lambdaQuery().in(FlowActionParam::getActionId, (Collection)flowActions.stream().map(FlowAction::getId).collect(Collectors.toList()))).stream().collect(Collectors.groupingBy(FlowActionParam::getActionId));
        return flowActions.stream().map(flowAction -> {
            VersionFlowAction versionFlowAction = VersionFlowStructMapper.MAPPER.toVersionFlowAction((FlowAction)flowAction);
            Optional.ofNullable(flowActionParamsMap.get(flowAction.getId())).ifPresent(flowActionParams -> versionFlowAction.setFlowActionParams(flowActionParams.stream().map(flowActionParam -> new VersionFlowActionParam().setActionId(flowAction.getPublishActionId()).setParamName(flowActionParam.getParamName()).setParamIndex(flowActionParam.getParamIndex()).setParamType(flowActionParam.getParamType()).setParamSchema(flowActionParam.getParamSchema())).collect(Collectors.toMap(v -> String.format("%s###%s", v.getParamType(), v.getParamIndex()), Functions.identity()))));
            return versionFlowAction;
        }).collect(Collectors.toMap(versionFlowAction -> String.valueOf(versionFlowAction.getId()), Functions.identity()));
    }
}

