/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionUltFormStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FormVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionForm;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.UltFormMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVersionDiffQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private UltFormMapper ultFormMapper;
    @Autowired
    private UltFormRepository ultFormRepository;
    @Autowired
    private FormVersionQuery formVersionQuery;

    public HashMap<String, VersionForm> getVersionForms(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionForms(appId);
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.FORM);
        return (HashMap)this.getVersionForms(appId, versionChanges, true);
    }

    public HashMap<String, VersionForm> getVersionFormsNoSetting(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionFormsNoSetting(appId);
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.FORM);
        return (HashMap)this.getVersionFormsNoSetting(appId, versionChanges);
    }

    public Map<String, VersionForm> getLatestVersionForms(Long appId) {
        return this.formVersionQuery.getLatestVersionForms(appId).stream().map(pUltForm -> {
            VersionForm versionForm = VersionUltFormStructMapper.MAPPER.toVersionForm((UltForm)pUltForm);
            versionForm.setSetting(JSON.parse((String)pUltForm.getSetting()));
            return versionForm;
        }).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }

    public Map<String, VersionForm> getLatestVersionFormsNoSetting(Long appId) {
        return this.formVersionQuery.getLatestVersionFormsNoSetting(appId).stream().map(VersionUltFormStructMapper.MAPPER::toVersionForm).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }

    public Map<String, VersionForm> getUnPublishedFormsNoSetting(Long appId) {
        return this.ultFormRepository.getFormsWithoutSetting(appId).stream().map(VersionUltFormStructMapper.MAPPER::toVersionForm).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }

    public Map<String, VersionForm> getVersionForms(Long appId, List<AppVersionChange> formChanges) {
        return this.getVersionForms(appId, formChanges, true);
    }

    public Map<String, VersionForm> getVersionForms(Long appId, List<AppVersionChange> formChanges, boolean parseSetting) {
        List finalFormChanges = formChanges.stream().filter(chg -> null != chg.getResourceId()).collect(Collectors.toList());
        if (finalFormChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getDeleteFlag, (Object)"1")).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalFormChanges.forEach(formChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltForm::getPublishRefFormId, (Object)formChange.getResourceId())).eq(UltForm::getVersion, (Object)formChange.getResourceVersion());
            });
        }));
        return this.ultFormMapper.selectList((Wrapper)wrapper).stream().map(pUltForm -> {
            VersionForm versionForm = VersionUltFormStructMapper.MAPPER.toVersionForm((UltForm)pUltForm);
            if (parseSetting) {
                versionForm.setSetting(JSON.parse((String)pUltForm.getSetting()));
            } else {
                versionForm.setSetting(pUltForm.getSetting());
            }
            return versionForm;
        }).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }

    public Map<String, VersionForm> getVersionForms(Long appId, AppVersion appVersion) {
        Optional<AppVersion> lastAppVersionOptional = this.appVersionQuery.getLatestMainVersionLeThanId(appId, appVersion.getId());
        if (!lastAppVersionOptional.isPresent()) {
            return Maps.newHashMap();
        }
        AppVersion lastAppVersion = lastAppVersionOptional.get();
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(lastAppVersion.getId(), MetadataType.FORM);
        if (versionChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        return this.getVersionForms(appId, versionChanges);
    }

    public Map<String, VersionForm> getVersionFormsNoSetting(Long appId, List<AppVersionChange> formChanges) {
        List finalFormChanges = formChanges.stream().filter(chg -> null != chg.getResourceId()).collect(Collectors.toList());
        if (finalFormChanges.isEmpty()) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(UltForm.class, field -> !field.getColumn().equals("setting")).eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getDeleteFlag, (Object)"1")).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalFormChanges.forEach(formChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltForm::getPublishRefFormId, (Object)formChange.getResourceId())).eq(UltForm::getVersion, (Object)formChange.getResourceVersion());
            });
        }));
        return this.ultFormMapper.selectList((Wrapper)wrapper).stream().map(VersionUltFormStructMapper.MAPPER::toVersionForm).collect(Collectors.toMap(form -> String.valueOf(form.getId()), Functions.identity()));
    }
}

