/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.alibaba.fastjson2.JSON;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionUltPageStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPage;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionPageBo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageVersionDiffQuery {
    private static final Logger log = LoggerFactory.getLogger(PageVersionDiffQuery.class);
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private UltPageRepository ultPageRepository;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;
    @Autowired
    private PageVersionQuery pageVersionQuery;

    public HashMap<String, VersionPage> getVersionPages(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionPages(appId);
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.PAGE);
        return versionChanges.isEmpty() ? Maps.newHashMap() : (HashMap)this.getVersionPages(appId, versionChanges);
    }

    public Map<String, VersionPage> getLatestVersionPages(Long appId) {
        List<UltPage> pUltPages = this.pageVersionQuery.getLatestVersionPagesWhenNoAppVersion(appId);
        if (pUltPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = pUltPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> pageBoSettingMap = this.pageBoSettingRepository.getPageBoSettingsByPageIds(pageIds).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return pUltPages.stream().map(pUltPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)pUltPage);
            Optional.ofNullable(pageBoSettingMap.get(pUltPage.getId())).ifPresent(pageBoSettings -> {
                Map<String, VersionPageBo> versionPageBos = pageBoSettings.parallelStream().map(pageBoSetting -> new VersionPageBo().setId(pageBoSetting.getUniqueId()).setPageId(pUltPage.getPublishRefPageId()).setBoCode(pageBoSetting.getBoCode()).setBoName(pageBoSetting.getBoName()).setSortPlace(pageBoSetting.getSortPlace()).setRemark(pageBoSetting.getRemark()).setDisabledFlag(pageBoSetting.getDisabledFlag()).setSetting(JSON.parse((String)pageBoSetting.getSetting())).setOriginId(pageBoSetting.getId())).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public Map<String, VersionPage> getVersionPages(Long appId, List<AppVersionChange> pageChanges) {
        List<UltPage> pUltPages = this.pageVersionQuery.getPages(appId, pageChanges, true);
        if (pUltPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = pUltPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> pageBoSettingMap = this.pageBoSettingRepository.getPageBoSettingsByPageIds(pageIds).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return pUltPages.stream().map(pUltPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)pUltPage);
            Optional.ofNullable(pageBoSettingMap.get(pUltPage.getId())).ifPresent(pageBoSettings -> {
                Map<String, VersionPageBo> versionPageBos = pageBoSettings.parallelStream().map(pageBoSetting -> new VersionPageBo().setId(pageBoSetting.getUniqueId()).setPageId(pUltPage.getPublishRefPageId()).setBoCode(pageBoSetting.getBoCode()).setBoName(pageBoSetting.getBoName()).setSortPlace(pageBoSetting.getSortPlace()).setRemark(pageBoSetting.getRemark()).setDisabledFlag(pageBoSetting.getDisabledFlag()).setSetting(JSON.parse((String)pageBoSetting.getSetting())).setOriginId(pageBoSetting.getId())).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public HashMap<String, VersionPage> getVersionPagesNoSetting(Long appId, Long appVersionId) {
        if (null == appVersionId) {
            return (HashMap)this.getLatestVersionPagesNoSetting(appId);
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.PAGE);
        return (HashMap)this.getVersionPagesNoSetting(appId, versionChanges);
    }

    public Map<String, VersionPage> getLatestVersionPagesNoSetting(Long appId) {
        List<UltPage> pUltPages = this.pageVersionQuery.getLatestVersionPagesWhenNoAppVersion(appId);
        if (pUltPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = pUltPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> pageBoSettingMap = this.pageBoSettingRepository.getPageBoSettingsByPageIdsWithoutSetting(pageIds).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return pUltPages.stream().map(pUltPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)pUltPage);
            Optional.ofNullable(pageBoSettingMap.get(pUltPage.getId())).ifPresent(pageBoSettings -> {
                Map<String, VersionPageBo> versionPageBos = pageBoSettings.parallelStream().map(pageBoSetting -> VersionUltPageStructMapper.MAPPER.toVersionPageBo((PageBoSetting)pageBoSetting, (UltPage)pUltPage)).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public Map<String, VersionPage> getUnPublishedPagesNoSetting(Long appId) {
        List ultPages = this.ultPageRepository.getPages(appId);
        if (ultPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = ultPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> versionPageSettingMap = this.pageBoSettingRepository.getPageBoSettingsByPageIdsWithoutSetting(pageIds).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return ultPages.stream().map(ultPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)ultPage);
            Optional.ofNullable(versionPageSettingMap.get(versionPage.getId())).ifPresent(vPageSettings -> {
                Map<String, VersionPageBo> versionPageBos = vPageSettings.parallelStream().map(VersionUltPageStructMapper.MAPPER::toVersionPageBo).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }

    public Map<String, VersionPage> getVersionPagesNoSetting(Long appId, List<AppVersionChange> pageChanges) {
        List<UltPage> pUltPages = this.pageVersionQuery.getPages(appId, pageChanges, true);
        if (pUltPages.isEmpty()) {
            return Maps.newHashMap();
        }
        List pageIds = pUltPages.stream().map(UltPage::getId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> pageBoSettingMap = this.pageBoSettingRepository.getPageBoSettingsByPageIdsWithoutSetting(pageIds).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        return pUltPages.stream().map(pUltPage -> {
            VersionPage versionPage = VersionUltPageStructMapper.MAPPER.toVersionPage((UltPage)pUltPage);
            Optional.ofNullable(pageBoSettingMap.get(pUltPage.getId())).ifPresent(pageBoSettings -> {
                Map<String, VersionPageBo> versionPageBos = pageBoSettings.parallelStream().map(pageBoSetting -> VersionUltPageStructMapper.MAPPER.toVersionPageBo((PageBoSetting)pageBoSetting, (UltPage)pUltPage)).collect(Collectors.toMap(pagebo -> String.valueOf(pagebo.getId()), Functions.identity()));
                versionPage.setPageBoSettings(versionPageBos);
            });
            return versionPage;
        }).collect(Collectors.toMap(page -> String.valueOf(page.getId()), Functions.identity()));
    }
}

