/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.diff.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionSueTagStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionTag;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueTagService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TagVersionDiffQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private ISueTagService sueTagService;

    public HashMap<String, VersionTag> getVersionTags(Long appId, Long appVersionId) {
        AppVersionChange dictVersionChange;
        String version = null == appVersionId ? this.getLatestTagVersion(appId) : ((dictVersionChange = (AppVersionChange)this.appVersionQuery.getAppVersionChange(appVersionId, MetadataType.TAG).orElse(null)) == null ? null : dictVersionChange.getResourceVersion());
        return null == version ? Maps.newHashMap() : (HashMap)this.getPublishedVersionTags(appId, version);
    }

    public String getLatestTagVersion(Long appId) {
        List uSueTag = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).orderByDesc(SueTag::getCreateTime));
        return this.getLatestTagVersion(appId, uSueTag);
    }

    public String getLatestTagVersion(Long appId, List<SueTag> uSueTag) {
        if (uSueTag.isEmpty()) {
            List pSueTag = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).orderByDesc(SueTag::getId));
            return pSueTag.isEmpty() ? null : ((SueTag)pSueTag.get(0)).getVersion();
        }
        return uSueTag.get(0).getVersion();
    }

    public Map<String, VersionTag> getUnPublishedTags(Long appId) {
        List sueTag = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code()));
        if (sueTag.isEmpty()) {
            return Maps.newHashMap();
        }
        return sueTag.stream().map(VersionSueTagStructMapper.MAPPER::toVersionTag).collect(Collectors.toMap(tag -> String.valueOf(tag.getId()), Functions.identity()));
    }

    public Map<String, VersionTag> getPublishedVersionTags(Long appId, String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Maps.newHashMap();
        }
        List sueTag = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getVersion, (Object)version));
        if (sueTag.isEmpty()) {
            return Maps.newHashMap();
        }
        return sueTag.stream().map(VersionSueTagStructMapper.MAPPER::toVersionTag).collect(Collectors.toMap(tag -> String.valueOf(tag.getId()), Functions.identity()));
    }
}

