/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.event.listener;

import com.xforceplus.ultraman.bocp.metadata.version.event.PublishEvent;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.repository.operationlog.OperationLogRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OperationLogEventListener {
    private static final Logger log = LoggerFactory.getLogger(OperationLogEventListener.class);
    @Autowired
    private OperationLogRepository operationLogRepository;

    @SkipDataAuth
    @Async
    @EventListener(value={PublishEvent.class})
    public void onApplicationEvent(PublishEvent event) {
        if (null == event.getMetadataType()) {
            log.error("\u5143\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a");
            return;
        }
        log.info("{} \u53d1\u5e03\u66f4\u65b0\u5ba1\u8ba1\u8bb0\u5f55", (Object)event.getMetadataType().code());
        try {
            switch (event.getMetadataType()) {
                case BO: {
                    if (event.isAll()) {
                        this.operationLogRepository.updateBoOperationLogAll(event.getAppId(), event.getNewVersion(), event.getNewVersion(), event.getAllIds());
                        break;
                    }
                    this.operationLogRepository.updateBoOperationLog(event.getAppId(), event.getNewVersion(), event.getNewVersion(), event.getChangedItems());
                    break;
                }
                case PAGE: {
                    this.operationLogRepository.updatePageOperationLog(event.getAppId(), event.getNewVersion(), event.getVersionMap(), event.getChangedItems());
                    break;
                }
                case DICT: {
                    this.doOperationLogUpdateForChildTable(event, "dict");
                    break;
                }
                case RULE: {
                    this.doOperationLogUpdateForChildTable(event, "sue_rule");
                    break;
                }
                case FLOW_ACTION: {
                    this.doOperationLogUpdateForChildTable(event, "flow_action");
                    break;
                }
                case API: {
                    this.doOperationLogUpdateForSingleTable(event, "apis");
                    break;
                }
                case APP_EVENT: {
                    this.doOperationLogUpdateForSingleTable(event, "app_event");
                    break;
                }
                case TAG: {
                    this.doOperationLogUpdateForSingleTable(event, "sue_tag");
                    break;
                }
                case SDK_SETTING: {
                    this.doOperationLogUpdateForSingleTable(event, "sdk_setting");
                    break;
                }
                case FORM: {
                    this.doOperationLogUpdateForMultiVersion(event, "ult_form");
                    break;
                }
                case FLOW_SETTING: {
                    this.doOperationLogUpdateForMultiVersion(event, "flow_setting");
                    break;
                }
                case PAGE_SETTING: {
                    this.doOperationLogUpdateForMultiVersion(event, "ult_page_setting");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u7248\u672c\u53d1\u5e03\u66f4\u65b0\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25, appId {}", (Object)event.getAppId());
        }
    }

    private void doOperationLogUpdateForSingleTable(PublishEvent event, String tableName) {
        if (null != tableName) {
            if (event.isAll()) {
                this.operationLogRepository.updateTableUnPublishDataAll(event.getAppId(), event.getNewVersion(), event.getNewVersion(), event.getAllIds(), tableName);
            } else {
                this.operationLogRepository.updateTableUnPublishData(event.getAppId(), event.getNewVersion(), event.getNewVersion(), event.getChangedItems(), tableName);
            }
        }
    }

    private void doOperationLogUpdateForChildTable(PublishEvent event, String tableName) {
        if (null != tableName) {
            if (event.isAll()) {
                this.operationLogRepository.updateOperationLogAllHasChildTable(event.getAppId(), event.getNewVersion(), event.getNewVersion(), event.getAllIds(), tableName);
            } else {
                this.operationLogRepository.updateOperationLogHasChildTable(event.getAppId(), event.getNewVersion(), event.getNewVersion(), event.getChangedItems(), tableName);
            }
        }
    }

    private void doOperationLogUpdateForMultiVersion(PublishEvent event, String tableName) {
        if (null != tableName) {
            this.operationLogRepository.updateTableUnPublishData(event.getAppId(), event.getNewVersion(), event.getVersionMap(), event.getChangedItems(), tableName);
        }
    }
}

