/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.AppEventStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.AppEventSubscribeStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.event.PublishEvent;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionAppEventStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEventSubscribe;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventSubscribeService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEventRepository;
import io.vavr.Tuple6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class AppEventVersionPublishExecutor {
    @Autowired
    private AppEventRepository appEventRepository;
    @Autowired
    private IAppEventService appEventService;
    @Autowired
    private IAppEventSubscribeService appEventSubscribeService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(final String newVersion, String originVersion, final PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        final List uAppEvents = this.appEventRepository.getAppEvents(publishContent.getAppId());
        if (CollectionUtils.isNotEmpty(publishContent.getUnAppEventChanges())) {
            this.publishVersionByChangeItems(publishContent.getAppId(), newVersion, originVersion, appVersionType, publishContent.getAppEventChanges(), publishContent.getAddAppEventChanges(), uAppEvents);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    AppEventVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.APP_EVENT, publishContent.getAppId(), publishContent.getAppEventChanges(), newVersion));
                }
            });
        } else {
            this.publishVersion(newVersion, appVersionType, uAppEvents);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    AppEventVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.APP_EVENT, publishContent.getAppId(), newVersion, uAppEvents.stream().map(AppEvent::getId).collect(Collectors.toList())));
                }
            });
        }
        return ServiceResponse.success();
    }

    private void publishVersion(String newVersion, AppVersionType appVersionType, List<AppEvent> uAppEvents) {
        if (uAppEvents.isEmpty()) {
            return;
        }
        ArrayList copyAppEvents = Lists.newArrayList();
        uAppEvents.forEach(e -> {
            AppEvent copyAppEvent = AppEventStructMapper.MAPPER.clone(e);
            copyAppEvent.setId(null);
            copyAppEvent.setPublishEventId(e.getId());
            copyAppEvent.setPublishFlag(PublishFlag.PUBLISHED.code());
            copyAppEvent.setVersion(newVersion);
            copyAppEvents.add(copyAppEvent);
        });
        this.appEventService.saveBatch((Collection)copyAppEvents);
        List eventIds = uAppEvents.stream().map(AppEvent::getId).collect(Collectors.toList());
        Map<Long, List<AppEventSubscribe>> subscribesMap = this.appEventSubscribeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEventSubscribe::getDeleteFlag, (Object)"1")).in(AppEventSubscribe::getEventId, eventIds)).stream().collect(Collectors.groupingBy(AppEventSubscribe::getEventId));
        ArrayList copySubscribes = Lists.newArrayList();
        copyAppEvents.forEach(o -> Optional.ofNullable(subscribesMap.get(o.getPublishEventId())).ifPresent(l -> l.forEach(s -> {
            AppEventSubscribe copySubscribe = AppEventSubscribeStructMapper.MAPPER.clone(s);
            copySubscribe.setId(null);
            copySubscribe.setEventId(o.getId());
            copySubscribe.setPublishFlag(PublishFlag.PUBLISHED.code());
            copySubscribes.add(copySubscribe);
        })));
        this.appEventSubscribeService.saveBatch((Collection)copySubscribes);
        Map<Long, Long> uniIdVsIdMap = copyAppEvents.stream().collect(Collectors.toMap(AppEvent::getUniqueId, AppEvent::getId));
        List rpAppEvents = copyAppEvents.stream().filter(e -> null != e.getRefEventId()).peek(e -> Optional.ofNullable(uniIdVsIdMap.get(e.getRefEventId())).ifPresent(arg_0 -> ((AppEvent)e).setRefEventId(arg_0))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rpAppEvents)) {
            this.appEventService.updateBatchById(rpAppEvents);
        }
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uAppEvents.forEach(e -> {
                e.setVersion(newVersion);
                this.appEventService.alwaysUpdateSomeColumnById(e);
            });
        }
    }

    private void publishVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addAppEventChanges, List<AppEvent> uAppEvents) {
        List uEventIds = uAppEvents.stream().map(AppEvent::getId).collect(Collectors.toList());
        HashMap uAppEventSubscribesMap = uEventIds.isEmpty() ? Maps.newHashMap() : this.appEventSubscribeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(AppEventSubscribe::getEventId, uEventIds)).eq(AppEventSubscribe::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(AppEventSubscribe::getEventId, Collectors.toList()));
        List pAppEvents = this.appEventService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEvent::getAppId, (Object)appId)).eq(AppEvent::getVersion, (Object)originVersion)).eq(AppEvent::getDeleteFlag, (Object)"1")).eq(AppEvent::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        List pEventIds = pAppEvents.stream().map(AppEvent::getId).collect(Collectors.toList());
        HashMap pAppEventSubscribesMap = pEventIds.isEmpty() ? Maps.newHashMap() : this.appEventSubscribeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(AppEventSubscribe::getEventId, pEventIds)).eq(AppEventSubscribe::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(AppEventSubscribe::getEventId, Collectors.toList()));
        Map<Long, Long> pPEventIdVOriEventId = pAppEvents.stream().collect(Collectors.toMap(AppEvent::getUniqueId, AppEvent::getId));
        Tuple6<List<AppEvent>, List<AppEvent>, List<AppEvent>, List<AppEventSubscribe>, List<AppEventSubscribe>, List<AppEventSubscribe>> appEventChanges = this.publishCommonService.dealAppEventChanges(changedItems, addAppEventChanges, pPEventIdVOriEventId);
        ArrayList copyAppEvents = Lists.newArrayList();
        List dAppEventIds = ((List)appEventChanges._2).stream().map(AppEvent::getId).collect(Collectors.toList());
        pAppEvents.stream().filter(appEvent -> !dAppEventIds.contains(appEvent.getId())).forEach(appEvent -> {
            AppEvent copyAppEvent = AppEventStructMapper.MAPPER.clone(appEvent).setId(null).setVersion(newVersion);
            copyAppEvents.add(copyAppEvent);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)appEventChanges._1))) {
            ((List)appEventChanges._1).forEach(appEvent -> {
                AppEvent copyAppEvent = AppEventStructMapper.MAPPER.clone(appEvent).setId(null).setPublishEventId(appEvent.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copyAppEvents.add(copyAppEvent);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)appEventChanges._3))) {
            ((List)appEventChanges._3).forEach(appEvent -> {
                Optional<AppEvent> uOptl = copyAppEvents.stream().filter(cAppEvent -> appEvent.getId().equals(cAppEvent.getUniqueId())).findAny();
                uOptl.ifPresent(event -> VersionAppEventStructMapper.MAPPER.updateAppEvent((AppEvent)appEvent, (AppEvent)event));
            });
        }
        this.appEventService.saveBatch((Collection)copyAppEvents);
        Map<Long, Long> publishIdVsIdMap = copyAppEvents.stream().collect(Collectors.toMap(AppEvent::getPublishEventId, AppEvent::getId));
        List rpAppEvents = copyAppEvents.stream().filter(e -> null != e.getRefEventId()).peek(e -> Optional.ofNullable(publishIdVsIdMap.get(e.getRefEventId())).ifPresent(arg_0 -> ((AppEvent)e).setRefEventId(arg_0))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rpAppEvents)) {
            this.appEventService.updateBatchById(rpAppEvents);
        }
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uAppEvents.forEach(appEvent -> appEvent.setVersion(newVersion));
            if (!uAppEvents.isEmpty()) {
                this.appEventService.updateBatchById(uAppEvents);
            }
        }
        List aRuleIds = ((List)appEventChanges._1).stream().map(AppEvent::getId).collect(Collectors.toList());
        ArrayList copyAppEventSubscribes = Lists.newArrayList();
        List dAppEventSubscribeIds = ((List)appEventChanges._5).stream().map(AppEventSubscribe::getId).collect(Collectors.toList());
        Map<Long, List<AppEventSubscribe>> rAppEventSubscribesMap = ((List)appEventChanges._6).stream().collect(Collectors.groupingBy(AppEventSubscribe::getEventId));
        copyAppEvents.forEach(copyAppEvent -> {
            if (CollectionUtils.isNotEmpty((Collection)aRuleIds) && aRuleIds.contains(copyAppEvent.getUniqueId())) {
                Optional.ofNullable(uAppEventSubscribesMap.get(copyAppEvent.getUniqueId())).ifPresent(s -> s.stream().filter(o -> !dAppEventSubscribeIds.contains(o.getId())).forEach(o -> copyAppEventSubscribes.add(AppEventSubscribeStructMapper.MAPPER.clone(o).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setEventId(copyAppEvent.getId()))));
            } else {
                Long pOriRuleId = (Long)pPEventIdVOriEventId.get(copyAppEvent.getUniqueId());
                Optional.ofNullable(pAppEventSubscribesMap.get(pOriRuleId)).ifPresent(s -> {
                    Optional.ofNullable(rAppEventSubscribesMap.get(copyAppEvent.getUniqueId())).ifPresent(rAppEventSubscribes -> rAppEventSubscribes.forEach(rAppEventSubscribe -> s.stream().filter(o -> rAppEventSubscribe.getUniqueId().equals(o.getUniqueId())).findAny().ifPresent(o -> VersionAppEventStructMapper.MAPPER.updateAppEventSubscribe((AppEventSubscribe)rAppEventSubscribe, (AppEventSubscribe)o))));
                    s.stream().filter(o -> !dAppEventSubscribeIds.contains(o.getId())).forEach(o -> copyAppEventSubscribes.add(AppEventSubscribeStructMapper.MAPPER.clone(o).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setEventId(copyAppEvent.getId())));
                });
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)appEventChanges._4))) {
            Map<Long, Long> nPEventIdsVEventIds = copyAppEvents.stream().collect(Collectors.toMap(AppEvent::getUniqueId, AppEvent::getId));
            ((List)appEventChanges._4).forEach(o -> {
                AppEventSubscribe copyAppEventSubscribe = AppEventSubscribeStructMapper.MAPPER.clone(o).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setEventId((Long)nPEventIdsVEventIds.get(o.getEventId()));
                copyAppEventSubscribes.add(copyAppEventSubscribe);
            });
        }
        this.appEventSubscribeService.saveBatch((Collection)copyAppEventSubscribes);
    }
}

