/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import akka.japi.tuple.Tuple17;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoApiDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoApiStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldAttributeStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldDomainAttributeStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldValidateStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoIndexStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoRelationshipStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.common.CommonBusiness;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.BoDataRuleDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.BoDataRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.ModuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.event.PublishEvent;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionBoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.publish.VersionIdMapThreadLocal;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppModule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApiDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRuleDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldValidate;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoIndex;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.ModuleBo;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.ModuleMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppModuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoApiDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoApiService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldDomainAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldValidateService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoIndexService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoRelationshipService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IModuleBoService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IModuleService;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldValidateRepository;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class BoVersionPublishExecutor {
    private static final Logger log = LoggerFactory.getLogger(BoVersionPublishExecutor.class);
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private ModuleMapper moduleMapper;
    @Autowired
    private IAppModuleService appModuleService;
    @Autowired
    private IModuleService moduleService;
    @Autowired
    private IModuleBoService moduleBoService;
    @Autowired
    private IBoService boService;
    @Autowired
    private IBoFieldService boFieldService;
    @Autowired
    private IBoApiService boApiService;
    @Autowired
    private IBoApiDetailService boApiDetailService;
    @Autowired
    private IBoRelationshipService boRelationshipService;
    @Autowired
    private IBoDataRuleService boDataRuleService;
    @Autowired
    private IBoDataRuleDetailService boDataRuleDetailService;
    @Autowired
    private IBoIndexService boIndexService;
    @Autowired
    private IBoFieldAttributeService boFieldAttributeService;
    @Autowired
    private IBoFieldValidateService boFieldValidateService;
    @Autowired
    private IBoFieldDomainAttributeService boFieldDomainAttributeService;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private BoFieldValidateRepository boFieldValidateRepository;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(final String newVersion, String originModuleVersion, final PublishContent publishContent) {
        App app = this.appRepository.getAppWithValidate(publishContent.getAppId().longValue());
        Optional uModuleOptional = this.defaultModuleService.getModule(publishContent.getAppId().longValue());
        if (!uModuleOptional.isPresent()) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u5e94\u7528\u6a21\u5757");
        }
        Module uModule = (Module)uModuleOptional.get();
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        Optional pModuleOptional = AppVersionType.PATCH.equals((Object)appVersionType) ? this.defaultModuleService.getPublishedModuleByAppId(app.getId().longValue(), originModuleVersion) : this.defaultModuleService.getPublishedModuleByAppId(app.getId().longValue(), uModule.getVersion());
        Module pModule = pModuleOptional.orElse(null);
        Module newModule = ModuleStructMapper.MAPPER.clone(uModule).setPublishFlag(PublishFlag.PUBLISHED.code()).setPublishModuleId(uModule.getId()).setVersion(newVersion).setId(null);
        this.moduleService.save((Object)newModule);
        AppModule appModule = new AppModule().setModuleId(newModule.getId()).setApplicationId(app.getId()).setDeleteFlag("1");
        this.appModuleService.save((Object)appModule);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uModule.setPublishFlag(PublishFlag.UNPUBLISHED.code());
            uModule.setPublishModuleId(null);
            uModule.setVersion(newVersion);
            this.moduleMapper.alwaysUpdateSomeColumnById((Object)uModule);
        }
        final List uModuleBos = this.moduleBoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ModuleBo::getModuleId, (Object)uModule.getId())).eq(ModuleBo::getDeleteFlag, (Object)"1"));
        if (CollectionUtils.isNotEmpty(publishContent.getUnBoChanges())) {
            this.publishModuleVersionByChangeItems(app, pModule, newModule, newVersion, appVersionType, publishContent.getBoChanges(), publishContent.getAddBoChanges(), uModuleBos);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    BoVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.BO, publishContent.getAppId(), publishContent.getBoChanges(), newVersion));
                }
            });
        } else {
            this.publishModuleVersion(app, newModule, newVersion, appVersionType, uModuleBos);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    BoVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.BO, publishContent.getAppId(), newVersion, uModuleBos.stream().map(ModuleBo::getBoId).collect(Collectors.toList())));
                }
            });
        }
        return ServiceResponse.success((String)"");
    }

    private Long publishModuleVersion(App app, Module newModule, String newVersion, AppVersionType appVersionType, List<ModuleBo> uModuleBos) {
        List boIds = uModuleBos.stream().map(ModuleBo::getBoId).collect(Collectors.toList());
        if (!boIds.isEmpty()) {
            List bos = this.boService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getDeleteFlag, (Object)"1")).in(Bo::getId, boIds));
            Map boFieldsMap = this.boFieldService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoField::getBoId, boIds)).eq(BoField::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoField::getBoId, Collectors.toList()));
            Map boIndexesMap = this.boIndexService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoIndex::getBoId, boIds)).eq(BoIndex::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoIndex::getBoId, Collectors.toList()));
            Map boRelationsMap = this.boRelationshipService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoRelationship::getBoId, boIds)).eq(BoRelationship::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoRelationship::getBoId, Collectors.toList()));
            Map boApisMap = this.boApiService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoApi::getBoId, boIds)).eq(BoApi::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoApi::getBoId, Collectors.toList()));
            Map boDataRulesMap = this.boDataRuleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoDataRule::getBoId, boIds)).eq(BoDataRule::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoDataRule::getBoId, Collectors.toList()));
            HashMap bo2Vbos = Maps.newHashMap();
            HashMap nboVFields = Maps.newHashMap();
            ArrayList copyBos = Lists.newArrayList();
            ArrayList copyModuleBos = Lists.newArrayList();
            ArrayList copyBoIndexes = Lists.newArrayList();
            ArrayList copyBoApiDetails = Lists.newArrayList();
            ArrayList copyBoRelationships = Lists.newArrayList();
            ArrayList copyBoDataRuleDetails = Lists.newArrayList();
            ArrayList copyBoFieldAttributes = Lists.newArrayList();
            ArrayList copyBoFieldValidates = Lists.newArrayList();
            ArrayList copyBoFieldDomainAttributes = Lists.newArrayList();
            if (AppVersionType.PATCH.equals((Object)appVersionType)) {
                bos.forEach(bo -> {
                    Bo copyBo = BoStructMapper.MAPPER.clone(bo);
                    copyBo.setId(null);
                    copyBo.setPublishBoId(bo.getId());
                    copyBo.setPublishFlag(PublishFlag.PUBLISHED.code());
                    copyBo.setVersion(newVersion);
                    copyBos.add(copyBo);
                });
            } else {
                bos.forEach(bo -> {
                    String nBoVersion = VersionUtils.nextVersion((String)bo.getVersion(), (AppVersionType)appVersionType);
                    Bo copyBo = BoStructMapper.MAPPER.clone(bo);
                    copyBo.setId(null);
                    copyBo.setPublishBoId(bo.getId());
                    copyBo.setPublishFlag(PublishFlag.PUBLISHED.code());
                    copyBo.setVersion(nBoVersion);
                    copyBos.add(copyBo);
                    bo.setVersion(nBoVersion);
                });
                this.boService.updateBatchById((Collection)bos);
            }
            this.boService.saveBatch((Collection)copyBos);
            HashMap copyBoApisMap = Maps.newHashMap();
            ArrayList allCopyBoApis = Lists.newArrayList();
            copyBos.forEach(copyBo -> Optional.ofNullable(boApisMap.get(copyBo.getPublishBoId())).ifPresent(boApis -> {
                ArrayList copyBoApis = Lists.newArrayList();
                boApis.forEach(boApi -> {
                    BoApi copyBoApi = BoApiStructMapper.MAPPER.clone(boApi);
                    copyBoApi.setId(null);
                    copyBoApi.setBoId(copyBo.getId());
                    copyBoApi.setPublishBoApiId(boApi.getId());
                    copyBoApis.add(copyBoApi);
                });
                allCopyBoApis.addAll(copyBoApis);
                copyBoApisMap.put(copyBo.getId(), copyBoApis);
            }));
            this.boApiService.saveBatch((Collection)allCopyBoApis);
            HashMap copyBoDataRulesMap = Maps.newHashMap();
            ArrayList allCopyBoDataRules = Lists.newArrayList();
            copyBos.forEach(copyBo -> Optional.ofNullable(boDataRulesMap.get(copyBo.getPublishBoId())).ifPresent(boDataRules -> {
                ArrayList copyBoDataRules = Lists.newArrayList();
                boDataRules.forEach(boDataRule -> {
                    BoDataRule copyBoDataRule = BoDataRuleStructMapper.MAPPER.clone(boDataRule);
                    copyBoDataRule.setId(null);
                    copyBoDataRule.setBoId(copyBo.getId());
                    copyBoDataRule.setPublishFlag(PublishFlag.PUBLISHED.code());
                    copyBoDataRule.setPublishDataRuleId(boDataRule.getId());
                    copyBoDataRules.add(copyBoDataRule);
                });
                allCopyBoDataRules.addAll(copyBoDataRules);
                copyBoDataRulesMap.put(copyBo.getId(), copyBoDataRules);
            }));
            this.boDataRuleService.saveBatch((Collection)allCopyBoDataRules);
            HashMap copyBoFieldsMap = Maps.newHashMap();
            ArrayList allCopyBoFields = Lists.newArrayList();
            copyBos.forEach(copyBo -> Optional.ofNullable(boFieldsMap.get(copyBo.getPublishBoId())).ifPresent(boFields -> {
                ArrayList copyBoFields = Lists.newArrayList();
                boFields.forEach(boField -> {
                    BoField copyBoField = BoFieldStructMapper.MAPPER.clone(boField);
                    copyBoField.setId(null);
                    copyBoField.setBoId(copyBo.getId());
                    copyBoField.setPublishFlag(PublishFlag.PUBLISHED.code());
                    copyBoField.setPublishFieldId(boField.getId());
                    copyBoFields.add(copyBoField);
                });
                allCopyBoFields.addAll(copyBoFields);
                copyBoFieldsMap.put(copyBo.getId(), copyBoFields);
            }));
            this.boFieldService.saveBatch((Collection)allCopyBoFields);
            copyBos.forEach(copyBo -> {
                ModuleBo copyModuleBo = new ModuleBo();
                copyModuleBo.setModuleId(newModule.getId());
                copyModuleBo.setBoId(copyBo.getId());
                copyModuleBos.add(copyModuleBo);
                Optional.ofNullable(boIndexesMap.get(copyBo.getPublishBoId())).ifPresent(boIndexes -> boIndexes.forEach(boIndex -> {
                    BoIndex copyBoIndex = BoIndexStructMapper.MAPPER.clone(boIndex);
                    copyBoIndex.setId(null);
                    copyBoIndex.setBoId(copyBo.getId());
                    copyBoIndexes.add(copyBoIndex);
                }));
                Optional.ofNullable(boRelationsMap.get(copyBo.getPublishBoId())).ifPresent(boRelationships -> boRelationships.forEach(boRelationship -> {
                    BoRelationship copyBoRelationship = BoRelationshipStructMapper.MAPPER.clone(boRelationship);
                    copyBoRelationship.setId(null);
                    copyBoRelationship.setBoId(copyBo.getId());
                    copyBoRelationships.add(copyBoRelationship);
                }));
                Optional.ofNullable(copyBoApisMap.get(copyBo.getId())).ifPresent(copyBoApis -> {
                    List boApiIds = copyBoApis.stream().map(BoApi::getPublishBoApiId).collect(Collectors.toList());
                    Map boApiDetailsMap = this.boApiDetailService.list((Wrapper)Wrappers.lambdaQuery().in(BoApiDetail::getBoApiId, boApiIds)).stream().collect(Collectors.groupingBy(BoApiDetail::getBoApiId, Collectors.toList()));
                    copyBoApis.forEach(copyBoApi -> Optional.ofNullable(boApiDetailsMap.get(copyBoApi.getPublishBoApiId())).ifPresent(details -> details.forEach(detail -> {
                        BoApiDetail copyApiDetail = BoApiDetailStructMapper.MAPPER.clone(detail);
                        copyApiDetail.setId(null);
                        copyApiDetail.setBoApiId(copyBoApi.getId());
                        copyBoApiDetails.add(copyApiDetail);
                    })));
                });
                Optional.ofNullable(copyBoDataRulesMap.get(copyBo.getId())).ifPresent(items -> {
                    List boDataRuleIds = items.stream().map(BoDataRule::getPublishDataRuleId).collect(Collectors.toList());
                    Map boDataRuleDetailsMap = this.boDataRuleDetailService.list((Wrapper)Wrappers.lambdaQuery().in(BoDataRuleDetail::getDataRuleId, boDataRuleIds)).stream().collect(Collectors.groupingBy(BoDataRuleDetail::getDataRuleId, Collectors.toList()));
                    items.forEach(item -> Optional.ofNullable(boDataRuleDetailsMap.get(item.getPublishDataRuleId())).ifPresent(details -> details.forEach(detail -> {
                        BoDataRuleDetail copyDetail = BoDataRuleDetailStructMapper.MAPPER.clone(detail);
                        copyDetail.setId(null);
                        copyDetail.setDataRuleId(item.getId());
                        copyBoDataRuleDetails.add(copyDetail);
                    })));
                });
                Optional.ofNullable(copyBoFieldsMap.get(copyBo.getId())).ifPresent(copyBoFields -> {
                    List boFieldIds = copyBoFields.stream().map(BoField::getPublishFieldId).collect(Collectors.toList());
                    Map boFieldAttrsMap = this.boFieldAttributeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoFieldAttribute::getFieldId, boFieldIds)).eq(BoFieldAttribute::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoFieldAttribute::getFieldId, Collectors.toList()));
                    Map boFieldValidatesMap = this.boFieldValidateRepository.getBoFieldValidatesByFieldIds(boFieldIds).stream().collect(Collectors.groupingBy(BoFieldValidate::getFieldId, Collectors.toList()));
                    Map boFieldDomainAttributeMap = this.boFieldDomainAttributeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoFieldDomainAttribute::getFieldId, boFieldIds)).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoFieldDomainAttribute::getFieldId, Collectors.toList()));
                    HashMap oFieldsVnFields = Maps.newHashMap();
                    copyBoFields.forEach(copyBoField -> {
                        oFieldsVnFields.put(copyBoField.getPublishFieldId(), copyBoField.getId());
                        Optional.ofNullable(boFieldAttrsMap.get(copyBoField.getPublishFieldId())).ifPresent(boFieldAttributes -> {
                            BoFieldAttribute copyBoFieldAttribute = boFieldAttributes.isEmpty() ? CommonBusiness.newBoFieldAttribute((BoField)copyBoField) : BoFieldAttributeStructMapper.MAPPER.clone((BoFieldAttribute)boFieldAttributes.get(0));
                            copyBoFieldAttribute.setId(null);
                            copyBoFieldAttribute.setFieldId(copyBoField.getId());
                            copyBoFieldAttribute.setDeleteFlag("1");
                            copyBoFieldAttributes.add(copyBoFieldAttribute);
                        });
                        Optional.ofNullable(boFieldValidatesMap.get(copyBoField.getPublishFieldId())).ifPresent(boFieldValidates -> {
                            BoFieldValidate copyBoFieldValidate = boFieldValidates.isEmpty() ? new BoFieldValidate() : BoFieldValidateStructMapper.MAPPER.clone((BoFieldValidate)boFieldValidates.get(0));
                            copyBoFieldValidate.setId(null);
                            copyBoFieldValidate.setFieldId(copyBoField.getId());
                            copyBoFieldValidates.add(copyBoFieldValidate);
                        });
                        Optional.ofNullable(boFieldDomainAttributeMap.get(copyBoField.getPublishFieldId())).ifPresent(boFieldDomainAttributes -> {
                            BoFieldDomainAttribute copyBoFieldDomainAttribute = boFieldDomainAttributes.isEmpty() ? new BoFieldDomainAttribute() : BoFieldDomainAttributeStructMapper.MAPPER.clone((BoFieldDomainAttribute)boFieldDomainAttributes.get(0));
                            copyBoFieldDomainAttribute.setId(null);
                            copyBoFieldDomainAttribute.setFieldId(copyBoField.getId());
                            copyBoFieldDomainAttribute.setDeleteFlag("1");
                            copyBoFieldDomainAttributes.add(copyBoFieldDomainAttribute);
                        });
                    });
                    nboVFields.put(copyBo.getId(), oFieldsVnFields);
                });
                bo2Vbos.put(copyBo.getPublishBoId(), copyBo.getId());
            });
            this.moduleBoService.saveBatch((Collection)copyModuleBos);
            this.boFieldAttributeService.saveBatch((Collection)copyBoFieldAttributes);
            if (CollectionUtils.isNotEmpty((Collection)copyBoRelationships)) {
                this.boRelationshipService.saveBatch((Collection)copyBoRelationships);
            }
            if (CollectionUtils.isNotEmpty((Collection)copyBoIndexes)) {
                this.boIndexService.saveBatch((Collection)copyBoIndexes);
            }
            if (CollectionUtils.isNotEmpty((Collection)copyBoDataRuleDetails)) {
                this.boDataRuleDetailService.saveBatch((Collection)copyBoDataRuleDetails);
            }
            if (CollectionUtils.isNotEmpty((Collection)copyBoApiDetails)) {
                this.boApiDetailService.saveBatch((Collection)copyBoApiDetails);
            }
            if (CollectionUtils.isNotEmpty((Collection)copyBoFieldValidates)) {
                this.boFieldValidateService.saveBatch((Collection)copyBoFieldValidates);
            }
            if (CollectionUtils.isNotEmpty((Collection)copyBoFieldDomainAttributes)) {
                this.boFieldDomainAttributeService.saveBatch((Collection)copyBoFieldDomainAttributes);
            }
            if (AppCustomType.TENANT.code().equals(app.getCustomType())) {
                this.convertUIdToVIdForPublishAllWhenIsTenantApp(copyBoRelationships, copyBoFieldDomainAttributes, bo2Vbos, nboVFields);
            } else {
                this.convertUIdToVIdForPublishAll(copyBos, allCopyBoFields, copyBoRelationships, copyBoFieldDomainAttributes, allCopyBoDataRules, bo2Vbos, nboVFields);
            }
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(bo2Vbos);
        }
        return newModule.getId();
    }

    private void publishModuleVersionByChangeItems(App app, Module pModule, Module newModule, String newVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addBoChanges, List<ModuleBo> uModuleBos) {
        if (uModuleBos.isEmpty()) {
            return;
        }
        ArrayList pModuleBos = null != pModule ? this.moduleBoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ModuleBo::getModuleId, (Object)pModule.getId())).eq(ModuleBo::getDeleteFlag, (Object)"1")) : Lists.newArrayList();
        List pBoIds = pModuleBos.stream().map(ModuleBo::getBoId).collect(Collectors.toList());
        ArrayList pBos = pBoIds.isEmpty() ? Lists.newArrayList() : this.boService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Bo::getId, pBoIds)).eq(Bo::getDeleteFlag, (Object)"1"));
        Map<Long, Long> pPBoIdVOriBoId = pBos.stream().collect(Collectors.toMap(Bo::getPublishBoId, Bo::getId));
        HashMap pBoFieldsMap = pBoIds.isEmpty() ? Maps.newHashMap() : this.boFieldService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoField::getBoId, pBoIds)).eq(BoField::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoField::getBoId, Collectors.toList()));
        HashMap pBoIndexesMap = pBoIds.isEmpty() ? Maps.newHashMap() : this.boIndexService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoIndex::getBoId, pBoIds)).eq(BoIndex::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoIndex::getBoId, Collectors.toList()));
        HashMap pBoRelationsMap = pBoIds.isEmpty() ? Maps.newHashMap() : this.boRelationshipService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoRelationship::getBoId, pBoIds)).eq(BoRelationship::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoRelationship::getBoId, Collectors.toList()));
        HashMap pBoApisMap = pBoIds.isEmpty() ? Maps.newHashMap() : this.boApiService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoApi::getBoId, pBoIds)).eq(BoApi::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoApi::getBoId, Collectors.toList()));
        HashMap pBoDataRulesMap = pBoIds.isEmpty() ? Maps.newHashMap() : this.boDataRuleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoDataRule::getBoId, pBoIds)).eq(BoDataRule::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoDataRule::getBoId, Collectors.toList()));
        Tuple17<List<Bo>, List<Bo>, List<Bo>, List<BoRelationship>, List<BoRelationship>, List<BoIndex>, List<BoIndex>, List<BoIndex>, List<BoField>, List<BoField>, List<BoField>, List<BoApi>, List<BoApi>, List<BoApi>, List<BoDataRule>, List<BoDataRule>, List<BoDataRule>> moduleChanges = this.publishCommonService.dealModuleChanges(changedItems, addBoChanges, pPBoIdVOriBoId);
        List uBoIds = uModuleBos.stream().map(ModuleBo::getBoId).collect(Collectors.toList());
        HashMap uBoFieldsMap = uBoIds.isEmpty() ? Maps.newHashMap() : this.boFieldService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoField::getBoId, uBoIds)).eq(BoField::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoField::getBoId, Collectors.toList()));
        HashMap uBoIndexesMap = uBoIds.isEmpty() ? Maps.newHashMap() : this.boIndexService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoIndex::getBoId, uBoIds)).eq(BoIndex::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoIndex::getBoId, Collectors.toList()));
        HashMap uBoRelationshipsMap = uBoIds.isEmpty() ? Maps.newHashMap() : this.boRelationshipService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoRelationship::getBoId, uBoIds)).eq(BoRelationship::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoRelationship::getBoId, Collectors.toList()));
        HashMap uBoApisMap = uBoIds.isEmpty() ? Maps.newHashMap() : this.boApiService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoApi::getBoId, uBoIds)).eq(BoApi::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoApi::getBoId, Collectors.toList()));
        HashMap uBoDataRulesMap = uBoIds.isEmpty() ? Maps.newHashMap() : this.boDataRuleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoDataRule::getBoId, uBoIds)).eq(BoDataRule::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoDataRule::getBoId, Collectors.toList()));
        ArrayList copyBos = Lists.newArrayList();
        ArrayList copyBoIndexes = Lists.newArrayList();
        ArrayList copyBoApiDetails = Lists.newArrayList();
        ArrayList copyBoRelationships = Lists.newArrayList();
        ArrayList copyBoDataRuleDetails = Lists.newArrayList();
        ArrayList copyBoFieldAttributes = Lists.newArrayList();
        ArrayList copyBoFieldValidates = Lists.newArrayList();
        ArrayList copyBoFieldDomainAttributes = Lists.newArrayList();
        HashMap oriBoIdVCopyBoMap = Maps.newHashMap();
        HashMap uniBoIdVCopyBoMap = Maps.newHashMap();
        List dBoIds = ((List)moduleChanges.t2()).stream().map(Bo::getId).collect(Collectors.toList());
        pBos.stream().filter(bo -> !dBoIds.contains(bo.getId())).forEach(bo -> {
            String nBoVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? newVersion : VersionUtils.nextVersion((String)bo.getVersion(), (AppVersionType)appVersionType);
            Bo copyBo = BoStructMapper.MAPPER.clone(bo).setId(null).setVersion(nBoVersion);
            copyBos.add(copyBo);
            oriBoIdVCopyBoMap.put(bo.getId(), copyBo);
            uniBoIdVCopyBoMap.put(copyBo.getPublishBoId(), copyBo);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)moduleChanges.t1()))) {
            ((List)moduleChanges.t1()).forEach(bo -> {
                String nBoVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? newVersion : VersionUtils.nextVersion((String)bo.getVersion(), (AppVersionType)appVersionType);
                Bo copyBo = BoStructMapper.MAPPER.clone(bo).setId(null).setPublishBoId(bo.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(nBoVersion);
                copyBos.add(copyBo);
                oriBoIdVCopyBoMap.put(bo.getId(), copyBo);
                uniBoIdVCopyBoMap.put(copyBo.getPublishBoId(), copyBo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)moduleChanges.t3()))) {
            ((List)moduleChanges.t3()).forEach(bo -> {
                Optional<Bo> uBoOptl = copyBos.stream().filter(cBo -> bo.getId().equals(cBo.getPublishBoId())).findAny();
                uBoOptl.ifPresent(value -> VersionBoStructMapper.MAPPER.updateBo((Bo)bo, (Bo)value));
            });
        }
        this.boService.saveBatch((Collection)copyBos);
        List copyModuleBos = copyBos.stream().map(copyBo -> new ModuleBo().setModuleId(newModule.getId()).setBoId(copyBo.getId())).collect(Collectors.toList());
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            ArrayList uBos = uBoIds.isEmpty() ? Lists.newArrayList() : this.boService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Bo::getId, uBoIds)).eq(Bo::getDeleteFlag, (Object)"1"));
            Map<Long, String> nPBoIdsVBoVersions = copyBos.stream().collect(Collectors.toMap(Bo::getPublishBoId, Bo::getVersion));
            List uBosNeedUpdate = uBos.stream().filter(bo -> nPBoIdsVBoVersions.containsKey(bo.getId())).map(bo -> {
                bo.setVersion((String)nPBoIdsVBoVersions.get(bo.getId()));
                return bo;
            }).collect(Collectors.toList());
            if (!uBosNeedUpdate.isEmpty()) {
                this.boService.updateBatchById(uBosNeedUpdate);
            }
        }
        Map<Long, Long> nPBoIdsVBoIds = copyBos.stream().collect(Collectors.toMap(Bo::getPublishBoId, Bo::getId));
        List<Long> aBoIds = ((List)moduleChanges.t1()).stream().map(Bo::getId).collect(Collectors.toList());
        List dBoRelIds = ((List)moduleChanges.t5()).stream().map(BoRelationship::getId).collect(Collectors.toList());
        copyBos.forEach(copyBo -> {
            if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(copyBo.getPublishBoId())) {
                List boRels = (List)uBoRelationshipsMap.get(copyBo.getPublishBoId());
                Optional.ofNullable(boRels).ifPresent(boRelationships -> boRelationships.stream().filter(boRel -> !dBoRelIds.contains(boRel.getId())).forEach(boRelationship -> copyBoRelationships.add(BoRelationshipStructMapper.MAPPER.clone(boRelationship).setId(null).setBoId(copyBo.getId()))));
            } else {
                List boRels = (List)pBoRelationsMap.get(pPBoIdVOriBoId.get(copyBo.getPublishBoId()));
                Optional.ofNullable(boRels).ifPresent(boRelationships -> boRelationships.stream().filter(boRel -> !dBoRelIds.contains(boRel.getId())).forEach(boRelationship -> copyBoRelationships.add(BoRelationshipStructMapper.MAPPER.clone(boRelationship).setId(null).setBoId(copyBo.getId()))));
            }
        });
        ((List)moduleChanges.t4()).forEach(boRelationship -> copyBoRelationships.add(BoRelationshipStructMapper.MAPPER.clone(boRelationship).setId(null).setBoId((Long)nPBoIdsVBoIds.get(boRelationship.getBoId()))));
        List dBoIdxIds = ((List)moduleChanges.t7()).stream().map(BoIndex::getId).collect(Collectors.toList());
        Map<Long, List<BoIndex>> rBoIdxsMap = ((List)moduleChanges.t8()).stream().collect(Collectors.groupingBy(BoIndex::getBoId));
        copyBos.forEach(copyBo -> {
            if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(copyBo.getPublishBoId())) {
                Optional.ofNullable(uBoIndexesMap.get(copyBo.getPublishBoId())).ifPresent(boIndexes -> boIndexes.stream().filter(boIdx -> !dBoIdxIds.contains(boIdx.getId())).forEach(boIndex -> copyBoIndexes.add(BoIndexStructMapper.MAPPER.clone(boIndex).setId(null).setBoId(copyBo.getId()))));
            } else {
                Optional.ofNullable(pBoIndexesMap.get(pPBoIdVOriBoId.get(copyBo.getPublishBoId()))).ifPresent(boIndexes -> {
                    Optional.ofNullable(rBoIdxsMap.get(copyBo.getPublishBoId())).ifPresent(rBoIdxs -> rBoIdxs.forEach(rBoIdx -> boIndexes.stream().filter(boIdx -> rBoIdx.getCode().equals(boIdx.getCode())).findAny().ifPresent(boIdx -> VersionBoStructMapper.MAPPER.updateBoIndex((BoIndex)rBoIdx, (BoIndex)boIdx))));
                    boIndexes.stream().filter(boIdx -> !dBoIdxIds.contains(boIdx.getId())).forEach(boIndex -> copyBoIndexes.add(BoIndexStructMapper.MAPPER.clone(boIndex).setId(null).setBoId(copyBo.getId())));
                });
            }
        });
        ((List)moduleChanges.t6()).forEach(boIdx -> copyBoIndexes.add(BoIndexStructMapper.MAPPER.clone(boIdx).setId(null).setBoId((Long)nPBoIdsVBoIds.get(boIdx.getBoId()))));
        HashMap copyBoDataRulesMap = Maps.newHashMap();
        ArrayList allCopyBoDataRules = Lists.newArrayList();
        List dBoDRIds = ((List)moduleChanges.t16()).stream().map(BoDataRule::getId).collect(Collectors.toList());
        Map<Long, List<BoDataRule>> rBoDRsMap = ((List)moduleChanges.t17()).stream().collect(Collectors.groupingBy(BoDataRule::getBoId));
        copyBos.forEach(copyBo -> {
            ArrayList copyBoDataRules = Lists.newArrayList();
            HashMap oriBoDataRuleIdVCopyBoDataRuleMap = Maps.newHashMap();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(copyBo.getPublishBoId())) {
                Optional.ofNullable(uBoDataRulesMap.get(copyBo.getPublishBoId())).ifPresent(boDataRules -> boDataRules.stream().filter(boDR -> !dBoDRIds.contains(boDR.getId())).forEach(boDR -> {
                    BoDataRule copyBoDataRule = BoDataRuleStructMapper.MAPPER.clone(boDR).setId(null).setBoId(copyBo.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setPublishDataRuleId(boDR.getId());
                    copyBoDataRules.add(copyBoDataRule);
                    oriBoDataRuleIdVCopyBoDataRuleMap.put(boDR.getId(), copyBoDataRule);
                }));
            } else {
                Optional.ofNullable(pBoDataRulesMap.get(pPBoIdVOriBoId.get(copyBo.getPublishBoId()))).ifPresent(boDataRules -> {
                    Optional.ofNullable(rBoDRsMap.get(copyBo.getPublishBoId())).ifPresent(rBoDRs -> rBoDRs.forEach(rBoDR -> boDataRules.stream().filter(boDR -> rBoDR.getId().equals(boDR.getPublishDataRuleId())).findAny().ifPresent(boDR -> VersionBoStructMapper.MAPPER.updateBoDataRule((BoDataRule)rBoDR, (BoDataRule)boDR))));
                    boDataRules.stream().filter(boDR -> !dBoDRIds.contains(boDR.getId())).forEach(boDR -> {
                        BoDataRule copyBoDataRule = BoDataRuleStructMapper.MAPPER.clone(boDR).setId(null).setBoId(copyBo.getId());
                        copyBoDataRules.add(copyBoDataRule);
                        oriBoDataRuleIdVCopyBoDataRuleMap.put(boDR.getId(), copyBoDataRule);
                    });
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)moduleChanges.t15()))) {
                ((List)moduleChanges.t15()).stream().filter(boDataRule -> boDataRule.getBoId().equals(copyBo.getPublishBoId())).forEach(boDataRule -> {
                    BoDataRule copyBoDataRule = BoDataRuleStructMapper.MAPPER.clone(boDataRule).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setPublishDataRuleId(boDataRule.getId()).setBoId((Long)nPBoIdsVBoIds.get(boDataRule.getBoId()));
                    copyBoDataRules.add(copyBoDataRule);
                    oriBoDataRuleIdVCopyBoDataRuleMap.put(boDataRule.getId(), copyBoDataRule);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)copyBoDataRules)) {
                allCopyBoDataRules.addAll(copyBoDataRules);
                copyBoDataRulesMap.put(copyBo.getId(), copyBoDataRules);
            }
        });
        this.boDataRuleService.saveBatch((Collection)allCopyBoDataRules);
        copyBos.forEach(copyBo -> Optional.ofNullable(copyBoDataRulesMap.get(copyBo.getId())).ifPresent(copyBoDataRules -> {
            List publishBoDataRuleIds = copyBoDataRules.stream().map(BoDataRule::getPublishDataRuleId).distinct().collect(Collectors.toList());
            HashMap boDataRuleDetailsMap = publishBoDataRuleIds.isEmpty() ? Maps.newHashMap() : this.boDataRuleDetailService.list((Wrapper)Wrappers.lambdaQuery().in(BoDataRuleDetail::getDataRuleId, publishBoDataRuleIds)).stream().collect(Collectors.groupingBy(BoDataRuleDetail::getDataRuleId, Collectors.toList()));
            copyBoDataRules.forEach(copyBoDataRule -> Optional.ofNullable(boDataRuleDetailsMap.get(copyBoDataRule.getPublishDataRuleId())).ifPresent(boDataRuleDetails -> boDataRuleDetails.forEach(boDataRuleDetail -> {
                BoDataRuleDetail copyBoDataRuleDetail = BoDataRuleDetailStructMapper.MAPPER.clone(boDataRuleDetail);
                copyBoDataRuleDetail.setId(null).setDataRuleId(copyBoDataRule.getId());
                copyBoDataRuleDetails.add(copyBoDataRuleDetail);
            })));
        }));
        HashMap copyBoApisMap = Maps.newHashMap();
        ArrayList allCopyBoApis = Lists.newArrayList();
        List dBoApiIds = ((List)moduleChanges.t13()).stream().map(BoApi::getId).collect(Collectors.toList());
        Map<Long, List<BoApi>> rBoApisMap = ((List)moduleChanges.t14()).stream().collect(Collectors.groupingBy(BoApi::getBoId));
        copyBos.forEach(copyBo -> {
            ArrayList copyBoApis = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(copyBo.getPublishBoId())) {
                Optional.ofNullable(uBoApisMap.get(copyBo.getPublishBoId())).ifPresent(boApis -> boApis.stream().filter(boApi -> !dBoApiIds.contains(boApi.getId())).forEach(boApi -> {
                    BoApi copyBoApi = BoApiStructMapper.MAPPER.clone(boApi).setId(null).setPublishBoApiId(boApi.getId()).setBoId(copyBo.getId());
                    copyBoApis.add(copyBoApi);
                }));
            } else {
                Optional.ofNullable(pBoApisMap.get(pPBoIdVOriBoId.get(copyBo.getPublishBoId()))).ifPresent(boApis -> {
                    Optional.ofNullable(rBoApisMap.get(copyBo.getPublishBoId())).ifPresent(rBoApis -> rBoApis.forEach(rBoApi -> boApis.stream().filter(boApi -> rBoApi.getId().equals(boApi.getPublishBoApiId())).findAny().ifPresent(boApi -> VersionBoStructMapper.MAPPER.updateBoApi((BoApi)rBoApi, (BoApi)boApi))));
                    boApis.stream().filter(boApi -> !dBoApiIds.contains(boApi.getId())).forEach(boApi -> {
                        BoApi copyBoApi = BoApiStructMapper.MAPPER.clone(boApi).setId(null).setBoId(copyBo.getId());
                        copyBoApis.add(copyBoApi);
                    });
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)moduleChanges.t12()))) {
                ((List)moduleChanges.t12()).stream().filter(boApi -> boApi.getBoId().equals(copyBo.getPublishBoId())).forEach(boApi -> {
                    BoApi copyBoApi = BoApiStructMapper.MAPPER.clone(boApi).setId(null).setPublishBoApiId(boApi.getId()).setBoId((Long)nPBoIdsVBoIds.get(boApi.getBoId()));
                    copyBoApis.add(copyBoApi);
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)copyBoApis)) {
                allCopyBoApis.addAll(copyBoApis);
                copyBoApisMap.put(copyBo.getId(), copyBoApis);
            }
        });
        this.boApiService.saveBatch((Collection)allCopyBoApis);
        copyBos.forEach(copyBo -> Optional.ofNullable(copyBoApisMap.get(copyBo.getId())).ifPresent(copyBoApis -> {
            List publishBoApiIds = copyBoApis.stream().map(BoApi::getPublishBoApiId).distinct().collect(Collectors.toList());
            HashMap boApiDetailsMap = publishBoApiIds.isEmpty() ? Maps.newHashMap() : this.boApiDetailService.list((Wrapper)Wrappers.lambdaQuery().in(BoApiDetail::getBoApiId, publishBoApiIds)).stream().collect(Collectors.groupingBy(BoApiDetail::getBoApiId, Collectors.toList()));
            copyBoApis.forEach(copyBoApi -> Optional.ofNullable(boApiDetailsMap.get(copyBoApi.getPublishBoApiId())).ifPresent(boApiDetails -> boApiDetails.forEach(boApiDetail -> {
                BoApiDetail copyBoApiDetail = BoApiDetailStructMapper.MAPPER.clone(boApiDetail);
                copyBoApiDetail.setId(null).setBoApiId(copyBoApi.getId());
                copyBoApiDetails.add(copyBoApiDetail);
            })));
        }));
        HashMap copyBoIdVCopyBoFieldMap = Maps.newHashMap();
        HashMap copyBoIdVCopyBoFieldMap2 = Maps.newHashMap();
        HashMap copyBoIdVCopyBoFieldPidMap = Maps.newHashMap();
        HashMap copyBoFieldsMap = Maps.newHashMap();
        ArrayList allCopyBoFields = Lists.newArrayList();
        List dBoFdIds = ((List)moduleChanges.t10()).stream().map(BoField::getId).collect(Collectors.toList());
        Map<Long, List<BoField>> rBoFdsMap = ((List)moduleChanges.t11()).stream().collect(Collectors.groupingBy(BoField::getBoId));
        copyBos.forEach(copyBo -> {
            Map uniFieldIdVCopyBoFieldMap;
            ArrayList copyBoFields = Lists.newArrayList();
            HashMap oriFIdVCopyBoFieldMap = Maps.newHashMap();
            HashMap oriFIdVCopyBoFieldMap2 = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(copyBo.getPublishBoId())) {
                Optional.ofNullable(uBoFieldsMap.get(copyBo.getPublishBoId())).ifPresent(boFields -> boFields.stream().filter(boFd -> !dBoFdIds.contains(boFd.getId())).forEach(boField -> {
                    BoField copyBoField = BoFieldStructMapper.MAPPER.clone(boField).setId(null).setPublishFieldId(boField.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setBoId(copyBo.getId());
                    copyBoFields.add(copyBoField);
                    oriFIdVCopyBoFieldMap.put(boField.getId(), copyBoField);
                    oriFIdVCopyBoFieldMap2.put(boField.getId(), copyBoField);
                }));
            } else {
                Optional.ofNullable(pBoFieldsMap.get(pPBoIdVOriBoId.get(copyBo.getPublishBoId()))).ifPresent(boFields -> {
                    ArrayList rBoFields = rBoFdsMap.containsKey(copyBo.getPublishBoId()) ? (List)rBoFdsMap.get(copyBo.getPublishBoId()) : Lists.newArrayList();
                    rBoFields.forEach(rBoFd -> boFields.stream().filter(boField -> rBoFd.getId().equals(boField.getPublishFieldId())).findAny().ifPresent(boField -> VersionBoStructMapper.MAPPER.updateBoField((BoField)rBoFd, (BoField)boField)));
                    List rBoFieldIds = rBoFields.stream().map(BoField::getId).collect(Collectors.toList());
                    boFields.stream().filter(boFd -> !dBoFdIds.contains(boFd.getId())).forEach(boField -> {
                        BoField copyBoField = BoFieldStructMapper.MAPPER.clone(boField).setId(null).setBoId(copyBo.getId());
                        copyBoFields.add(copyBoField);
                        oriFIdVCopyBoFieldMap.put(rBoFieldIds.contains(boField.getPublishFieldId()) ? boField.getPublishFieldId() : boField.getId(), copyBoField);
                        oriFIdVCopyBoFieldMap2.put(boField.getId(), copyBoField);
                    });
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)moduleChanges.t9()))) {
                ((List)moduleChanges.t9()).stream().filter(boField -> boField.getBoId().equals(copyBo.getPublishBoId())).forEach(boField -> {
                    BoField copyBoField = BoFieldStructMapper.MAPPER.clone(boField).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setPublishFieldId(boField.getId()).setBoId((Long)nPBoIdsVBoIds.get(boField.getBoId()));
                    copyBoFields.add(copyBoField);
                    oriFIdVCopyBoFieldMap.put(boField.getId(), copyBoField);
                    oriFIdVCopyBoFieldMap2.put(boField.getId(), copyBoField);
                });
            }
            if (!oriFIdVCopyBoFieldMap.isEmpty()) {
                copyBoIdVCopyBoFieldMap.put(copyBo.getId(), oriFIdVCopyBoFieldMap);
            }
            if (!oriFIdVCopyBoFieldMap2.isEmpty()) {
                copyBoIdVCopyBoFieldMap2.put(copyBo.getId(), oriFIdVCopyBoFieldMap2);
            }
            if (!(uniFieldIdVCopyBoFieldMap = copyBoFields.stream().collect(Collectors.toMap(BoField::getPublishFieldId, Functions.identity()))).isEmpty()) {
                copyBoIdVCopyBoFieldPidMap.put(copyBo.getId(), uniFieldIdVCopyBoFieldMap);
            }
            if (CollectionUtils.isNotEmpty((Collection)copyBoFields)) {
                allCopyBoFields.addAll(copyBoFields);
                copyBoFieldsMap.put(copyBo.getId(), copyBoFields);
            }
        });
        this.boFieldService.saveBatch((Collection)allCopyBoFields);
        copyBos.forEach(copyBo -> Optional.ofNullable(copyBoFieldsMap.get(copyBo.getId())).ifPresent(copyBoFields -> {
            Map oriFIdVCopyBoFieldMap = (Map)copyBoIdVCopyBoFieldMap.get(copyBo.getId());
            if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(copyBo.getPublishBoId())) {
                Set boFieldIds = oriFIdVCopyBoFieldMap.keySet();
                Map<Long, List<BoFieldAttribute>> boFieldAttrsMap = this.boFieldAttributeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoFieldAttribute::getFieldId, boFieldIds)).eq(BoFieldAttribute::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoFieldAttribute::getFieldId));
                Map boFieldValidatesMap = this.boFieldValidateRepository.getBoFieldValidatesByFieldIds(new ArrayList(boFieldIds)).stream().collect(Collectors.groupingBy(BoFieldValidate::getFieldId, Collectors.toList()));
                Map<Long, List<BoFieldDomainAttribute>> boFieldDomainAttributeMap = this.boFieldDomainAttributeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoFieldDomainAttribute::getFieldId, boFieldIds)).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoFieldDomainAttribute::getFieldId));
                copyBoFields.forEach(copyBoField -> {
                    Optional.ofNullable(boFieldAttrsMap.get(copyBoField.getPublishFieldId())).ifPresent(boFieldAttributes -> {
                        BoFieldAttribute copyBoFieldAttribute = boFieldAttributes.isEmpty() ? CommonBusiness.newBoFieldAttribute((BoField)copyBoField) : BoFieldAttributeStructMapper.MAPPER.clone((BoFieldAttribute)boFieldAttributes.get(0));
                        copyBoFieldAttribute.setId(null).setFieldId(copyBoField.getId()).setDeleteFlag("1");
                        copyBoFieldAttributes.add(copyBoFieldAttribute);
                    });
                    Optional.ofNullable(boFieldValidatesMap.get(copyBoField.getPublishFieldId())).ifPresent(boFieldValidates -> {
                        BoFieldValidate copyBoFieldValidate = boFieldValidates.isEmpty() ? new BoFieldValidate() : BoFieldValidateStructMapper.MAPPER.clone((BoFieldValidate)boFieldValidates.get(0));
                        copyBoFieldValidate.setId(null).setFieldId(copyBoField.getId());
                        copyBoFieldValidates.add(copyBoFieldValidate);
                    });
                    Optional.ofNullable(boFieldDomainAttributeMap.get(copyBoField.getPublishFieldId())).ifPresent(boFieldDomainAttributes -> {
                        BoFieldDomainAttribute copyBoFieldDomainAttribute = boFieldDomainAttributes.isEmpty() ? new BoFieldDomainAttribute() : BoFieldDomainAttributeStructMapper.MAPPER.clone((BoFieldDomainAttribute)boFieldDomainAttributes.get(0));
                        copyBoFieldDomainAttribute.setId(null).setFieldId(copyBoField.getId()).setDeleteFlag("1");
                        copyBoFieldDomainAttributes.add(copyBoFieldDomainAttribute);
                    });
                });
            } else {
                Set boFieldIds = oriFIdVCopyBoFieldMap.keySet();
                Map boFieldAttrsMap = this.boFieldAttributeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoFieldAttribute::getFieldId, boFieldIds)).eq(BoFieldAttribute::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoFieldAttribute::getFieldId, Collectors.toList()));
                Map<Long, List<BoFieldValidate>> boFieldValidatesMap = this.boFieldValidateService.list((Wrapper)Wrappers.lambdaQuery().in(BoFieldValidate::getFieldId, boFieldIds)).stream().collect(Collectors.groupingBy(BoFieldValidate::getFieldId));
                Map boFieldDomainAttributeMap = this.boFieldDomainAttributeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoFieldDomainAttribute::getFieldId, boFieldIds)).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoFieldDomainAttribute::getFieldId, Collectors.toList()));
                boFieldIds.forEach(boFieldId -> {
                    BoField copyBoField = (BoField)oriFIdVCopyBoFieldMap.get(boFieldId);
                    Optional.ofNullable(boFieldAttrsMap.get(boFieldId)).ifPresent(boFieldAttributes -> {
                        BoFieldAttribute copyBoFieldAttribute = boFieldAttributes.isEmpty() ? CommonBusiness.newBoFieldAttribute((BoField)copyBoField) : BoFieldAttributeStructMapper.MAPPER.clone((BoFieldAttribute)boFieldAttributes.get(0));
                        copyBoFieldAttribute.setId(null).setFieldId(copyBoField.getId()).setDeleteFlag("1");
                        copyBoFieldAttributes.add(copyBoFieldAttribute);
                    });
                    Optional.ofNullable(boFieldValidatesMap.get(boFieldId)).ifPresent(boFieldValidates -> {
                        BoFieldValidate copyBoFieldValidate = boFieldValidates.isEmpty() ? new BoFieldValidate() : BoFieldValidateStructMapper.MAPPER.clone((BoFieldValidate)boFieldValidates.get(0));
                        copyBoFieldValidate.setId(null);
                        copyBoFieldValidate.setFieldId(copyBoField.getId());
                        copyBoFieldValidates.add(copyBoFieldValidate);
                    });
                    Optional.ofNullable(boFieldDomainAttributeMap.get(boFieldId)).ifPresent(boFieldDomainAttributes -> {
                        BoFieldDomainAttribute copyBoFieldDomainAttribute = boFieldDomainAttributes.isEmpty() ? new BoFieldDomainAttribute() : BoFieldDomainAttributeStructMapper.MAPPER.clone((BoFieldDomainAttribute)boFieldDomainAttributes.get(0));
                        copyBoFieldDomainAttribute.setId(null).setFieldId(copyBoField.getId()).setDeleteFlag("1");
                        copyBoFieldDomainAttributes.add(copyBoFieldDomainAttribute);
                    });
                });
            }
        }));
        this.moduleBoService.saveBatch(copyModuleBos);
        this.boFieldAttributeService.saveBatch((Collection)copyBoFieldAttributes);
        if (CollectionUtils.isNotEmpty((Collection)copyBoIndexes)) {
            this.boIndexService.saveBatch((Collection)copyBoIndexes);
        }
        if (CollectionUtils.isNotEmpty((Collection)copyBoApiDetails)) {
            this.boApiDetailService.saveBatch((Collection)copyBoApiDetails);
        }
        if (CollectionUtils.isNotEmpty((Collection)copyBoDataRuleDetails)) {
            this.boDataRuleDetailService.saveBatch((Collection)copyBoDataRuleDetails);
        }
        if (CollectionUtils.isNotEmpty((Collection)copyBoFieldValidates)) {
            this.boFieldValidateService.saveBatch((Collection)copyBoFieldValidates);
        }
        if (AppCustomType.TENANT.code().equals(app.getCustomType())) {
            this.convertUIdToVIdForPublishPartWhenIsTenantApp(copyBoRelationships, copyBoFieldDomainAttributes, pBoRelationsMap, aBoIds, oriBoIdVCopyBoMap, uniBoIdVCopyBoMap, copyBoIdVCopyBoFieldMap2, copyBoIdVCopyBoFieldPidMap);
        } else {
            this.convertUIdToVIdForPublishPart(copyBos, allCopyBoFields, copyBoRelationships, copyBoFieldDomainAttributes, allCopyBoDataRules, pBoRelationsMap, aBoIds, oriBoIdVCopyBoMap, uniBoIdVCopyBoMap, copyBoIdVCopyBoFieldMap2, copyBoIdVCopyBoFieldPidMap);
        }
        VersionIdMapThreadLocal.getInstance().getIdMap().putAll(oriBoIdVCopyBoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Bo)e.getValue()).getId())));
        VersionIdMapThreadLocal.getInstance().getIdMap().putAll(uniBoIdVCopyBoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Bo)e.getValue()).getId())));
    }

    private void convertUIdToVIdForPublishAll(List<Bo> copyBos, List<BoField> allCopyBoFields, List<BoRelationship> copyBoRelationships, List<BoFieldDomainAttribute> copyBoFieldDomainAttributes, List<BoDataRule> copyBoDataRules, Map<Long, Long> bo2Vbos, Map<Long, Map<Long, Long>> nboVFields) {
        List rBoDataRules;
        List aggreBoFieldDomainAttribute;
        List rpBos = copyBos.stream().filter(vbo -> vbo.getParentBoId() != null || vbo.getRefBoId() != null || vbo.getSyncBoId() != null).map(vbo -> {
            Optional.ofNullable(vbo.getParentBoId()).ifPresent(parentBoId -> vbo.setParentBoId((Long)bo2Vbos.get(parentBoId)));
            Optional.ofNullable(vbo.getRefBoId()).ifPresent(refBoId -> vbo.setRefBoId((Long)bo2Vbos.get(refBoId)));
            Optional.ofNullable(vbo.getSyncBoId()).ifPresent(syncBoId -> vbo.setSyncBoId((Long)bo2Vbos.get(syncBoId)));
            return vbo;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rpBos)) {
            this.boService.updateBatchById(rpBos);
        }
        Map<Long, Long> pFieldIdVCopyFieldIdMap = allCopyBoFields.stream().collect(Collectors.toMap(BoField::getPublishFieldId, BoField::getId));
        List updateBoFields = allCopyBoFields.stream().filter(boField -> boField.getSyncFieldId() != null && pFieldIdVCopyFieldIdMap.containsKey(boField.getSyncFieldId())).map(boField -> {
            boField.setSyncFieldId((Long)pFieldIdVCopyFieldIdMap.get(boField.getSyncFieldId()));
            return boField;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(updateBoFields)) {
            this.boFieldService.updateBatchById(updateBoFields);
        }
        copyBoRelationships.forEach(relation -> {
            relation.setJoinBoId((Long)bo2Vbos.get(relation.getJoinBoId()));
            if (relation.getBoField() != null) {
                Optional.ofNullable(nboVFields.get(relation.getBoId())).ifPresent(boFieldMap -> relation.setBoField((Long)boFieldMap.get(relation.getBoField())));
            }
            if (relation.getJoinField() != null) {
                Optional.ofNullable(nboVFields.get(relation.getJoinBoId())).ifPresent(boFieldMap -> relation.setJoinField((Long)boFieldMap.get(relation.getJoinField())));
            }
        });
        if (CollectionUtils.isNotEmpty(copyBoRelationships)) {
            this.boRelationshipService.updateBatchById(copyBoRelationships);
        }
        Map<Long, Long> relUIdOriIdMapping = copyBoRelationships.stream().collect(Collectors.toMap(BoRelationship::getUniqueId, BoRelationship::getId));
        List lookupBoFieldDomainAttribute = copyBoFieldDomainAttributes.stream().filter(domainAttribute -> domainAttribute.getLookupBoId() != null || domainAttribute.getLookupFieldId() != null || domainAttribute.getLookupRelationId() != null).map(domainAttribute -> {
            if (domainAttribute.getLookupRelationId() != null) {
                domainAttribute.setLookupRelationId((Long)relUIdOriIdMapping.get(domainAttribute.getLookupRelationId()));
            }
            if (domainAttribute.getLookupBoId() != null) {
                domainAttribute.setLookupBoId((Long)bo2Vbos.get(domainAttribute.getLookupBoId()));
            }
            if (domainAttribute.getLookupBoId() != null && domainAttribute.getLookupFieldId() != null) {
                Optional.ofNullable(nboVFields.get(domainAttribute.getLookupBoId())).ifPresent(boFieldMap -> domainAttribute.setLookupFieldId((Long)boFieldMap.get(domainAttribute.getLookupFieldId())));
            }
            return domainAttribute;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(lookupBoFieldDomainAttribute)) {
            this.boFieldDomainAttributeService.updateBatchById(lookupBoFieldDomainAttribute);
        }
        if (CollectionUtils.isNotEmpty(aggreBoFieldDomainAttribute = copyBoFieldDomainAttributes.stream().filter(domainAttribute -> domainAttribute.getAggregationBoId() != null || domainAttribute.getAggregationFieldId() != null || domainAttribute.getAggregationRelationId() != null).map(domainAttribute -> {
            if (domainAttribute.getAggregationRelationId() != null) {
                domainAttribute.setAggregationRelationId((Long)relUIdOriIdMapping.get(domainAttribute.getAggregationRelationId()));
            }
            if (domainAttribute.getAggregationBoId() != null) {
                domainAttribute.setAggregationBoId((Long)bo2Vbos.get(domainAttribute.getAggregationBoId()));
            }
            if (domainAttribute.getAggregationBoId() != null && domainAttribute.getAggregationFieldId() != null) {
                Optional.ofNullable(nboVFields.get(domainAttribute.getAggregationBoId())).ifPresent(boFieldMap -> domainAttribute.setAggregationFieldId((Long)boFieldMap.get(domainAttribute.getAggregationFieldId())));
            }
            return domainAttribute;
        }).collect(Collectors.toList()))) {
            this.boFieldDomainAttributeService.updateBatchById(aggreBoFieldDomainAttribute);
        }
        if (CollectionUtils.isNotEmpty(rBoDataRules = copyBoDataRules.stream().filter(dr -> null != dr.getRefBoId()).map(dr -> {
            dr.setRefBoId((Long)bo2Vbos.get(dr.getRefBoId()));
            return dr;
        }).collect(Collectors.toList()))) {
            this.boDataRuleService.updateBatchById(rBoDataRules);
        }
    }

    private void convertUIdToVIdForPublishPart(List<Bo> copyBos, List<BoField> allCopyBoFields, List<BoRelationship> copyBoRelationships, List<BoFieldDomainAttribute> copyBoFieldDomainAttributes, List<BoDataRule> copyBoDataRules, Map<Long, List<BoRelationship>> pBoRelationsMap, List<Long> aBoIds, Map<Long, Bo> oriBoIdVCopyBoMap, Map<Long, Bo> uniBoIdVCopyBoMap, Map<Long, Map<Long, BoField>> copyBoIdVCopyBoFieldMap2, Map<Long, Map<Long, BoField>> copyBoIdVCopyBoFieldPidMap) {
        List rBoDataRules;
        List rpBos = copyBos.stream().filter(vbo -> vbo.getParentBoId() != null || vbo.getRefBoId() != null || vbo.getSyncBoId() != null).map(vbo -> {
            if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(vbo.getPublishBoId())) {
                Optional.ofNullable(vbo.getParentBoId()).ifPresent(parentBoId -> vbo.setParentBoId(((Bo)uniBoIdVCopyBoMap.get(parentBoId)).getId()));
                Optional.ofNullable(vbo.getRefBoId()).ifPresent(refBoId -> vbo.setRefBoId(((Bo)uniBoIdVCopyBoMap.get(refBoId)).getId()));
                Optional.ofNullable(vbo.getSyncBoId()).ifPresent(syncBoId -> vbo.setSyncBoId(((Bo)uniBoIdVCopyBoMap.get(syncBoId)).getId()));
            } else {
                Optional.ofNullable(vbo.getParentBoId()).ifPresent(parentBoId -> {
                    Long boId;
                    if (oriBoIdVCopyBoMap.containsKey(parentBoId)) {
                        boId = ((Bo)oriBoIdVCopyBoMap.get(parentBoId)).getId();
                    } else if (uniBoIdVCopyBoMap.containsKey(parentBoId)) {
                        boId = ((Bo)uniBoIdVCopyBoMap.get(parentBoId)).getId();
                    } else {
                        log.error(String.format("\u6839\u636eparentBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", parentBoId));
                        return;
                    }
                    vbo.setParentBoId(boId);
                });
                Optional.ofNullable(vbo.getRefBoId()).ifPresent(refBoId -> {
                    Long boId;
                    if (oriBoIdVCopyBoMap.containsKey(refBoId)) {
                        boId = ((Bo)oriBoIdVCopyBoMap.get(refBoId)).getId();
                    } else if (uniBoIdVCopyBoMap.containsKey(refBoId)) {
                        boId = ((Bo)uniBoIdVCopyBoMap.get(refBoId)).getId();
                    } else {
                        log.error(String.format("\u6839\u636erefBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", refBoId));
                        return;
                    }
                    vbo.setRefBoId(boId);
                });
                Optional.ofNullable(vbo.getSyncBoId()).ifPresent(syncBoId -> {
                    Long boId;
                    if (oriBoIdVCopyBoMap.containsKey(syncBoId)) {
                        boId = ((Bo)oriBoIdVCopyBoMap.get(syncBoId)).getId();
                    } else if (uniBoIdVCopyBoMap.containsKey(syncBoId)) {
                        boId = ((Bo)uniBoIdVCopyBoMap.get(syncBoId)).getId();
                    } else {
                        log.error(String.format("\u6839\u636esyncBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", syncBoId));
                        return;
                    }
                    vbo.setSyncBoId(boId);
                });
            }
            return vbo;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rpBos)) {
            this.boService.updateBatchById(rpBos);
        }
        Map<Long, Long> pFieldIdVCopyFieldIdMap = allCopyBoFields.stream().collect(Collectors.toMap(BoField::getPublishFieldId, BoField::getId));
        List updateBoFields = allCopyBoFields.stream().filter(boField -> boField.getSyncFieldId() != null && pFieldIdVCopyFieldIdMap.containsKey(boField.getSyncFieldId())).map(boField -> {
            boField.setSyncFieldId((Long)pFieldIdVCopyFieldIdMap.get(boField.getSyncFieldId()));
            return boField;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(updateBoFields)) {
            this.boFieldService.updateBatchById(updateBoFields);
        }
        copyBoRelationships.forEach(relation -> {
            if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(relation.getBoId())) {
                if (relation.getJoinBoId() != null) {
                    if (!uniBoIdVCopyBoMap.containsKey(relation.getJoinBoId())) {
                        log.error(String.format("\u6839\u636erelation.joinBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", relation.getJoinBoId()));
                        return;
                    }
                    relation.setJoinBoId(((Bo)uniBoIdVCopyBoMap.get(relation.getJoinBoId())).getId());
                }
            } else if (relation.getJoinBoId() != null) {
                Long joinBoId;
                if (oriBoIdVCopyBoMap.containsKey(relation.getJoinBoId())) {
                    joinBoId = ((Bo)oriBoIdVCopyBoMap.get(relation.getJoinBoId())).getId();
                } else if (uniBoIdVCopyBoMap.containsKey(relation.getJoinBoId())) {
                    joinBoId = ((Bo)uniBoIdVCopyBoMap.get(relation.getJoinBoId())).getId();
                } else {
                    log.error(String.format("\u6839\u636erelation.joinBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", relation.getJoinBoId()));
                    return;
                }
                relation.setJoinBoId(joinBoId);
            }
            if (relation.getBoField() != null) {
                Optional.ofNullable(copyBoIdVCopyBoFieldMap2.get(relation.getBoId())).ifPresent(oriFIdVCopyBoFieldMap2 -> {
                    BoField boField;
                    BoField boField2 = boField = oriFIdVCopyBoFieldMap2.containsKey(relation.getBoField()) ? (BoField)oriFIdVCopyBoFieldMap2.get(relation.getBoField()) : (BoField)((Map)copyBoIdVCopyBoFieldPidMap.get(relation.getBoId())).get(relation.getBoField());
                    if (boField != null) {
                        relation.setBoField(boField.getId());
                    }
                });
            }
            if (relation.getJoinField() != null) {
                Optional.ofNullable(copyBoIdVCopyBoFieldMap2.get(relation.getJoinBoId())).ifPresent(oriFIdVCopyBoFieldMap2 -> {
                    BoField boField;
                    BoField boField2 = boField = oriFIdVCopyBoFieldMap2.containsKey(relation.getJoinField()) ? (BoField)oriFIdVCopyBoFieldMap2.get(relation.getJoinField()) : (BoField)((Map)copyBoIdVCopyBoFieldPidMap.get(relation.getJoinBoId())).get(relation.getJoinField());
                    if (boField != null) {
                        relation.setJoinField(boField.getId());
                    }
                });
            }
        });
        if (CollectionUtils.isNotEmpty(copyBoRelationships)) {
            this.boRelationshipService.saveBatch(copyBoRelationships);
        }
        Map<Long, Long> relVIdUIdMapping = pBoRelationsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoRelationship::getId, BoRelationship::getUniqueId));
        Map<Long, Long> relUIdCopyIdMapping = copyBoRelationships.stream().collect(Collectors.toMap(BoRelationship::getUniqueId, BoRelationship::getId));
        copyBoFieldDomainAttributes.stream().filter(domainAttribute -> domainAttribute.getLookupBoId() != null || domainAttribute.getLookupFieldId() != null || domainAttribute.getLookupRelationId() != null).forEach(domainAttribute -> {
            if (domainAttribute.getLookupRelationId() != null) {
                if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(domainAttribute.getLookupBoId())) {
                    domainAttribute.setLookupRelationId((Long)relUIdCopyIdMapping.get(domainAttribute.getLookupRelationId()));
                } else {
                    Long relUniqueId;
                    Long l = relUniqueId = relUIdCopyIdMapping.keySet().contains(domainAttribute.getLookupRelationId()) ? domainAttribute.getLookupRelationId() : (Long)relVIdUIdMapping.get(domainAttribute.getLookupRelationId());
                    if (relUniqueId == null) {
                        throw new RuntimeException(String.format("\u6839\u636edomainAttribute.getLookupRelationId\u67e5\u8be2\u4e0d\u5230\u5173\u7cfbuniqueId %d ", domainAttribute.getLookupRelationId()));
                    }
                    domainAttribute.setLookupRelationId((Long)relUIdCopyIdMapping.get(relUniqueId));
                }
            }
            if (domainAttribute.getLookupBoId() != null) {
                Long lookupBoId = null;
                if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(domainAttribute.getLookupBoId())) {
                    if (!uniBoIdVCopyBoMap.containsKey(domainAttribute.getLookupBoId())) {
                        log.error(String.format("\u6839\u636edomainAttribute.getLookupBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", domainAttribute.getLookupBoId()));
                    } else {
                        lookupBoId = ((Bo)uniBoIdVCopyBoMap.get(domainAttribute.getLookupBoId())).getId();
                    }
                } else if (oriBoIdVCopyBoMap.containsKey(domainAttribute.getLookupBoId())) {
                    lookupBoId = ((Bo)oriBoIdVCopyBoMap.get(domainAttribute.getLookupBoId())).getId();
                } else if (uniBoIdVCopyBoMap.containsKey(domainAttribute.getLookupBoId())) {
                    lookupBoId = ((Bo)uniBoIdVCopyBoMap.get(domainAttribute.getLookupBoId())).getId();
                } else {
                    log.error(String.format("\u6839\u636edomainAttribute.getLookupBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", domainAttribute.getLookupBoId()));
                }
                domainAttribute.setLookupBoId(lookupBoId);
                if (domainAttribute.getLookupFieldId() != null) {
                    Optional.ofNullable(copyBoIdVCopyBoFieldMap2.get(domainAttribute.getLookupBoId())).ifPresent(oriFIdVCopyBoFieldMap2 -> {
                        BoField copyBoField;
                        BoField boField = copyBoField = oriFIdVCopyBoFieldMap2.containsKey(domainAttribute.getLookupFieldId()) ? (BoField)oriFIdVCopyBoFieldMap2.get(domainAttribute.getLookupFieldId()) : (BoField)((Map)copyBoIdVCopyBoFieldPidMap.get(domainAttribute.getLookupBoId())).get(domainAttribute.getLookupFieldId());
                        if (copyBoField != null) {
                            domainAttribute.setLookupFieldId(copyBoField.getId());
                        }
                    });
                }
            }
        });
        copyBoFieldDomainAttributes.stream().filter(domainAttribute -> domainAttribute.getAggregationBoId() != null || domainAttribute.getAggregationFieldId() != null || domainAttribute.getAggregationRelationId() != null).forEach(domainAttribute -> {
            if (domainAttribute.getAggregationRelationId() != null) {
                if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(domainAttribute.getAggregationBoId())) {
                    domainAttribute.setAggregationRelationId((Long)relUIdCopyIdMapping.get(domainAttribute.getAggregationRelationId()));
                } else {
                    Long relUniqueId;
                    Long l = relUniqueId = relUIdCopyIdMapping.keySet().contains(domainAttribute.getAggregationRelationId()) ? domainAttribute.getAggregationRelationId() : (Long)relVIdUIdMapping.get(domainAttribute.getAggregationRelationId());
                    if (relUniqueId == null) {
                        throw new RuntimeException(String.format("\u6839\u636edomainAttribute.getAggregationRelationId\u67e5\u8be2\u4e0d\u5230\u5173\u7cfbuniqueId %d ", domainAttribute.getAggregationRelationId()));
                    }
                    domainAttribute.setAggregationRelationId((Long)relUIdCopyIdMapping.get(relUniqueId));
                }
            }
            if (domainAttribute.getAggregationBoId() != null) {
                Long aggregationBoId = null;
                if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(domainAttribute.getAggregationBoId())) {
                    if (!uniBoIdVCopyBoMap.containsKey(domainAttribute.getAggregationBoId())) {
                        log.error(String.format("\u6839\u636edomainAttribute.getAggregationBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", domainAttribute.getAggregationBoId()));
                    } else {
                        aggregationBoId = ((Bo)uniBoIdVCopyBoMap.get(domainAttribute.getAggregationBoId())).getId();
                    }
                } else if (oriBoIdVCopyBoMap.containsKey(domainAttribute.getAggregationBoId())) {
                    aggregationBoId = ((Bo)oriBoIdVCopyBoMap.get(domainAttribute.getAggregationBoId())).getId();
                } else if (uniBoIdVCopyBoMap.containsKey(domainAttribute.getAggregationBoId())) {
                    aggregationBoId = ((Bo)uniBoIdVCopyBoMap.get(domainAttribute.getAggregationBoId())).getId();
                } else {
                    log.error(String.format("\u6839\u636edomainAttribute.getAggregationBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", domainAttribute.getAggregationBoId()));
                }
                domainAttribute.setAggregationBoId(aggregationBoId);
                if (domainAttribute.getAggregationFieldId() != null) {
                    Optional.ofNullable(copyBoIdVCopyBoFieldMap2.get(domainAttribute.getAggregationBoId())).ifPresent(oriFIdVCopyBoFieldMap2 -> {
                        BoField copyBoField;
                        BoField boField = copyBoField = oriFIdVCopyBoFieldMap2.containsKey(domainAttribute.getAggregationFieldId()) ? (BoField)oriFIdVCopyBoFieldMap2.get(domainAttribute.getAggregationFieldId()) : (BoField)((Map)copyBoIdVCopyBoFieldPidMap.get(domainAttribute.getAggregationBoId())).get(domainAttribute.getAggregationFieldId());
                        if (copyBoField != null) {
                            domainAttribute.setAggregationFieldId(copyBoField.getId());
                        }
                    });
                }
            }
        });
        if (CollectionUtils.isNotEmpty(copyBoFieldDomainAttributes)) {
            this.boFieldDomainAttributeService.saveBatch(copyBoFieldDomainAttributes);
        }
        if (CollectionUtils.isNotEmpty(rBoDataRules = copyBoDataRules.stream().filter(dr -> null != dr.getRefBoId()).map(dr -> {
            Long boId;
            if (oriBoIdVCopyBoMap.containsKey(dr.getRefBoId())) {
                boId = ((Bo)oriBoIdVCopyBoMap.get(dr.getRefBoId())).getId();
            } else if (uniBoIdVCopyBoMap.containsKey(dr.getRefBoId())) {
                boId = ((Bo)uniBoIdVCopyBoMap.get(dr.getRefBoId())).getId();
            } else {
                throw new RuntimeException(String.format("\u6839\u636eboDataRule RefBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u5feb\u7167\u5bf9\u8c61ID %d ", dr.getRefBoId()));
            }
            dr.setRefBoId(boId);
            return dr;
        }).collect(Collectors.toList()))) {
            this.boDataRuleService.updateBatchById(rBoDataRules);
        }
    }

    private void convertUIdToVIdForPublishAllWhenIsTenantApp(List<BoRelationship> copyBoRelationships, List<BoFieldDomainAttribute> copyBoFieldDomainAttributes, Map<Long, Long> bo2Vbos, Map<Long, Map<Long, Long>> nboVFields) {
        copyBoRelationships.forEach(relation -> {
            if (relation.getBoField() != null) {
                Optional.ofNullable(nboVFields.get(relation.getBoId())).ifPresent(boFieldMap -> relation.setBoField(boFieldMap.getOrDefault(relation.getBoField(), relation.getBoField())));
            }
            if (relation.getJoinField() != null) {
                Optional.ofNullable(nboVFields.get(relation.getJoinBoId())).ifPresent(boFieldMap -> relation.setJoinField(boFieldMap.getOrDefault(relation.getJoinField(), relation.getJoinField())));
            }
        });
        if (CollectionUtils.isNotEmpty(copyBoRelationships)) {
            this.boRelationshipService.updateBatchById(copyBoRelationships);
        }
        Map<Long, Long> relUIdOriIdMapping = copyBoRelationships.stream().collect(Collectors.toMap(BoRelationship::getUniqueId, BoRelationship::getId));
        List lookupBoFieldDomainAttributes = copyBoFieldDomainAttributes.stream().filter(domainAttribute -> domainAttribute.getLookupBoId() != null || domainAttribute.getLookupFieldId() != null || domainAttribute.getLookupRelationId() != null).map(domainAttribute -> {
            if (domainAttribute.getLookupRelationId() != null) {
                domainAttribute.setLookupRelationId(relUIdOriIdMapping.getOrDefault(domainAttribute.getLookupRelationId(), domainAttribute.getLookupRelationId()));
            }
            if (domainAttribute.getLookupBoId() != null) {
                domainAttribute.setLookupBoId(bo2Vbos.getOrDefault(domainAttribute.getLookupBoId(), domainAttribute.getLookupBoId()));
                Optional.ofNullable(nboVFields.get(domainAttribute.getLookupBoId())).ifPresent(boFieldMap -> domainAttribute.setLookupFieldId(boFieldMap.getOrDefault(domainAttribute.getLookupFieldId(), domainAttribute.getLookupFieldId())));
            }
            return domainAttribute;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(lookupBoFieldDomainAttributes)) {
            this.boFieldDomainAttributeService.updateBatchById(lookupBoFieldDomainAttributes);
        }
    }

    private void convertUIdToVIdForPublishPartWhenIsTenantApp(List<BoRelationship> copyBoRelationships, List<BoFieldDomainAttribute> copyBoFieldDomainAttributes, Map<Long, List<BoRelationship>> pBoRelationsMap, List<Long> aBoIds, Map<Long, Bo> oriBoIdVCopyBoMap, Map<Long, Bo> uniBoIdVCopyBoMap, Map<Long, Map<Long, BoField>> copyBoIdVCopyBoFieldMap2, Map<Long, Map<Long, BoField>> copyBoIdVCopyBoFieldPidMap) {
        copyBoRelationships.forEach(relation -> {
            if (relation.getBoField() != null) {
                Optional.ofNullable(copyBoIdVCopyBoFieldMap2.get(relation.getBoId())).ifPresent(oriFIdVCopyBoFieldMap2 -> {
                    BoField boField;
                    BoField boField2 = boField = oriFIdVCopyBoFieldMap2.containsKey(relation.getBoField()) ? (BoField)oriFIdVCopyBoFieldMap2.get(relation.getBoField()) : (BoField)((Map)copyBoIdVCopyBoFieldPidMap.get(relation.getBoId())).get(relation.getBoField());
                    if (boField != null) {
                        relation.setBoField(boField.getId());
                    }
                });
            }
            if (relation.getJoinField() != null) {
                Optional.ofNullable(copyBoIdVCopyBoFieldMap2.get(relation.getJoinBoId())).ifPresent(oriFIdVCopyBoFieldMap2 -> {
                    BoField boField;
                    BoField boField2 = boField = oriFIdVCopyBoFieldMap2.containsKey(relation.getJoinField()) ? (BoField)oriFIdVCopyBoFieldMap2.get(relation.getJoinField()) : (BoField)((Map)copyBoIdVCopyBoFieldPidMap.get(relation.getJoinBoId())).get(relation.getJoinField());
                    if (boField != null) {
                        relation.setJoinField(boField.getId());
                    }
                });
            }
        });
        if (CollectionUtils.isNotEmpty(copyBoRelationships)) {
            this.boRelationshipService.saveBatch(copyBoRelationships);
        }
        Map<Long, Long> relVIdUIdMapping = pBoRelationsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoRelationship::getId, BoRelationship::getUniqueId));
        Map<Long, Long> relUIdCopyIdMapping = copyBoRelationships.stream().collect(Collectors.toMap(BoRelationship::getUniqueId, BoRelationship::getId));
        copyBoFieldDomainAttributes.stream().filter(domainAttribute -> domainAttribute.getLookupBoId() != null || domainAttribute.getLookupFieldId() != null || domainAttribute.getLookupRelationId() != null).forEach(domainAttribute -> {
            if (domainAttribute.getLookupRelationId() != null) {
                if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(domainAttribute.getLookupBoId())) {
                    domainAttribute.setLookupRelationId((Long)relUIdCopyIdMapping.get(domainAttribute.getLookupRelationId()));
                } else {
                    Long relUniqueId = relUIdCopyIdMapping.keySet().contains(domainAttribute.getLookupRelationId()) ? domainAttribute.getLookupRelationId() : (Long)relVIdUIdMapping.get(domainAttribute.getLookupRelationId());
                    domainAttribute.setLookupRelationId(relUIdCopyIdMapping.getOrDefault(relUniqueId, domainAttribute.getLookupRelationId()));
                }
            }
            if (domainAttribute.getLookupBoId() != null) {
                Long lookupBoId = domainAttribute.getLookupBoId();
                if (CollectionUtils.isNotEmpty((Collection)aBoIds) && aBoIds.contains(domainAttribute.getLookupBoId())) {
                    if (!uniBoIdVCopyBoMap.containsKey(domainAttribute.getLookupBoId())) {
                        log.error(String.format("\u6839\u636edomainAttribute.getLookupBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", domainAttribute.getLookupBoId()));
                    } else {
                        lookupBoId = ((Bo)uniBoIdVCopyBoMap.get(domainAttribute.getLookupBoId())).getId();
                    }
                } else if (oriBoIdVCopyBoMap.containsKey(domainAttribute.getLookupBoId())) {
                    lookupBoId = ((Bo)oriBoIdVCopyBoMap.get(domainAttribute.getLookupBoId())).getId();
                } else if (uniBoIdVCopyBoMap.containsKey(domainAttribute.getLookupBoId())) {
                    lookupBoId = ((Bo)uniBoIdVCopyBoMap.get(domainAttribute.getLookupBoId())).getId();
                } else {
                    log.error(String.format("\u6839\u636edomainAttribute.getLookupBoId\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61 %d ", domainAttribute.getLookupBoId()));
                }
                domainAttribute.setLookupBoId(lookupBoId);
                if (domainAttribute.getLookupFieldId() != null) {
                    Optional.ofNullable(copyBoIdVCopyBoFieldMap2.get(domainAttribute.getLookupBoId())).ifPresent(oriFIdVCopyBoFieldMap2 -> {
                        BoField copyBoField;
                        BoField boField = copyBoField = oriFIdVCopyBoFieldMap2.containsKey(domainAttribute.getLookupFieldId()) ? (BoField)oriFIdVCopyBoFieldMap2.get(domainAttribute.getLookupFieldId()) : (BoField)((Map)copyBoIdVCopyBoFieldPidMap.get(domainAttribute.getLookupBoId())).get(domainAttribute.getLookupFieldId());
                        if (copyBoField != null) {
                            domainAttribute.setLookupFieldId(copyBoField.getId());
                        }
                    });
                }
            }
        });
    }
}

