/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.event.PublishEvent;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionDictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DictDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import io.vavr.Tuple6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class DictVersionPublishExecutor {
    private static final Logger log = LoggerFactory.getLogger(DictVersionPublishExecutor.class);
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictDetailRepository dictDetailRepository;
    @Autowired
    private IDictDetailService dictDetailService;
    @Autowired
    private IDictService dictService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(final String newVersion, String originVersion, final PublishContent publishContent) {
        App app = this.appRepository.getAppWithValidate(publishContent.getAppId().longValue());
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        final List uDicts = this.dictRepository.getDicts(publishContent.getAppId());
        if (CollectionUtils.isNotEmpty(publishContent.getUnDictChanges())) {
            this.publishDictVersionByChangeItems(app, newVersion, originVersion, appVersionType, publishContent.getDictChanges(), publishContent.getAddDictChanges(), uDicts);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    DictVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.DICT, publishContent.getAppId(), publishContent.getDictChanges(), newVersion));
                }
            });
        } else {
            this.publishDictVersion(app, newVersion, appVersionType, uDicts);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    DictVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.DICT, publishContent.getAppId(), newVersion, uDicts.stream().map(Dict::getId).collect(Collectors.toList())));
                }
            });
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent(this, MetadataType.DICT, publishContent));
        return ServiceResponse.success();
    }

    private void publishDictVersion(App app, String newVersion, AppVersionType appVersionType, List<Dict> uDicts) {
        if (uDicts.isEmpty()) {
            return;
        }
        ArrayList copyDicts = Lists.newArrayList();
        uDicts.forEach(dict -> {
            Dict copyDict = DictStructMapper.MAPPER.clone(dict);
            copyDict.setId(null);
            copyDict.setPublishDictId(dict.getId());
            copyDict.setPublishFlag(PublishFlag.PUBLISHED.code());
            copyDict.setVersion(newVersion);
            copyDicts.add(copyDict);
        });
        this.dictService.saveBatch((Collection)copyDicts);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uDicts.forEach(dict -> {
                dict.setVersion(newVersion);
                this.dictService.alwaysUpdateSomeColumnById(dict);
            });
        }
        List dictIds = uDicts.stream().map(Dict::getId).collect(Collectors.toList());
        Map<Long, List<DictDetail>> dictDetailMap = this.dictDetailRepository.getDictDetailsByDictIds(dictIds).stream().collect(Collectors.groupingBy(DictDetail::getDictId));
        ArrayList copyDictDetails = Lists.newArrayList();
        copyDicts.forEach(copyDict -> Optional.ofNullable(dictDetailMap.get(copyDict.getPublishDictId())).ifPresent(dictDetails -> dictDetails.forEach(dictDetail -> {
            DictDetail copyDictDetail = DictDetailStructMapper.MAPPER.clone(dictDetail);
            copyDictDetail.setId(null);
            copyDictDetail.setDictId(copyDict.getId());
            copyDictDetail.setVersion(newVersion);
            copyDictDetails.add(copyDictDetail);
            if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
                dictDetail.setVersion(VersionUtils.nextVersion((String)dictDetail.getVersion(), (AppVersionType)appVersionType));
            }
        })));
        this.dictDetailService.saveBatch((Collection)copyDictDetails);
        if (!AppVersionType.PATCH.equals((Object)appVersionType) && !dictDetailMap.isEmpty()) {
            List updateDictDetails = dictDetailMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            this.dictDetailService.updateBatchById(updateDictDetails);
        }
        if (!AppCustomType.TENANT.code().equals(app.getCustomType())) {
            this.convertUniIdToVersionIdForPublishAll(copyDicts);
        }
    }

    private void publishDictVersionByChangeItems(App app, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addDictChanges, List<Dict> uDicts) {
        List uDictIds = uDicts.stream().map(Dict::getId).collect(Collectors.toList());
        Map uDictDetailsMap = this.dictDetailRepository.getDictDetailsByDictIds(uDictIds).stream().collect(Collectors.groupingBy(DictDetail::getDictId, Collectors.toList()));
        List pDicts = this.dictService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)app.getId())).eq(Dict::getVersion, (Object)originVersion)).eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        List pDictIds = pDicts.stream().map(Dict::getId).collect(Collectors.toList());
        Map pDictDetailsMap = this.dictDetailRepository.getDictDetailsByDictIds(pDictIds).stream().collect(Collectors.groupingBy(DictDetail::getDictId, Collectors.toList()));
        Map<Long, Long> pPDictIdVOriDictId = pDicts.stream().collect(Collectors.toMap(Dict::getPublishDictId, Dict::getId));
        Tuple6<List<Dict>, List<Dict>, List<Dict>, List<DictDetail>, List<DictDetail>, List<DictDetail>> dictChanges = this.publishCommonService.dealDictChanges(changedItems, addDictChanges, pPDictIdVOriDictId);
        ArrayList copyDicts = Lists.newArrayList();
        HashMap oriDictIdVCopyDictMap = Maps.newHashMap();
        HashMap uniDictIdVCopyDictMap = Maps.newHashMap();
        List dDictIds = ((List)dictChanges._2).stream().map(Dict::getId).collect(Collectors.toList());
        pDicts.stream().filter(dict -> !dDictIds.contains(dict.getId())).forEach(dict -> {
            Dict copyDict = DictStructMapper.MAPPER.clone(dict).setId(null).setVersion(newVersion);
            copyDicts.add(copyDict);
            oriDictIdVCopyDictMap.put(dict.getId(), copyDict);
            uniDictIdVCopyDictMap.put(copyDict.getPublishDictId(), copyDict);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)dictChanges._1))) {
            ((List)dictChanges._1).forEach(dict -> {
                Dict copyDict = DictStructMapper.MAPPER.clone(dict).setId(null).setPublishDictId(dict.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copyDicts.add(copyDict);
                oriDictIdVCopyDictMap.put(dict.getId(), copyDict);
                uniDictIdVCopyDictMap.put(copyDict.getPublishDictId(), copyDict);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)dictChanges._3))) {
            ((List)dictChanges._3).forEach(dict -> {
                Optional<Dict> uOptl = copyDicts.stream().filter(cDict -> dict.getId().equals(cDict.getPublishDictId())).findAny();
                if (uOptl.isPresent()) {
                    VersionDictStructMapper.MAPPER.updateDict((Dict)dict, uOptl.get());
                }
            });
        }
        this.dictService.saveBatch((Collection)copyDicts);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uDicts.forEach(dict -> dict.setVersion(newVersion));
            if (!uDicts.isEmpty()) {
                this.dictService.updateBatchById(uDicts);
            }
        }
        List<Long> aDictIds = ((List)dictChanges._1).stream().map(Dict::getId).collect(Collectors.toList());
        ArrayList copyDictDetails = Lists.newArrayList();
        List dDictDlIds = ((List)dictChanges._5).stream().map(DictDetail::getId).collect(Collectors.toList());
        Map<Long, List<DictDetail>> rDictDlsMap = ((List)dictChanges._6).stream().collect(Collectors.groupingBy(DictDetail::getDictId));
        copyDicts.forEach(copyDict -> {
            if (CollectionUtils.isNotEmpty((Collection)aDictIds) && aDictIds.contains(copyDict.getPublishDictId())) {
                Optional.ofNullable(uDictDetailsMap.get(copyDict.getPublishDictId())).ifPresent(dictDetails -> dictDetails.stream().filter(dictDl -> !dDictDlIds.contains(dictDl.getId())).forEach(dictDetail -> copyDictDetails.add(DictDetailStructMapper.MAPPER.clone(dictDetail).setId(null).setDictId(copyDict.getId()).setVersion(newVersion))));
            } else {
                Long pOriDictId = (Long)pPDictIdVOriDictId.get(copyDict.getPublishDictId());
                Optional.ofNullable(pDictDetailsMap.get(pOriDictId)).ifPresent(dictDetails -> {
                    Optional.ofNullable(rDictDlsMap.get(copyDict.getPublishDictId())).ifPresent(rDictDls -> rDictDls.forEach(rDictDl -> dictDetails.stream().filter(dictDl -> rDictDl.getCode().equals(dictDl.getCode())).findAny().ifPresent(dictDl -> VersionDictStructMapper.MAPPER.updateDictDetail((DictDetail)rDictDl, (DictDetail)dictDl))));
                    dictDetails.stream().filter(dictDl -> !dDictDlIds.contains(dictDl.getId())).forEach(dictDetail -> copyDictDetails.add(DictDetailStructMapper.MAPPER.clone(dictDetail).setId(null).setDictId(copyDict.getId()).setVersion(newVersion)));
                });
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)dictChanges._4))) {
            Map<Long, Long> nPDictIdsVDictIds = copyDicts.stream().collect(Collectors.toMap(Dict::getPublishDictId, Dict::getId));
            ((List)dictChanges._4).forEach(dictDetail -> {
                DictDetail copyDictDetail = DictDetailStructMapper.MAPPER.clone(dictDetail).setId(null).setDictId((Long)nPDictIdsVDictIds.get(dictDetail.getDictId()));
                copyDictDetails.add(copyDictDetail);
            });
        }
        this.dictDetailService.saveBatch((Collection)copyDictDetails);
        if (!AppCustomType.TENANT.code().equals(app.getCustomType())) {
            this.convertUniIdToVersionIdForPublishPart(copyDicts, aDictIds, oriDictIdVCopyDictMap, uniDictIdVCopyDictMap);
        }
    }

    private void convertUniIdToVersionIdForPublishAll(List<Dict> copyDicts) {
        Map<Long, Long> dictIdMapping = copyDicts.stream().collect(Collectors.toMap(Dict::getPublishDictId, Dict::getId));
        List rpDicts = copyDicts.stream().filter(vbo -> vbo.getRefDictId() != null).map(o -> {
            Optional.ofNullable(o.getRefDictId()).ifPresent(refId -> o.setRefDictId((Long)dictIdMapping.get(refId)));
            return o;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rpDicts)) {
            this.dictService.updateBatchById(rpDicts);
        }
    }

    private void convertUniIdToVersionIdForPublishPart(List<Dict> copyDicts, List<Long> aDictIds, Map<Long, Dict> oriDictIdVCopyDictMap, Map<Long, Dict> uniDictIdVCopyDictMap) {
        List rpDicts = copyDicts.stream().filter(vbo -> vbo.getRefDictId() != null).map(o -> {
            if (CollectionUtils.isNotEmpty((Collection)aDictIds) && aDictIds.contains(o.getPublishDictId())) {
                Optional.ofNullable(o.getRefDictId()).ifPresent(refBoId -> o.setRefDictId(((Dict)uniDictIdVCopyDictMap.get(refBoId)).getId()));
            } else {
                Optional.ofNullable(o.getRefDictId()).ifPresent(refId -> {
                    Long dictId;
                    if (oriDictIdVCopyDictMap.containsKey(refId)) {
                        dictId = ((Dict)oriDictIdVCopyDictMap.get(refId)).getId();
                    } else if (uniDictIdVCopyDictMap.containsKey(refId)) {
                        dictId = ((Dict)uniDictIdVCopyDictMap.get(refId)).getId();
                    } else {
                        log.error(String.format("\u6839\u636erefDictId\u627e\u4e0d\u5b57\u5178 %d ", refId));
                        return;
                    }
                    o.setRefDictId(dictId);
                });
            }
            return o;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rpDicts)) {
            this.dictService.updateBatchById(rpDicts);
        }
    }
}

