/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.event.PublishEvent;
import com.xforceplus.ultraman.bocp.metadata.version.publish.impl.PageSettingVersionPublishStandardImpl;
import com.xforceplus.ultraman.bocp.metadata.version.publish.impl.PageSettingVersionPublishTenantImpl;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class PageSettingVersionPublishExecutor {
    private static final Logger log = LoggerFactory.getLogger(PageSettingVersionPublishExecutor.class);
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private PageSettingVersionPublishStandardImpl pageSettingVersionPublishStandardImpl;
    @Autowired
    private PageSettingVersionPublishTenantImpl pageSettingVersionPublishTenantImpl;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(Long appId, AppVersionType appVersionType, final List<ChangedItem> changedItems, String publishRemark, final String newVersion, String originVersion) {
        ServiceResponse serviceResponse;
        final App app = this.appRepository.getApp(appId.longValue()).orElse(null);
        if (null == app) {
            throw new RuntimeException("\u67e5\u8be2\u4e0d\u5230\u5e94\u7528");
        }
        if (AppVersionType.PATCH.equals((Object)appVersionType) && (StringUtils.isEmpty((CharSequence)newVersion) || StringUtils.isEmpty((CharSequence)originVersion))) {
            throw new RuntimeException("\u5f53\u53d1\u5e03\u8865\u4e01\u7248\u672c\u65f6\uff0c\u65b0\u7248\u672c\u548c\u539f\u7248\u672c\u4fe1\u606f\u5fc5\u987b\u5b58\u5728");
        }
        if (AppCustomType.STANDARD.code().equals(app.getCustomType())) {
            serviceResponse = this.pageSettingVersionPublishStandardImpl.publish(app, appVersionType, changedItems, newVersion, originVersion);
        } else if (AppCustomType.TENANT.code().equals(app.getCustomType())) {
            serviceResponse = this.pageSettingVersionPublishTenantImpl.publish(app, appVersionType, changedItems, newVersion, originVersion);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5e94\u7528\u7c7b\u578b");
        }
        if (serviceResponse.isSuccess()) {
            final Map versionInfos = (Map)serviceResponse.getData();
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    PageSettingVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent(this, MetadataType.PAGE_SETTING, app.getId(), changedItems, newVersion, versionInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> ((VersionInfo)o.getValue()).getNewVersion()))));
                }
            });
        }
        return serviceResponse;
    }
}

