/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.sdkSetting.mapstruct.SdkSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.event.PublishEvent;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionSdkSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISdkSettingService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SdkSettingRepository;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class SdkSettingVersionPublishExecutor {
    @Autowired
    private ISdkSettingService sdkSettingService;
    @Autowired
    private SdkSettingRepository sdkSettingRepository;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(final String newVersion, String originVersion, final PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        final List uSdkSettings = this.sdkSettingRepository.getSdkSettings(publishContent.getAppId());
        if (CollectionUtils.isNotEmpty(publishContent.getUnSdkSettingChanges())) {
            this.publishVersionByChangeItems(publishContent.getAppId(), newVersion, originVersion, appVersionType, publishContent.getSdkSettingChanges(), publishContent.getAddSdkSettingChanges(), uSdkSettings);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    SdkSettingVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.SDK_SETTING, publishContent.getAppId(), publishContent.getSdkSettingChanges(), newVersion));
                }
            });
        } else {
            this.publishVersion(newVersion, appVersionType, uSdkSettings);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    SdkSettingVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.SDK_SETTING, publishContent.getAppId(), newVersion, uSdkSettings.stream().map(SdkSetting::getId).collect(Collectors.toList())));
                }
            });
        }
        return ServiceResponse.success();
    }

    private void publishVersion(String newVersion, AppVersionType appVersionType, List<SdkSetting> uSdkSettings) {
        if (uSdkSettings.isEmpty()) {
            return;
        }
        ArrayList copySdkSettings = Lists.newArrayList();
        uSdkSettings.forEach(e -> {
            SdkSetting copySdkSetting = SdkSettingStructMapper.MAPPER.clone(e);
            copySdkSetting.setId(null);
            copySdkSetting.setPublishSettingId(e.getId());
            copySdkSetting.setPublishFlag(PublishFlag.PUBLISHED.code());
            copySdkSetting.setVersion(newVersion);
            copySdkSettings.add(copySdkSetting);
        });
        this.sdkSettingService.saveBatch((Collection)copySdkSettings);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uSdkSettings.forEach(e -> {
                e.setVersion(newVersion);
                this.sdkSettingService.alwaysUpdateSomeColumnById(e);
            });
        }
    }

    private void publishVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addSdkSettingChanges, List<SdkSetting> uSdkSettings) {
        List pSdkSettings = this.sdkSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SdkSetting::getAppId, (Object)appId)).eq(SdkSetting::getVersion, (Object)originVersion)).eq(SdkSetting::getDeleteFlag, (Object)"1")).eq(SdkSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        Map<Long, Long> apiUniIdVTplOriginIdMap = pSdkSettings.stream().collect(Collectors.toMap(SdkSetting::getUniqueId, SdkSetting::getId));
        Tuple3<List<SdkSetting>, List<SdkSetting>, List<SdkSetting>> sdkSettingChanges = this.publishCommonService.dealSdkSettingChanges(changedItems, addSdkSettingChanges, apiUniIdVTplOriginIdMap);
        ArrayList copySdkSettings = Lists.newArrayList();
        List dSdkSettingIds = ((List)sdkSettingChanges._2).stream().map(SdkSetting::getId).collect(Collectors.toList());
        pSdkSettings.stream().filter(sdkSetting -> !dSdkSettingIds.contains(sdkSetting.getId())).forEach(sdkSetting -> {
            SdkSetting copySdkSetting = SdkSettingStructMapper.MAPPER.clone(sdkSetting).setId(null).setVersion(newVersion);
            copySdkSettings.add(copySdkSetting);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)sdkSettingChanges._1))) {
            ((List)sdkSettingChanges._1).forEach(sdkSetting -> {
                SdkSetting copySdkSetting = SdkSettingStructMapper.MAPPER.clone(sdkSetting).setId(null).setPublishSettingId(sdkSetting.getId()).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copySdkSettings.add(copySdkSetting);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)sdkSettingChanges._3))) {
            ((List)sdkSettingChanges._3).forEach(sdkSetting -> {
                Optional<SdkSetting> uOptl = copySdkSettings.stream().filter(cSdkSetting -> sdkSetting.getId().equals(cSdkSetting.getUniqueId())).findAny();
                uOptl.ifPresent(event -> VersionSdkSettingStructMapper.MAPPER.updateSdkSetting((SdkSetting)sdkSetting, (SdkSetting)event));
            });
        }
        this.sdkSettingService.saveBatch((Collection)copySdkSettings);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uSdkSettings.forEach(sdkSetting -> sdkSetting.setVersion(newVersion));
            if (!uSdkSettings.isEmpty()) {
                this.sdkSettingService.updateBatchById(uSdkSettings);
            }
        }
    }
}

