/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.SueTagStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.event.PublishEvent;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionSueTagStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueTagService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueTagRepository;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class TagVersionPublishExecutor {
    @Autowired
    private ISueTagService sueTagService;
    @Autowired
    private SueTagRepository sueTagRepository;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(final String newVersion, String originVersion, final PublishContent publishContent) {
        AppVersionType appVersionType = AppVersionType.fromCode((String)publishContent.getVersionType());
        final List uSueTags = this.sueTagRepository.getSueTags(publishContent.getAppId());
        if (CollectionUtils.isNotEmpty(publishContent.getUnTagChanges())) {
            this.publishVersionByChangeItems(publishContent.getAppId(), newVersion, originVersion, appVersionType, publishContent.getTagChanges(), publishContent.getAddTagChanges(), uSueTags);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    TagVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.TAG, publishContent.getAppId(), publishContent.getTagChanges(), newVersion));
                }
            });
        } else {
            this.publishVersion(newVersion, appVersionType, uSueTags);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    TagVersionPublishExecutor.this.applicationEventPublisher.publishEvent((ApplicationEvent)new PublishEvent((Object)this, MetadataType.TAG, publishContent.getAppId(), newVersion, uSueTags.stream().map(SueTag::getId).collect(Collectors.toList())));
                }
            });
        }
        return ServiceResponse.success();
    }

    private void publishVersion(String newVersion, AppVersionType appVersionType, List<SueTag> uSueTags) {
        if (uSueTags.isEmpty()) {
            return;
        }
        ArrayList copySueTags = Lists.newArrayList();
        uSueTags.forEach(authTpl -> {
            SueTag copySueTag = SueTagStructMapper.MAPPER.clone(authTpl);
            copySueTag.setId(null);
            copySueTag.setPublishFlag(PublishFlag.PUBLISHED.code());
            copySueTag.setVersion(newVersion);
            copySueTags.add(copySueTag);
        });
        this.sueTagService.saveBatch((Collection)copySueTags);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uSueTags.forEach(authTpl -> {
                authTpl.setVersion(newVersion);
                this.sueTagService.alwaysUpdateSomeColumnById(authTpl);
            });
        }
    }

    private void publishVersionByChangeItems(Long appId, String newVersion, String originVersion, AppVersionType appVersionType, List<ChangedItem> changedItems, List<ChangedItem> addTagChanges, List<SueTag> uSueTags) {
        List pSueTags = this.sueTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueTag::getAppId, (Object)appId)).eq(SueTag::getVersion, (Object)originVersion)).eq(SueTag::getDeleteFlag, (Object)"1")).eq(SueTag::getPublishFlag, (Object)PublishFlag.PUBLISHED.code()));
        Map<Long, Long> apiUniIdVTplOriginIdMap = pSueTags.stream().collect(Collectors.toMap(SueTag::getUniqueId, SueTag::getId));
        Tuple3<List<SueTag>, List<SueTag>, List<SueTag>> tagChanges = this.publishCommonService.dealTagChanges(changedItems, addTagChanges, apiUniIdVTplOriginIdMap);
        ArrayList copySueTags = Lists.newArrayList();
        List dSueTagIds = ((List)tagChanges._2).stream().map(SueTag::getId).collect(Collectors.toList());
        pSueTags.stream().filter(tag -> !dSueTagIds.contains(tag.getId())).forEach(tag -> {
            SueTag copySueTag = SueTagStructMapper.MAPPER.clone(tag).setId(null).setVersion(newVersion);
            copySueTags.add(copySueTag);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)tagChanges._1))) {
            ((List)tagChanges._1).forEach(tag -> {
                SueTag copySueTag = SueTagStructMapper.MAPPER.clone(tag).setId(null).setPublishFlag(PublishFlag.PUBLISHED.code()).setVersion(newVersion);
                copySueTags.add(copySueTag);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)tagChanges._3))) {
            ((List)tagChanges._3).forEach(tag -> {
                Optional<SueTag> uOptl = copySueTags.stream().filter(cSueTag -> tag.getId().equals(cSueTag.getUniqueId())).findAny();
                uOptl.ifPresent(sueTag -> VersionSueTagStructMapper.MAPPER.updateTag((SueTag)tag, (SueTag)sueTag));
            });
        }
        this.sueTagService.saveBatch((Collection)copySueTags);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            uSueTags.forEach(tag -> tag.setVersion(newVersion));
            if (!uSueTags.isEmpty()) {
                this.sueTagService.updateBatchById(uSueTags);
            }
        }
    }
}

