/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.flow.mapstruct.FlowSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.publish.VersionIdMapThreadLocal;
import com.xforceplus.ultraman.bocp.metadata.version.query.FlowSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowSettingVersionPublishTenantImpl {
    private static final Logger log = LoggerFactory.getLogger(FlowSettingVersionPublishTenantImpl.class);
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private FlowSettingRepository flowSettingRepository;
    @Autowired
    private FlowSettingVersionQuery flowSettingVersionQuery;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(App app, AppVersionType appVersionType, List<ChangedItem> changedItems, String newVersion, String originVersion) {
        List<FlowSetting> pFlowSettings = AppVersionType.PATCH.equals((Object)appVersionType) ? this.flowSettingVersionQuery.getFlowSettings(app.getId(), originVersion) : this.flowSettingVersionQuery.getLatestVersionFlowSettings(app.getId());
        Map<Long, Long> pPFlowSettingIdVOriFlowSettingId = pFlowSettings.stream().collect(Collectors.toMap(FlowSetting::getPublishFlowId, FlowSetting::getId));
        Tuple3<List<FlowSetting>, List<FlowSetting>, List<FlowSetting>> flowSettingChanges = this.publishCommonService.dealFlowSettingChanges(changedItems, pPFlowSettingIdVOriFlowSettingId);
        ArrayList copyFlowSettings = Lists.newArrayList();
        HashMap oriFlowSettingIdVCopyFlowSettingMap = Maps.newHashMap();
        Set dFlowIds = ((List)flowSettingChanges._2).stream().map(FlowSetting::getId).collect(Collectors.toSet());
        pFlowSettings.stream().filter(flow -> !dFlowIds.contains(flow.getId())).forEach(flowSetting -> {
            FlowSetting copyFlowSetting = FlowSettingStructMapper.MAPPER.clone(flowSetting);
            copyFlowSettings.add(copyFlowSetting);
            oriFlowSettingIdVCopyFlowSettingMap.put(flowSetting.getId(), copyFlowSetting);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowSettingChanges._1))) {
            ((List)flowSettingChanges._1).forEach(flowSetting -> {
                FlowSetting copyFlowSetting = FlowSettingStructMapper.MAPPER.clone(flowSetting).setId(null).setPublishFlowId(flowSetting.getId()).setPublishFlag(PublishFlag.PUBLISHED.code());
                copyFlowSettings.add(copyFlowSetting);
                oriFlowSettingIdVCopyFlowSettingMap.put(flowSetting.getId(), copyFlowSetting);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowSettingChanges._3))) {
            ((List)flowSettingChanges._3).forEach(uFlowSetting -> {
                Optional<FlowSetting> pFlowSettingOptl = copyFlowSettings.stream().filter(cFlowSetting -> uFlowSetting.getId().equals(cFlowSetting.getPublishFlowId())).findAny();
                if (pFlowSettingOptl.isPresent()) {
                    FlowSettingStructMapper.MAPPER.update(uFlowSetting, pFlowSettingOptl.get());
                    pFlowSettingOptl.get().setId(null);
                }
            });
        }
        HashMap versionInfos = Maps.newHashMap();
        Map<Long, FlowSetting> pFlowSettingMap = pFlowSettings.stream().collect(Collectors.toMap(FlowSetting::getId, Function.identity()));
        List<Long> needChangedFlowSettingIds = this.getNeedChangedFlowSettingIds(flowSettingChanges, pFlowSettingMap);
        HashMap flowSettingNewVersionMap = Maps.newHashMap();
        copyFlowSettings.forEach(flowSetting -> {
            String nFlowSettingVersion = flowSetting.getVersion();
            if (needChangedFlowSettingIds.contains(flowSetting.getPublishFlowId())) {
                nFlowSettingVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? newVersion : VersionUtils.nextVersion((String)flowSetting.getVersion(), (AppVersionType)appVersionType);
            }
            flowSettingNewVersionMap.put(flowSetting.getPublishFlowId(), nFlowSettingVersion);
            versionInfos.put(flowSetting.getPublishFlowId(), new VersionInfo().setPublishId(flowSetting.getPublishFlowId()).setOriginVersion(flowSetting.getVersion()).setNewVersion(nFlowSettingVersion));
            flowSetting.setVersion(nFlowSettingVersion);
        });
        List copyFlowSettingsNeedSave = copyFlowSettings.stream().filter(f -> needChangedFlowSettingIds.contains(f.getPublishFlowId())).map(flowSetting -> flowSetting.setId(null)).collect(Collectors.toList());
        this.flowSettingService.saveBatch(copyFlowSettingsNeedSave, 10);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            List uFlowSettings = this.flowSettingRepository.getFlowSettingsWithoutFrontSetting(app.getId());
            List uFlowSettingsNeedUpdateVersion = uFlowSettings.stream().filter(f -> needChangedFlowSettingIds.contains(f.getId())).map(uFlowSetting -> {
                String version = (String)flowSettingNewVersionMap.get(uFlowSetting.getId());
                return uFlowSetting.setVersion(version);
            }).collect(Collectors.toList());
            this.flowSettingService.updateBatchById(uFlowSettingsNeedUpdateVersion, 10);
        }
        Optional.ofNullable(VersionIdMapThreadLocal.getInstance().getIdMap()).ifPresent(idMap -> {
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(oriFlowSettingIdVCopyFlowSettingMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FlowSetting)e.getValue()).getId())));
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(pPFlowSettingIdVOriFlowSettingId);
        });
        return ServiceResponse.success((String)"", (Object)versionInfos);
    }

    private List<Long> getNeedChangedFlowSettingIds(Tuple3<List<FlowSetting>, List<FlowSetting>, List<FlowSetting>> flowSettingChanges, Map<Long, FlowSetting> pFlowSettingMap) {
        HashSet flowSettingIds = Sets.newHashSet();
        ((List)flowSettingChanges._1).forEach(item -> flowSettingIds.add(item.getId()));
        ((List)flowSettingChanges._2).forEach(item -> flowSettingIds.add(item.getPublishFlowId()));
        ((List)flowSettingChanges._3).forEach(item -> flowSettingIds.add(item.getId()));
        return new ArrayList<Long>(flowSettingIds);
    }
}

