/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.query.FormVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltFormStructMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltFormService;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVersionPublishTenantImpl {
    private static final Logger log = LoggerFactory.getLogger(FormVersionPublishTenantImpl.class);
    @Autowired
    private UltFormRepository ultFormRepository;
    @Autowired
    private IUltFormService ultFormService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private FormVersionQuery formVersionQuery;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(App app, AppVersionType appVersionType, List<ChangedItem> changedItems, String newVersion, String originVersion) {
        List filteredUForms;
        List<UltForm> pForms = AppVersionType.PATCH.equals((Object)appVersionType) ? this.formVersionQuery.getForms(app.getId(), originVersion) : this.formVersionQuery.getLatestVersionFormsBatch(app.getId());
        Map<Long, Long> pPFormIdVOriFormId = pForms.stream().collect(Collectors.toMap(UltForm::getPublishRefFormId, UltForm::getId));
        Tuple3<List<UltForm>, List<UltForm>, List<UltForm>> formChanges = this.publishCommonService.dealFormChanges(changedItems, pPFormIdVOriFormId);
        ArrayList copyForms = Lists.newArrayList();
        Set dFormIds = ((List)formChanges._2).stream().map(UltForm::getId).collect(Collectors.toSet());
        pForms.stream().filter(form -> !dFormIds.contains(form.getId())).forEach(form -> {
            UltForm copyForm = UltFormStructMapper.MAPPER.clone(form);
            copyForms.add(copyForm);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)formChanges._1))) {
            ((List)formChanges._1).forEach(form -> {
                UltForm copyForm = UltFormStructMapper.MAPPER.clone(form).setId(null).setPublishRefFormId(form.getId()).setPublishFlag(PfcpPublishFlag.PUBLISHED.code());
                copyForms.add(copyForm);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)formChanges._3))) {
            ((List)formChanges._3).forEach(uForm -> {
                Optional<UltForm> pFormOptl = copyForms.stream().filter(cForm -> uForm.getId().equals(cForm.getPublishRefFormId())).findAny();
                if (pFormOptl.isPresent()) {
                    UltFormStructMapper.MAPPER.updateForm(uForm, pFormOptl.get());
                    pFormOptl.get().setId(null);
                }
            });
        }
        HashMap versionInfos = Maps.newHashMap();
        Map<Long, UltForm> pBasicFormMap = pForms.stream().collect(Collectors.toMap(UltForm::getId, Function.identity()));
        List<Long> needChangedFormIds = this.getNeedChangedFormIds(formChanges, pBasicFormMap);
        HashMap formNewVersionMap = Maps.newHashMap();
        copyForms.forEach(form -> {
            String nFormVersion = form.getVersion();
            if (needChangedFormIds.contains(form.getPublishRefFormId())) {
                nFormVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? newVersion : VersionUtils.nextVersion((String)form.getVersion(), (AppVersionType)appVersionType);
            }
            formNewVersionMap.put(form.getPublishRefFormId(), nFormVersion);
            versionInfos.put(form.getPublishRefFormId(), new VersionInfo().setPublishId(form.getPublishRefFormId()).setOriginVersion(form.getVersion()).setNewVersion(nFormVersion));
            form.setVersion(nFormVersion);
        });
        List filteredCopyForms = copyForms.stream().filter(f -> needChangedFormIds.contains(f.getPublishRefFormId())).peek(form -> form.setId(null)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filteredCopyForms)) {
            this.ultFormService.saveBatch(filteredCopyForms, 10);
        }
        if (!AppVersionType.PATCH.equals((Object)appVersionType) && CollectionUtils.isNotEmpty(filteredUForms = this.ultFormRepository.getFormsBatch(app.getId()).stream().filter(f -> needChangedFormIds.contains(f.getId())).peek(uForm -> {
            String version = (String)formNewVersionMap.get(uForm.getId());
            uForm.setVersion(version);
        }).collect(Collectors.toList()))) {
            this.ultFormService.updateBatchById(filteredUForms, 10);
        }
        return ServiceResponse.success((String)"", (Object)versionInfos);
    }

    private List<Long> getNeedChangedFormIds(Tuple3<List<UltForm>, List<UltForm>, List<UltForm>> formChanges, Map<Long, UltForm> pBasicFormMap) {
        HashSet formIds = Sets.newHashSet();
        ((List)formChanges._1).forEach(item -> formIds.add(item.getId()));
        ((List)formChanges._2).forEach(item -> formIds.add(item.getPublishRefFormId()));
        ((List)formChanges._3).forEach(item -> formIds.add(item.getId()));
        return new ArrayList<Long>(formIds);
    }
}

