/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.publish.VersionIdMapThreadLocal;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageSettingStructMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageSettingRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageSettingService;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageSettingVersionPublishStandardImpl {
    private static final Logger log = LoggerFactory.getLogger(PageSettingVersionPublishStandardImpl.class);
    @Autowired
    private IUltPageSettingService ultPageSettingService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private UltPageSettingRepository ultPageSettingRepository;
    @Autowired
    private PageSettingVersionQuery pageSettingVersionQuery;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(App app, AppVersionType appVersionType, List<ChangedItem> changedItems, String newVersion, String originVersion) {
        List<UltPageSetting> pUltPageSettings = AppVersionType.PATCH.equals((Object)appVersionType) ? this.pageSettingVersionQuery.getPageSettings(app.getId(), originVersion) : this.pageSettingVersionQuery.getLatestVersionPageSettingsBatch(app.getId());
        Map<Long, Long> pPUltPageSettingIdVOriUltPageSettingId = pUltPageSettings.stream().collect(Collectors.toMap(UltPageSetting::getPublishRefPageId, UltPageSetting::getId));
        Tuple3<List<UltPageSetting>, List<UltPageSetting>, List<UltPageSetting>> ultPageSettingChanges = this.publishCommonService.dealPageSettingChanges(changedItems, pPUltPageSettingIdVOriUltPageSettingId);
        ArrayList copyUltPageSettings = Lists.newArrayList();
        HashMap oriUltPageSettingIdVCopyUltPageSettingMap = Maps.newHashMap();
        Set dStandardIds = ((List)ultPageSettingChanges._2).stream().filter(e -> e.getRefPageId() == 0L).map(UltPageSetting::getId).collect(Collectors.toSet());
        Set dCustomIds = ((List)ultPageSettingChanges._2).stream().filter(e -> e.getRefPageId() != 0L).map(UltPageSetting::getId).collect(Collectors.toSet());
        pUltPageSettings.stream().filter(flow -> !dStandardIds.contains(flow.getId()) && !dStandardIds.contains(flow.getRefPageId()) && !dCustomIds.contains(flow.getId())).forEach(ultPageSetting -> {
            UltPageSetting copyUltPageSetting = UltPageSettingStructMapper.MAPPER.clone(ultPageSetting);
            copyUltPageSettings.add(copyUltPageSetting);
            oriUltPageSettingIdVCopyUltPageSettingMap.put(ultPageSetting.getId(), copyUltPageSetting);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)ultPageSettingChanges._1))) {
            ((List)ultPageSettingChanges._1).forEach(ultPageSetting -> {
                UltPageSetting copyUltPageSetting = UltPageSettingStructMapper.MAPPER.clone(ultPageSetting).setId(null).setPublishRefPageId(ultPageSetting.getId()).setPublishFlag(PublishFlag.PUBLISHED.code());
                copyUltPageSettings.add(copyUltPageSetting);
                oriUltPageSettingIdVCopyUltPageSettingMap.put(ultPageSetting.getId(), copyUltPageSetting);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)ultPageSettingChanges._3))) {
            ((List)ultPageSettingChanges._3).forEach(uUltPageSetting -> {
                Optional<UltPageSetting> pUltPageSettingOptl = copyUltPageSettings.stream().filter(cUltPageSetting -> uUltPageSetting.getId().equals(cUltPageSetting.getPublishRefPageId())).findAny();
                if (pUltPageSettingOptl.isPresent()) {
                    UltPageSettingStructMapper.MAPPER.updatePageSetting(uUltPageSetting, pUltPageSettingOptl.get());
                    pUltPageSettingOptl.get().setId(null);
                }
            });
        }
        HashMap versionInfos = Maps.newHashMap();
        Map<Long, UltPageSetting> pBasicUltPageSettingMap = pUltPageSettings.stream().filter(o -> o.getRefPageId() == 0L).collect(Collectors.toMap(UltPageSetting::getId, Function.identity()));
        List<Long> needChangedUltPageSettingIds = this.getNeedChangedUltPageSettingIds(ultPageSettingChanges, pBasicUltPageSettingMap);
        HashMap ultPageSettingNewVersionMap = Maps.newHashMap();
        copyUltPageSettings.stream().filter(o -> o.getRefPageId() == 0L).forEach(ultPageSetting -> {
            String nUltPageSettingVersion = ultPageSetting.getVersion();
            if (needChangedUltPageSettingIds.contains(ultPageSetting.getPublishRefPageId())) {
                nUltPageSettingVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? newVersion : VersionUtils.nextVersion((String)ultPageSetting.getVersion(), (AppVersionType)appVersionType);
            }
            ultPageSettingNewVersionMap.put(ultPageSetting.getPublishRefPageId(), nUltPageSettingVersion);
            versionInfos.put(ultPageSetting.getPublishRefPageId(), new VersionInfo().setPublishId(ultPageSetting.getPublishRefPageId()).setOriginVersion(ultPageSetting.getVersion()).setNewVersion(nUltPageSettingVersion));
            ultPageSetting.setVersion(nUltPageSettingVersion);
        });
        copyUltPageSettings.stream().filter(flow -> flow.getRefPageId() != 0L).forEach(flow -> {
            Optional.ofNullable(pBasicUltPageSettingMap.get(flow.getRefPageId())).ifPresent(pPageSetting -> flow.setRefPageId(pPageSetting.getPublishRefPageId()));
            if (ultPageSettingNewVersionMap.containsKey(flow.getRefPageId())) {
                String nPageSettingVersion = (String)ultPageSettingNewVersionMap.get(flow.getRefPageId());
                versionInfos.put(flow.getPublishRefPageId(), new VersionInfo().setPublishId(flow.getPublishRefPageId()).setOriginVersion(flow.getVersion()).setNewVersion(nPageSettingVersion));
                flow.setVersion(nPageSettingVersion);
            } else {
                log.error(String.format("\u6d41-%d\u67e5\u8be2\u4e0d\u5230\u6d41\u4e3b\u6570\u636e-{%s}\uff0c\u5bfc\u81f4\u7248\u672c\u65e0\u6cd5\u66f4\u65b0\u548c\u6ca1\u6709\u5173\u8054\u5e94\u7528\u7248\u672c", flow.getId(), flow.getRefPageId()));
            }
        });
        List copyUltPageSettingsNeedSave = copyUltPageSettings.stream().filter(f -> needChangedUltPageSettingIds.contains(f.getPublishRefPageId()) || needChangedUltPageSettingIds.contains(f.getRefPageId())).map(ultPageSetting -> ultPageSetting.setId(null)).collect(Collectors.toList());
        this.ultPageSettingService.saveBatch(copyUltPageSettingsNeedSave, 10);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            List uUltPageSettings = this.ultPageSettingRepository.getPageSettingsBatch(app.getId());
            List uUltPageSettingsNeedUpdateVersion = uUltPageSettings.stream().filter(f -> needChangedUltPageSettingIds.contains(f.getId()) || needChangedUltPageSettingIds.contains(f.getRefPageId())).map(uUltPageSetting -> {
                String version = (String)ultPageSettingNewVersionMap.get(0L == uUltPageSetting.getRefPageId() ? uUltPageSetting.getId() : uUltPageSetting.getRefPageId());
                return uUltPageSetting.setVersion(version);
            }).collect(Collectors.toList());
            this.ultPageSettingService.updateBatchById(uUltPageSettingsNeedUpdateVersion, 10);
        }
        if (!AppCustomType.TENANT.code().equals(app.getCustomType())) {
            this.convertUniIdToVersionIdForPublishAll(copyUltPageSettings, needChangedUltPageSettingIds);
        }
        Optional.ofNullable(VersionIdMapThreadLocal.getInstance().getIdMap()).ifPresent(idMap -> {
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(oriUltPageSettingIdVCopyUltPageSettingMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((UltPageSetting)e.getValue()).getId())));
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(pPUltPageSettingIdVOriUltPageSettingId);
        });
        return ServiceResponse.success((String)"", (Object)versionInfos);
    }

    private List<Long> getNeedChangedUltPageSettingIds(Tuple3<List<UltPageSetting>, List<UltPageSetting>, List<UltPageSetting>> ultPageSettingChanges, Map<Long, UltPageSetting> pBasicUltPageSettingMap) {
        HashSet ultPageSettingIds = Sets.newHashSet();
        ((List)ultPageSettingChanges._1).forEach(item -> {
            if (item.getRefPageId() == 0L) {
                ultPageSettingIds.add(item.getId());
            } else {
                ultPageSettingIds.add(item.getRefPageId());
            }
        });
        ((List)ultPageSettingChanges._2).forEach(item -> {
            if (item.getRefPageId() == 0L) {
                ultPageSettingIds.add(item.getPublishRefPageId());
            } else {
                Long ultPageSettingId;
                Long l = ultPageSettingId = pBasicUltPageSettingMap.containsKey(item.getRefPageId()) ? ((UltPageSetting)pBasicUltPageSettingMap.get(item.getRefPageId())).getRefPageId() : null;
                if (ultPageSettingId != null) {
                    ultPageSettingIds.add(ultPageSettingId);
                }
            }
        });
        ((List)ultPageSettingChanges._3).forEach(item -> {
            if (item.getRefPageId() == 0L) {
                ultPageSettingIds.add(item.getId());
            } else {
                ultPageSettingIds.add(item.getRefPageId());
            }
        });
        return new ArrayList<Long>(ultPageSettingIds);
    }

    private void convertUniIdToVersionIdForPublishAll(List<UltPageSetting> copyUltPageSettings, List<Long> needChangedUltPageSettingIds) {
        Map pPageSettingIdVCopyPageSettingMap = copyUltPageSettings.stream().collect(Collectors.toMap(UltPageSetting::getPublishRefPageId, Function.identity()));
        List rUltPageSettings = copyUltPageSettings.stream().filter(f -> f.getRefPageId() != 0L && needChangedUltPageSettingIds.contains(f.getRefPageId())).map(flow -> {
            Long refPageSettingId;
            Long l = refPageSettingId = pPageSettingIdVCopyPageSettingMap.containsKey(flow.getRefPageId()) ? ((UltPageSetting)pPageSettingIdVCopyPageSettingMap.get(flow.getRefPageId())).getId() : null;
            if (refPageSettingId == null) {
                throw new RuntimeException(String.format("\u6839\u636eUltPageSetting RefPageId\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u5feb\u7167\u6d41ID %d ", flow.getRefPageId()));
            }
            return flow.setRefPageId(refPageSettingId);
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rUltPageSettings)) {
            this.ultPageSettingService.updateBatchById(rUltPageSettings, 10);
        }
    }
}

