/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.publish.VersionIdMapThreadLocal;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageSettingStructMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageSettingRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageSettingService;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageSettingVersionPublishTenantImpl {
    private static final Logger log = LoggerFactory.getLogger(PageSettingVersionPublishTenantImpl.class);
    @Autowired
    private IUltPageSettingService ultPageSettingService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private UltPageSettingRepository ultPageSettingRepository;
    @Autowired
    private PageSettingVersionQuery pageSettingVersionQuery;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(App app, AppVersionType appVersionType, List<ChangedItem> changedItems, String newVersion, String originVersion) {
        List<UltPageSetting> pUltPageSettings = AppVersionType.PATCH.equals((Object)appVersionType) ? this.pageSettingVersionQuery.getPageSettings(app.getId(), originVersion) : this.pageSettingVersionQuery.getLatestVersionPageSettingsBatch(app.getId());
        Map<Long, Long> pPUltPageSettingIdVOriUltPageSettingId = pUltPageSettings.stream().collect(Collectors.toMap(UltPageSetting::getPublishRefPageId, UltPageSetting::getId));
        Tuple3<List<UltPageSetting>, List<UltPageSetting>, List<UltPageSetting>> ultPageSettingChanges = this.publishCommonService.dealPageSettingChanges(changedItems, pPUltPageSettingIdVOriUltPageSettingId);
        ArrayList copyUltPageSettings = Lists.newArrayList();
        HashMap oriUltPageSettingIdVCopyUltPageSettingMap = Maps.newHashMap();
        Set dPageSettings = ((List)ultPageSettingChanges._2).stream().map(UltPageSetting::getId).collect(Collectors.toSet());
        pUltPageSettings.stream().filter(flow -> !dPageSettings.contains(flow.getId())).forEach(ultPageSetting -> {
            UltPageSetting copyUltPageSetting = UltPageSettingStructMapper.MAPPER.clone(ultPageSetting);
            copyUltPageSettings.add(copyUltPageSetting);
            oriUltPageSettingIdVCopyUltPageSettingMap.put(ultPageSetting.getId(), copyUltPageSetting);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)ultPageSettingChanges._1))) {
            ((List)ultPageSettingChanges._1).forEach(ultPageSetting -> {
                UltPageSetting copyUltPageSetting = UltPageSettingStructMapper.MAPPER.clone(ultPageSetting).setId(null).setPublishRefPageId(ultPageSetting.getId()).setPublishFlag(PublishFlag.PUBLISHED.code());
                copyUltPageSettings.add(copyUltPageSetting);
                oriUltPageSettingIdVCopyUltPageSettingMap.put(ultPageSetting.getId(), copyUltPageSetting);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)ultPageSettingChanges._3))) {
            ((List)ultPageSettingChanges._3).forEach(uUltPageSetting -> {
                Optional<UltPageSetting> pUltPageSettingOptl = copyUltPageSettings.stream().filter(cUltPageSetting -> uUltPageSetting.getId().equals(cUltPageSetting.getPublishRefPageId())).findAny();
                if (pUltPageSettingOptl.isPresent()) {
                    UltPageSettingStructMapper.MAPPER.updatePageSetting(uUltPageSetting, pUltPageSettingOptl.get());
                    pUltPageSettingOptl.get().setId(null);
                }
            });
        }
        HashMap versionInfos = Maps.newHashMap();
        Map<Long, UltPageSetting> pUltPageSettingMap = pUltPageSettings.stream().collect(Collectors.toMap(UltPageSetting::getId, Function.identity()));
        List<Long> needChangedUltPageSettingIds = this.getNeedChangedUltPageSettingIds(ultPageSettingChanges, pUltPageSettingMap);
        HashMap ultPageSettingNewVersionMap = Maps.newHashMap();
        copyUltPageSettings.forEach(ultPageSetting -> {
            String nUltPageSettingVersion = ultPageSetting.getVersion();
            if (needChangedUltPageSettingIds.contains(ultPageSetting.getPublishRefPageId())) {
                nUltPageSettingVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? newVersion : VersionUtils.nextVersion((String)ultPageSetting.getVersion(), (AppVersionType)appVersionType);
            }
            ultPageSettingNewVersionMap.put(ultPageSetting.getPublishRefPageId(), nUltPageSettingVersion);
            versionInfos.put(ultPageSetting.getPublishRefPageId(), new VersionInfo().setPublishId(ultPageSetting.getPublishRefPageId()).setOriginVersion(ultPageSetting.getVersion()).setNewVersion(nUltPageSettingVersion));
            ultPageSetting.setVersion(nUltPageSettingVersion);
        });
        List copyUltPageSettingsNeedSave = copyUltPageSettings.stream().filter(f -> needChangedUltPageSettingIds.contains(f.getPublishRefPageId())).map(ultPageSetting -> ultPageSetting.setId(null)).collect(Collectors.toList());
        this.ultPageSettingService.saveBatch(copyUltPageSettingsNeedSave, 10);
        if (!AppVersionType.PATCH.equals((Object)appVersionType)) {
            List uUltPageSettings = this.ultPageSettingRepository.getPageSettingsBatch(app.getId());
            List uUltPageSettingsNeedUpdateVersion = uUltPageSettings.stream().filter(f -> needChangedUltPageSettingIds.contains(f.getId())).map(uUltPageSetting -> {
                String version = (String)ultPageSettingNewVersionMap.get(uUltPageSetting.getId());
                return uUltPageSetting.setVersion(version);
            }).collect(Collectors.toList());
            this.ultPageSettingService.updateBatchById(uUltPageSettingsNeedUpdateVersion, 10);
        }
        Optional.ofNullable(VersionIdMapThreadLocal.getInstance().getIdMap()).ifPresent(idMap -> {
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(oriUltPageSettingIdVCopyUltPageSettingMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((UltPageSetting)e.getValue()).getId())));
            VersionIdMapThreadLocal.getInstance().getIdMap().putAll(pPUltPageSettingIdVOriUltPageSettingId);
        });
        return ServiceResponse.success((String)"", (Object)versionInfos);
    }

    private List<Long> getNeedChangedUltPageSettingIds(Tuple3<List<UltPageSetting>, List<UltPageSetting>, List<UltPageSetting>> ultPageSettingChanges, Map<Long, UltPageSetting> pUltPageSettingMap) {
        HashSet ultPageSettingIds = Sets.newHashSet();
        ((List)ultPageSettingChanges._1).forEach(item -> ultPageSettingIds.add(item.getId()));
        ((List)ultPageSettingChanges._2).forEach(item -> ultPageSettingIds.add(item.getPublishRefPageId()));
        ((List)ultPageSettingChanges._3).forEach(item -> ultPageSettingIds.add(item.getId()));
        return new ArrayList<Long>(ultPageSettingIds);
    }
}

