/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.PageBoSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageStructMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IPageBoSettingService;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageService;
import io.vavr.Tuple6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageVersionPublishStandardImpl {
    private static final Logger log = LoggerFactory.getLogger(PageVersionPublishStandardImpl.class);
    @Autowired
    private UltPageRepository ultPageRepository;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;
    @Autowired
    private IUltPageService ultPageService;
    @Autowired
    private IPageBoSettingService pageBoSettingService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private PageVersionQuery pageVersionQuery;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(App app, AppVersionType appVersionType, List<ChangedItem> changedItems, String newVersion, String originVersion) {
        List filteredUPages;
        List<UltPage> pPages = AppVersionType.PATCH.equals((Object)appVersionType) ? this.pageVersionQuery.getPages(app.getId(), originVersion) : this.pageVersionQuery.getLatestVersionPagesBatch(app.getId());
        Map<Long, Long> pPPageIdVOriPageId = pPages.stream().collect(Collectors.toMap(UltPage::getPublishRefPageId, UltPage::getId));
        Tuple6<List<UltPage>, List<UltPage>, List<UltPage>, List<PageBoSetting>, List<PageBoSetting>, List<PageBoSetting>> pageChanges = this.publishCommonService.dealPageChanges(changedItems, pPPageIdVOriPageId);
        ArrayList copyPages = Lists.newArrayList();
        Set dBasicPageIds = ((List)pageChanges._2).stream().filter(page -> page.getRefPageId() == 0L).map(UltPage::getId).collect(Collectors.toSet());
        Set dTenantPageIds = ((List)pageChanges._2).stream().filter(page -> page.getRefPageId() != 0L).map(UltPage::getId).collect(Collectors.toSet());
        Map pBasicPageMap = pPages.stream().filter(page -> page.getRefPageId() == 0L).collect(Collectors.toMap(UltPage::getId, Function.identity()));
        pPages.stream().filter(page -> !dBasicPageIds.contains(page.getId()) && !dBasicPageIds.contains(page.getRefPageId()) && !dTenantPageIds.contains(page.getId())).forEach(page -> {
            UltPage copyPage = UltPageStructMapper.MAPPER.clone(page);
            copyPages.add(copyPage);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)pageChanges._1))) {
            ((List)pageChanges._1).forEach(page -> {
                UltPage copyPage = UltPageStructMapper.MAPPER.clone(page).setId(null).setPublishRefPageId(page.getId()).setPublishFlag(PfcpPublishFlag.PUBLISHED.code());
                copyPages.add(copyPage);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)pageChanges._3))) {
            ((List)pageChanges._3).forEach(page -> {
                Optional<UltPage> pPageOptl = copyPages.stream().filter(cPage -> page.getId().equals(cPage.getPublishRefPageId())).findAny();
                if (pPageOptl.isPresent()) {
                    UltPageStructMapper.MAPPER.updatePage(page, pPageOptl.get());
                    pPageOptl.get().setId(null);
                }
            });
        }
        List uPages = this.ultPageRepository.getPages(app.getId());
        HashMap versionInfos = Maps.newHashMap();
        List<Long> needChangedBasicPageIds = this.getNeedChangedBasicPageIds(pageChanges, uPages, pPages);
        HashMap basicPageNewVersionMap = Maps.newHashMap();
        copyPages.stream().filter(page -> page.getRefPageId() == 0L).forEach(page -> {
            String nPageVersion = page.getVersion();
            if (needChangedBasicPageIds.contains(page.getPublishRefPageId())) {
                nPageVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? newVersion : VersionUtils.nextVersion((String)page.getVersion(), (AppVersionType)appVersionType);
            }
            basicPageNewVersionMap.put(page.getPublishRefPageId(), nPageVersion);
            versionInfos.put(page.getPublishRefPageId(), new VersionInfo().setPublishId(page.getPublishRefPageId()).setOriginVersion(page.getVersion()).setNewVersion(nPageVersion));
            page.setVersion(nPageVersion);
        });
        copyPages.stream().filter(page -> page.getRefPageId() != 0L).forEach(page -> {
            Optional.ofNullable(pBasicPageMap.get(page.getRefPageId())).ifPresent(pPage -> page.setRefPageId(pPage.getPublishRefPageId()));
            if (basicPageNewVersionMap.containsKey(page.getRefPageId())) {
                String nPageVersion = (String)basicPageNewVersionMap.get(page.getRefPageId());
                versionInfos.put(page.getPublishRefPageId(), new VersionInfo().setPublishId(page.getPublishRefPageId()).setOriginVersion(page.getVersion()).setNewVersion(nPageVersion));
                page.setVersion(nPageVersion);
            } else {
                log.error(String.format("\u5217\u8868-%d\u67e5\u8be2\u4e0d\u5230\u5217\u8868\u4e3b\u6570\u636e-{%s}\uff0c\u5bfc\u81f4\u7248\u672c\u65e0\u6cd5\u66f4\u65b0\u548c\u6ca1\u6709\u5173\u8054\u5e94\u7528\u7248\u672c", page.getId(), page.getRefPageId()));
            }
        });
        List filteredCopyPages = copyPages.stream().filter(p -> needChangedBasicPageIds.contains(p.getPublishRefPageId()) || needChangedBasicPageIds.contains(p.getRefPageId())).peek(page -> page.setId(null)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filteredCopyPages)) {
            this.ultPageService.saveBatch(filteredCopyPages, 10);
        }
        if (!AppVersionType.PATCH.equals((Object)appVersionType) && CollectionUtils.isNotEmpty(filteredUPages = uPages.stream().filter(f -> needChangedBasicPageIds.contains(f.getId()) || needChangedBasicPageIds.contains(f.getRefPageId())).peek(uPage -> {
            String version = (String)basicPageNewVersionMap.get(uPage.getRefPageId() == 0L ? uPage.getId() : uPage.getRefPageId());
            uPage.setVersion(version);
        }).collect(Collectors.toList()))) {
            this.ultPageService.updateBatchById(filteredUPages, 10);
        }
        Map<Long, Long> nPPageIdsVPageIds = copyPages.stream().collect(Collectors.toMap(UltPage::getPublishRefPageId, UltPage::getId));
        List aPageIds = ((List)pageChanges._1).stream().map(UltPage::getId).collect(Collectors.toList());
        List dPageBoSettingIds = ((List)pageChanges._5).stream().map(PageBoSetting::getUniqueId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> rBoSettingsMap = ((List)pageChanges._6).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        ArrayList copyPageBoSettings = Lists.newArrayList();
        copyPages.stream().filter(p -> needChangedBasicPageIds.contains(p.getPublishRefPageId()) || needChangedBasicPageIds.contains(p.getRefPageId())).forEach(copyPage -> {
            if (CollectionUtils.isNotEmpty((Collection)aPageIds) && aPageIds.contains(copyPage.getPublishRefPageId())) {
                Optional.ofNullable(this.pageBoSettingRepository.getPageBoSettingsByPageId(copyPage.getPublishRefPageId())).ifPresent(pageBoSettings -> pageBoSettings.forEach(boSetting -> copyPageBoSettings.add(PageBoSettingStructMapper.MAPPER.clone(boSetting).setId(null).setPageId(copyPage.getId()))));
            } else {
                Optional.ofNullable(pPPageIdVOriPageId.get(copyPage.getPublishRefPageId())).ifPresent(pPageId -> Optional.ofNullable(this.pageBoSettingRepository.getPageBoSettingsByPageId(pPageId)).ifPresent(pageBoSettings -> {
                    Optional.ofNullable(rBoSettingsMap.get(copyPage.getPublishRefPageId())).ifPresent(rBoSettings -> rBoSettings.forEach(rBoSetting -> pageBoSettings.stream().filter(boSetting -> rBoSetting.getUniqueId().equals(boSetting.getUniqueId())).findAny().ifPresent(boSetting -> {
                        PageBoSettingStructMapper.MAPPER.updatePageBoSetting(rBoSetting, boSetting);
                        boSetting.setPageId(copyPage.getId());
                    })));
                    pageBoSettings.stream().filter(pageBoSetting -> !dPageBoSettingIds.contains(pageBoSetting.getUniqueId())).forEach(boSetting -> copyPageBoSettings.add(PageBoSettingStructMapper.MAPPER.clone(boSetting).setId(null).setPageId(copyPage.getId())));
                }));
            }
        });
        ((List)pageChanges._4).forEach(pageBoSetting -> copyPageBoSettings.add(PageBoSettingStructMapper.MAPPER.clone(pageBoSetting).setId(null).setPageId((Long)nPPageIdsVPageIds.get(pageBoSetting.getPageId()))));
        if (CollectionUtils.isNotEmpty((Collection)copyPageBoSettings)) {
            this.pageBoSettingService.saveBatch((Collection)copyPageBoSettings, 10);
        }
        this.convertUniIdToVersionIdForPublishAll(copyPages, needChangedBasicPageIds);
        return ServiceResponse.success((String)"", (Object)versionInfos);
    }

    private List<Long> getNeedChangedBasicPageIds(Tuple6<List<UltPage>, List<UltPage>, List<UltPage>, List<PageBoSetting>, List<PageBoSetting>, List<PageBoSetting>> pageChanges, List<UltPage> uPages, List<UltPage> pPages) {
        Map uPageMap = uPages.stream().collect(Collectors.toMap(UltPage::getId, Function.identity()));
        Map pPageMap = pPages.stream().collect(Collectors.toMap(UltPage::getId, Function.identity()));
        HashSet pageIds = Sets.newHashSet();
        ((List)pageChanges._1).forEach(item -> {
            if (item.getRefPageId() == 0L) {
                pageIds.add(item.getId());
            } else {
                pageIds.add(item.getRefPageId());
            }
        });
        ((List)pageChanges._2).forEach(item -> {
            if (item.getRefPageId() == 0L) {
                pageIds.add(item.getPublishRefPageId());
            } else {
                Long pageId;
                Long l = pageId = pPageMap.containsKey(item.getRefPageId()) ? ((UltPage)pPageMap.get(item.getRefPageId())).getPublishRefPageId() : null;
                if (pageId != null) {
                    pageIds.add(pageId);
                }
            }
        });
        ((List)pageChanges._3).forEach(item -> {
            if (item.getRefPageId() == 0L) {
                pageIds.add(item.getId());
            } else {
                pageIds.add(item.getRefPageId());
            }
        });
        ((List)pageChanges._4).forEach(p -> Optional.ofNullable(uPageMap.get(p.getPageId())).ifPresent(page -> {
            if (page.getRefPageId() == 0L) {
                pageIds.add(page.getId());
            } else {
                pageIds.add(page.getRefPageId());
            }
        }));
        ((List)pageChanges._5).forEach(p -> Optional.ofNullable(pPageMap.get(p.getPageId())).ifPresent(page -> {
            if (page.getRefPageId() == 0L) {
                pageIds.add(page.getPublishRefPageId());
            } else {
                Long pageId;
                Long l = pageId = pPageMap.containsKey(page.getRefPageId()) ? ((UltPage)pPageMap.get(page.getRefPageId())).getPublishRefPageId() : null;
                if (pageId != null) {
                    pageIds.add(pageId);
                }
            }
        }));
        ((List)pageChanges._6).forEach(p -> Optional.ofNullable(uPageMap.get(p.getPageId())).ifPresent(page -> {
            if (page.getRefPageId() == 0L) {
                pageIds.add(page.getId());
            } else {
                pageIds.add(page.getRefPageId());
            }
        }));
        return new ArrayList<Long>(pageIds);
    }

    private void convertUniIdToVersionIdForPublishAll(List<UltPage> copyPages, List<Long> needChangedBasicPageIds) {
        Map pPageIdVCopyPageMap = copyPages.stream().collect(Collectors.toMap(UltPage::getPublishRefPageId, Function.identity()));
        List filteredCopyPages = copyPages.stream().filter(page -> page.getRefPageId() != 0L && needChangedBasicPageIds.contains(page.getRefPageId())).map(page -> {
            Long refPageId;
            Long l = refPageId = pPageIdVCopyPageMap.containsKey(page.getRefPageId()) ? ((UltPage)pPageIdVCopyPageMap.get(page.getRefPageId())).getId() : null;
            if (refPageId != null) {
                page.setRefPageId(refPageId);
                return page;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filteredCopyPages)) {
            this.ultPageService.updateBatchById(filteredCopyPages, 10);
        }
    }
}

