/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.publish.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.common.PublishCommonService;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionInfo;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.PageBoSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageStructMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IPageBoSettingService;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageService;
import io.vavr.Tuple6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageVersionPublishTenantImpl {
    private static final Logger log = LoggerFactory.getLogger(PageVersionPublishTenantImpl.class);
    @Autowired
    private UltPageRepository ultPageRepository;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;
    @Autowired
    private IUltPageService ultPageService;
    @Autowired
    private IPageBoSettingService pageBoSettingService;
    @Autowired
    private PublishCommonService publishCommonService;
    @Autowired
    private PageVersionQuery pageVersionQuery;

    @SkipOperationLog
    @SkipAutoAudit
    public ServiceResponse publish(App app, AppVersionType appVersionType, List<ChangedItem> changedItems, String newVersion, String originVersion) {
        List filteredUPages;
        List<UltPage> pPages = AppVersionType.PATCH.equals((Object)appVersionType) ? this.pageVersionQuery.getPages(app.getId(), originVersion) : this.pageVersionQuery.getLatestVersionPagesBatch(app.getId());
        Map<Long, Long> pPPageIdVOriPageId = pPages.stream().collect(Collectors.toMap(UltPage::getPublishRefPageId, UltPage::getId));
        Tuple6<List<UltPage>, List<UltPage>, List<UltPage>, List<PageBoSetting>, List<PageBoSetting>, List<PageBoSetting>> pageChanges = this.publishCommonService.dealPageChanges(changedItems, pPPageIdVOriPageId);
        ArrayList copyPages = Lists.newArrayList();
        Set dPageIds = ((List)pageChanges._2).stream().map(UltPage::getId).collect(Collectors.toSet());
        pPages.stream().filter(page -> !dPageIds.contains(page.getId())).forEach(o -> {
            UltPage copyPage = UltPageStructMapper.MAPPER.clone(o);
            copyPages.add(copyPage);
        });
        if (CollectionUtils.isNotEmpty((Collection)((Collection)pageChanges._1))) {
            ((List)pageChanges._1).forEach(page -> {
                UltPage copyPage = UltPageStructMapper.MAPPER.clone(page).setId(null).setPublishRefPageId(page.getId()).setPublishFlag(PfcpPublishFlag.PUBLISHED.code());
                copyPages.add(copyPage);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)pageChanges._3))) {
            ((List)pageChanges._3).forEach(page -> {
                Optional<UltPage> pPageOptl = copyPages.stream().filter(cPage -> page.getId().equals(cPage.getPublishRefPageId())).findAny();
                if (pPageOptl.isPresent()) {
                    UltPageStructMapper.MAPPER.updatePage(page, pPageOptl.get());
                    pPageOptl.get().setId(null);
                }
            });
        }
        List uPages = this.ultPageRepository.getPages(app.getId());
        HashMap versionInfos = Maps.newHashMap();
        List<Long> needChangedPageIds = this.getNeedChangedPageIds(pageChanges, uPages, pPages);
        HashMap pageNewVersionMap = Maps.newHashMap();
        copyPages.forEach(page -> {
            String nPageVersion = page.getVersion();
            if (needChangedPageIds.contains(page.getPublishRefPageId())) {
                nPageVersion = AppVersionType.PATCH.equals((Object)appVersionType) ? newVersion : VersionUtils.nextVersion((String)page.getVersion(), (AppVersionType)appVersionType);
            }
            pageNewVersionMap.put(page.getPublishRefPageId(), nPageVersion);
            versionInfos.put(page.getPublishRefPageId(), new VersionInfo().setPublishId(page.getPublishRefPageId()).setOriginVersion(page.getVersion()).setNewVersion(nPageVersion));
            page.setVersion(nPageVersion);
        });
        List filteredCopyPages = copyPages.stream().filter(p -> needChangedPageIds.contains(p.getPublishRefPageId())).map(page -> page.setId(null)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filteredCopyPages)) {
            this.ultPageService.saveBatch(filteredCopyPages, 10);
        }
        if (!AppVersionType.PATCH.equals((Object)appVersionType) && CollectionUtils.isNotEmpty(filteredUPages = uPages.stream().filter(f -> needChangedPageIds.contains(f.getId())).peek(uPage -> {
            String version = (String)pageNewVersionMap.get(uPage.getId());
            uPage.setVersion(version);
        }).collect(Collectors.toList()))) {
            this.ultPageService.updateBatchById(filteredUPages, 10);
        }
        Map<Long, Long> nPPageIdsVPageIds = copyPages.stream().collect(Collectors.toMap(UltPage::getPublishRefPageId, UltPage::getId));
        List aPageIds = ((List)pageChanges._1).stream().map(UltPage::getId).collect(Collectors.toList());
        List dPageBoSettingIds = ((List)pageChanges._5).stream().map(PageBoSetting::getUniqueId).collect(Collectors.toList());
        Map<Long, List<PageBoSetting>> rBoSettingsMap = ((List)pageChanges._6).stream().collect(Collectors.groupingBy(PageBoSetting::getPageId));
        ArrayList copyPageBoSettings = Lists.newArrayList();
        copyPages.stream().filter(p -> needChangedPageIds.contains(p.getPublishRefPageId())).forEach(copyPage -> {
            if (CollectionUtils.isNotEmpty((Collection)aPageIds) && aPageIds.contains(copyPage.getPublishRefPageId())) {
                Optional.ofNullable(this.pageBoSettingRepository.getPageBoSettingsByPageId(copyPage.getPublishRefPageId())).ifPresent(pageBoSettings -> pageBoSettings.forEach(boSetting -> copyPageBoSettings.add(PageBoSettingStructMapper.MAPPER.clone(boSetting).setId(null).setPageId(copyPage.getId()))));
            } else {
                Optional.ofNullable(pPPageIdVOriPageId.get(copyPage.getPublishRefPageId())).ifPresent(pPageId -> Optional.ofNullable(this.pageBoSettingRepository.getPageBoSettingsByPageId(pPageId)).ifPresent(pageBoSettings -> {
                    Optional.ofNullable(rBoSettingsMap.get(copyPage.getPublishRefPageId())).ifPresent(rBoSettings -> rBoSettings.forEach(rBoSetting -> pageBoSettings.stream().filter(boSetting -> rBoSetting.getUniqueId().equals(boSetting.getUniqueId())).findAny().ifPresent(boSetting -> {
                        PageBoSettingStructMapper.MAPPER.updatePageBoSetting(rBoSetting, boSetting);
                        boSetting.setPageId(copyPage.getId());
                    })));
                    pageBoSettings.stream().filter(pageBoSetting -> !dPageBoSettingIds.contains(pageBoSetting.getUniqueId())).forEach(boSetting -> copyPageBoSettings.add(PageBoSettingStructMapper.MAPPER.clone(boSetting).setId(null).setPageId(copyPage.getId())));
                }));
            }
        });
        ((List)pageChanges._4).forEach(pageBoSetting -> copyPageBoSettings.add(PageBoSettingStructMapper.MAPPER.clone(pageBoSetting).setId(null).setPageId((Long)nPPageIdsVPageIds.get(pageBoSetting.getPageId()))));
        if (CollectionUtils.isNotEmpty((Collection)copyPageBoSettings)) {
            this.pageBoSettingService.saveBatch((Collection)copyPageBoSettings, 10);
        }
        return ServiceResponse.success((String)"", (Object)versionInfos);
    }

    private List<Long> getNeedChangedPageIds(Tuple6<List<UltPage>, List<UltPage>, List<UltPage>, List<PageBoSetting>, List<PageBoSetting>, List<PageBoSetting>> pageChanges, List<UltPage> uPages, List<UltPage> pPages) {
        Map uPageMap = uPages.stream().collect(Collectors.toMap(UltPage::getId, Function.identity()));
        Map pPageMap = pPages.stream().collect(Collectors.toMap(UltPage::getId, Function.identity()));
        HashSet pageIds = Sets.newHashSet();
        ((List)pageChanges._1).forEach(item -> pageIds.add(item.getId()));
        ((List)pageChanges._2).forEach(item -> pageIds.add(item.getPublishRefPageId()));
        ((List)pageChanges._3).forEach(item -> pageIds.add(item.getId()));
        ((List)pageChanges._4).forEach(p -> Optional.ofNullable(uPageMap.get(p.getPageId())).ifPresent(page -> pageIds.add(page.getId())));
        ((List)pageChanges._5).forEach(p -> Optional.ofNullable(pPageMap.get(p.getPageId())).ifPresent(page -> pageIds.add(page.getPublishRefPageId())));
        ((List)pageChanges._6).forEach(p -> Optional.ofNullable(uPageMap.get(p.getPageId())).ifPresent(page -> pageIds.add(page.getId())));
        return new ArrayList<Long>(pageIds);
    }
}

