/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IApisService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiVersionQuery {
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IApisService apisService;

    public List<Apis> getApis(Long appId, String appVersion) {
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appId, appVersion, MetadataType.API).orElse(null);
        if (null == versionChange) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getVersion, (Object)versionChange.getResourceVersion())).eq(Apis::getDeleteFlag, (Object)"1")).eq(Apis::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        return this.apisService.list((Wrapper)wrapper);
    }

    public List<Apis> getApis(Long appVersionId) {
        AppVersion appVersion = (AppVersion)this.appVersionService.getById((Serializable)appVersionId);
        if (null == appVersion) {
            return Lists.newArrayList();
        }
        return this.getApis(appVersion.getAppId(), appVersion.getVersion());
    }

    public Apis getApiByUIDAndVersionWithValidate(Long appId, Long uID, String apiVersion) {
        Apis vApi = (Apis)this.apisService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Apis::getApplicationId, (Object)appId)).eq(Apis::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(Apis::getUniqueId, (Object)uID)).eq(Apis::getVersion, (Object)apiVersion), false);
        if (null == vApi) {
            throw new ValidateException(String.format("\u6839\u636e\u63a5\u53e3 UID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, apiVersion));
        }
        return vApi;
    }
}

