/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.VersionStatus;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEnvService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionChangeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppVersionQuery {
    @Autowired
    private IAppEnvService appEnvService;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private IAppVersionChangeService appVersionChangeService;
    @Autowired
    private AppEnvRepository appEnvRepository;

    public boolean isAppVersionsChange(Long currentVersionId, Long comparedVersionId, MetadataType metadataType) {
        Optional<AppVersionChange> currentOptional = this.getAppVersionChange(currentVersionId, metadataType);
        Optional<AppVersionChange> comparedOptional = this.getAppVersionChange(comparedVersionId, metadataType);
        if (!currentOptional.isPresent() || !comparedOptional.isPresent()) {
            return true;
        }
        return !currentOptional.get().getResourceVersion().equals(comparedOptional.get().getResourceVersion());
    }

    public Optional<AppVersion> getAppVersionByAppIdAndEnvId(Long appId, Long envId) {
        Optional appEnvOptional = this.appEnvRepository.getAppEnv(appId.longValue(), envId.longValue());
        return appEnvOptional.map(appEnv -> (AppVersion)this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getId, (Object)appEnv.getAppVersionId())).eq(AppVersion::getDeleteFlag, (Object)"1"), false));
    }

    public Optional<AppVersion> getLatestMainVersion(Long appId) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1")).orderByDesc(AppVersion::getId)).last("limit 10"));
        return appVersions.stream().sorted(this::compareVersion).findFirst();
    }

    public Optional<AppVersion> getLatestPatchVersion(Long appId, Long mainVersionId) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getMainVersionId, (Object)mainVersionId)).eq(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1")).orderByDesc(AppVersion::getId)).last("limit 10"));
        return appVersions.stream().sorted(this::compareVersion).findFirst();
    }

    public Optional<AppVersion> getLatestMainVersionLeThanId(Long appId, Long appVersionId) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1")).le(AppVersion::getId, (Object)appVersionId)).orderByDesc(AppVersion::getId)).last("limit 10"));
        return appVersions.stream().sorted(this::compareVersion).findFirst();
    }

    public String getLatestMainVersionIncludeDelete(Long appId) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{AppVersion::getVersion}).eq(AppVersion::getAppId, (Object)appId)).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).orderByDesc(AppVersion::getId)).last("limit 10"));
        return appVersions.stream().sorted(this::compareVersion).findFirst().orElse(new AppVersion()).getVersion();
    }

    public Optional<AppVersion> getPreviousMainVersion(Long appId, Long currentVersionId) {
        List appVersions = this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).ne(AppVersion::getVersionType, (Object)AppVersionType.PATCH.code())).eq(AppVersion::getDeleteFlag, (Object)"1")).lt(AppVersion::getId, (Object)currentVersionId)).orderByDesc(AppVersion::getId)).last("limit 10"));
        return appVersions.stream().sorted(this::compareVersion).findFirst();
    }

    public List<AppVersion> getAppVersions(Long appId) {
        return this.appVersionService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getDeleteFlag, (Object)"1"));
    }

    public List<AppVersion> getAppVersions(Long appId, VersionStatus versionStatus) {
        return this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getVersionStatus, (Object)versionStatus.code())).eq(AppVersion::getDeleteFlag, (Object)"1"));
    }

    public Optional<AppVersion> getAppVersion(Long appId, String appVersion) {
        return this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getVersion, (Object)appVersion)).eq(AppVersion::getDeleteFlag, (Object)"1")).stream().findAny();
    }

    public Optional<AppVersion> getAppVersion(Long appVersionId) {
        return Optional.ofNullable(this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getId, (Object)appVersionId)).eq(AppVersion::getDeleteFlag, (Object)"1"), false));
    }

    public Optional<AppVersion> getAppVersion(Long appId, Long appVersionId) {
        return this.getAppVersion(appId, appVersionId, true);
    }

    public Optional<AppVersion> getAppVersion(Long appId, Long appVersionId, boolean includeDelete) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getId, (Object)appVersionId);
        if (!includeDelete) {
            queryWrapper.eq(AppVersion::getDeleteFlag, (Object)"1");
        }
        return Optional.ofNullable(this.appVersionService.getOne((Wrapper)queryWrapper, false));
    }

    public AppVersion getAppVersionWithValidate(Long appId, String appVersion) {
        AppVersion appVersionObj = (AppVersion)this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getVersion, (Object)appVersion)).eq(AppVersion::getDeleteFlag, (Object)"1"), false);
        if (null == appVersionObj) {
            throw new ValidateException(String.format("\u6839\u636e\u5e94\u7528ID %s \u548c \u5e94\u7528\u7248\u672c %s \u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u7248\u672c\u4fe1\u606f", appId, appVersion));
        }
        return appVersionObj;
    }

    public AppVersion getLatestMainVersionWithValidate(Long appId) {
        Optional<AppVersion> appVersionOptional = this.getLatestMainVersion(appId);
        if (!appVersionOptional.isPresent()) {
            throw new ValidateException(String.format("\u6839\u636e\u5e94\u7528ID %s  \u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u7248\u672c\u4fe1\u606f", appId));
        }
        return appVersionOptional.get();
    }

    @SkipDataAuth
    public AppVersion getAppVersionWithValidateSkipDataAuth(Long appId, String appVersion) {
        return this.getAppVersionWithValidate(appId, appVersion);
    }

    public AppVersion getAppVersionWithValidate(Long appVersionId) {
        AppVersion appVersionObj = (AppVersion)this.appVersionService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getId, (Object)appVersionId)).eq(AppVersion::getDeleteFlag, (Object)"1"), false);
        if (null == appVersionObj) {
            throw new ValidateException(String.format("\u6839\u636e\u5e94\u7528\u7248\u672cID %s\u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u7248\u672c\u4fe1\u606f", appVersionId));
        }
        return appVersionObj;
    }

    public AppVersion getAppVersionWithValidate(Long appId, Long appVersionId) {
        return this.getAppVersionWithValidate(appId, appVersionId, true);
    }

    public AppVersion getAppVersionWithValidate(Long appId, Long appVersionId, boolean includeDelete) {
        AppVersion appVersionObj;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getId, (Object)appVersionId);
        if (!includeDelete) {
            queryWrapper.eq(AppVersion::getDeleteFlag, (Object)"1");
        }
        if (null == (appVersionObj = (AppVersion)this.appVersionService.getOne((Wrapper)queryWrapper, false))) {
            throw new ValidateException(String.format("\u6839\u636e\u5e94\u7528ID %s \u548c \u5e94\u7528\u7248\u672cID %s \u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u7248\u672c\u4fe1\u606f", appId, appVersionId));
        }
        return appVersionObj;
    }

    public AppVersion getPreviousVersion(Long appId, String currentVersion) {
        AppVersion appVersion = this.getAppVersionWithValidate(appId, currentVersion);
        AppVersion previousVersion = null;
        if (AppVersionType.PATCH.code().equals(appVersion.getVersionType())) {
            Optional<AppVersion> previousAppVersionOptional = this.getAppVersion(appId, appVersion.getParentVersionId());
            if (previousAppVersionOptional.isPresent()) {
                previousVersion = previousAppVersionOptional.get();
            }
        } else {
            Optional<AppVersion> previousAppVersionOptional = this.getPreviousMainVersion(appId, appVersion.getId());
            if (previousAppVersionOptional.isPresent()) {
                previousVersion = previousAppVersionOptional.get();
            }
        }
        return previousVersion;
    }

    public Optional<AppVersionChange> getAppVersionChange(Long appId, String appVersion, MetadataType metadataType) {
        Optional<AppVersion> appVersionOptl = this.getAppVersion(appId, appVersion);
        if (!appVersionOptl.isPresent()) {
            return Optional.empty();
        }
        return this.getAppVersionChange(appVersionOptl.get().getId(), metadataType);
    }

    public Optional<AppVersionChange> getAppVersionChange(Long appVersionId, MetadataType metadataType) {
        if (!Arrays.asList(MetadataType.BO, MetadataType.DICT, MetadataType.FLOW_ACTION, MetadataType.API, MetadataType.RULE, MetadataType.TAG, MetadataType.APP_EVENT, MetadataType.SDK_SETTING).contains(metadataType)) {
            throw new ValidateException("\u9519\u8bef\u7684\u8d44\u6e90\u7c7b\u578b");
        }
        AppVersionChange appVersionChange = (AppVersionChange)this.appVersionChangeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersionId)).eq(AppVersionChange::getResourceType, (Object)metadataType.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1"), false);
        return Optional.ofNullable(appVersionChange);
    }

    public AppVersionChange getAppVersionChangeWithValidate(Long appVersionId, MetadataType metadataType, Long metadataId) {
        AppVersionChange appVersionChange = (AppVersionChange)this.appVersionChangeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersionId)).eq(AppVersionChange::getResourceType, (Object)metadataType.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1")).eq(AppVersionChange::getResourceId, (Object)metadataId), false);
        if (null == appVersionChange) {
            throw new ValidateException(String.format("\u6839\u636e\u5e94\u7528\u7248\u672cID %s \u5143\u6570\u636e\u7c7b\u578b %s \u5143\u6570\u636eID %s \u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u7248\u672c\u53d8\u66f4\u4fe1\u606f", appVersionId, metadataType.code(), metadataId));
        }
        return appVersionChange;
    }

    public List<AppVersionChange> getAppVersionChanges(Long appId, String appVersion, MetadataType metadataType) {
        Optional<AppVersion> appVersionOptl = this.getAppVersion(appId, appVersion);
        if (!appVersionOptl.isPresent()) {
            return Lists.newArrayList();
        }
        return this.getAppVersionChanges(appVersionOptl.get().getId(), metadataType);
    }

    public List<AppVersionChange> getAppVersionChanges(Long appVersionId, MetadataType metadataType) {
        if (!Arrays.asList(MetadataType.PAGE, MetadataType.FORM, MetadataType.FLOW_SETTING, MetadataType.PAGE_SETTING).contains(metadataType)) {
            throw new RuntimeException("\u9519\u8bef\u7684\u8d44\u6e90\u7c7b\u578b");
        }
        return this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersionId)).eq(AppVersionChange::getResourceType, (Object)metadataType.code())).eq(AppVersionChange::getDeleteFlag, (Object)"1")).isNotNull(AppVersionChange::getResourceId));
    }

    public List<AppVersionChange> getAppVersionChanges(Long appVersionId) {
        return this.appVersionChangeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersionChange::getAppVersionId, (Object)appVersionId)).eq(AppVersionChange::getDeleteFlag, (Object)"1"));
    }

    public Optional<AppVersionChange> getAppVersionChange(Long appId, Long envId, MetadataType metadataType) {
        AppEnv appEnv = (AppEnv)this.appEnvService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppEnv::getAppId, (Object)appId)).eq(AppEnv::getEnvId, (Object)envId)).eq(AppEnv::getDeleteFlag, (Object)"1"));
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Optional.empty();
        }
        return this.getAppVersionChange(appEnv.getAppVersionId(), metadataType);
    }

    private int compareVersion(AppVersion o1, AppVersion o2) {
        int intV1 = VersionUtils.computeVersionInt((String)o1.getVersion());
        int intV2 = VersionUtils.computeVersionInt((String)o2.getVersion());
        return intV2 - intV1;
    }
}

