/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoVersionQuery {
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private IBoService boService;

    public List<Bo> getBos(Long appId, String appVersion) {
        return this.getBos(appId, appVersion, true);
    }

    @SkipDataAuth
    public List<Bo> getBosSkipDataAuth(Long appId, String appVersion) {
        return this.getBos(appId, appVersion);
    }

    public List<Bo> getBos(Long appVersionId) {
        AppVersion appVersion = (AppVersion)this.appVersionService.getById((Serializable)appVersionId);
        if (appVersion == null) {
            return Lists.newArrayList();
        }
        return this.getBos(appVersion.getAppId(), appVersion.getVersion());
    }

    public List<Bo> getBos(Long appId, Long envId) {
        AppEnv appEnv = this.appEnvRepository.getAppEnv(appId.longValue(), envId.longValue()).orElse(null);
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Lists.newArrayList();
        }
        return this.getBos(appEnv.getAppVersionId());
    }

    @SkipDataAuth
    public List<Bo> getBos(Long appId, String appVersion, boolean includeTenant) {
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appId, appVersion, MetadataType.BO).orElse(null);
        if (null == versionChange) {
            return Lists.newArrayList();
        }
        Optional moduleOptl = this.defaultModuleService.getPublishedModuleByAppId(appId.longValue(), versionChange.getResourceVersion());
        if (!moduleOptl.isPresent()) {
            return Lists.newArrayList();
        }
        List vBos = this.defaultModuleService.getBos(((Module)moduleOptl.get()).getId());
        return includeTenant ? vBos : vBos.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
    }

    public Bo getBoByUIDAndVersionWithValidate(Long appId, Long uID, String boVersion) {
        Bo bo = (Bo)this.boService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getAppId, (Object)appId)).eq(Bo::getPublishBoId, (Object)uID)).eq(Bo::getVersion, (Object)boVersion), false);
        if (null == bo) {
            throw new ValidateException(String.format("\u6839\u636e\u5bf9\u8c61UID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, boVersion));
        }
        return bo;
    }
}

