/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictVersionQuery {
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IDictService dictService;

    public List<Dict> getDicts(Long appId, String appVersion) {
        return this.getDicts(appId, appVersion, true);
    }

    public List<Dict> getDicts(Long appVersionId) {
        AppVersion appVersion = (AppVersion)this.appVersionService.getById((Serializable)appVersionId);
        if (null == appVersion) {
            return Lists.newArrayList();
        }
        return this.getDicts(appVersion.getAppId(), appVersion.getVersion());
    }

    public List<Dict> getDicts(Long appId, Long envId) {
        AppEnv appEnv = this.appEnvRepository.getAppEnv(appId.longValue(), envId.longValue()).orElse(null);
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Lists.newArrayList();
        }
        return this.getDicts(appEnv.getAppVersionId());
    }

    public List<Dict> getDicts(Long appId, String appVersion, boolean includeTenant) {
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appId, appVersion, MetadataType.DICT).orElse(null);
        if (null == versionChange) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getAppId, (Object)appId)).eq(Dict::getVersion, (Object)versionChange.getResourceVersion())).eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        List vDicts = this.dictService.list((Wrapper)wrapper);
        return includeTenant ? vDicts : vDicts.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
    }

    public Dict getDictByUIDAndVersionWithValidate(Long appId, Long uID, String dictVersion) {
        Dict dict = (Dict)this.dictService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(Dict::getAppId, (Object)appId)).eq(Dict::getUniqueId, (Object)uID)).eq(Dict::getVersion, (Object)dictVersion), false);
        if (null == dict) {
            throw new ValidateException(String.format("\u6839\u636e\u5b57\u5178UID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, dictVersion));
        }
        return dict;
    }
}

