/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowActionVersionQuery {
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IFlowActionService flowActionService;

    public List<FlowAction> getLatestVersionActions(Long appId) {
        AppVersion appVersion = this.appVersionQuery.getLatestMainVersionWithValidate(appId);
        return this.getActions(appId, appVersion.getVersion());
    }

    public List<FlowAction> getActions(Long appId, String appVersion) {
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appId, appVersion, MetadataType.FLOW_ACTION).orElse(null);
        if (null == versionChange) {
            return Lists.newArrayList();
        }
        return this.flowActionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getDeleteFlag, (Object)"1")).eq(FlowAction::getVersion, (Object)versionChange.getResourceVersion())).isNotNull(FlowAction::getPublishActionId));
    }

    public List<FlowAction> getActions(Long appVersionId) {
        AppVersion appVersion = (AppVersion)this.appVersionService.getById((Serializable)appVersionId);
        if (null == appVersion) {
            return Lists.newArrayList();
        }
        return this.getActions(appVersion.getAppId(), appVersion.getVersion());
    }

    public List<FlowAction> getActions(Long appId, Long envId) {
        AppEnv appEnv = this.appEnvRepository.getAppEnv(appId.longValue(), envId.longValue()).orElse(null);
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Lists.newArrayList();
        }
        return this.getActions(appEnv.getAppVersionId());
    }

    public FlowAction getActionByUIDAndVersionWithValidate(Long appId, Long uID, String actionVersion) {
        FlowAction vAction = (FlowAction)this.flowActionService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowAction::getAppId, (Object)appId)).eq(FlowAction::getPublishActionId, (Object)uID)).eq(FlowAction::getVersion, (Object)actionVersion), false);
        if (null == vAction) {
            throw new ValidateException(String.format("\u6839\u636e\u81ea\u5b9a\u4e49ACTION UID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, actionVersion));
        }
        return vAction;
    }
}

