/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ChangeFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowSettingVersionQuery {
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private FlowSettingRepository flowSettingRepository;

    public List<FlowSetting> getLatestVersionFlowSettings(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), MetadataType.FLOW_SETTING);
            return this.getFlowSettingsBatch(appId, versionChanges, true, true);
        }
        return this.getLatestVersionFlowSettingsByUnPublishFlowSettings(appId);
    }

    public List<FlowSetting> getLatestVersionFlowSettingsByUnPublishFlowSettings(Long appId) {
        List flowSettings = this.flowSettingRepository.getFlowSettingsWithoutFrontSetting(appId);
        if (flowSettings.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList pFlowSettingss = Lists.newArrayList();
        flowSettings.forEach(flowSetting -> {
            FlowSetting pFlowSetting = (FlowSetting)this.flowSettingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(FlowSetting::getPublishFlowId, (Object)flowSetting.getId())).eq(FlowSetting::getVersion, (Object)flowSetting.getVersion())).eq(FlowSetting::getDeleteFlag, (Object)"1"), false);
            if (pFlowSetting != null) {
                pFlowSettingss.add(pFlowSetting);
            }
        });
        return pFlowSettingss;
    }

    public List<FlowSetting> getFlowSettings(Long appId, String appVersion) {
        return this.getFlowSettingsBatch(appId, appVersion, true, true);
    }

    public List<FlowSetting> getFlowSettingsWithoutAllSetting(Long appId, String appVersion) {
        LambdaQueryWrapper<FlowSetting> wrapper = this.getFlowSettingsWrapper(appId, appVersion);
        wrapper.select(FlowSetting.class, o -> !o.getColumn().equals("flow_setting") && !o.getColumn().equals("flow_setting_front"));
        return this.getFlowSettings(wrapper);
    }

    public List<FlowSetting> getFlowSettings(LambdaQueryWrapper<FlowSetting> wrapper) {
        if (wrapper.isEmptyOfWhere()) {
            return Lists.newArrayList();
        }
        return this.flowSettingService.list(wrapper);
    }

    public List<FlowSetting> getFlowSettings(Long appId, List<AppVersionChange> versionChanges) {
        LambdaQueryWrapper<FlowSetting> flowSettingWrapper = this.getFlowSettingsWrapper(appId, versionChanges);
        return flowSettingWrapper.isEmptyOfWhere() ? Lists.newArrayList() : this.flowSettingService.list(flowSettingWrapper);
    }

    public LambdaQueryWrapper<FlowSetting> getFlowSettingsWrapper(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FLOW_SETTING);
        return this.getFlowSettingsWrapper(appId, versionChanges);
    }

    public LambdaQueryWrapper<FlowSetting> getFlowSettingsWrapper(Long appId, List<AppVersionChange> versionChanges) {
        List finalVersionChanges = versionChanges.stream().filter(o -> null != o.getResourceId()).collect(Collectors.toList());
        if (finalVersionChanges.isEmpty()) {
            return Wrappers.lambdaQuery();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getDeleteFlag, (Object)"1")).eq(FlowSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalVersionChanges.forEach(pageChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(FlowSetting::getPublishFlowId, (Object)pageChange.getResourceId())).eq(FlowSetting::getVersion, (Object)pageChange.getResourceVersion());
            });
        }));
        return wrapper;
    }

    public List<FlowSetting> getFlowSettings(Long appId, Long envId) {
        AppEnv appEnv = this.appEnvRepository.getAppEnv(appId.longValue(), envId.longValue()).orElse(null);
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Lists.newArrayList();
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appEnv.getAppVersionId(), MetadataType.FLOW_SETTING);
        return this.getFlowSettingsBatch(appId, versionChanges, true, true);
    }

    public List<FlowSetting> getFlowSettingsByAppIdAndAppVersionId(Long appId, Long appVersionId) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.FLOW_SETTING);
        return this.getFlowSettingsBatch(appId, versionChanges, true, true);
    }

    public List<FlowSetting> getFlowSettings(Long appId, String appVersion, boolean includeFlowSettingFront, boolean includeTenant) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FLOW_SETTING);
        return this.getFlowSettingsBatch(appId, versionChanges, includeFlowSettingFront, includeTenant);
    }

    public List<FlowSetting> getFlowSettingsBatch(Long appId, String appVersion, boolean includeFlowSettingFront, boolean includeTenant) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FLOW_SETTING);
        return this.getFlowSettingsBatch(appId, versionChanges, includeFlowSettingFront, includeTenant);
    }

    public List<FlowSetting> getFlowSettings(Long appId, String appVersion, boolean includeFlowSettingFront, boolean includeTenant, boolean isOnlyChanged) {
        List<Object> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FLOW_SETTING);
        versionChanges = versionChanges.stream().filter(o -> !isOnlyChanged || ChangeFlag.CHANGED.code().equals(o.getChangeFlag())).collect(Collectors.toList());
        return this.getFlowSettingsBatch(appId, versionChanges, includeFlowSettingFront, includeTenant);
    }

    private List<FlowSetting> getFlowSettingsBatch(Long appId, List<AppVersionChange> versionChanges, boolean includeFlowSettingFront, boolean includeTenant) {
        Map<Integer, List<AppVersionChange>> batches = versionChanges.stream().collect(Collectors.groupingBy(i -> versionChanges.indexOf(i) / 10));
        return batches.values().stream().map(l -> this.getFlowSettings(appId, (List<AppVersionChange>)l, includeFlowSettingFront, includeTenant)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<FlowSetting> getFlowSettings(Long appId, List<AppVersionChange> versionChanges, boolean includeFlowSettingFront, boolean includeTenant) {
        LambdaQueryWrapper<FlowSetting> wrapper = this.getFlowSettingsWrapper(appId, versionChanges);
        if (!includeFlowSettingFront) {
            wrapper.select(FlowSetting.class, info -> !info.getColumn().equals("flow_setting_front"));
        }
        List vFlowSettings = this.flowSettingService.list(wrapper);
        return includeTenant ? vFlowSettings : vFlowSettings.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
    }

    public FlowSetting getFlowSettingByUIDAndVersionWithValidate(Long appId, Long uID, String flowVersion) {
        FlowSetting vFlowSetting = (FlowSetting)this.flowSettingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getPublishFlowId, (Object)uID)).eq(FlowSetting::getVersion, (Object)flowVersion), false);
        if (null == vFlowSetting) {
            throw new ValidateException(String.format("\u6839\u636e\u6d41\u914d\u7f6e UID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, flowVersion));
        }
        return vFlowSetting;
    }

    public List<FlowSetting> getTenantFlowSettings(Long appId, Long vFlowSettingId) {
        return this.flowSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(FlowSetting::getDeleteFlag, (Object)"1")).eq(FlowSetting::getAppId, (Object)appId)).eq(FlowSetting::getRefFlowId, (Object)vFlowSettingId));
    }
}

