/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ChangeFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppVersionChangeRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltFormService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVersionQuery {
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private UltFormRepository ultFormRepository;
    @Autowired
    private AppVersionChangeRepository appVersionChangeRepository;
    @Autowired
    private IUltFormService ultFormService;

    public List<UltForm> getLatestVersionFormsWhenNoAppVersion(Long appId) {
        LambdaQueryWrapper<UltForm> wrapper = this.getLatestVersionFormsWhenNoAppVersionWrapper(appId);
        return wrapper.isEmptyOfWhere() ? Lists.newArrayList() : this.ultFormService.list(wrapper);
    }

    public List<UltForm> getLatestVersionFormsNoSettingWhenNoAppVersion(Long appId) {
        LambdaQueryWrapper<UltForm> wrapper = this.getLatestVersionFormsWhenNoAppVersionWrapper(appId);
        wrapper.select(UltForm.class, field -> !field.getColumn().equals("setting"));
        return wrapper.isEmptyOfWhere() ? Lists.newArrayList() : this.ultFormService.list(wrapper);
    }

    public LambdaQueryWrapper<UltForm> getLatestVersionFormsWhenNoAppVersionWrapper(Long appId) {
        List ultForms = this.ultFormRepository.getFormsWithoutSetting(appId);
        return ultForms.isEmpty() ? Wrappers.lambdaQuery() : (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code())).eq(UltForm::getDeleteFlag, (Object)"1")).and(w -> ultForms.forEach(form -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.or()).eq(UltForm::getPublishRefFormId, (Object)form.getId())).eq(UltForm::getVersion, (Object)form.getVersion());
        }));
    }

    public LambdaQueryWrapper<UltForm> getLatestVersionFormsWrapper(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), MetadataType.FORM);
            return this.getFormsWrapper(appId, versionChanges);
        }
        return this.getLatestVersionFormsWhenNoAppVersionWrapper(appId);
    }

    public List<UltForm> getLatestVersionForms(Long appId) {
        LambdaQueryWrapper<UltForm> formWrapper = this.getLatestVersionFormsWrapper(appId);
        return formWrapper.isEmptyOfWhere() ? Lists.newArrayList() : this.ultFormService.list(formWrapper);
    }

    public UltForm getLatestVersionForm(Long appId, Long formUID) {
        AppVersion appVersion = this.appVersionQuery.getLatestMainVersionWithValidate(appId);
        AppVersionChange appVersionChange = this.appVersionChangeRepository.getAppVersionChangeWithValidate(appVersion.getId(), formUID);
        return this.getFormByUIdAndVersionWithValidate(appId, formUID, appVersionChange.getResourceVersion());
    }

    public List<UltForm> getLatestVersionFormsBatch(Long appId) {
        List<Object> versionChanges;
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), MetadataType.FORM);
        } else {
            LambdaQueryWrapper formWrapper = this.ultFormRepository.getFormsWrapper(appId).select(new SFunction[]{UltForm::getId, UltForm::getVersion});
            versionChanges = this.ultFormService.list((Wrapper)formWrapper).stream().map(o -> new AppVersionChange().setResourceId(o.getId()).setResourceVersion(o.getVersion())).collect(Collectors.toList());
        }
        return this.getFormsBatch(appId, versionChanges, true);
    }

    public List<UltForm> getLatestVersionFormsNoSetting(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), MetadataType.FORM);
            return this.getFormsNoSetting(appId, versionChanges, true);
        }
        return this.getLatestVersionFormsNoSettingWhenNoAppVersion(appId);
    }

    public List<UltForm> getForms(Long appId, String appVersion) {
        return this.getFormsBatch(appId, appVersion, true);
    }

    public List<UltForm> getFormsBatch(Long appId, String appVersion) {
        return this.getFormsBatch(appId, appVersion, true);
    }

    public List<UltForm> getFormsBatch(Long appId, String appVersion, boolean includeTenant) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FORM);
        return this.getFormsBatch(appId, versionChanges, includeTenant);
    }

    public List<UltForm> getFormsBatch(Long appId, List<AppVersionChange> versionChanges, boolean includeTenant) {
        Map<Integer, List<AppVersionChange>> batches = versionChanges.stream().collect(Collectors.groupingBy(i -> versionChanges.indexOf(i) / 10));
        return batches.values().stream().map(l -> this.getForms(appId, (List<AppVersionChange>)l, includeTenant)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<UltForm> getForms(Long appId, String appVersion, boolean includeTenant) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FORM);
        return this.getFormsBatch(appId, versionChanges, includeTenant);
    }

    public List<UltForm> getForms(Long appId, String appVersion, boolean includeTenant, boolean isOnlyChanged) {
        List<Object> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FORM);
        versionChanges = versionChanges.stream().filter(o -> !isOnlyChanged || ChangeFlag.CHANGED.code().equals(o.getChangeFlag())).collect(Collectors.toList());
        return isOnlyChanged ? this.getForms(appId, versionChanges, includeTenant) : this.getFormsBatch(appId, versionChanges, includeTenant);
    }

    public List<UltForm> getForms(LambdaQueryWrapper<UltForm> wrapper) {
        return this.getForms(wrapper, true);
    }

    public List<UltForm> getForms(LambdaQueryWrapper<UltForm> wrapper, boolean includeTenant) {
        ArrayList vUltForms = wrapper.isEmptyOfWhere() ? Lists.newArrayList() : this.ultFormService.list(wrapper);
        return includeTenant ? vUltForms : vUltForms.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
    }

    public LambdaQueryWrapper<UltForm> getFormsWrapper(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FORM);
        return this.getFormsWrapper(appId, versionChanges);
    }

    public LambdaQueryWrapper<UltForm> getFormsWrapper(Long appId, List<AppVersionChange> versionChanges) {
        List finalVersionChanges = versionChanges.stream().filter(chg -> null != chg.getResourceId()).collect(Collectors.toList());
        if (finalVersionChanges.isEmpty()) {
            return Wrappers.lambdaQuery();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getDeleteFlag, (Object)"1")).eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalVersionChanges.forEach(formChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltForm::getPublishRefFormId, (Object)formChange.getResourceId())).eq(UltForm::getVersion, (Object)formChange.getResourceVersion());
            });
        }));
        return wrapper;
    }

    public List<UltForm> getForms(Long appId, Long envId) {
        AppEnv appEnv = this.appEnvRepository.getAppEnv(appId.longValue(), envId.longValue()).orElse(null);
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Lists.newArrayList();
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appEnv.getAppVersionId(), MetadataType.FORM);
        return this.getFormsBatch(appId, versionChanges, true);
    }

    public List<UltForm> getFormsByAppIdAndAppVersionId(Long appId, Long appVersionId) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.FORM);
        return this.getFormsBatch(appId, versionChanges, true);
    }

    public List<UltForm> getForms(Long appId, List<AppVersionChange> versionChanges, boolean includeTenant) {
        LambdaQueryWrapper<UltForm> wrapper = this.getFormsWrapper(appId, versionChanges);
        return this.getForms(wrapper, includeTenant);
    }

    private List<UltForm> getFormsNoSetting(Long appId, List<AppVersionChange> versionChanges, boolean includeTenant) {
        LambdaQueryWrapper<UltForm> wrapper = this.getFormsWrapper(appId, versionChanges);
        wrapper.select(UltForm.class, field -> !field.getColumn().equals("setting"));
        return this.getForms(wrapper, includeTenant);
    }

    public List<UltForm> getFormsWithoutSetting(Long appId, String appVersion) {
        LambdaQueryWrapper<UltForm> wrapper = this.getFormsWrapper(appId, appVersion);
        wrapper.select(UltForm.class, field -> !field.getColumn().equals("setting"));
        return this.getForms(wrapper);
    }

    public List<UltForm> getChangedFormsInVersion(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.FORM).stream().filter(o -> null != o.getResourceId() && ChangeFlag.CHANGED.code().equals(o.getChangeFlag())).collect(Collectors.toList());
        return this.getFormsBatch(appId, versionChanges, true);
    }

    public UltForm getFormByUIdAndVersionWithValidate(Long appId, Long uID, String formVersion) {
        UltForm vUltForm = (UltForm)this.ultFormService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getPublishRefFormId, (Object)uID)).eq(UltForm::getVersion, (Object)formVersion)).eq(UltForm::getDeleteFlag, (Object)"1"), false);
        if (null == vUltForm) {
            throw new RuntimeException(String.format("\u6839\u636e\u9875\u9762\u89c6\u56feUID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, formVersion));
        }
        return vUltForm;
    }

    public List<UltForm> getTenantForms(Long appId, Long vFormId) {
        return this.ultFormService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getAppId, (Object)appId)).eq(UltForm::getRefFormId, (Object)vFormId)).eq(UltForm::getDeleteFlag, (Object)"1"));
    }
}

