/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.ApiVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.AppEventVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.BoVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.DictVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.FlowActionVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.FlowSettingVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.FormVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.PageVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.RuleVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.SdkSettingVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.TagVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.ApiVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppEventVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.BoVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.DictVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FlowActionVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FlowSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FormVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.RuleVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.SdkSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.TagVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionChangeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetadataVersionQuery {
    private static final Logger log = LoggerFactory.getLogger(MetadataVersionQuery.class);
    @Autowired
    private BoVersionDiffQuery boVersionDiffQuery;
    @Autowired
    private DictVersionDiffQuery dictVersionDiffQuery;
    @Autowired
    private PageVersionDiffQuery pageVersionDiffQuery;
    @Autowired
    private FormVersionDiffQuery formVersionDiffQuery;
    @Autowired
    private FlowActionVersionDiffQuery flowActionVersionDiffQuery;
    @Autowired
    private FlowSettingVersionDiffQuery flowSettingVersionDiffQuery;
    @Autowired
    private ApiVersionDiffQuery apiVersionDiffQuery;
    @Autowired
    private RuleVersionDiffQuery ruleVersionDiffQuery;
    @Autowired
    private TagVersionDiffQuery tagVersionDiffQuery;
    @Autowired
    private AppEventVersionDiffQuery appEventVersionDiffQuery;
    @Autowired
    private SdkSettingVersionDiffQuery sdkSettingVersionDiffQuery;
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private IAppVersionChangeService appVersionChangeService;
    @Autowired
    private BoVersionQuery boVersionQuery;
    @Autowired
    private DictVersionQuery dictVersionQuery;
    @Autowired
    private PageVersionQuery pageVersionQuery;
    @Autowired
    private FormVersionQuery formVersionQuery;
    @Autowired
    private FlowActionVersionQuery flowActionVersionQuery;
    @Autowired
    private FlowSettingVersionQuery flowSettingVersionQuery;
    @Autowired
    private ApiVersionQuery apiVersionQuery;
    @Autowired
    private RuleVersionQuery ruleVersionQuery;
    @Autowired
    private TagVersionQuery tagVersionQuery;
    @Autowired
    private AppEventVersionQuery appEventVersionQuery;
    @Autowired
    private SdkSettingVersionQuery sdkSettingVersionQuery;
    @Autowired
    private PageSettingVersionQuery pageSettingVersionQuery;

    public List<AppVersion> getAppVersions(Long appId, Long appVersionId, Long comparedAppVersionId) {
        return this.appVersionService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).and(w1 -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w1.gt(AppVersion::getId, (Object)appVersionId)).lt(AppVersion::getId, (Object)comparedAppVersionId)).or(w2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w2.gt(AppVersion::getId, (Object)comparedAppVersionId)).lt(AppVersion::getId, (Object)appVersionId);
            });
        })).orderByDesc(AppVersion::getId));
    }

    public VersionContent getVersionMeta(Long appId, Long appVersionId, MetadataType metadataType) {
        VersionContent versionContent = new VersionContent();
        if (MetadataType.BO.equals((Object)metadataType)) {
            versionContent.setBos(this.boVersionDiffQuery.getVersionBos(appId, appVersionId));
        } else if (MetadataType.DICT.equals((Object)metadataType)) {
            versionContent.setDicts(this.dictVersionDiffQuery.getVersionDicts(appId, appVersionId));
        } else if (MetadataType.PAGE.equals((Object)metadataType)) {
            versionContent.setPages(this.pageVersionDiffQuery.getVersionPages(appId, appVersionId));
        } else if (MetadataType.FORM.equals((Object)metadataType)) {
            versionContent.setForms(this.formVersionDiffQuery.getVersionForms(appId, appVersionId));
        } else if (MetadataType.FLOW_ACTION.equals((Object)metadataType)) {
            versionContent.setFlowActions(this.flowActionVersionDiffQuery.getVersionFlowActions(appId, appVersionId));
        } else if (MetadataType.FLOW_SETTING.equals((Object)metadataType)) {
            versionContent.setFlowSettings(this.flowSettingVersionDiffQuery.getVersionFlowSettings(appId, appVersionId));
        } else if (MetadataType.API.equals((Object)metadataType)) {
            versionContent.setApis(this.apiVersionDiffQuery.getVersionApis(appId, appVersionId));
        } else if (MetadataType.RULE.equals((Object)metadataType)) {
            versionContent.setRules(this.ruleVersionDiffQuery.getVersionRules(appId, appVersionId));
        } else if (MetadataType.TAG.equals((Object)metadataType)) {
            versionContent.setTags(this.tagVersionDiffQuery.getVersionTags(appId, appVersionId));
        } else if (MetadataType.APP_EVENT.equals((Object)metadataType)) {
            versionContent.setAppEvents(this.appEventVersionDiffQuery.getVersionAppEvents(appId, appVersionId));
        } else if (MetadataType.SDK_SETTING.equals((Object)metadataType)) {
            versionContent.setSdkSettings(this.sdkSettingVersionDiffQuery.getVersionSdkSettings(appId, appVersionId));
        } else {
            log.error(String.format("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s\u5176\u4e2d\u4e4b\u4e00", Arrays.stream(MetadataType.values()).map(Enum::name).collect(Collectors.joining(","))));
        }
        return versionContent;
    }

    public <T> List<T> getMetadataByType(Long appId, String appVersion, Class<T> targetType) {
        if (Bo.class.isAssignableFrom(targetType)) {
            return this.boVersionQuery.getBos(appId, appVersion);
        }
        if (Dict.class.isAssignableFrom(targetType)) {
            return this.dictVersionQuery.getDicts(appId, appVersion);
        }
        if (UltPage.class.isAssignableFrom(targetType)) {
            return this.pageVersionQuery.getPages(appId, appVersion);
        }
        if (UltForm.class.isAssignableFrom(targetType)) {
            return this.formVersionQuery.getForms(appId, appVersion);
        }
        if (FlowAction.class.isAssignableFrom(targetType)) {
            return this.flowActionVersionQuery.getActions(appId, appVersion);
        }
        if (FlowSetting.class.isAssignableFrom(targetType)) {
            return this.flowSettingVersionQuery.getFlowSettings(appId, appVersion);
        }
        if (Apis.class.isAssignableFrom(targetType)) {
            return this.apiVersionQuery.getApis(appId, appVersion);
        }
        if (SueRule.class.isAssignableFrom(targetType)) {
            return this.ruleVersionQuery.getRules(appId, appVersion);
        }
        if (SueTag.class.isAssignableFrom(targetType)) {
            return this.tagVersionQuery.getTags(appId, appVersion);
        }
        if (AppEvent.class.isAssignableFrom(targetType)) {
            return this.appEventVersionQuery.getAppEvents(appId, appVersion);
        }
        if (SdkSetting.class.isAssignableFrom(targetType)) {
            return this.sdkSettingVersionQuery.getSdkSettings(appId, appVersion);
        }
        if (UltPageSetting.class.isAssignableFrom(targetType)) {
            return this.pageSettingVersionQuery.getPageSettings(appId, appVersion);
        }
        throw new RuntimeException("\u76ee\u6807\u7c7b\u578b\u4e0d\u5b58\u5728");
    }

    @SkipDataAuth
    public <T> List<T> getMetadataByTypeSkipDataAuth(Long appId, String appVersion, Class<T> targetType) {
        return this.getMetadataByType(appId, appVersion, targetType);
    }

    public List<Bo> getBos(Long appId, String appVersion) {
        return this.boVersionQuery.getBos(appId, appVersion, true);
    }

    public List<Bo> getBos(Long appVersionId) {
        return this.boVersionQuery.getBos(appVersionId);
    }

    public List<Dict> getDicts(Long appId, String appVersion) {
        return this.dictVersionQuery.getDicts(appId, appVersion, true);
    }

    public List<Dict> getDicts(Long appVersionId) {
        return this.dictVersionQuery.getDicts(appVersionId);
    }

    public List<UltPage> getPages(Long appId, String appVersion) {
        return this.pageVersionQuery.getPages(appId, appVersion, true);
    }

    public List<UltPage> getPages(Long appId, Long appVersionId) {
        return this.pageVersionQuery.getPagesByAppIdAndAppVersionId(appId, appVersionId);
    }

    public List<UltForm> getForms(Long appId, String appVersion) {
        return this.formVersionQuery.getForms(appId, appVersion, true);
    }

    public List<UltForm> getForms(Long appId, Long appVersionId) {
        return this.formVersionQuery.getFormsByAppIdAndAppVersionId(appId, appVersionId);
    }

    public List<FlowAction> getActions(Long appId, String appVersion) {
        return this.flowActionVersionQuery.getActions(appId, appVersion);
    }

    public List<FlowSetting> getFlowSettings(Long appId, String appVersion) {
        return this.flowSettingVersionQuery.getFlowSettings(appId, appVersion, true, true);
    }

    public List<FlowSetting> getFlowSettings(Long appId, Long appVersionId) {
        return this.flowSettingVersionQuery.getFlowSettingsByAppIdAndAppVersionId(appId, appVersionId);
    }

    public List<Apis> getApis(Long appId, String appVersion) {
        return this.apiVersionQuery.getApis(appId, appVersion);
    }

    public List<SueRule> getRules(Long appId, String appVersion) {
        return this.ruleVersionQuery.getRules(appId, appVersion);
    }

    public List<SueTag> getTags(Long appId, String appVersion) {
        return this.tagVersionQuery.getTags(appId, appVersion);
    }

    public List<AppEvent> getAppEvents(Long appId, String appVersion) {
        return this.appEventVersionQuery.getAppEvents(appId, appVersion);
    }

    public List<SdkSetting> getSdkSettings(Long appId, String appVersion) {
        return this.sdkSettingVersionQuery.getSdkSettings(appId, appVersion);
    }

    public List<UltPageSetting> getPageSettings(Long appId, String appVersion) {
        return this.pageSettingVersionQuery.getPageSettings(appId, appVersion, true);
    }

    public List<UltPageSetting> getPageSettings(Long appId, Long appVersionId) {
        return this.pageSettingVersionQuery.getPageSettingsByAppIdAndAppVersionId(appId, appVersionId);
    }

    public List<UltPage> getLatestVersionPages(Long appId) {
        return this.pageVersionQuery.getLatestVersionPages(appId);
    }

    public List<UltForm> getLatestVersionForms(Long appId) {
        return this.formVersionQuery.getLatestVersionForms(appId);
    }

    public List<FlowSetting> getLatestVersionFlowSettings(Long appId) {
        return this.flowSettingVersionQuery.getLatestVersionFlowSettings(appId);
    }

    public List<UltPageSetting> getLatestVersionPageSettings(Long appId) {
        return this.pageSettingVersionQuery.getLatestVersionPageSettings(appId);
    }
}

