/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ChangeFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageSettingRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageSettingService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageSettingVersionQuery {
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IUltPageSettingService ultPageSettingService;
    @Autowired
    private UltPageSettingRepository ultPageSettingRepository;

    public List<UltPageSetting> getLatestVersionPageSettings(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), MetadataType.PAGE_SETTING);
            return this.getPageSettingsBatch(appId, versionChanges, true);
        }
        return this.getLatestVersionPageSettingsByUnPublishPageSettings(appId);
    }

    public List<UltPageSetting> getLatestVersionPageSettingsBatch(Long appId) {
        List<Object> versionChanges;
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), MetadataType.PAGE_SETTING);
        } else {
            LambdaQueryWrapper pageSettingWrapper = this.ultPageSettingRepository.getPageSettingsWrapper(appId).select(new SFunction[]{UltPageSetting::getId, UltPageSetting::getVersion});
            versionChanges = this.ultPageSettingService.list((Wrapper)pageSettingWrapper).stream().map(o -> new AppVersionChange().setResourceId(o.getId()).setResourceVersion(o.getVersion())).collect(Collectors.toList());
        }
        return this.getPageSettingsBatch(appId, versionChanges, true);
    }

    public List<UltPageSetting> getLatestVersionPageSettingsByUnPublishPageSettings(Long appId) {
        List ultPageSettings = this.ultPageSettingRepository.getPageSettings(appId);
        if (ultPageSettings.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList pUltPageSettings = Lists.newArrayList();
        ultPageSettings.forEach(ultPageSetting -> {
            UltPageSetting pUltPageSetting = (UltPageSetting)this.ultPageSettingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPageSetting::getAppId, (Object)appId)).eq(UltPageSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(UltPageSetting::getPublishRefPageId, (Object)ultPageSetting.getId())).eq(UltPageSetting::getVersion, (Object)ultPageSetting.getVersion())).eq(UltPageSetting::getDeleteFlag, (Object)"1"), false);
            if (pUltPageSetting != null) {
                pUltPageSettings.add(pUltPageSetting);
            }
        });
        return pUltPageSettings;
    }

    public List<UltPageSetting> getPageSettings(Long appId, String appVersion) {
        return this.getPageSettingsBatch(appId, appVersion);
    }

    public List<UltPageSetting> getPageSettingsBatch(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE_SETTING);
        return this.getPageSettingsBatch(appId, versionChanges, true);
    }

    public List<UltPageSetting> getPageSettingsBatch(Long appId, List<AppVersionChange> versionChanges, boolean includeTenant) {
        Map<Integer, List<AppVersionChange>> batches = versionChanges.stream().collect(Collectors.groupingBy(i -> versionChanges.indexOf(i) / 10));
        return batches.values().stream().map(l -> this.getPageSettings(appId, (List<AppVersionChange>)l, includeTenant)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<UltPageSetting> getPageSettings(Long appId, Long envId) {
        AppEnv appEnv = this.appEnvRepository.getAppEnv(appId.longValue(), envId.longValue()).orElse(null);
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Lists.newArrayList();
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appEnv.getAppVersionId(), MetadataType.PAGE_SETTING);
        return this.getPageSettingsBatch(appId, versionChanges, true);
    }

    public List<UltPageSetting> getPageSettingsByAppIdAndAppVersionId(Long appId, Long appVersionId) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.PAGE_SETTING);
        return this.getPageSettingsBatch(appId, versionChanges, true);
    }

    public List<UltPageSetting> getPageSettings(Long appId, String appVersion, boolean includeTenant) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE_SETTING);
        return this.getPageSettingsBatch(appId, versionChanges, includeTenant);
    }

    public List<UltPageSetting> getPageSettings(Long appId, String appVersion, boolean includeTenant, boolean isOnlyChanged) {
        List<Object> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE_SETTING);
        versionChanges = versionChanges.stream().filter(o -> !isOnlyChanged || ChangeFlag.CHANGED.code().equals(o.getChangeFlag())).collect(Collectors.toList());
        return isOnlyChanged ? this.getPageSettings(appId, versionChanges, includeTenant) : this.getPageSettingsBatch(appId, versionChanges, includeTenant);
    }

    public List<UltPageSetting> getPageSettings(LambdaQueryWrapper<UltPageSetting> wrapper) {
        return this.getPageSettings(wrapper, true);
    }

    public List<UltPageSetting> getPageSettingsWithoutSetting(Long appId, String appVersion) {
        LambdaQueryWrapper<UltPageSetting> wrapper = this.getPageSettingsWrapper(appId, appVersion);
        wrapper.select(UltPageSetting.class, field -> !field.getColumn().equals("setting"));
        return this.getPageSettings(wrapper);
    }

    public List<UltPageSetting> getPageSettings(LambdaQueryWrapper<UltPageSetting> wrapper, boolean includeTenant) {
        if (wrapper.isEmptyOfWhere()) {
            return Lists.newArrayList();
        }
        List vUltPageSettings = this.ultPageSettingService.list(wrapper);
        return includeTenant ? vUltPageSettings : vUltPageSettings.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
    }

    public LambdaQueryWrapper<UltPageSetting> getPageSettingsWrapper(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE_SETTING);
        return this.getPageSettingsWrapper(appId, versionChanges);
    }

    public LambdaQueryWrapper<UltPageSetting> getPageSettingsWrapper(Long appId, List<AppVersionChange> versionChanges) {
        if (versionChanges.isEmpty()) {
            return Wrappers.lambdaQuery();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPageSetting::getAppId, (Object)appId)).eq(UltPageSetting::getDeleteFlag, (Object)"1")).eq(UltPageSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        wrapper.and(w -> versionChanges.forEach(pageChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltPageSetting::getPublishRefPageId, (Object)pageChange.getResourceId())).eq(UltPageSetting::getVersion, (Object)pageChange.getResourceVersion());
            });
        }));
        return wrapper;
    }

    private List<UltPageSetting> getPageSettings(Long appId, List<AppVersionChange> versionChanges, boolean includeTenant) {
        LambdaQueryWrapper<UltPageSetting> wrapper = this.getPageSettingsWrapper(appId, versionChanges);
        return this.getPageSettings(wrapper, includeTenant);
    }

    public List<UltPageSetting> getChangedPageSettingsInVersion(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE_SETTING).stream().filter(o -> null != o.getResourceId() && ChangeFlag.CHANGED.code().equals(o.getChangeFlag())).collect(Collectors.toList());
        return this.getPageSettingsBatch(appId, versionChanges, true);
    }

    public UltPageSetting getPageSettingByUIdAndVersionWithValidate(Long appId, Long uID, String pageSettingVersion) {
        UltPageSetting vUltPageSetting = (UltPageSetting)this.ultPageSettingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPageSetting::getAppId, (Object)appId)).eq(UltPageSetting::getPublishRefPageId, (Object)uID)).eq(UltPageSetting::getVersion, (Object)pageSettingVersion)).eq(UltPageSetting::getDeleteFlag, (Object)"1"), false);
        if (null == vUltPageSetting) {
            throw new RuntimeException(String.format("\u6839\u636e\u65b0\u89c6\u56feUID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, pageSettingVersion));
        }
        return vUltPageSetting;
    }

    public List<UltPageSetting> getTenantPageSettings(Long appId, Long vPageSettingId) {
        return this.ultPageSettingService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPageSetting::getAppId, (Object)appId)).eq(UltPageSetting::getRefPageId, (Object)vPageSettingId)).eq(UltPageSetting::getDeleteFlag, (Object)"1"));
    }
}

