/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.ChangeFlag;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppVersionChangeRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageVersionQuery {
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IUltPageService ultPageService;
    @Autowired
    private AppVersionChangeRepository appVersionChangeRepository;
    @Autowired
    private UltPageRepository ultPageRepository;

    public LambdaQueryWrapper<UltPage> getLatestVersionPagesWrapper(Long appId) {
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), MetadataType.PAGE);
            return this.getPagesWrapper(appId, versionChanges);
        }
        return this.getLatestVersionPagesWrapperWhenNoAppVersion(appId);
    }

    public List<UltPage> getLatestVersionPages(Long appId) {
        LambdaQueryWrapper<UltPage> pageWrapper = this.getLatestVersionPagesWrapper(appId);
        return pageWrapper.isEmptyOfWhere() ? Lists.newArrayList() : this.ultPageService.list(pageWrapper);
    }

    public List<UltPage> getLatestVersionPagesBatch(Long appId) {
        List<Object> versionChanges;
        Optional<AppVersion> appVersionOptl = this.appVersionQuery.getLatestMainVersion(appId);
        if (appVersionOptl.isPresent()) {
            versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionOptl.get().getId(), MetadataType.PAGE);
        } else {
            LambdaQueryWrapper pageWrapper = this.ultPageRepository.getPagesWrapper(appId).select(new SFunction[]{UltPage::getId, UltPage::getVersion});
            versionChanges = this.ultPageService.list((Wrapper)pageWrapper).stream().map(o -> new AppVersionChange().setResourceId(o.getId()).setResourceVersion(o.getVersion())).collect(Collectors.toList());
        }
        return this.getPagesBatch(appId, versionChanges, true);
    }

    public UltPage getLatestVersionPage(Long appId, Long pageUID) {
        AppVersion appVersion = this.appVersionQuery.getLatestMainVersionWithValidate(appId);
        AppVersionChange appVersionChange = this.appVersionChangeRepository.getAppVersionChangeWithValidate(appVersion.getId(), pageUID);
        return this.getPageByUIdAndVersionWithValidate(appId, pageUID, appVersionChange.getResourceVersion());
    }

    public List<UltPage> getPages(Long appId, String appVersion) {
        return this.getPagesBatch(appId, appVersion);
    }

    public List<UltPage> getPagesBatch(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE);
        return this.getPagesBatch(appId, versionChanges, true);
    }

    public List<UltPage> getPagesBatch(Long appId, List<AppVersionChange> versionChanges, boolean includeTenant) {
        Map<Integer, List<AppVersionChange>> batches = versionChanges.stream().collect(Collectors.groupingBy(i -> versionChanges.indexOf(i) / 10));
        return batches.values().stream().map(l -> this.getPages(appId, (List<AppVersionChange>)l, includeTenant)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<UltPage> getPages(Long appId, String appVersion, boolean includeTenant) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE);
        return this.getPagesBatch(appId, versionChanges, includeTenant);
    }

    public List<UltPage> getPages(Long appId, String appVersion, boolean includeTenant, boolean isOnlyChanged) {
        List<Object> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE);
        versionChanges = versionChanges.stream().filter(o -> !isOnlyChanged || ChangeFlag.CHANGED.code().equals(o.getChangeFlag())).collect(Collectors.toList());
        return isOnlyChanged ? this.getPages(appId, versionChanges, includeTenant) : this.getPagesBatch(appId, versionChanges, includeTenant);
    }

    public List<UltPage> getPages(LambdaQueryWrapper<UltPage> wrapper) {
        return this.getPages(wrapper, true);
    }

    public List<UltPage> getPages(LambdaQueryWrapper<UltPage> wrapper, boolean includeTenant) {
        ArrayList vUltPages = wrapper.isEmptyOfWhere() ? Lists.newArrayList() : this.ultPageService.list(wrapper);
        return includeTenant ? vUltPages : vUltPages.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
    }

    public LambdaQueryWrapper<UltPage> getPagesWrapper(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE);
        return this.getPagesWrapper(appId, versionChanges);
    }

    public LambdaQueryWrapper<UltPage> getPagesWrapper(Long appId, Long appVersionId) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.PAGE);
        return this.getPagesWrapper(appId, versionChanges);
    }

    public LambdaQueryWrapper<UltPage> getPagesWrapper(Long appId, List<AppVersionChange> versionChanges) {
        List finalPageChanges = versionChanges.stream().filter(chg -> null != chg.getResourceId()).collect(Collectors.toList());
        if (finalPageChanges.isEmpty()) {
            return Wrappers.lambdaQuery();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getDeleteFlag, (Object)"1")).eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.PUBLISHED.code());
        wrapper.and(w -> finalPageChanges.forEach(pageChange -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.or(w1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w1.eq(UltPage::getPublishRefPageId, (Object)pageChange.getResourceId())).eq(UltPage::getVersion, (Object)pageChange.getResourceVersion());
            });
        }));
        return wrapper;
    }

    public List<UltPage> getLatestVersionPagesWhenNoAppVersion(Long appId) {
        LambdaQueryWrapper<UltPage> pageWrapper = this.getLatestVersionPagesWrapperWhenNoAppVersion(appId);
        return pageWrapper.isEmptyOfWhere() ? Lists.newArrayList() : this.ultPageService.list(pageWrapper);
    }

    public LambdaQueryWrapper<UltPage> getLatestVersionPagesWrapperWhenNoAppVersion(Long appId) {
        LambdaQueryWrapper pageWrapper = this.ultPageRepository.getPagesWrapper(appId).select(new SFunction[]{UltPage::getId, UltPage::getVersion});
        List<AppVersionChange> versionChanges = this.ultPageService.list((Wrapper)pageWrapper).stream().map(o -> new AppVersionChange().setResourceId(o.getId()).setResourceVersion(o.getVersion())).collect(Collectors.toList());
        return this.getPagesWrapper(appId, versionChanges);
    }

    public List<UltPage> getPages(Long appId, Long envId) {
        AppEnv appEnv = this.appEnvRepository.getAppEnv(appId.longValue(), envId.longValue()).orElse(null);
        if (null == appEnv || null == appEnv.getAppVersionId()) {
            return Lists.newArrayList();
        }
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appEnv.getAppVersionId(), MetadataType.PAGE);
        return this.getPagesBatch(appId, versionChanges, true);
    }

    public List<UltPage> getPagesByAppIdAndAppVersionId(Long appId, Long appVersionId) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appVersionId, MetadataType.PAGE);
        return this.getPagesBatch(appId, versionChanges, true);
    }

    public List<UltPage> getPages(Long appId, List<AppVersionChange> versionChanges, boolean includeTenant) {
        LambdaQueryWrapper<UltPage> wrapper = this.getPagesWrapper(appId, versionChanges);
        return this.getPages(wrapper, includeTenant);
    }

    public List<UltPage> getChangedPagesInVersion(Long appId, String appVersion) {
        List<AppVersionChange> versionChanges = this.appVersionQuery.getAppVersionChanges(appId, appVersion, MetadataType.PAGE).stream().filter(o -> null != o.getResourceId() && ChangeFlag.CHANGED.code().equals(o.getChangeFlag())).collect(Collectors.toList());
        return this.getPagesBatch(appId, versionChanges, true);
    }

    public UltPage getPageByUIdAndVersionWithValidate(Long appId, Long uID, String pageVersion) {
        UltPage vUltPage = (UltPage)this.ultPageService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getAppId, (Object)appId)).eq(UltPage::getPublishRefPageId, (Object)uID)).eq(UltPage::getVersion, (Object)pageVersion)).eq(UltPage::getDeleteFlag, (Object)"1"), false);
        if (null == vUltPage) {
            throw new RuntimeException(String.format("\u6839\u636e\u9875\u9762\u89c6\u56feUID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, pageVersion));
        }
        return vUltPage;
    }

    public List<UltPage> getTenantPages(Long appId, Long vPageId) {
        return this.ultPageService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getDeleteFlag, (Object)"1")).eq(UltPage::getRefPageId, (Object)vPageId)).eq(UltPage::getAppId, (Object)appId));
    }
}

