/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleVersionQuery {
    @Autowired
    private IAppVersionService appVersionService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private ISueRuleService sueRuleService;

    public List<SueRule> getRules(Long appId, String appVersion) {
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appId, appVersion, MetadataType.RULE).orElse(null);
        if (null == versionChange) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getVersion, (Object)versionChange.getResourceVersion())).eq(SueRule::getDeleteFlag, (Object)"1")).eq(SueRule::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        return this.sueRuleService.list((Wrapper)wrapper);
    }

    public List<SueRule> getRules(Long appVersionId) {
        AppVersion appVersion = (AppVersion)this.appVersionService.getById((Serializable)appVersionId);
        if (null == appVersion) {
            return Lists.newArrayList();
        }
        return this.getRules(appVersion.getAppId(), appVersion.getVersion());
    }

    public SueRule getRuleByUIDAndVersionWithValidate(Long appId, Long uID, String ruleVersion) {
        SueRule vRule = (SueRule)this.sueRuleService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SueRule::getAppId, (Object)appId)).eq(SueRule::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(SueRule::getUniqueId, (Object)uID)).eq(SueRule::getVersion, (Object)ruleVersion), false);
        if (null == vRule) {
            throw new ValidateException(String.format("\u6839\u636e\u89c4\u5219 UID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, ruleVersion));
        }
        return vRule;
    }
}

