/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.query;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISdkSettingService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SdkSettingVersionQuery {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private ISdkSettingService sdkSettingService;

    public List<SdkSetting> getSdkSettings(Long appId, String appVersion) {
        AppVersionChange versionChange = this.appVersionQuery.getAppVersionChange(appId, appVersion, MetadataType.SDK_SETTING).orElse(null);
        if (null == versionChange) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SdkSetting::getAppId, (Object)appId)).eq(SdkSetting::getVersion, (Object)versionChange.getResourceVersion())).eq(SdkSetting::getDeleteFlag, (Object)"1")).eq(SdkSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code());
        return this.sdkSettingService.list((Wrapper)wrapper);
    }

    public SdkSetting getSdkSettingByUIDAndVersionWithValidate(Long appId, Long uID, String sdkSettingVersion) {
        SdkSetting vSdkSetting = (SdkSetting)this.sdkSettingService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SdkSetting::getAppId, (Object)appId)).eq(SdkSetting::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(SdkSetting::getUniqueId, (Object)uID)).eq(SdkSetting::getVersion, (Object)sdkSettingVersion), false);
        if (null == vSdkSetting) {
            throw new ValidateException(String.format("\u6839\u636eSDK\u914d\u7f6e UID %s \u548c\u7248\u672c\u53f7 %s \u67e5\u8be2\u4e0d\u5230\u6570\u636e", uID, sdkSettingVersion));
        }
        return vSdkSetting;
    }
}

