/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffAggregator;
import com.xforceplus.ultraman.bocp.metadata.version.diff.query.BoVersionDiffQuery;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppDiffService;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBo;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersionChange;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppDiffServiceImpl
implements IAppDiffService {
    private static final Logger log = LoggerFactory.getLogger(AppDiffServiceImpl.class);
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private VersionDiffAggregator versionDiffAggregator;
    @Autowired
    private BoVersionDiffQuery boVersionDiffQuery;

    @Override
    public ServiceResponse getAppSetting(Long appId, String appVersion) {
        Optional<AppVersionChange> versionChangeOptl = this.appVersionQuery.getAppVersionChange(appId, appVersion, MetadataType.BO);
        if (!versionChangeOptl.isPresent()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u7248\u672c\u4fe1\u606f");
        }
        Optional moduleOptional = this.defaultModuleService.getPublishedModuleByAppId(appId.longValue(), versionChangeOptl.get().getResourceVersion());
        if (!moduleOptional.isPresent()) {
            return ServiceResponse.fail((String)String.format("\u67e5\u8be2\u4e0d\u5230\u5e94\u7528{} \u9ed8\u8ba4\u6a21\u5757", appId));
        }
        Map<String, VersionBo> versionBos = this.boVersionDiffQuery.getVersionBos(((Module)moduleOptional.get()).getId(), PublishFlag.fromCode((String)((Module)moduleOptional.get()).getPublishFlag()));
        return ServiceResponse.success((String)"", (Object)new VersionContent().setBos((HashMap)versionBos));
    }

    @Override
    public ServiceResponse getLatestVersionDiff(Long appId) {
        log.debug("\u5e94\u7528 {} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 start", (Object)appId);
        AppVersion appVersion = this.appVersionQuery.getLatestMainVersion(appId).orElse(null);
        VersionContent versionContent = this.versionDiffAggregator.executeDiff(appId, appVersion);
        log.debug("\u5e94\u7528 {} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 end", (Object)appId);
        return ServiceResponse.success((String)"", (Object)versionContent);
    }

    @Override
    public ServiceResponse getLatestVersionDiff(Long appId, String resourceType, String retDataType) {
        if (MetadataType.fromCode((String)resourceType) == null) {
            return ServiceResponse.fail((String)"\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        log.debug("\u5e94\u7528 {} \u8d44\u6e90 {} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 start", (Object)appId, (Object)resourceType);
        if (null == MetadataType.fromCode((String)resourceType)) {
            return ServiceResponse.fail((String)String.format("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s\u5176\u4e2d\u4e4b\u4e00", Arrays.stream(MetadataType.values()).map(Enum::name).collect(Collectors.joining(","))));
        }
        AppVersion appVersion = this.appVersionQuery.getLatestMainVersion(appId).orElse(null);
        VersionContent versionContent = this.versionDiffAggregator.executeDiff(appId, appVersion, MetadataType.fromCode((String)resourceType), retDataType);
        log.debug("\u5e94\u7528 {} \u8d44\u6e90 {} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 end", (Object)appId, (Object)resourceType);
        return ServiceResponse.success((String)"", (Object)versionContent);
    }

    @Override
    public ServiceResponse getVersionDiff(Long appId, Long appVersionId) {
        AppVersion appVersion = this.appVersionQuery.getAppVersionWithValidate(appId, appVersionId);
        VersionContent versionContent = this.versionDiffAggregator.executeDiff(appId, appVersion);
        log.debug("{} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 end", (Object)appId);
        return ServiceResponse.success((String)"", (Object)versionContent);
    }

    @Override
    public ServiceResponse getVersionDiff(Long appId, Long appVersionId, String resourceType, String retDataType) {
        AppVersion appVersion = this.appVersionQuery.getAppVersionWithValidate(appId, appVersionId);
        if (null == MetadataType.fromCode((String)resourceType)) {
            return ServiceResponse.fail((String)String.format("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s\u5176\u4e2d\u4e4b\u4e00", Arrays.stream(MetadataType.values()).map(Enum::name).collect(Collectors.joining(","))));
        }
        VersionContent versionContent = this.versionDiffAggregator.executeDiff(appId, appVersion, MetadataType.fromCode((String)resourceType), retDataType);
        log.debug("{} \u83b7\u53d6\u5dee\u5f02\u5bf9\u6bd4 end", (Object)appVersion.getAppId());
        return ServiceResponse.success((String)"", (Object)versionContent);
    }

    @Override
    public ServiceResponse getVersionDiffWithPreviousVersion(Long appId, Long comparedVersionId) {
        AppVersion appVersion = this.appVersionQuery.getAppVersionWithValidate(appId, comparedVersionId);
        Long previousVersionId = null;
        if (AppVersionType.PATCH.code().equals(appVersion.getVersionType())) {
            previousVersionId = appVersion.getParentVersionId();
        } else {
            Optional<AppVersion> previousAppVersionOptional = this.appVersionQuery.getPreviousMainVersion(appId, comparedVersionId);
            if (previousAppVersionOptional.isPresent()) {
                previousVersionId = previousAppVersionOptional.get().getId();
            }
        }
        return this.versionDiffAggregator.executeDiff(appId, previousVersionId, comparedVersionId);
    }

    @Override
    public ServiceResponse getVersionDiffWithPreviousVersion(Long appId, Long comparedVersionId, String resourceType, String retDataType) {
        if (null == MetadataType.fromCode((String)resourceType)) {
            return ServiceResponse.fail((String)String.format("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s\u5176\u4e2d\u4e4b\u4e00", Arrays.stream(MetadataType.values()).map(Enum::name).collect(Collectors.joining(","))));
        }
        AppVersion appVersion = this.appVersionQuery.getAppVersionWithValidate(appId, comparedVersionId);
        Long previousVersionId = null;
        if (AppVersionType.PATCH.code().equals(appVersion.getVersionType())) {
            previousVersionId = appVersion.getParentVersionId();
        } else {
            Optional<AppVersion> previousAppVersionOptional = this.appVersionQuery.getPreviousMainVersion(appId, comparedVersionId);
            if (previousAppVersionOptional.isPresent()) {
                previousVersionId = previousAppVersionOptional.get().getId();
            }
        }
        return this.versionDiffAggregator.executeDiff(appId, previousVersionId, comparedVersionId, MetadataType.fromCode((String)resourceType), retDataType);
    }

    @Override
    public ServiceResponse getVersionDiff(Long appId, Long leftVersionId, Long rightVersionId) {
        return this.versionDiffAggregator.executeDiff(appId, leftVersionId, rightVersionId);
    }

    @Override
    public ServiceResponse getVersionDiff(Long appId, Long leftVersionId, Long rightVersionId, String resourceType, String retDataType) {
        if (null == MetadataType.fromCode((String)resourceType)) {
            return ServiceResponse.fail((String)String.format("\u5dee\u5f02\u6bd4\u5bf9\u7684\u8d44\u6e90\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s\u5176\u4e2d\u4e4b\u4e00", Arrays.stream(MetadataType.values()).map(Enum::name).collect(Collectors.joining(","))));
        }
        return this.versionDiffAggregator.executeDiff(appId, leftVersionId, rightVersionId, MetadataType.fromCode((String)resourceType), retDataType);
    }
}

