/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionChangeService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldDomainAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoRelationshipService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipAutoAudit;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipOperationLog;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldDomainAttributeRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRelationshipRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageSettingRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltFormService;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageService;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageSettingService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppRefVersionChangeServiceImpl
implements IAppRefVersionChangeService {
    private static final Logger log = LoggerFactory.getLogger(AppRefVersionChangeServiceImpl.class);
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private BoFieldRepository boFieldRepository;
    @Autowired
    private BoFieldDomainAttributeRepository boFieldDomainAttributeRepository;
    @Autowired
    private BoRelationshipRepository boRelationshipRepository;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private UltPageRepository ultPageRepository;
    @Autowired
    private UltFormRepository ultFormRepository;
    @Autowired
    private FlowSettingRepository flowSettingRepository;
    @Autowired
    private UltPageSettingRepository ultPageSettingRepository;
    @Autowired
    private DataRuleRepository dataRuleRepository;
    @Autowired
    private IBoService boService;
    @Autowired
    private IBoRelationshipService boRelationshipService;
    @Autowired
    private IBoDataRuleService boDataRuleService;
    @Autowired
    private IBoFieldDomainAttributeService boFieldDomainAttributeService;
    @Autowired
    private IDictService dictService;
    @Autowired
    private IUltPageService ultPageService;
    @Autowired
    private IUltFormService ultFormService;
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private IUltPageSettingService ultPageSettingService;

    @Override
    @SkipOperationLog
    @SkipAutoAudit
    @Transactional(rollbackFor={Exception.class})
    public void updateRefAppVersionContent(Long tenantAppId, Long refAppId, String originRefAppVersion, String newRefAppVersion) {
        List tenantBos = this.boRepository.getBos(tenantAppId.longValue());
        List tenantDicts = this.dictRepository.getDicts(tenantAppId);
        List tenantPages = this.ultPageRepository.getPages(tenantAppId);
        List tenantForms = this.ultFormRepository.getForms(tenantAppId);
        List tenantFlowSettings = this.flowSettingRepository.getFlowSettingsWithoutFrontSetting(tenantAppId);
        List tenantPageSettings = this.ultPageSettingRepository.getPageSettings(tenantAppId);
        List<Bo> originStandardVersionBos = this.metadataVersionQuery.getMetadataByType(refAppId, originRefAppVersion, Bo.class);
        List<Dict> originStandardVersionDicts = this.metadataVersionQuery.getMetadataByType(refAppId, originRefAppVersion, Dict.class);
        List<UltPage> originStandardVersionPages = this.metadataVersionQuery.getMetadataByType(refAppId, originRefAppVersion, UltPage.class);
        List<UltForm> originStandardVersionForms = this.metadataVersionQuery.getMetadataByType(refAppId, originRefAppVersion, UltForm.class);
        List<FlowSetting> originStandardVersionFlowSettings = this.metadataVersionQuery.getMetadataByType(refAppId, originRefAppVersion, FlowSetting.class);
        List<UltPageSetting> originStandardVersionPageSettings = this.metadataVersionQuery.getMetadataByType(refAppId, originRefAppVersion, UltPageSetting.class);
        List<Bo> newStandardVersionBos = this.metadataVersionQuery.getMetadataByType(refAppId, newRefAppVersion, Bo.class);
        List<Dict> newStandardVersionDicts = this.metadataVersionQuery.getMetadataByType(refAppId, newRefAppVersion, Dict.class);
        List<UltPage> newStandardVersionPages = this.metadataVersionQuery.getMetadataByType(refAppId, newRefAppVersion, UltPage.class);
        List<UltForm> newStandardVersionForms = this.metadataVersionQuery.getMetadataByType(refAppId, newRefAppVersion, UltForm.class);
        List<FlowSetting> newStandardVersionFlowSettings = this.metadataVersionQuery.getMetadataByType(refAppId, newRefAppVersion, FlowSetting.class);
        List<UltPageSetting> newStandardVersionPageSettings = this.metadataVersionQuery.getMetadataByType(refAppId, newRefAppVersion, UltPageSetting.class);
        this.updateIdsInBo(tenantBos, originStandardVersionBos, newStandardVersionBos);
        this.updateIdsInDict(tenantDicts, originStandardVersionDicts, newStandardVersionDicts);
        this.updateIdsInUltPage(tenantPages, originStandardVersionPages, newStandardVersionPages);
        this.updateIdsInUltForm(tenantForms, originStandardVersionForms, newStandardVersionForms);
        this.updateIdsInFlowSetting(tenantFlowSettings, originStandardVersionFlowSettings, newStandardVersionFlowSettings);
        this.updateIdsInUltPageSetting(tenantPageSettings, originStandardVersionPageSettings, newStandardVersionPageSettings);
    }

    private void updateIdsInBo(List<Bo> tenantItems, List<Bo> originStandardVersionItems, List<Bo> newStandardVersionItems) {
        Map<Long, Long> originIdMapping = originStandardVersionItems.stream().collect(Collectors.toMap(Bo::getId, Bo::getUniqueId));
        Map<Long, Long> newIdMapping = newStandardVersionItems.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        Map<Long, Long> origin2newIdMapping = this.getOrigin2newIdMapping(originIdMapping, newIdMapping);
        tenantItems.forEach(o -> {
            Optional.ofNullable(o.getParentBoId()).ifPresent(parentBoId -> {
                if (origin2newIdMapping.containsKey(parentBoId)) {
                    o.setParentBoId((Long)origin2newIdMapping.get(parentBoId));
                } else {
                    log.error(String.format("\u66f4\u65b0\u5bf9\u8c61\uff08%s\uff09\u7684\u7236\u5bf9\u8c61ID\uff08parentBoId\uff09\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), parentBoId));
                }
            });
            Optional.ofNullable(o.getRefBoId()).ifPresent(refBoId -> {
                if (origin2newIdMapping.containsKey(refBoId)) {
                    o.setRefBoId((Long)origin2newIdMapping.get(refBoId));
                } else {
                    log.error(String.format("\u66f4\u65b0\u5bf9\u8c61\uff08%s\uff09\u7684\u6807\u51c6\u5bf9\u8c61ID(refBoId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), refBoId));
                }
            });
            Optional.ofNullable(o.getSyncBoId()).ifPresent(syncBoId -> {
                if (origin2newIdMapping.containsKey(syncBoId)) {
                    o.setSyncBoId((Long)origin2newIdMapping.get(syncBoId));
                } else {
                    log.error(String.format("\u66f4\u65b0\u5bf9\u8c61\uff08%s\uff09\u7684\u540c\u6b65\u5bf9\u8c61ID(syncBoId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), syncBoId));
                }
            });
        });
        this.boService.updateBatchById(tenantItems);
        List<Long> tenantBoIds = tenantItems.stream().map(Bo::getId).collect(Collectors.toList());
        this.updateIdsInBoField(tenantBoIds, origin2newIdMapping);
        this.updateIdsInBoDataRule(tenantBoIds, origin2newIdMapping);
    }

    private void updateIdsInBoField(List<Long> tenantBoIds, Map<Long, Long> origin2newIdMapping) {
        List tenantBoFields = this.boFieldRepository.getBoFieldsByBoIds(tenantBoIds);
        Map<Long, Long> originFieldIdMapping = this.boFieldRepository.getBoFieldsByBoIds(new ArrayList<Long>(origin2newIdMapping.keySet())).stream().collect(Collectors.toMap(BoField::getId, BoField::getUniqueId));
        Map<Long, Long> newFieldIdMapping = this.boFieldRepository.getBoFieldsByBoIds(new ArrayList<Long>(origin2newIdMapping.values())).stream().collect(Collectors.toMap(BoField::getId, BoField::getUniqueId));
        Map<Long, Long> origin2newFieldIdMapping = this.getOrigin2newIdMapping(originFieldIdMapping, newFieldIdMapping);
        this.updateIdsInBoRelationship(tenantBoIds, origin2newIdMapping, origin2newFieldIdMapping);
        this.updateIdsInBoFieldDomainAttribute(tenantBoFields, origin2newIdMapping, origin2newFieldIdMapping);
    }

    private void updateIdsInBoFieldDomainAttribute(List<BoField> tenantBoFields, Map<Long, Long> origin2newIdMapping, Map<Long, Long> origin2newFieldIdMapping) {
        List<String> computeFieldTypes = Arrays.asList(FieldType.LOOKUP.code(), FieldType.AGGREGATION.code());
        List tenantComputeBoFieldIds = tenantBoFields.stream().filter(o -> computeFieldTypes.contains(o.getFieldType())).map(BoField::getId).collect(Collectors.toList());
        if (tenantComputeBoFieldIds.isEmpty()) {
            return;
        }
        Map<Long, Long> originRelationIdMapping = this.boRelationshipRepository.getBoRelationshipsByBoIds(new ArrayList<Long>(origin2newIdMapping.keySet())).stream().collect(Collectors.toMap(BoRelationship::getId, BoRelationship::getUniqueId));
        Map<Long, Long> newRelationIdMapping = this.boRelationshipRepository.getBoRelationshipsByBoIds(new ArrayList<Long>(origin2newIdMapping.values())).stream().collect(Collectors.toMap(BoRelationship::getId, BoRelationship::getUniqueId));
        Map<Long, Long> origin2newRelationIdMapping = this.getOrigin2newIdMapping(originRelationIdMapping, newRelationIdMapping);
        List tenantBoFieldDomainAttributes = this.boFieldDomainAttributeRepository.getBoFieldDomainAttributesByFieldIds(tenantComputeBoFieldIds);
        tenantBoFieldDomainAttributes.forEach(o -> {
            Optional.ofNullable(o.getLookupRelationId()).ifPresent(lookupRelationId -> {
                if (origin2newRelationIdMapping.containsKey(lookupRelationId)) {
                    o.setLookupRelationId((Long)origin2newRelationIdMapping.get(lookupRelationId));
                } else {
                    log.debug(String.format("\u66f4\u65b0\u5b57\u6bb5\u9886\u57df\u4fe1\u606f\uff08%s\uff09\u7684\u5173\u7cfbID(lookupRelationId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), lookupRelationId));
                }
            });
            Optional.ofNullable(o.getLookupBoId()).ifPresent(lookupBoId -> {
                if (origin2newIdMapping.containsKey(lookupBoId)) {
                    o.setLookupBoId((Long)origin2newIdMapping.get(lookupBoId));
                } else {
                    log.debug(String.format("\u66f4\u65b0\u5b57\u6bb5\u9886\u57df\u4fe1\u606f\uff08%s\uff09\u7684\u5bf9\u8c61ID(lookupBoId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), lookupBoId));
                }
            });
            Optional.ofNullable(o.getLookupFieldId()).ifPresent(lookupFieldId -> {
                if (origin2newFieldIdMapping.containsKey(lookupFieldId)) {
                    o.setLookupFieldId((Long)origin2newFieldIdMapping.get(lookupFieldId));
                } else {
                    log.debug(String.format("\u66f4\u65b0\u5b57\u6bb5\u9886\u57df\u4fe1\u606f\uff08%s\uff09\u7684\u5b57\u6bb5ID(lookupFieldId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), lookupFieldId));
                }
            });
            Optional.ofNullable(o.getAggregationRelationId()).ifPresent(aggregationRelationId -> {
                if (origin2newRelationIdMapping.containsKey(aggregationRelationId)) {
                    o.setAggregationRelationId((Long)origin2newRelationIdMapping.get(aggregationRelationId));
                } else {
                    log.debug(String.format("\u66f4\u65b0\u5b57\u6bb5\u9886\u57df\u4fe1\u606f\uff08%s\uff09\u7684\u5173\u7cfbID(aggregationRelationId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), aggregationRelationId));
                }
            });
            Optional.ofNullable(o.getAggregationBoId()).ifPresent(aggregationBoId -> {
                if (origin2newIdMapping.containsKey(aggregationBoId)) {
                    o.setAggregationBoId((Long)origin2newIdMapping.get(aggregationBoId));
                } else {
                    log.debug(String.format("\u66f4\u65b0\u5b57\u6bb5\u9886\u57df\u4fe1\u606f\uff08%s\uff09\u7684\u5bf9\u8c61ID(aggregationBoId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), aggregationBoId));
                }
            });
            Optional.ofNullable(o.getAggregationFieldId()).ifPresent(aggregationFieldId -> {
                if (origin2newFieldIdMapping.containsKey(aggregationFieldId)) {
                    o.setAggregationFieldId((Long)origin2newFieldIdMapping.get(aggregationFieldId));
                } else {
                    log.debug(String.format("\u66f4\u65b0\u5b57\u6bb5\u9886\u57df\u4fe1\u606f\uff08%s\uff09\u7684\u5b57\u6bb5ID(aggregationFieldId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), aggregationFieldId));
                }
            });
        });
        this.boFieldDomainAttributeService.updateBatchById((Collection)tenantBoFieldDomainAttributes);
    }

    private void updateIdsInBoRelationship(List<Long> tenantBoIds, Map<Long, Long> origin2newIdMapping, Map<Long, Long> origin2newFieldIdMapping) {
        List tenantBoRelationships = this.boRelationshipRepository.getBoRelationshipsByBoIds(tenantBoIds);
        tenantBoRelationships.forEach(o -> {
            Optional.ofNullable(o.getJoinBoId()).ifPresent(joinBoId -> {
                if (origin2newIdMapping.containsKey(joinBoId)) {
                    o.setJoinBoId((Long)origin2newIdMapping.get(joinBoId));
                } else {
                    log.error(String.format("\u66f4\u65b0\u5173\u7cfb\uff08%s\uff09\u7684\u5173\u8054\u6807\u51c6\u5bf9\u8c61ID(joinBoId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), joinBoId));
                }
            });
            Optional.ofNullable(o.getJoinField()).ifPresent(joinFieldId -> {
                if (origin2newFieldIdMapping.containsKey(joinFieldId)) {
                    o.setJoinField((Long)origin2newFieldIdMapping.get(joinFieldId));
                } else {
                    log.debug(String.format("\u66f4\u65b0\u5173\u7cfb\uff08%s\uff09\u7684\u5173\u8054\u6807\u51c6\u5b57\u6bb5ID(joinFieldId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), joinFieldId));
                }
            });
        });
        this.boRelationshipService.updateBatchById((Collection)tenantBoRelationships);
    }

    private void updateIdsInBoDataRule(List<Long> tenantBoIds, Map<Long, Long> origin2newIdMapping) {
        List tenantBoDataRules = this.dataRuleRepository.getDefaultDataRulesByBoIds(tenantBoIds);
        tenantBoDataRules.forEach(o -> Optional.ofNullable(o.getRefBoId()).ifPresent(refId -> {
            if (origin2newIdMapping.containsKey(refId)) {
                o.setRefBoId((Long)origin2newIdMapping.get(refId));
            } else {
                log.error(String.format("\u66f4\u65b0\u6570\u636e\u6743\u9650\uff08%s\uff09\u7684\u6807\u51c6\u5bf9\u8c61ID(refBoId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), refId));
            }
        }));
        this.boDataRuleService.updateBatchById((Collection)tenantBoDataRules);
    }

    private void updateIdsInDict(List<Dict> tenantItems, List<Dict> originStandardVersionItems, List<Dict> newStandardVersionItems) {
        Map<Long, Long> originIdMapping = originStandardVersionItems.stream().collect(Collectors.toMap(Dict::getId, Dict::getUniqueId));
        Map<Long, Long> newIdMapping = newStandardVersionItems.stream().collect(Collectors.toMap(Dict::getUniqueId, Dict::getId));
        tenantItems.forEach(o -> Optional.ofNullable(o.getRefDictId()).ifPresent(refId -> {
            Long uniqueId = (Long)originIdMapping.get(o.getRefDictId());
            if (newIdMapping.containsKey(uniqueId)) {
                o.setRefDictId((Long)newIdMapping.get(uniqueId));
            } else {
                log.error(String.format("\u66f4\u65b0\u5b57\u5178\uff08%s\uff09\u7684\u6807\u51c6\u5b57\u5178ID(refDictId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), refId));
            }
        }));
        this.dictService.updateBatchById(tenantItems);
    }

    private void updateIdsInUltPage(List<UltPage> tenantItems, List<UltPage> originStandardVersionItems, List<UltPage> newStandardVersionItems) {
        Map<Long, Long> originIdMapping = originStandardVersionItems.stream().collect(Collectors.toMap(UltPage::getId, UltPage::getUniqueId));
        Map<Long, Long> newIdMapping = newStandardVersionItems.stream().collect(Collectors.toMap(UltPage::getUniqueId, UltPage::getId));
        tenantItems.forEach(o -> Optional.ofNullable(o.getRefPageId()).ifPresent(refId -> {
            Long uniqueId = (Long)originIdMapping.get(o.getRefPageId());
            if (newIdMapping.containsKey(uniqueId)) {
                o.setRefPageId((Long)newIdMapping.get(uniqueId));
            } else {
                log.error(String.format("\u66f4\u65b0\u9875\u9762\uff08%s\uff09\u7684\u6807\u51c6\u9875\u9762ID(refPageId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), refId));
            }
        }));
        this.ultPageService.updateBatchById(tenantItems, 10);
    }

    private void updateIdsInUltForm(List<UltForm> tenantItems, List<UltForm> originStandardVersionItems, List<UltForm> newStandardVersionItems) {
        Map<Long, Long> originIdMapping = originStandardVersionItems.stream().collect(Collectors.toMap(UltForm::getId, UltForm::getUniqueId));
        Map<Long, Long> newIdMapping = newStandardVersionItems.stream().collect(Collectors.toMap(UltForm::getUniqueId, UltForm::getId));
        tenantItems.forEach(o -> Optional.ofNullable(o.getRefFormId()).ifPresent(refId -> {
            Long uniqueId = (Long)originIdMapping.get(o.getRefFormId());
            if (newIdMapping.containsKey(uniqueId)) {
                o.setRefFormId((Long)newIdMapping.get(uniqueId));
            } else {
                log.error(String.format("\u66f4\u65b0\u8868\u5355\uff08%s\uff09\u7684\u6807\u51c6\u8868\u5355ID(refFormId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), refId));
            }
        }));
        this.ultFormService.updateBatchById(tenantItems, 10);
    }

    private void updateIdsInFlowSetting(List<FlowSetting> tenantItems, List<FlowSetting> originStandardVersionItems, List<FlowSetting> newStandardVersionItems) {
        Map<Long, Long> originIdMapping = originStandardVersionItems.stream().collect(Collectors.toMap(FlowSetting::getId, FlowSetting::getPublishFlowId));
        Map<Long, Long> newIdMapping = newStandardVersionItems.stream().collect(Collectors.toMap(FlowSetting::getPublishFlowId, FlowSetting::getId));
        tenantItems.forEach(o -> Optional.ofNullable(o.getRefFlowId()).ifPresent(refId -> {
            Long uniqueId = (Long)originIdMapping.get(o.getRefFlowId());
            if (newIdMapping.containsKey(uniqueId)) {
                o.setRefFlowId((Long)newIdMapping.get(uniqueId));
            } else {
                log.error(String.format("\u66f4\u65b0\u6d41\uff08%s\uff09\u7684\u6807\u51c6\u6d41ID(refFlowId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), refId));
            }
        }));
        this.flowSettingService.updateBatchById(tenantItems, 10);
    }

    private void updateIdsInUltPageSetting(List<UltPageSetting> tenantItems, List<UltPageSetting> originStandardVersionItems, List<UltPageSetting> newStandardVersionItems) {
        Map<Long, Long> originIdMapping = originStandardVersionItems.stream().collect(Collectors.toMap(UltPageSetting::getId, UltPageSetting::getUniqueId));
        Map<Long, Long> newIdMapping = newStandardVersionItems.stream().collect(Collectors.toMap(UltPageSetting::getUniqueId, UltPageSetting::getId));
        tenantItems.forEach(o -> Optional.ofNullable(o.getRefPageId()).ifPresent(refId -> {
            Long uniqueId = (Long)originIdMapping.get(o.getRefPageId());
            if (newIdMapping.containsKey(uniqueId)) {
                o.setRefPageId((Long)newIdMapping.get(uniqueId));
            } else {
                log.error(String.format("\u66f4\u65b0\u65b0\u9875\u9762\uff08%s\uff09\u7684\u6807\u51c6\u9875\u9762ID(refPageId)\u5931\u8d25\uff0c\u6839\u636e\u539fID\uff08%s\uff09\u6ca1\u6709\u627e\u5230\u5bf9\u5e94ID", o.getId(), refId));
            }
        }));
        this.ultPageSettingService.updateBatchById(tenantItems, 10);
    }

    private Map<Long, Long> getOrigin2newIdMapping(Map<Long, Long> originIdMapping, Map<Long, Long> newIdMapping) {
        return originIdMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> newIdMapping.getOrDefault(entry.getValue(), null))).entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

