/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppEventVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.BoVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.DictVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FlowSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FormVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.SdkSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionMetadataService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRelationshipRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@SkipDataAuth
@Service
public class AppRefVersionMetadataServiceImpl
implements IAppRefVersionMetadataService {
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private BoVersionQuery boVersionQuery;
    @Autowired
    private DictVersionQuery dictVersionQuery;
    @Autowired
    private PageVersionQuery pageVersionQuery;
    @Autowired
    private FormVersionQuery formVersionQuery;
    @Autowired
    private FlowSettingVersionQuery flowSettingVersionQuery;
    @Autowired
    private AppEventVersionQuery appEventVersionQuery;
    @Autowired
    private SdkSettingVersionQuery sdkSettingVersionQuery;
    @Autowired
    private BoFieldRepository boFieldRepository;
    @Autowired
    private BoRelationshipRepository boRelationshipRepository;
    @Autowired
    private PageSettingVersionQuery pageSettingVersionQuery;

    @Override
    public Map<Long, Long> getIdMapping(Long appId, MetadataType metadataType) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        if (MetadataType.BO.equals((Object)metadataType)) {
            List<Bo> stdVersionBos = this.boVersionQuery.getBos(appRef.getRefAppId(), appRef.getRefAppVersion());
            return stdVersionBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        }
        if (MetadataType.DICT.equals((Object)metadataType)) {
            List<Dict> stdVersionDicts = this.dictVersionQuery.getDicts(appRef.getRefAppId(), appRef.getRefAppVersion());
            return stdVersionDicts.stream().collect(Collectors.toMap(Dict::getUniqueId, Dict::getId));
        }
        if (MetadataType.PAGE.equals((Object)metadataType)) {
            List<UltPage> stdVersionPages = this.pageVersionQuery.getPages(appRef.getRefAppId(), appRef.getRefAppVersion());
            return stdVersionPages.stream().collect(Collectors.toMap(UltPage::getUniqueId, UltPage::getId));
        }
        if (MetadataType.FORM.equals((Object)metadataType)) {
            List<UltForm> stdVersionForms = this.formVersionQuery.getForms(appRef.getRefAppId(), appRef.getRefAppVersion());
            return stdVersionForms.stream().collect(Collectors.toMap(UltForm::getUniqueId, UltForm::getId));
        }
        if (MetadataType.FLOW_SETTING.equals((Object)metadataType)) {
            List<FlowSetting> stdVersionFlows = this.flowSettingVersionQuery.getFlowSettings(appRef.getRefAppId(), appRef.getRefAppVersion());
            return stdVersionFlows.stream().collect(Collectors.toMap(FlowSetting::getPublishFlowId, FlowSetting::getId));
        }
        if (MetadataType.APP_EVENT.equals((Object)metadataType)) {
            List<AppEvent> stdVersionEvents = this.appEventVersionQuery.getAppEvents(appRef.getRefAppId(), appRef.getRefAppVersion());
            return stdVersionEvents.stream().collect(Collectors.toMap(AppEvent::getUniqueId, AppEvent::getId));
        }
        if (MetadataType.SDK_SETTING.equals((Object)metadataType)) {
            List<SdkSetting> stdVersionSdkSettings = this.sdkSettingVersionQuery.getSdkSettings(appRef.getRefAppId(), appRef.getRefAppVersion());
            return stdVersionSdkSettings.stream().collect(Collectors.toMap(SdkSetting::getUniqueId, SdkSetting::getId));
        }
        throw new RuntimeException("resource type unsupported");
    }

    @Override
    public Map<Long, Long> getBoFieldVersion2uniIdMapping(List<Long> stdBoVersionIds) {
        List stdVersionBoFields = this.boFieldRepository.getBoFieldsByBoIds(stdBoVersionIds);
        return stdVersionBoFields.stream().collect(Collectors.toMap(BoField::getId, BoField::getUniqueId));
    }

    @Override
    public Map<Long, Long> getBoRelationshipVersion2uniIdMapping(List<Long> stdBoVersionIds) {
        List stdVersionBoRelationships = this.boRelationshipRepository.getBoRelationshipsByBoIds(stdBoVersionIds);
        return stdVersionBoRelationships.stream().collect(Collectors.toMap(BoRelationship::getId, BoRelationship::getUniqueId));
    }

    @Override
    public Optional<Bo> getRefVersionBo(Long appId, Long stdBoUniId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        return this.getRefVersionBo(appRef, stdBoUniId);
    }

    @Override
    public Optional<Dict> getRefVersionDict(Long appId, Long stdDictUniId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        return this.getRefVersionDict(appRef, stdDictUniId);
    }

    @Override
    public Optional<UltPage> getRefVersionPage(Long appId, Long stdPageUniId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        return this.getRefVersionPage(appRef, stdPageUniId);
    }

    @Override
    public Optional<UltForm> getRefVersionForm(Long appId, Long stdFormUniId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        return this.getRefVersionForm(appRef, stdFormUniId);
    }

    @Override
    public Optional<FlowSetting> getRefVersionFlow(Long appId, Long stdFlowUniId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        return this.getRefVersionFlow(appRef, stdFlowUniId);
    }

    @Override
    public Optional<AppEvent> getRefVersionAppEvent(Long appId, Long stdEventUniId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        return this.getRefVersionAppEvent(appRef, stdEventUniId);
    }

    @Override
    public Optional<SdkSetting> getRefVersionSdkSetting(Long appId, Long stdSdkSettingId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        return this.getRefVersionSdkSetting(appRef, stdSdkSettingId);
    }

    @Override
    public Optional<UltPageSetting> getRefVersionPageSetting(Long appId, Long stdPageSettingUniId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        return this.getRefVersionPageSetting(appRef, stdPageSettingUniId);
    }

    @Override
    public Optional<Bo> getRefVersionBo(AppRef appRef, Long stdBoUniId) {
        List<Bo> stdVersionBos = this.boVersionQuery.getBos(appRef.getRefAppId(), appRef.getRefAppVersion());
        return stdVersionBos.stream().filter(o -> o.getUniqueId().equals(stdBoUniId)).findAny();
    }

    @Override
    public Optional<Dict> getRefVersionDict(AppRef appRef, Long stdDictUniId) {
        List<Dict> stdVersionDicts = this.dictVersionQuery.getDicts(appRef.getRefAppId(), appRef.getRefAppVersion());
        return stdVersionDicts.stream().filter(o -> o.getUniqueId().equals(stdDictUniId)).findAny();
    }

    @Override
    public Optional<UltPage> getRefVersionPage(AppRef appRef, Long stdPageUniId) {
        List<UltPage> stdVersionPages = this.pageVersionQuery.getPages(appRef.getRefAppId(), appRef.getRefAppVersion());
        return stdVersionPages.stream().filter(o -> o.getUniqueId().equals(stdPageUniId)).findAny();
    }

    @Override
    public Optional<UltForm> getRefVersionForm(AppRef appRef, Long stdFormUniId) {
        List<UltForm> stdVersionForms = this.formVersionQuery.getForms(appRef.getRefAppId(), appRef.getRefAppVersion());
        return stdVersionForms.stream().filter(o -> o.getUniqueId().equals(stdFormUniId)).findAny();
    }

    @Override
    public Optional<FlowSetting> getRefVersionFlow(AppRef appRef, Long stdFlowUniId) {
        List<FlowSetting> stdVersionFlows = this.flowSettingVersionQuery.getFlowSettings(appRef.getRefAppId(), appRef.getRefAppVersion());
        return stdVersionFlows.stream().filter(o -> o.getPublishFlowId().equals(stdFlowUniId)).findAny();
    }

    @Override
    public Optional<AppEvent> getRefVersionAppEvent(AppRef appRef, Long stdEventUniId) {
        List<AppEvent> stdVersionEvents = this.appEventVersionQuery.getAppEvents(appRef.getRefAppId(), appRef.getRefAppVersion());
        return stdVersionEvents.stream().filter(o -> o.getUniqueId().equals(stdEventUniId)).findAny();
    }

    @Override
    public Optional<SdkSetting> getRefVersionSdkSetting(AppRef appRef, Long stdSdkSettingId) {
        List<SdkSetting> stdVersionSdkSettings = this.sdkSettingVersionQuery.getSdkSettings(appRef.getRefAppId(), appRef.getRefAppVersion());
        return stdVersionSdkSettings.stream().filter(o -> o.getUniqueId().equals(stdSdkSettingId)).findAny();
    }

    @Override
    public Optional<UltPageSetting> getRefVersionPageSetting(AppRef appRef, Long stdPageSettingUniId) {
        List<UltPageSetting> stdVersionPages = this.pageSettingVersionQuery.getPageSettings(appRef.getRefAppId(), appRef.getRefAppVersion());
        return stdVersionPages.stream().filter(o -> o.getUniqueId().equals(stdPageSettingUniId)).findAny();
    }
}

