/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import com.alibaba.fastjson2.JSON;
import com.xforceplus.ultraman.bocp.metadata.constant.BocpConstant;
import com.xforceplus.ultraman.bocp.metadata.dto.AppDeployDTO;
import com.xforceplus.ultraman.bocp.metadata.dto.AppRefDTO;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppRefChangeStatus;
import com.xforceplus.ultraman.bocp.metadata.enums.AppRefChangeType;
import com.xforceplus.ultraman.bocp.metadata.enums.AppRefHistoryOpType;
import com.xforceplus.ultraman.bocp.metadata.enums.VersionStatus;
import com.xforceplus.ultraman.bocp.metadata.infra.util.UserUtils;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.AppRefStructMapper;
import com.xforceplus.ultraman.bocp.metadata.service.IAppRefHistoryExService;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionService;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionValidateService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.AppRefMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppRefService;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRefRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class AppRefVersionServiceImpl
implements IAppRefVersionService {
    private static final Logger log = LoggerFactory.getLogger(AppRefVersionServiceImpl.class);
    @Autowired
    private AppRefMapper appRefMapper;
    @Autowired
    private IAppRefService appRefService;
    @Autowired
    private IAppRefHistoryExService appRefHistoryExService;
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private AppRefRepository appRefRepository;
    @Autowired
    private IAppRefVersionValidateService appRefVersionValidateService;

    @Override
    public ServiceResponse changeRefApp(AppRefDTO appRefDTO, boolean force) {
        Optional appEnvOptional;
        AppRef appRef = (AppRef)this.appRefService.getById((Serializable)appRefDTO.getId());
        if (null == appRef) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u6570\u636e");
        }
        if (appRef.getRefAppId().equals(appRefDTO.getRefAppId())) {
            return ServiceResponse.fail((String)"\u53d8\u66f4\u7684\u76ee\u6807\u6807\u51c6\u5e94\u7528\u4e0e\u5f53\u524d\u5f15\u7528\u7684\u6807\u51c6\u5e94\u7528\u76f8\u540c");
        }
        if (!this.appVersionQuery.getAppVersion(appRefDTO.getRefAppId(), appRefDTO.getRefAppVersion()).isPresent()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u53d8\u66f4\u7684\u76ee\u6807\u6807\u51c6\u5e94\u7528\u7248\u672c");
        }
        if (!force && (appEnvOptional = this.appEnvRepository.getAppEnv(appRef.getAppId().longValue(), BocpConstant.PROD_APP_ENV_ID.longValue())).isPresent() && null != ((AppEnv)appEnvOptional.get()).getAppVersionId()) {
            throw new RuntimeException("\u79df\u6237\u5b9a\u5236\u5df2\u53d1\u5e03\u8fc7\u751f\u4ea7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        AppRef newAppRef = AppRefStructMapper.MAPPER.clone(appRef);
        newAppRef.setRefAppId(appRefDTO.getRefAppId());
        newAppRef.setRefAppVersion(appRefDTO.getRefAppVersion());
        this.appRefService.updateById((Object)newAppRef);
        this.appRefHistoryExService.logByOpType(AppRefHistoryOpType.CHANGE_REF_APP, appRef, newAppRef);
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse changeVersion(AppRefDTO appRefDTO, boolean force) {
        AppRef appRef = (AppRef)this.appRefService.getById((Serializable)appRefDTO.getId());
        if (null == appRef) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u5e94\u7528\u5b9a\u5236\u4fe1\u606f");
        }
        if (!this.appVersionQuery.getAppVersion(appRef.getRefAppId(), appRefDTO.getRefAppVersion()).isPresent()) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u76ee\u6807\u6807\u51c6\u5e94\u7528\u7248\u672c");
        }
        if (appRefDTO.getRefAppVersion().equals(appRef.getRefAppVersion())) {
            return ServiceResponse.fail((String)"\u5f53\u524d\u7248\u672c\u548c\u76ee\u6807\u7248\u672c\u76f8\u540c\uff0c\u4e0d\u9700\u8981\u5904\u7406");
        }
        ServiceResponse<Tuple2<Map<MetadataType, List<String>>, Map<MetadataType, List<String>>>> serviceResponse = this.appRefVersionValidateService.validateWhenChangeVersion(appRef, appRefDTO.getRefAppVersion());
        AppRef newAppRef = AppRefStructMapper.MAPPER.clone(appRef);
        newAppRef.setChangeContent(this.buildChangeContent((Map)((Tuple2)serviceResponse.getData())._1, (Map)((Tuple2)serviceResponse.getData())._2));
        newAppRef.setRefAppVersion(appRefDTO.getRefAppVersion());
        newAppRef.setChangerId(UserUtils.getUserId());
        newAppRef.setChangerName(UserUtils.getUsername());
        newAppRef.setChangeTime(LocalDateTime.now());
        if (!serviceResponse.isSuccess() && !force) {
            newAppRef.setChangeStatus(AppRefChangeStatus.FAIL.code());
            newAppRef.setChangeRemark("\u79df\u6237\u5b9a\u5236\u5e94\u7528\u624b\u5de5\u89e6\u53d1 \u6821\u9a8c\u5931\u8d25");
            this.appRefHistoryExService.logByOpType(AppRefHistoryOpType.MANUAL_CHANGE_REF_VERSION, appRef, newAppRef);
            newAppRef.setRefAppVersion(appRef.getRefAppVersion());
            this.appRefService.updateById((Object)newAppRef);
            return serviceResponse;
        }
        newAppRef.setChangeRemark("\u79df\u6237\u5b9a\u5236\u5e94\u7528\u624b\u5de5\u89e6\u53d1" + (serviceResponse.isSuccess() ? " \u6821\u9a8c\u6210\u529f" : " \u6821\u9a8c\u5931\u8d25") + (force ? " \u5f3a\u5236\u6267\u884c" : ""));
        newAppRef.setChangeStatus(AppRefChangeStatus.SUCCESS.code());
        this.appRefHistoryExService.logByOpType(AppRefHistoryOpType.MANUAL_CHANGE_REF_VERSION, appRef, newAppRef);
        this.appRefMapper.updateById((Object)newAppRef);
        return ServiceResponse.success((String)"\u6267\u884c\u6210\u529f");
    }

    @Override
    @SkipDataAuth
    public void changeVersionWhenStdAppDeploy(AppDeployDTO appDeployDTO) {
        long startTime = System.currentTimeMillis();
        log.debug("\u6807\u51c6\u5e94\u7528\u90e8\u7f72\u6b63\u5f0f\u73af\u5883\uff0c\u5f00\u59cb\u66f4\u65b0\u79df\u6237\u5b9a\u5236\u5e94\u7528\u7684\u5b9a\u5236\u7248\u672c {}", (Object)JSON.toJSONString((Object)appDeployDTO));
        if (!BocpConstant.PROD_APP_ENV_ID.equals(appDeployDTO.getEnvId())) {
            throw new RuntimeException("\u90e8\u7f72\u975e\u6b63\u5f0f\u73af\u5883");
        }
        App app = this.appRepository.getAppWithValidate(appDeployDTO.getAppId().longValue());
        if (!AppCustomType.STANDARD.code().equals(app.getCustomType())) {
            throw new RuntimeException("\u5f53\u524d\u5e94\u7528\u4e0d\u662f\u6807\u51c6\u5e94\u7528");
        }
        Map releaseAppVersionMap = this.appVersionQuery.getAppVersions(appDeployDTO.getAppId(), VersionStatus.RELEASE).stream().collect(Collectors.toMap(AppVersion::getVersion, Function.identity()));
        if (!releaseAppVersionMap.containsKey(appDeployDTO.getDeployVersion())) {
            throw new RuntimeException("\u67e5\u8be2\u4e0d\u5230\u90e8\u7f72\u7248\u672c");
        }
        List autoAppRefs = this.appRefRepository.getAppRefs(appDeployDTO.getAppId().longValue()).stream().filter(o -> AppRefChangeType.AUTO.code().equals(o.getChangeType())).collect(Collectors.toList());
        autoAppRefs.stream().filter(o -> appDeployDTO.getDeployVersion().equals(o.getRefAppVersion())).forEach(appRef -> {
            AppRef newAppRef = AppRefStructMapper.MAPPER.clone(appRef);
            newAppRef.setRefAppVersion(appDeployDTO.getDeployVersion());
            newAppRef.setChangerId(appDeployDTO.getDeployerId());
            newAppRef.setChangerName(appDeployDTO.getDeployerName());
            newAppRef.setChangeTime(appDeployDTO.getDeployTime());
            newAppRef.setChangeRemark("\u7531\u6807\u51c6\u5e94\u7528\u6b63\u5f0f\u73af\u5883\u90e8\u7f72\u89e6\u53d1\uff0c\u7248\u672c\u76f8\u540c\uff0c\u4e0d\u9700\u8981\u53d8\u66f4");
            newAppRef.setChangeContent("");
            newAppRef.setChangeStatus(AppRefChangeStatus.SUCCESS.code());
            this.appRefHistoryExService.logByOpType(AppRefHistoryOpType.AUTO_CHANGE_REF_VERSION, appRef, newAppRef);
            newAppRef.setRefAppVersion(appRef.getRefAppVersion());
            this.appRefMapper.alwaysUpdateSomeColumnById((Object)newAppRef);
        });
        this.updateRefVersion(appDeployDTO, autoAppRefs.stream().filter(o -> !appDeployDTO.getDeployVersion().equals(o.getRefAppVersion())).collect(Collectors.toList()));
        log.debug("\u6807\u51c6\u5e94\u7528\u90e8\u7f72\u6b63\u5f0f\u73af\u5883\uff0c\u79df\u6237\u5b9a\u5236\u5e94\u7528\u7684\u5b9a\u5236\u7248\u672c\u66f4\u65b0\u7ed3\u675f {}, \u8017\u65f6\uff1a{}", (Object)JSON.toJSONString((Object)appDeployDTO), (Object)((System.currentTimeMillis() - startTime) / 1000L + "s"));
    }

    private String buildChangeContent(Map<MetadataType, List<String>> conflictItemMap, Map<MetadataType, List<String>> affectedItemMap) {
        StringBuilder stringBuilder = new StringBuilder("\u6807\u51c6\u5e94\u7528\u7684\u76f8\u5173\u53d8\u66f4\u5185\u5bb9\uff1a\n");
        stringBuilder.append("\u53d8\u66f4\u51b2\u7a81\u9879\uff08\u5bfc\u81f4\u6267\u884c\u5931\u8d25\u7684\u539f\u56e0\uff09: \n");
        if (conflictItemMap.isEmpty() || conflictItemMap.values().stream().mapToLong(List::size).sum() == 0L) {
            stringBuilder.append("\u65e0 \n\n");
        } else {
            stringBuilder.append(this.buildChangeItem(MetadataType.BO, conflictItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.DICT, conflictItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.PAGE, conflictItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.FORM, conflictItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.FLOW_SETTING, conflictItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.PAGE_SETTING, conflictItemMap));
            stringBuilder.append("\n");
        }
        stringBuilder.append("\u53d8\u66f4\u65e0\u51b2\u7a81\u9879: \n");
        if (affectedItemMap.isEmpty() || affectedItemMap.values().stream().mapToLong(List::size).sum() == 0L) {
            stringBuilder.append("\u65e0 \n\n");
        } else {
            stringBuilder.append(this.buildChangeItem(MetadataType.BO, affectedItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.DICT, affectedItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.PAGE, affectedItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.FORM, affectedItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.FLOW_SETTING, affectedItemMap));
            stringBuilder.append(this.buildChangeItem(MetadataType.PAGE_SETTING, affectedItemMap));
        }
        return stringBuilder.toString();
    }

    private String buildChangeItem(MetadataType metadataType, Map<MetadataType, List<String>> changeItemMap) {
        StringBuilder stringBuilder = new StringBuilder();
        if (changeItemMap.containsKey(metadataType)) {
            Optional.ofNullable(changeItemMap.get(metadataType)).ifPresent(l -> {
                stringBuilder.append(String.format("%s\uff1a\n", metadataType.desc()));
                l.forEach(o -> stringBuilder.append("  " + o + "\n"));
            });
        } else {
            stringBuilder.append(String.format("%s\uff1a\u65e0 \n", metadataType.desc()));
        }
        return stringBuilder.toString();
    }

    private void updateRefVersion(AppDeployDTO appDeployDTO, List<AppRef> autoAppRefsShouldChange) {
        autoAppRefsShouldChange = autoAppRefsShouldChange.stream().filter(o -> this.appRepository.getApp(o.getAppId().longValue()).isPresent()).collect(Collectors.toList());
        Map<Long, ServiceResponse<Tuple2<Map<MetadataType, List<String>>, Map<MetadataType, List<String>>>>> result = this.appRefVersionValidateService.validateWhenChangeVersion(autoAppRefsShouldChange, appDeployDTO.getAppId(), appDeployDTO.getDeployVersion());
        autoAppRefsShouldChange.forEach(appRef -> {
            AppRef newAppRef = AppRefStructMapper.MAPPER.clone(appRef);
            newAppRef.setChangerId(appDeployDTO.getDeployerId());
            newAppRef.setChangerName(appDeployDTO.getDeployerName());
            newAppRef.setChangeTime(appDeployDTO.getDeployTime());
            newAppRef.setRefAppVersion(appDeployDTO.getDeployVersion());
            try {
                ServiceResponse serviceResponse = (ServiceResponse)result.get(appRef.getAppId());
                newAppRef.setChangeContent(this.buildChangeContent((Map)((Tuple2)serviceResponse.getData())._1, (Map)((Tuple2)serviceResponse.getData())._2));
                if (serviceResponse.isSuccess()) {
                    newAppRef.setChangeRemark("\u7531\u6807\u51c6\u5e94\u7528\u6b63\u5f0f\u73af\u5883\u90e8\u7f72\u89e6\u53d1\uff0c\u6267\u884c\u6210\u529f");
                    newAppRef.setChangeStatus(AppRefChangeStatus.SUCCESS.code());
                    this.appRefHistoryExService.logByOpType(AppRefHistoryOpType.AUTO_CHANGE_REF_VERSION, appRef, newAppRef);
                } else {
                    newAppRef.setChangeRemark("\u7531\u6807\u51c6\u5e94\u7528\u6b63\u5f0f\u73af\u5883\u90e8\u7f72\u89e6\u53d1\uff0c\u6267\u884c\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u53d8\u66f4\u5185\u5bb9");
                    newAppRef.setChangeStatus(AppRefChangeStatus.FAIL.code());
                    this.appRefHistoryExService.logByOpType(AppRefHistoryOpType.AUTO_CHANGE_REF_VERSION, appRef, newAppRef);
                    newAppRef.setRefAppVersion(appRef.getRefAppVersion());
                }
            }
            catch (Exception e) {
                newAppRef.setChangeRemark("\u7531\u6807\u51c6\u5e94\u7528\u6b63\u5f0f\u73af\u5883\u90e8\u7f72\u89e6\u53d1\uff0c\u6267\u884c\u5f02\u5e38");
                newAppRef.setChangeStatus(AppRefChangeStatus.FAIL.code());
                newAppRef.setChangeContent(e.getMessage());
                this.appRefHistoryExService.logByOpType(AppRefHistoryOpType.AUTO_CHANGE_REF_VERSION, appRef, newAppRef);
                log.error("\u53d8\u66f4\u79df\u6237\u5b9a\u5236\u5e94\u7528\u7684\u5b9a\u5236\u7248\u672c\u5f02\u5e38 {}", (Object)appRef.getAppId(), (Object)e);
                newAppRef.setRefAppVersion(appRef.getRefAppVersion());
            }
            this.appRefMapper.updateById((Object)newAppRef);
        });
    }
}

