/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import akka.japi.tuple.Tuple9;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.version.diff.FormVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.PageVersionDiffExecutor;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffAggregator;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionValidateService;
import com.xforceplus.ultraman.bocp.metadata.version.validator.AppVersionValidator;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.metadata.repository.aggregator.AppMetadataQueryAggregator;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@SkipDataAuth
@Service
public class AppRefVersionValidateServiceImpl
implements IAppRefVersionValidateService {
    private static final Logger log = LoggerFactory.getLogger(AppRefVersionValidateServiceImpl.class);
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private VersionDiffAggregator versionDiffAggregator;
    @Autowired
    private PageVersionDiffExecutor pageVersionDiffExecutor;
    @Autowired
    private FormVersionDiffExecutor formVersionDiffExecutor;
    @Autowired
    private AppMetadataQueryAggregator appMetadataQueryAggregator;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;
    @Autowired
    private AppVersionValidator appVersionValidator;

    @Override
    public ServiceResponse<Tuple2<Map<MetadataType, List<String>>, Map<MetadataType, List<String>>>> validateWhenChangeVersion(AppRef appRef, String newStdAppVersion) {
        return this.validateWhenChangeVersion(Collections.singletonList(appRef), appRef.getRefAppId(), newStdAppVersion).values().stream().findAny().orElse(null);
    }

    @Override
    public Map<Long, ServiceResponse<Tuple2<Map<MetadataType, List<String>>, Map<MetadataType, List<String>>>>> validateWhenChangeVersion(List<AppRef> appRefs, Long stdAppId, String newStdAppVersion) {
        HashMap result = Maps.newHashMap();
        Map<String, Tuple9<AppVersion, Map<Long, Long>, Map<Long, Long>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>>> stdVersionChangeTupleMap = this.getStdVersionChangeTupleMap(stdAppId, newStdAppVersion, appRefs);
        appRefs.forEach(o -> {
            Tuple9 tuple = (Tuple9)stdVersionChangeTupleMap.get(o.getRefAppVersion());
            App tenantApp = this.appRepository.getAppWithValidate(o.getAppId().longValue());
            log.info("\u6807\u51c6\u5e94\u7528\uff08{} {} -> {}\uff09\u6b63\u5f0f\u90e8\u7f72\uff0c\u79df\u6237\u5b9a\u5236\u5e94\u7528\uff08{}\uff09\u7248\u672c\u53d8\u66f4\uff08{} -> {}\uff09\u6821\u9a8c\u5f00\u59cb", new Object[]{stdAppId, ((AppVersion)tuple.t1()).getVersion(), newStdAppVersion, o.getAppId(), tenantApp.getTenantCode(), newStdAppVersion});
            ServiceResponse<Tuple2<Map<MetadataType, List<String>>, Map<MetadataType, List<String>>>> itemResp = this.validateMetadatas((AppRef)o, (Map)tuple.t2(), (Map)tuple.t3(), (List)tuple.t4(), (List)tuple.t5(), (List)tuple.t6(), (List)tuple.t7(), (List)tuple.t8(), (List)tuple.t9());
            log.info("\u79df\u6237\u5b9a\u5236\u5e94\u7528 \u7248\u672c\u53d8\u66f4 \u6821\u9a8c\u7ed3\u675f");
            result.put(o.getAppId(), itemResp);
        });
        return result;
    }

    private ServiceResponse<Tuple2<Map<MetadataType, List<String>>, Map<MetadataType, List<String>>>> validateMetadatas(AppRef appRef, Map<Long, Long> originStdBoUniIdVIdMapping, Map<Long, Long> originStdDictUniIdVIdMapping, List<ChangedItem> boChangedItems, List<ChangedItem> dictChangedItems, List<ChangedItem> pageChangedItems, List<ChangedItem> formChangedItems, List<ChangedItem> flowSettingChangedItems, List<ChangedItem> pageSettingChangedItems) {
        List tenantBos = this.appMetadataQueryAggregator.getBos(appRef.getAppId());
        Tuple2<List<String>, List<String>> boValidateResult = this.validateBos(appRef.getAppId(), tenantBos, originStdBoUniIdVIdMapping, boChangedItems);
        Tuple2<List<String>, List<String>> dictValidateResult = this.validateDicts(appRef.getAppId(), tenantBos, originStdDictUniIdVIdMapping, dictChangedItems);
        Tuple2<List<String>, List<String>> pageValidateResult = this.validatePages(appRef.getAppId(), pageChangedItems);
        Tuple2<List<String>, List<String>> formValidateResult = this.validateForms(appRef.getAppId(), formChangedItems);
        Tuple2<List<String>, List<String>> flowValidateResult = this.validateFlowSettings(appRef.getAppId(), flowSettingChangedItems);
        Tuple2<List<String>, List<String>> pageSettingValidateResult = this.validatePageSettings(appRef.getAppId(), pageSettingChangedItems);
        HashMap confictItemMap = Maps.newHashMap();
        HashMap affectedItemMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)boValidateResult._1))) {
            confictItemMap.put(MetadataType.BO, boValidateResult._1);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)boValidateResult._2))) {
            affectedItemMap.put(MetadataType.BO, boValidateResult._2);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)dictValidateResult._1))) {
            confictItemMap.put(MetadataType.DICT, dictValidateResult._1);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)dictValidateResult._2))) {
            affectedItemMap.put(MetadataType.DICT, dictValidateResult._2);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)pageValidateResult._1))) {
            confictItemMap.put(MetadataType.PAGE, pageValidateResult._1);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)pageValidateResult._2))) {
            affectedItemMap.put(MetadataType.PAGE, pageValidateResult._2);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)formValidateResult._1))) {
            confictItemMap.put(MetadataType.FORM, formValidateResult._1);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)formValidateResult._2))) {
            affectedItemMap.put(MetadataType.FORM, formValidateResult._2);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowValidateResult._1))) {
            confictItemMap.put(MetadataType.FLOW_SETTING, flowValidateResult._1);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flowValidateResult._2))) {
            affectedItemMap.put(MetadataType.FLOW_SETTING, flowValidateResult._2);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)pageSettingValidateResult._1))) {
            confictItemMap.put(MetadataType.PAGE_SETTING, pageSettingValidateResult._1);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)pageSettingValidateResult._2))) {
            affectedItemMap.put(MetadataType.PAGE_SETTING, pageSettingValidateResult._2);
        }
        if (confictItemMap.isEmpty()) {
            log.info("\u6821\u9a8c\u65e0\u51b2\u7a81\uff0c\u901a\u8fc7");
            return ServiceResponse.success((String)"", (Object)new Tuple2((Object)confictItemMap, (Object)affectedItemMap));
        }
        log.info("\u6821\u9a8c\u6709\u51b2\u7a81");
        return ServiceResponse.fail((String)"", (Object)new Tuple2((Object)confictItemMap, (Object)affectedItemMap));
    }

    private Tuple2<List<String>, List<String>> validateBos(Long tenantAppId, List<Bo> tenantBos, Map<Long, Long> originStdBoUniIdVIdMapping, List<ChangedItem> changedItems) {
        if (CollectionUtils.isEmpty(changedItems)) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        List tenantPages = this.appMetadataQueryAggregator.getPages(tenantAppId);
        List tenantForms = this.appMetadataQueryAggregator.getForms(tenantAppId);
        List tenantFlows = this.appMetadataQueryAggregator.getFlowSettings(tenantAppId);
        List tenantPageSettings = this.appMetadataQueryAggregator.getPageSettings(tenantAppId);
        return this.appVersionValidator.validateBos(changedItems, tenantBos, tenantPages, tenantForms, tenantFlows, tenantPageSettings, originStdBoUniIdVIdMapping);
    }

    private Tuple2<List<String>, List<String>> validateDicts(Long tenantAppId, List<Bo> tenantBos, Map<Long, Long> originStdDictUniIdVIdMapping, List<ChangedItem> changedItems) {
        if (CollectionUtils.isEmpty(changedItems)) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        List tenantDicts = this.appMetadataQueryAggregator.getDicts(tenantAppId);
        return this.appVersionValidator.validateDicts(changedItems, tenantDicts, tenantBos, originStdDictUniIdVIdMapping);
    }

    private Tuple2<List<String>, List<String>> validatePages(Long tenantAppId, List<ChangedItem> changedItems) {
        if (CollectionUtils.isEmpty(changedItems)) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        List tenantPages = this.appMetadataQueryAggregator.getPages(tenantAppId);
        return this.appVersionValidator.validatePages(changedItems, tenantPages);
    }

    private Tuple2<List<String>, List<String>> validateForms(Long tenantAppId, List<ChangedItem> changedItems) {
        if (CollectionUtils.isEmpty(changedItems)) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        List tenantForms = this.appMetadataQueryAggregator.getForms(tenantAppId);
        return this.appVersionValidator.validateForms(changedItems, tenantForms);
    }

    private Tuple2<List<String>, List<String>> validateFlowSettings(Long tenantAppId, List<ChangedItem> changedItems) {
        if (CollectionUtils.isEmpty(changedItems)) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        List tenantFlows = this.appMetadataQueryAggregator.getFlowSettings(tenantAppId);
        return this.appVersionValidator.validateFlowSettings(changedItems, tenantFlows);
    }

    private Tuple2<List<String>, List<String>> validatePageSettings(Long tenantAppId, List<ChangedItem> changedItems) {
        return this.appVersionValidator.validatePageSettings(Lists.newArrayList(), Lists.newArrayList());
    }

    private Map<String, Tuple9<AppVersion, Map<Long, Long>, Map<Long, Long>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>>> getStdVersionChangeTupleMap(Long stdAppId, String newStdAppVersionStr, List<AppRef> appRefs) {
        AppVersion newStdAppVersion = this.appVersionQuery.getAppVersionWithValidate(stdAppId, newStdAppVersionStr);
        return this.getStdVersionChangeTupleMap(stdAppId, newStdAppVersion.getId(), appRefs.stream().map(AppRef::getRefAppVersion).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private Map<String, Tuple9<AppVersion, Map<Long, Long>, Map<Long, Long>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>, List<ChangedItem>>> getStdVersionChangeTupleMap(Long stdAppId, Long newStdAppVersionId, List<String> originStdAppVersions) {
        HashMap stdVersionChangeTupleMap = Maps.newHashMap();
        originStdAppVersions.forEach(v -> {
            if (!stdVersionChangeTupleMap.containsKey(v)) {
                AppVersion originStdAppVersion = this.appVersionQuery.getAppVersionWithValidate(stdAppId, (String)v);
                Map<Long, Long> originStdBoUniIdVIdMapping = this.metadataVersionQuery.getBos(originStdAppVersion.getId()).stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
                Map<Long, Long> originStdDictUniIdVIdMapping = this.metadataVersionQuery.getDicts(originStdAppVersion.getId()).stream().collect(Collectors.toMap(Dict::getUniqueId, Dict::getId));
                List<ChangedItem> boChangedItems = this.versionDiffAggregator.getBosSysExclusiveDiff(stdAppId, originStdAppVersion.getId(), newStdAppVersionId);
                List<ChangedItem> dictChangedItems = this.versionDiffAggregator.getDiff(stdAppId, originStdAppVersion.getId(), newStdAppVersionId, MetadataType.DICT);
                List<ChangedItem> pageChangedItems = this.pageVersionDiffExecutor.getDiff(stdAppId, originStdAppVersion.getId(), newStdAppVersionId, false);
                List<ChangedItem> formChangedItems = this.formVersionDiffExecutor.getDiff(stdAppId, originStdAppVersion.getId(), newStdAppVersionId, false);
                List<ChangedItem> flowSettingChangedItems = this.versionDiffAggregator.getDiff(stdAppId, originStdAppVersion.getId(), newStdAppVersionId, MetadataType.FLOW_SETTING);
                ArrayList pageSettingChangedItems = Lists.newArrayList();
                stdVersionChangeTupleMap.put(v, new Tuple9((Object)originStdAppVersion, originStdBoUniIdVIdMapping, originStdDictUniIdVIdMapping, boChangedItems, dictChangedItems, pageChangedItems, formChangedItems, flowSettingChangedItems, (Object)pageSettingChangedItems));
            }
        });
        return stdVersionChangeTupleMap;
    }
}

