/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.service.impl;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.service.IAppEnvDeployDetailExService;
import com.xforceplus.ultraman.bocp.metadata.util.IdConvertUtil;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.BoVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.DictVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FlowSettingVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.FormVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppVersionMergeForMultiTenantService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnvDeployDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.datarule.domain.enums.AppEnvType;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@SkipDataAuth
@Component
public class AppVersionMergeForMultiTenantServiceImpl
implements IAppVersionMergeForMultiTenantService {
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private BoVersionQuery boVersionQuery;
    @Autowired
    private DictVersionQuery dictVersionQuery;
    @Autowired
    private PageVersionQuery pageVersionQuery;
    @Autowired
    private FormVersionQuery formVersionQuery;
    @Autowired
    private FlowSettingVersionQuery flowSettingVersionQuery;
    @Autowired
    private IAppEnvDeployDetailExService appEnvDeployDetailExService;

    @Override
    public List<Bo> getBos(Long stdAppId, String appVersion) {
        return this.getBos(stdAppId, appVersion, Maps.newHashMap());
    }

    @Override
    public List<Dict> getDicts(Long stdAppId, String appVersion) {
        List<Dict> stdDicts = this.dictVersionQuery.getDicts(stdAppId, appVersion);
        List tenantDicts = this.getProdTenantDeployDetail(stdAppId).stream().map(o -> this.dictVersionQuery.getDicts(o.getAppVersionId())).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, Long> stdDictIdMapping = stdDicts.stream().collect(Collectors.toMap(Dict::getUniqueId, Dict::getId));
        IdConvertUtil.convertDictUniIdToVersionId(tenantDicts, stdDictIdMapping);
        return ListUtils.union(stdDicts, tenantDicts);
    }

    @Override
    public List<UltPage> getPages(Long stdAppId, String appVersion) {
        List<UltPage> stdPages = this.pageVersionQuery.getPages(stdAppId, appVersion);
        List tenantPages = this.getProdTenantDeployDetail(stdAppId).stream().map(o -> this.pageVersionQuery.getPages(o.getAppId(), o.getDeployVersion())).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, Long> stdPageIdMapping = stdPages.stream().collect(Collectors.toMap(UltPage::getPublishRefPageId, UltPage::getId));
        IdConvertUtil.convertPageUniIdToVersionId(tenantPages, stdPageIdMapping);
        return ListUtils.union(stdPages, tenantPages);
    }

    @Override
    public List<UltForm> getForms(Long stdAppId, String appVersion) {
        List<UltForm> stdForms = this.formVersionQuery.getForms(stdAppId, appVersion);
        List tenantForms = this.getProdTenantDeployDetail(stdAppId).stream().map(o -> this.formVersionQuery.getForms(o.getAppId(), o.getDeployVersion())).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, Long> stdFormIdMapping = stdForms.stream().collect(Collectors.toMap(UltForm::getPublishRefFormId, UltForm::getId));
        IdConvertUtil.convertFormUniIdToVersionId(tenantForms, stdFormIdMapping);
        return ListUtils.union(stdForms, tenantForms);
    }

    @Override
    public List<FlowSetting> getFlowSettings(Long stdAppId, String appVersion) {
        List<FlowSetting> stdFlows = this.flowSettingVersionQuery.getFlowSettings(stdAppId, appVersion);
        List tenantFlows = this.getProdTenantDeployDetail(stdAppId).stream().map(o -> this.flowSettingVersionQuery.getFlowSettings(o.getAppId(), o.getDeployVersion())).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, Long> stdFlowIdMapping = stdFlows.stream().collect(Collectors.toMap(FlowSetting::getPublishFlowId, FlowSetting::getId));
        IdConvertUtil.convertFlowUniIdToVersionId(tenantFlows, stdFlowIdMapping);
        return ListUtils.union(stdFlows, tenantFlows);
    }

    @Override
    public List<Bo> getBos(Long stdAppId, String appVersion, Map<Long, String> tenantAppVersionMap) {
        Tuple2<List<Bo>, List<Bo>> tuple2 = this.getBosTuple(stdAppId, appVersion, tenantAppVersionMap);
        return ListUtils.union((List)((List)tuple2._1), (List)((List)tuple2._2));
    }

    @Override
    public Tuple2<List<Bo>, List<Bo>> getBosTuple(Long stdAppId, String appVersion, Map<Long, String> tenantAppVersionMap) {
        List<AppEnvDeployDetail> appEnvDeployDetails = this.getProdTenantDeployDetail(stdAppId);
        if (!tenantAppVersionMap.isEmpty()) {
            appEnvDeployDetails.forEach(o -> {
                if (tenantAppVersionMap.containsKey(o.getAppId())) {
                    Optional<AppVersion> appVersionOptional = this.appVersionQuery.getAppVersion(o.getAppId(), (String)tenantAppVersionMap.get(o.getAppId()));
                    appVersionOptional.ifPresent(version -> o.setAppVersionId(version.getId()));
                }
            });
        }
        List<Bo> stdBos = this.boVersionQuery.getBos(stdAppId, appVersion);
        List tenantBos = appEnvDeployDetails.stream().map(o -> this.boVersionQuery.getBos(o.getAppVersionId())).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, Long> stdBoIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        IdConvertUtil.convertBoUniIdToVersionId(tenantBos, stdBoIdMapping);
        return new Tuple2(stdBos, tenantBos);
    }

    private List<AppEnvDeployDetail> getProdTenantDeployDetail(Long stdAppId) {
        return this.appEnvDeployDetailExService.getDeployDetailsByStdAppIdAndEnvId(stdAppId.longValue(), Long.parseLong(AppEnvType.PROD.code())).stream().filter(o -> AppCustomType.TENANT.code().equals(o.getCustomType())).collect(Collectors.toList());
    }
}

