/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.version.validator;

import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.flow.util.FlowSettingUtil;
import com.xforceplus.ultraman.bocp.metadata.util.BoIndexUtil;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.DiffType;
import com.xforceplus.ultraman.bocp.metadata.view.util.PageFormBoSettingParseUtil;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoIndex;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldDomainAttributeRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoIndexRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppVersionValidator {
    @Autowired
    private BoFieldRepository boFieldRepository;
    @Autowired
    private BoFieldDomainAttributeRepository boFieldDomainAttributeRepository;
    @Autowired
    private BoIndexRepository boIndexRepository;
    @Autowired
    private DataRuleRepository dataRuleRepository;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private DictRepository dictRepository;

    public Tuple2<List<String>, List<String>> validateBos(List<ChangedItem> changedItems, List<Bo> tenantBos, List<UltPage> tenantPages, List<UltForm> tenantForms, List<FlowSetting> tenantFlows, List<UltPageSetting> tenantPageSettings, Map<Long, Long> originStdBoUniIdVIdMapping) {
        if (changedItems.isEmpty()) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        Map stdBoIdMapping = tenantBos.stream().collect(Collectors.toMap(Bo::getRefBoId, Function.identity()));
        ArrayList conflictItems = Lists.newArrayList();
        ArrayList unConflictedItems = Lists.newArrayList();
        changedItems.forEach(changedItem -> {
            String[] changeInfo = changedItem.getPath().split("/");
            if (changeInfo.length < 2) {
                return;
            }
            Long stdBoId = Long.parseLong(changeInfo[1]);
            if (!stdBoIdMapping.containsKey(stdBoId)) {
                if (originStdBoUniIdVIdMapping.containsKey(stdBoId)) {
                    this.validateBoHasNoTenantBo((ChangedItem)changedItem, changeInfo, stdBoId, originStdBoUniIdVIdMapping, tenantPages, tenantForms, tenantFlows, tenantPageSettings, conflictItems);
                }
            } else {
                Bo tenantBo = (Bo)stdBoIdMapping.get(stdBoId);
                this.validateBoHasTenantBo((ChangedItem)changedItem, changeInfo, stdBoId, tenantBo, originStdBoUniIdVIdMapping, tenantPages, tenantForms, tenantFlows, tenantPageSettings, conflictItems, unConflictedItems);
            }
        });
        return new Tuple2((Object)conflictItems, (Object)unConflictedItems);
    }

    private void validateBoHasTenantBo(ChangedItem changedItem, String[] changeInfo, Long stdBoId, Bo tenantBo, Map<Long, Long> originStdBoUniIdVIdMapping, List<UltPage> tenantPages, List<UltForm> tenantForms, List<FlowSetting> tenantFlows, List<UltPageSetting> tenantPageSettings, List<String> conflictItems, List<String> unConflictedItems) {
        String validateTextPrefix = String.format("\u6807\u51c6\u5bf9\u8c61\uff08%s-%s\uff09", stdBoId, tenantBo.getCode());
        if (changeInfo.length == 2 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
            conflictItems.add(String.format("%s\u4e0d\u5b58\u5728, \u4f46\u5b58\u5728\u5b9a\u5236\u5bf9\u8c61", validateTextPrefix));
        } else if (changeInfo.length == 3 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
            unConflictedItems.add(String.format("%s\u7684\u5c5e\u6027\uff08%s - %s\uff09\u88ab\u4fee\u6539", validateTextPrefix, changeInfo[2], changedItem.getValue()));
        } else if (changeInfo.length == 4 && DiffType.ADD.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boIndexes".equals(changeInfo[2])) {
            Long stdBoIndexId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u7d22\u5f15\uff08%s\uff09\u65b0\u521b\u5efa", validateTextPrefix, stdBoIndexId));
        } else if (changeInfo.length == 4 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boIndexes".equals(changeInfo[2])) {
            Long stdBoIndexId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u7d22\u5f15\uff08%s\uff09\u4e0d\u5b58\u5728", validateTextPrefix, stdBoIndexId));
        } else if (changeInfo.length == 5 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boIndexes".equals(changeInfo[2])) {
            Long stdBoIndexId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u7d22\u5f15\uff08%s\uff09\u7684\u5c5e\u6027\uff08%s - %s\uff09\u88ab\u4fee\u6539", validateTextPrefix, stdBoIndexId, changeInfo[4], changedItem.getValue()));
        } else if (changeInfo.length == 4 && DiffType.ADD.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boRelationships".equals(changeInfo[2])) {
            Long stdBoRelId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u5173\u7cfb\uff08%s\uff09\u65b0\u521b\u5efa", validateTextPrefix, stdBoRelId));
        } else if (changeInfo.length == 4 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boRelationships".equals(changeInfo[2])) {
            Long stdBoRelId = Long.parseLong(changeInfo[3]);
            List<BoField> matchFields = this.getBoFieldUseRelationship(stdBoRelId, tenantBo);
            if (matchFields.isEmpty()) {
                unConflictedItems.add(String.format("%s\u7684\u5173\u7cfb\uff08%s\uff09\u4e0d\u5b58\u5728", validateTextPrefix, stdBoRelId));
            } else {
                StringBuilder stringBuilder = new StringBuilder(String.format("%s\u7684\u5173\u7cfb\uff08%s\uff09\u4e0d\u5b58\u5728, \u4f46\u5b58\u5728\u5b9a\u5236", validateTextPrefix, stdBoRelId));
                stringBuilder.append(String.format("\\n    \u8ba1\u7b97\u5b57\u6bb5\uff1a%s", matchFields.stream().map(BoField::getCode).collect(Collectors.joining(","))));
                conflictItems.add(stringBuilder.toString());
            }
        } else if (changeInfo.length == 4 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boRelationships".equals(changeInfo[2])) {
            Long stdBoRelId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u7d22\u5f15\uff08%s\uff09\u7684\u5c5e\u6027\uff08%s - %s\uff09\u88ab\u4fee\u6539", validateTextPrefix, stdBoRelId, changeInfo[4], changedItem.getValue()));
        } else if (changeInfo.length == 4 && DiffType.ADD.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boFields".equals(changeInfo[2])) {
            Long stdBoDataRuleId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u5b57\u6bb5\uff08%s\uff09\u65b0\u521b\u5efa", validateTextPrefix, stdBoDataRuleId));
        } else if (changeInfo.length == 4 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boFields".equals(changeInfo[2])) {
            Long stdBoFieldId = Long.parseLong(changeInfo[3]);
            BoField vStdBoField = this.boFieldRepository.getBoField(originStdBoUniIdVIdMapping.get(stdBoId), stdBoFieldId).orElse(null);
            if (null == vStdBoField) {
                throw new RuntimeException(String.format("\u6839\u636e\u5bf9\u8c61\u5feb\u7167Id %s \u5b57\u6bb5\u5168\u5c40Id %s, \u67e5\u8be2\u4e0d\u5230\u5feb\u7167\u5b57\u6bb5", originStdBoUniIdVIdMapping.get(stdBoId), stdBoFieldId));
            }
            List<BoIndex> matchBoIndexes = this.getBoIndexUseField(vStdBoField, tenantBo);
            List<BoDataRule> matchBoDataRules = this.getBoDataRuleUseField(vStdBoField, tenantBo);
            List<UltPage> matchUltPages = this.getUltPageUseField(vStdBoField, tenantBo.getCode(), tenantPages);
            List<UltForm> matchUltForms = this.getUltFormUseField(vStdBoField, tenantBo.getCode(), tenantForms);
            List<FlowSetting> matchFlows = this.getFlowSettingUseField(vStdBoField, tenantBo.getCode(), tenantFlows);
            List<UltPageSetting> matchUltPageSettings = this.getUltPageSettingUseField(vStdBoField, tenantBo.getCode(), tenantPageSettings);
            if (matchBoIndexes.isEmpty() && matchBoDataRules.isEmpty() && matchUltPages.isEmpty() && matchUltForms.isEmpty() && matchFlows.isEmpty()) {
                unConflictedItems.add(String.format("%s\u7684\u5b57\u6bb5\uff08%s\uff09\u4e0d\u5b58\u5728", validateTextPrefix, stdBoFieldId));
            } else {
                StringBuilder stringBuilder = new StringBuilder(String.format("%s\u7684\u5b57\u6bb5\uff08%s-%s\uff09\u4e0d\u5b58\u5728, \u4f46\u5b58\u5728\u5b9a\u5236", validateTextPrefix, stdBoFieldId, vStdBoField.getCode()));
                if (!matchBoIndexes.isEmpty()) {
                    stringBuilder.append(String.format("\n    \u7d22\u5f15\uff1a%s", matchBoIndexes.stream().map(BoIndex::getName).collect(Collectors.joining(","))));
                }
                if (!matchBoDataRules.isEmpty()) {
                    stringBuilder.append(String.format("\n    \u6570\u636e\u6743\u9650\uff1a%s", matchBoDataRules.stream().map(BoDataRule::getName).collect(Collectors.joining(","))));
                }
                if (!matchUltPages.isEmpty()) {
                    stringBuilder.append(String.format("\n    \u5217\u8868\u89c6\u56fe\uff1a%s", matchUltPages.stream().map(UltPage::getName).collect(Collectors.joining(","))));
                }
                if (!matchUltForms.isEmpty()) {
                    stringBuilder.append(String.format("\n    \u8868\u5355\u89c6\u56fe\uff1a%s", matchUltForms.stream().map(UltForm::getName).collect(Collectors.joining(","))));
                }
                if (!matchFlows.isEmpty()) {
                    stringBuilder.append(String.format("\n    \u6d41\uff1a%s", matchFlows.stream().map(FlowSetting::getName).collect(Collectors.joining(","))));
                }
                if (!matchUltPageSettings.isEmpty()) {
                    // empty if block
                }
                conflictItems.add(stringBuilder.toString());
            }
        } else if (changeInfo.length == 5 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boFields".equals(changeInfo[2])) {
            Long stdBoFieldId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u5b57\u6bb5\uff08%s\uff09\u7684\u5c5e\u6027\uff08%s - %s\uff09\u88ab\u4fee\u6539", validateTextPrefix, stdBoFieldId, changeInfo[4], changedItem.getValue()));
        } else if (changeInfo.length == 4 && DiffType.ADD.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boDataRules".equals(changeInfo[2])) {
            Long stdBoDataRuleId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u9ed8\u8ba4\u6743\u9650\u89c4\u5219\uff08%s\uff09\u65b0\u521b\u5efa", validateTextPrefix, stdBoDataRuleId));
        } else if (changeInfo.length == 4 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boDataRules".equals(changeInfo[2])) {
            Long stdBoDataRuleId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u9ed8\u8ba4\u6743\u9650\u89c4\u5219\uff08%s\uff09\u4e0d\u5b58\u5728", validateTextPrefix, stdBoDataRuleId));
        } else if (changeInfo.length == 5 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boDataRules".equals(changeInfo[2])) {
            Long stdBoDataRuleId = Long.parseLong(changeInfo[3]);
            unConflictedItems.add(String.format("%s\u7684\u9ed8\u8ba4\u6743\u9650\u89c4\u5219\uff08%s\uff09\u7684\u5c5e\u6027\uff08%s - %s\uff09\u88ab\u4fee\u6539", validateTextPrefix, stdBoDataRuleId, changeInfo[4], changedItem.getValue()));
        }
    }

    private void validateBoHasNoTenantBo(ChangedItem changedItem, String[] changeInfo, Long stdBoId, Map<Long, Long> originStdBoUniIdVIdMapping, List<UltPage> tenantPages, List<UltForm> tenantForms, List<FlowSetting> tenantFlows, List<UltPageSetting> tenantPageSettings, List<String> conflictItems) {
        if (changeInfo.length == 2 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
            Long vStdBoId = originStdBoUniIdVIdMapping.get(stdBoId);
            Bo vStdBo = this.boRepository.getBoWithValidate(vStdBoId);
            String validateTextPrefix = String.format("\u6807\u51c6\u5bf9\u8c61\uff08%s-%s\uff09", vStdBo.getUniqueId(), vStdBo.getCode());
            List<UltPage> matchUltPages = this.getUltPageUseStdBo(vStdBo, tenantPages);
            List<UltForm> matchUltForms = this.getUltFormUseStdBo(vStdBo, tenantForms);
            List<FlowSetting> matchFlows = this.getFlowSettingUseStdBo(vStdBo, tenantFlows);
            List<UltPageSetting> matchUltPageSettings = this.getUltPageSettingUseStdBo(vStdBo, tenantPageSettings);
            if (!(matchUltPages.isEmpty() && matchUltForms.isEmpty() && matchFlows.isEmpty())) {
                StringBuilder stringBuilder = new StringBuilder(String.format("%s\u5b58\u5728\u5b9a\u5236", validateTextPrefix));
                if (!matchUltPages.isEmpty()) {
                    stringBuilder.append(String.format("\\n    \u5217\u8868\u89c6\u56fe\uff1a%s", matchUltPages.stream().map(UltPage::getName).collect(Collectors.joining(","))));
                }
                if (!matchUltForms.isEmpty()) {
                    stringBuilder.append(String.format("\\n    \u8868\u5355\u89c6\u56fe\uff1a%s", matchUltForms.stream().map(UltForm::getName).collect(Collectors.joining(","))));
                }
                if (!matchFlows.isEmpty()) {
                    stringBuilder.append(String.format("\\n    \u6d41\uff1a%s", matchFlows.stream().map(FlowSetting::getName).collect(Collectors.joining(","))));
                }
                if (!matchUltPageSettings.isEmpty()) {
                    // empty if block
                }
                conflictItems.add(stringBuilder.toString());
            }
        } else if (changeInfo.length == 4 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "boFields".equals(changeInfo[2])) {
            Long vStdBoId = originStdBoUniIdVIdMapping.get(stdBoId);
            Bo vStdBo = this.boRepository.getBoWithValidate(vStdBoId);
            String validateTextPrefix = String.format("\u6807\u51c6\u5bf9\u8c61\uff08%s-%s\uff09", vStdBo.getUniqueId(), vStdBo.getCode());
            Long stdBoFieldId = Long.parseLong(changeInfo[3]);
            BoField vStdBoField = this.boFieldRepository.getBoField(originStdBoUniIdVIdMapping.get(stdBoId), stdBoFieldId).orElse(null);
            if (null == vStdBoField) {
                throw new RuntimeException(String.format("\u6839\u636e\u5bf9\u8c61\u5feb\u7167Id %s \u5b57\u6bb5\u5168\u5c40Id %s, \u67e5\u8be2\u4e0d\u5230\u5feb\u7167\u5b57\u6bb5", originStdBoUniIdVIdMapping.get(stdBoId), stdBoFieldId));
            }
            List<UltPage> matchUltPages = this.getUltPageUseField(vStdBoField, vStdBo.getCode(), tenantPages);
            List<UltForm> matchUltForms = this.getUltFormUseField(vStdBoField, vStdBo.getCode(), tenantForms);
            List<FlowSetting> matchFlows = this.getFlowSettingUseField(vStdBoField, vStdBo.getCode(), tenantFlows);
            List<UltPageSetting> matchUltPageSettings = this.getUltPageSettingUseField(vStdBoField, vStdBo.getCode(), tenantPageSettings);
            if (!(matchUltPages.isEmpty() && matchUltForms.isEmpty() && matchFlows.isEmpty())) {
                StringBuilder stringBuilder = new StringBuilder(String.format("%s\u7684\u5b57\u6bb5\uff08%s-%s\uff09\u4e0d\u5b58\u5728, \u4f46\u5b58\u5728\u5b9a\u5236", validateTextPrefix, stdBoFieldId, vStdBoField.getCode()));
                if (!matchUltPages.isEmpty()) {
                    stringBuilder.append(String.format("\n    \u5217\u8868\u89c6\u56fe\uff1a%s", matchUltPages.stream().map(UltPage::getName).collect(Collectors.joining(","))));
                }
                if (!matchUltForms.isEmpty()) {
                    stringBuilder.append(String.format("\n    \u8868\u5355\u89c6\u56fe\uff1a%s", matchUltForms.stream().map(UltForm::getName).collect(Collectors.joining(","))));
                }
                if (!matchFlows.isEmpty()) {
                    stringBuilder.append(String.format("\n    \u6d41\uff1a%s", matchFlows.stream().map(FlowSetting::getName).collect(Collectors.joining(","))));
                }
                if (!matchUltPageSettings.isEmpty()) {
                    // empty if block
                }
                conflictItems.add(stringBuilder.toString());
            }
        }
    }

    public Tuple2<List<String>, List<String>> validateDicts(List<ChangedItem> changedItems, List<Dict> tenantDicts, List<Bo> tenantBos, Map<Long, Long> originStdDictUniIdVIdMapping) {
        if (changedItems.isEmpty()) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        ArrayList conflictItems = Lists.newArrayList();
        ArrayList unConflictedItems = Lists.newArrayList();
        Map stdDictIdMapping = tenantDicts.stream().collect(Collectors.toMap(Dict::getRefDictId, Function.identity()));
        changedItems.forEach(changedItem -> {
            String[] changeInfo = changedItem.getPath().split("/");
            if (changeInfo.length < 2) {
                return;
            }
            Long stdDictId = Long.parseLong(changeInfo[1]);
            if (!stdDictIdMapping.containsKey(stdDictId)) {
                if (originStdDictUniIdVIdMapping.containsKey(stdDictId)) {
                    this.validateDictHasNoTenantDict((ChangedItem)changedItem, changeInfo, stdDictId, originStdDictUniIdVIdMapping, tenantBos, conflictItems);
                }
            } else {
                Dict tenantDict = (Dict)stdDictIdMapping.get(stdDictId);
                this.validateDictHasTenantDict((ChangedItem)changedItem, changeInfo, stdDictId, tenantDict, conflictItems, unConflictedItems);
            }
        });
        return new Tuple2((Object)conflictItems, (Object)unConflictedItems);
    }

    private void validateDictHasTenantDict(ChangedItem changedItem, String[] changeInfo, Long stdDictId, Dict tenantDict, List<String> conflictItems, List<String> unConflictedItems) {
        String validateTextPrefix = String.format("\u6807\u51c6\u5b57\u5178\uff08%s-%s\uff09", stdDictId, tenantDict.getCode());
        if (changeInfo.length == 2 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
            conflictItems.add(String.format("%s\u4e0d\u5b58\u5728, \u4f46\u5b58\u5728\u5b9a\u5236\u5b57\u5178", validateTextPrefix));
        } else if (changeInfo.length == 3 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
            unConflictedItems.add(String.format("%s\u7684\u5c5e\u6027\uff08%s - %s\uff09\u88ab\u4fee\u6539", validateTextPrefix, changeInfo[2], changedItem.getValue()));
        } else if (changeInfo.length == 4 && DiffType.ADD.equals((Object)DiffType.fromCode(changedItem.getOp())) && "dictDetails".equals(changeInfo[2])) {
            unConflictedItems.add(String.format("%s\u7684\u5b57\u5178\u9879\uff08%s\uff09\u65b0\u521b\u5efa", validateTextPrefix, changeInfo[3]));
        } else if (changeInfo.length == 4 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "dictDetails".equals(changeInfo[2])) {
            unConflictedItems.add(String.format("%s\u7684\u5b57\u5178\u9879\uff08%s\uff09\u4e0d\u5b58\u5728", validateTextPrefix, changeInfo[3]));
        } else if (changeInfo.length == 5 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "dictDetails".equals(changeInfo[2])) {
            unConflictedItems.add(String.format("%s\u7684\u5b57\u5178\u9879\uff08%s\uff09\u7684\u5c5e\u6027\uff08%s - %s\uff09\u88ab\u4fee\u6539", validateTextPrefix, changeInfo[3], changeInfo[4], changedItem.getValue()));
        }
    }

    private void validateDictHasNoTenantDict(ChangedItem changedItem, String[] changeInfo, Long stdDictId, Map<Long, Long> originStdDictUniIdVIdMapping, List<Bo> tenantBos, List<String> conflictItems) {
        if (changeInfo.length == 2 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
            Long vStdDictId = originStdDictUniIdVIdMapping.get(stdDictId);
            Dict vStdDict = this.dictRepository.getDictWithValidate(vStdDictId);
            String validateTextPrefix = String.format("\u6807\u51c6\u5b57\u5178\uff08%s-%s\uff09", vStdDictId, vStdDict.getCode());
            List<Tuple2<String, String>> matchBoFieldInfos = this.getBoFieldInfoUseStdDict(vStdDict, tenantBos);
            if (!matchBoFieldInfos.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder(String.format("%s\u5b58\u5728\u5b9a\u5236", validateTextPrefix));
                stringBuilder.append(String.format("\\n    %s", matchBoFieldInfos.stream().map(o -> String.format("\u5bf9\u8c61\uff1a%s \u5b57\u6bb5\uff1a%s", o._1(), o._2())).collect(Collectors.joining(","))));
                conflictItems.add(stringBuilder.toString());
            }
        }
    }

    public Tuple2<List<String>, List<String>> validatePages(List<ChangedItem> changedItems, List<UltPage> tenantPages) {
        if (changedItems.isEmpty()) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        ArrayList conflictItems = Lists.newArrayList();
        ArrayList unConflictedItems = Lists.newArrayList();
        Map stdPageIdMapping = tenantPages.stream().collect(Collectors.toMap(UltPage::getRefPageId, Function.identity()));
        changedItems.forEach(changedItem -> {
            String[] changeInfo = changedItem.getPath().split("/");
            if (changeInfo.length < 2) {
                return;
            }
            Long stdPageId = Long.parseLong(changeInfo[1]);
            if (!stdPageIdMapping.containsKey(stdPageId)) {
                return;
            }
            UltPage tenantPage = (UltPage)stdPageIdMapping.get(stdPageId);
            String validateTextPrefix = String.format("\u6807\u51c6\u9875\u9762\uff08%s-%s\uff09", stdPageId, tenantPage.getCode());
            if (changeInfo.length == 2 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
                conflictItems.add(String.format("%s\u4e0d\u5b58\u5728, \u5b58\u5728\u5b9a\u5236\u5217\u8868\u89c6\u56fe", validateTextPrefix));
            } else if (changeInfo.length == 3 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
                unConflictedItems.add(String.format("%s\u7684\u5c5e\u6027\uff08%s - %s\uff09\u88ab\u4fee\u6539", validateTextPrefix, changeInfo[2], changedItem.getValue()));
            } else if (changeInfo.length == 4 && DiffType.ADD.equals((Object)DiffType.fromCode(changedItem.getOp())) && "pageBoSettings".equals(changeInfo[2])) {
                unConflictedItems.add(String.format("%s\u7684\u9875\u9762\u914d\u7f6e\uff08%s\uff09\u65b0\u521b\u5efa", validateTextPrefix, changeInfo[3]));
            } else if (changeInfo.length == 4 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "pageBoSettings".equals(changeInfo[2])) {
                unConflictedItems.add(String.format("%s\u7684\u9875\u9762\u914d\u7f6e\uff08%s\uff09\u4e0d\u5b58\u5728", validateTextPrefix, changeInfo[3]));
            } else if (changeInfo.length == 5 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp())) && "pageBoSettings".equals(changeInfo[2])) {
                unConflictedItems.add(String.format("%s\u7684\u9875\u9762\u914d\u7f6e\uff08%s\uff09\u7684\uff08%s\uff09\u88ab\u4fee\u6539", validateTextPrefix, changeInfo[3], changeInfo[4]));
            }
        });
        return new Tuple2((Object)conflictItems, (Object)unConflictedItems);
    }

    public Tuple2<List<String>, List<String>> validateForms(List<ChangedItem> changedItems, List<UltForm> tenantForms) {
        if (changedItems.isEmpty()) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        ArrayList conflictItems = Lists.newArrayList();
        ArrayList unConflictedItems = Lists.newArrayList();
        Map stdFormIdMapping = tenantForms.stream().collect(Collectors.toMap(UltForm::getRefFormId, Function.identity()));
        changedItems.forEach(changedItem -> {
            String[] changeInfo = changedItem.getPath().split("/");
            if (changeInfo.length < 2) {
                return;
            }
            Long stdFormId = Long.parseLong(changeInfo[1]);
            if (!stdFormIdMapping.containsKey(stdFormId)) {
                return;
            }
            UltForm tenantForm = (UltForm)stdFormIdMapping.get(stdFormId);
            String validateTextPrefix = String.format("\u6807\u51c6\u8868\u5355\uff08%s-%s\uff09", stdFormId, tenantForm.getCode());
            if (changeInfo.length == 2 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
                conflictItems.add(String.format("%s\u4e0d\u5b58\u5728, \u5b58\u5728\u5b9a\u5236\u8868\u5355\u89c6\u56fe", validateTextPrefix));
            } else if (changeInfo.length == 3 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
                unConflictedItems.add(String.format("%s\u7684\u914d\u7f6e\uff08%s\uff09\u88ab\u4fee\u6539", validateTextPrefix, changeInfo[2]));
            }
        });
        return new Tuple2((Object)conflictItems, (Object)unConflictedItems);
    }

    public Tuple2<List<String>, List<String>> validateFlowSettings(List<ChangedItem> changedItems, List<FlowSetting> tenantFlows) {
        if (changedItems.isEmpty()) {
            return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        ArrayList conflictItems = Lists.newArrayList();
        ArrayList unConflictedItems = Lists.newArrayList();
        Map stdFlowIdMapping = tenantFlows.stream().collect(Collectors.toMap(FlowSetting::getRefFlowId, Function.identity()));
        changedItems.forEach(changedItem -> {
            String[] changeInfo = changedItem.getPath().split("/");
            if (changeInfo.length < 2) {
                return;
            }
            Long stdFlowId = Long.parseLong(changeInfo[1]);
            if (!stdFlowIdMapping.containsKey(stdFlowId)) {
                return;
            }
            FlowSetting tenantFlowSetting = (FlowSetting)stdFlowIdMapping.get(stdFlowId);
            String validateTextPrefix = String.format("\u6807\u51c6\u6d41\uff08%s-%s\uff09", stdFlowId, tenantFlowSetting.getCode());
            if (changeInfo.length == 2 && DiffType.REMOVE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
                conflictItems.add(String.format("%s\u4e0d\u5b58\u5728, \u5b58\u5728\u5b9a\u5236\u6d41\u914d\u7f6e", validateTextPrefix));
            } else if (changeInfo.length == 3 && DiffType.REPLACE.equals((Object)DiffType.fromCode(changedItem.getOp()))) {
                unConflictedItems.add(String.format("%s\u7684\u5c5e\u6027\uff08%s\uff09\u88ab\u4fee\u6539", validateTextPrefix, changeInfo[2]));
            }
        });
        return new Tuple2((Object)conflictItems, (Object)unConflictedItems);
    }

    public Tuple2<List<String>, List<String>> validatePageSettings(List<ChangedItem> changedItems, List<UltPageSetting> ultPageSettings) {
        return new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
    }

    public List<BoField> getBoFieldUseRelationship(Long stdBoRelId, Bo tenantBo) {
        List boFields = this.boFieldRepository.getBoFields(tenantBo.getId()).stream().filter(o -> Arrays.asList(FieldType.AGGREGATION.code(), FieldType.LOOKUP.code()).contains(o.getFieldType())).collect(Collectors.toList());
        if (boFields.isEmpty()) {
            return Lists.newArrayList();
        }
        List matchFieldIds = this.boFieldDomainAttributeRepository.getBoFieldDomainAttributesByFieldIds(boFields.stream().map(BoField::getId).collect(Collectors.toList())).stream().filter(o -> stdBoRelId.equals(o.getLookupRelationId()) || stdBoRelId.equals(o.getAggregationRelationId())).map(BoFieldDomainAttribute::getFieldId).collect(Collectors.toList());
        return boFields.stream().filter(o -> matchFieldIds.contains(o.getId())).collect(Collectors.toList());
    }

    public List<BoIndex> getBoIndexUseField(BoField vStdBoField, Bo tenantBo) {
        List boIndexes = this.boIndexRepository.getBoIndexes(tenantBo.getId());
        if (boIndexes.isEmpty()) {
            return Lists.newArrayList();
        }
        return boIndexes.stream().filter(o -> BoIndexUtil.getFieldCodeList((BoIndex)o).contains(vStdBoField.getCode())).collect(Collectors.toList());
    }

    public List<BoDataRule> getBoDataRuleUseField(BoField vStdBoField, Bo tenantBo) {
        List boDataRules = this.dataRuleRepository.getDefaultDataRules(tenantBo.getId());
        if (boDataRules.isEmpty()) {
            return Lists.newArrayList();
        }
        return boDataRules.stream().filter(o -> vStdBoField.getCode().equals(o.getRowField()) || StringUtils.isNotBlank((CharSequence)o.getRowRule()) && o.getRowRule().contains(vStdBoField.getCode())).collect(Collectors.toList());
    }

    public List<UltPage> getUltPageUseField(BoField vStdBoField, String boCode, List<UltPage> tenantPages) {
        List pageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByPageIdsWithoutSetting(tenantPages.stream().map(UltPage::getId).collect(Collectors.toList())).stream().filter(o -> boCode.equals(o.getBoCode())).collect(Collectors.toList());
        if (pageBoSettings.isEmpty()) {
            return Lists.newArrayList();
        }
        List pageIdsOfmatchBoCodePageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByIds(pageBoSettings.stream().map(PageBoSetting::getId).collect(Collectors.toList())).stream().filter(o -> PageFormBoSettingParseUtil.isFieldCodeExist((String)o.getSetting(), (String)vStdBoField.getCode())).map(PageBoSetting::getPageId).collect(Collectors.toList());
        return tenantPages.stream().filter(o -> pageIdsOfmatchBoCodePageBoSettings.contains(o.getId())).collect(Collectors.toList());
    }

    public List<UltForm> getUltFormUseField(BoField vStdBoField, String boCode, List<UltForm> tenantForms) {
        List matchBoCodeUltForms = tenantForms.stream().filter(o -> boCode.equals(o.getBoCode())).collect(Collectors.toList());
        if (matchBoCodeUltForms.isEmpty()) {
            return Lists.newArrayList();
        }
        return matchBoCodeUltForms.stream().filter(o -> PageFormBoSettingParseUtil.isFieldCodeExist((String)o.getSetting(), (String)vStdBoField.getCode())).collect(Collectors.toList());
    }

    public List<FlowSetting> getFlowSettingUseField(BoField vStdBoField, String boCode, List<FlowSetting> tenantFlows) {
        return tenantFlows.stream().filter(o -> FlowSettingUtil.isBoFieldCodeExist((String)o.getFlowSetting(), (String)boCode, (String)vStdBoField.getCode())).collect(Collectors.toList());
    }

    public List<UltPageSetting> getUltPageSettingUseField(BoField vStdBoField, String boCode, List<UltPageSetting> tenantPageSettings) {
        return Lists.newArrayList();
    }

    public List<UltPage> getUltPageUseStdBo(Bo stdBo, List<UltPage> tenantPages) {
        if (null == stdBo) {
            return Lists.newArrayList();
        }
        if (tenantPages.isEmpty()) {
            return Lists.newArrayList();
        }
        List pageIdsOfmatchBoCodePageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByPageIdsWithoutSetting(tenantPages.stream().map(UltPage::getId).collect(Collectors.toList())).stream().filter(o -> stdBo.getCode().equals(o.getBoCode())).map(PageBoSetting::getPageId).collect(Collectors.toList());
        if (pageIdsOfmatchBoCodePageBoSettings.isEmpty()) {
            return Lists.newArrayList();
        }
        return tenantPages.stream().filter(o -> pageIdsOfmatchBoCodePageBoSettings.contains(o.getId())).collect(Collectors.toList());
    }

    public List<UltForm> getUltFormUseStdBo(Bo stdBo, List<UltForm> tenantForms) {
        if (null == stdBo) {
            return Lists.newArrayList();
        }
        return tenantForms.stream().filter(o -> stdBo.getCode().equals(o.getBoCode())).collect(Collectors.toList());
    }

    public List<FlowSetting> getFlowSettingUseStdBo(Bo stdBo, List<FlowSetting> tenantFlowSettings) {
        if (null == stdBo) {
            return Lists.newArrayList();
        }
        if (tenantFlowSettings.isEmpty()) {
            return Lists.newArrayList();
        }
        return tenantFlowSettings.stream().filter(o -> FlowSettingUtil.isBoCodeExist((String)o.getFlowSetting(), (String)stdBo.getCode())).collect(Collectors.toList());
    }

    public List<UltPageSetting> getUltPageSettingUseStdBo(Bo stdBo, List<UltPageSetting> tenantPageSettings) {
        return Lists.newArrayList();
    }

    public List<Tuple2<String, String>> getBoFieldInfoUseStdDict(Dict stdDict, List<Bo> tenantBos) {
        if (null == stdDict) {
            return Lists.newArrayList();
        }
        Map boMap = tenantBos.stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        return this.boFieldRepository.getBoFieldsByBoIdsAndDictId(new ArrayList<Long>(boMap.keySet()), stdDict.getId()).stream().map(o -> new Tuple2((Object)((Bo)boMap.get(o.getBoId())).getCode(), (Object)o.getCode())).collect(Collectors.toList());
    }
}

