/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.bo.convertor;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleStatus;
import com.xforceplus.ultraman.bocp.metadata.version.query.DataRuleVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.vo.DataRuleBoVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageBoConvertor {
    @Autowired
    private DataRuleVersionQuery dataRuleVersionQuery;

    public IPage<DataRuleBoVo> toDataRuleBoVo(IPage<Bo> page, Long appId, Long envId) {
        List dataRuleVos = this.dataRuleVersionQuery.getDataRules(appId, envId);
        return page.convert(bo -> {
            DataRuleBoVo dataRuleBoVo = new DataRuleBoVo();
            dataRuleBoVo.setId(bo.getId());
            dataRuleBoVo.setPublishBoId(bo.getPublishBoId());
            dataRuleBoVo.setName(bo.getName());
            dataRuleBoVo.setCode(bo.getCode());
            List<Long> boIds = Arrays.asList(bo.getId(), bo.getPublishBoId());
            List matchedDataRules = dataRuleVos.stream().filter(v -> boIds.contains(v.getBoId()) || boIds.contains(v.getRefBoId())).collect(Collectors.toList());
            dataRuleBoVo.setDataRuleCount(Long.valueOf(matchedDataRules.size()));
            dataRuleBoVo.setDataRuleDisabledCount(Long.valueOf(matchedDataRules.stream().filter(v -> DataRuleStatus.DISABLED.code().equals(v.getStatus())).count()));
            return dataRuleBoVo;
        });
    }
}

