/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.AggregationType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldDescribeType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FuzzyType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.RelationType;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoInfoVo;
import com.xforceplus.ultraman.bocp.metadata.vo.DictVo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppBosExcelExporter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private XSSFWorkbook workbook;
    private XSSFSheet sheet;
    private List<BoInfoVo> boList;
    private Map<Long, BoInfoVo> boMap;
    private Map<String, DictVo> enumMap;
    private Map<String, Integer> sheetNames;
    private List<String> systemFieldCodes;

    public AppBosExcelExporter(List<BoInfoVo> boList, List<DictVo> listEnums, List<String> systemFieldCodes) {
        this.boList = boList.stream().sorted(Comparator.comparing(BoInfoVo::getCode)).collect(Collectors.toList());
        this.boMap = this.boList.stream().collect(Collectors.toMap(e -> e.getId(), Function.identity()));
        this.enumMap = listEnums.stream().collect(Collectors.toMap(e -> e.getId().toString(), Function.identity()));
        this.sheetNames = Maps.newHashMap();
        this.systemFieldCodes = systemFieldCodes;
        this.workbook = new XSSFWorkbook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(HttpServletResponse response) {
        this.sheetNames.clear();
        this.writeBoListHeaderLine();
        this.writeBoListDataLine();
        for (BoInfoVo boInfoVo : this.boList) {
            this.writeBoFieldsHeaderLine(boInfoVo);
            this.writeBoFieldsDataLine(boInfoVo);
        }
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            this.workbook.write((OutputStream)outputStream);
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
        finally {
            try {
                this.workbook.close();
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error("", (Throwable)e);
            }
        }
    }

    private void writeBoListHeaderLine() {
        this.sheet = this.workbook.createSheet("\u5bf9\u8c61\u5217\u8868");
        XSSFRow row = this.sheet.createRow(0);
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFFont font = this.workbook.createFont();
        font.setBold(true);
        font.setFontHeight(12.0);
        style.setFont((Font)font);
        int columnCount = 0;
        this.createCell((Row)row, columnCount++, "\u5bf9\u8c61ID", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u5bf9\u8c61\u540d\u79f0", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u5bf9\u8c61\u4ee3\u7801", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u5bf9\u8c61\u5907\u6ce8", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u79df\u6237\u5b9a\u5236", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u79df\u6237\u540d\u79f0", (CellStyle)style);
    }

    private void writeBoListDataLine() {
        int rowCount = 1;
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFFont font = this.workbook.createFont();
        font.setFontHeight(10.0);
        style.setFont((Font)font);
        for (BoInfoVo boInfoVo : this.boList) {
            XSSFRow row = this.sheet.createRow(rowCount++);
            int columnCount = 0;
            this.createCell((Row)row, columnCount++, String.valueOf(boInfoVo.getId()), (CellStyle)style);
            this.createCell((Row)row, columnCount++, boInfoVo.getName(), (CellStyle)style);
            this.createCell((Row)row, columnCount++, boInfoVo.getCode(), (CellStyle)style);
            this.createCell((Row)row, columnCount++, boInfoVo.getRemark(), (CellStyle)style);
            this.createCell((Row)row, columnCount++, boInfoVo.getRefBoId() == null ? "\u5426" : "\u662f", (CellStyle)style);
            this.createCell((Row)row, columnCount++, boInfoVo.getTenantName(), (CellStyle)style);
        }
    }

    private void writeBoFieldsHeaderLine(BoInfoVo boInfoVo) {
        if (boInfoVo.getRefBoId() == null) {
            this.sheet = this.workbook.createSheet(String.format("%s-%s", boInfoVo.getName(), boInfoVo.getCode()));
        } else {
            String sheetName = String.format("%s-%s(%s)", boInfoVo.getName(), boInfoVo.getCode(), boInfoVo.getTenantName());
            if (this.sheetNames.containsKey(sheetName)) {
                this.sheetNames.put(sheetName, this.sheetNames.get(sheetName) + 1);
                sheetName = String.format("%s-%s(%s)%d", boInfoVo.getName(), boInfoVo.getCode(), boInfoVo.getTenantName(), this.sheetNames.get(sheetName));
            } else {
                this.sheetNames.put(sheetName, 0);
            }
            this.sheet = this.workbook.createSheet(sheetName);
        }
        XSSFRow row = this.sheet.createRow(0);
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFFont font = this.workbook.createFont();
        font.setBold(true);
        font.setFontHeight(12.0);
        style.setFont((Font)font);
        int columnCount = 0;
        this.createCell((Row)row, columnCount++, "\u5b57\u6bb5ID", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u5b57\u6bb5\u540d\u79f0", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u5b57\u6bb5\u4ee3\u7801", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u5b57\u6bb5\u7c7b\u578b", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u5b9a\u4e49", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u9ed8\u8ba4\u503c", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u957f\u5ea6\uff08\u7cbe\u5ea6\uff09", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u53ef\u4fee\u6539", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u53ef\u641c\u7d22", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u6a21\u7cca\u7c7b\u578b", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u901a\u914d\u7b26\u957f\u5ea6\u4e0a\u9650", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u8868\u8ff0\u7c7b\u578b", (CellStyle)style);
        this.createCell((Row)row, columnCount++, "\u6821\u9a8c\uff08\u6b63\u5219\uff09", (CellStyle)style);
    }

    private void writeBoFieldsDataLine(BoInfoVo boInfoVo) {
        int rowCount = 1;
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFFont font = this.workbook.createFont();
        font.setFontHeight(10.0);
        style.setFont((Font)font);
        style.setWrapText(true);
        ArrayList orderedFields = Lists.newArrayList();
        orderedFields.addAll(boInfoVo.getFields().stream().filter(field -> !this.systemFieldCodes.contains(field.getCode())).collect(Collectors.toList()));
        orderedFields.addAll(boInfoVo.getFields().stream().filter(field -> this.systemFieldCodes.contains(field.getCode())).collect(Collectors.toList()));
        for (BoFieldVo boFieldVo : orderedFields) {
            XSSFRow row = this.sheet.createRow(rowCount++);
            int columnCount = 0;
            this.createCell((Row)row, columnCount++, boFieldVo.getId() != null ? String.valueOf(boFieldVo.getId()) : "", (CellStyle)style);
            this.createCell((Row)row, columnCount++, boFieldVo.getName(), (CellStyle)style);
            this.createCell((Row)row, columnCount++, boFieldVo.getCode(), (CellStyle)style);
            if ("relationship".equals(boFieldVo.getType())) {
                String desc = RelationType.fromType((String)boFieldVo.getRemark()) != null ? RelationType.fromType((String)boFieldVo.getRemark()).desc() : "";
                this.createCell((Row)row, columnCount++, "\u5173\u7cfb\u5b57\u6bb5", (CellStyle)style);
                this.createCell((Row)row, columnCount++, desc, (CellStyle)style);
            } else {
                this.createCell((Row)row, columnCount++, FieldType.getTrueValue((String)boFieldVo.getType()).desc(), (CellStyle)style);
                this.createCell((Row)row, columnCount++, this.getFieldDefinition(boFieldVo), (CellStyle)style);
            }
            this.createCell((Row)row, columnCount++, boFieldVo.getDefaultValue(), (CellStyle)style);
            this.createCell((Row)row, columnCount++, String.format("%s%s", boFieldVo.getMaxLength(), boFieldVo.getDecimalPoint() == null ? "" : "(" + boFieldVo.getDecimalPoint() + ")"), (CellStyle)style);
            this.createCell((Row)row, columnCount++, boFieldVo.getEditable() != null && boFieldVo.getEditable() != false ? "\u662f" : "\u5426", (CellStyle)style);
            this.createCell((Row)row, columnCount++, boFieldVo.getSearchable() != null && boFieldVo.getSearchable() != false ? "\u662f" : "\u5426", (CellStyle)style);
            this.createCell((Row)row, columnCount++, FuzzyType.fromCode((String)boFieldVo.getFuzzyType()) == null ? "" : FuzzyType.fromCode((String)boFieldVo.getFuzzyType()).desc(), (CellStyle)style);
            this.createCell((Row)row, columnCount++, boFieldVo.getWildcardMaxWidth(), (CellStyle)style);
            this.createCell((Row)row, columnCount++, FieldDescribeType.fromCode((String)boFieldVo.getDescribeType()).desc(), (CellStyle)style);
            this.createCell((Row)row, columnCount++, boFieldVo.getValidateRule(), (CellStyle)style);
        }
    }

    private void createCell(Row row, int columnCount, Object value, CellStyle style) {
        this.sheet.autoSizeColumn(columnCount);
        Cell cell = row.createCell(columnCount);
        if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else {
            cell.setCellValue((String)value);
        }
        cell.setCellStyle(style);
    }

    private String getFieldDefinition(BoFieldVo boFieldVo) {
        FieldType fieldType = FieldType.getTrueValue((String)boFieldVo.getType());
        switch (fieldType) {
            case ENUM: 
            case ENUMS: {
                if (this.enumMap.containsKey(boFieldVo.getEnumCode())) {
                    DictVo dictVo = this.enumMap.get(boFieldVo.getEnumCode());
                    return String.format("%s\uff08%s\uff09", dictVo.getName(), dictVo.getCode());
                }
                return "";
            }
            case DATETIME: {
                HashMap domainConfigDT = StringUtils.isEmpty((CharSequence)boFieldVo.getDomainConfig()) ? Maps.newHashMap() : (Map)JSON.parseObject((String)boFieldVo.getDomainConfig(), Map.class);
                String timeFormat = (String)domainConfigDT.get("timeFormat");
                if ("yyyy-MM-dd hh:mm:ss".equals(timeFormat)) {
                    return "\u5e74-\u6708-\u65e5 \u65f6:\u5206:\u79d2";
                }
                if ("yyyy-MM-dd".equals(timeFormat)) {
                    return "\u5e74-\u6708-\u65e5";
                }
                if ("yyyy-MM".equals(timeFormat)) {
                    return "\u5e74-\u6708";
                }
                if ("yyyy".equals(timeFormat)) {
                    return "\u5e74";
                }
                return "";
            }
            case FORMULA: {
                String failedMsg = boFieldVo.getFailedPolicy() == null ? "" : (boFieldVo.getFailedPolicy().equals(1) ? "\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff0c\u6570\u636e\u65e0\u6cd5\u843d\u8868" : (boFieldVo.getFailedPolicy().equals(2) ? "\u8fd4\u56de\u9884\u8bbe\u9ed8\u8ba4\u503c\uff0c\u6570\u636e\u53ef\u4ee5\u843d\u8868" : ""));
                return String.format("\u8fd4\u56de\u503c\u7c7b\u578b\uff1a%s \n\u8868\u8fbe\u5f0f\uff1a%s \n\u5f53\u516c\u5f0f\u65e0\u6cd5\u8fd0\u7b97\u65f6\uff1a%s  \n", FieldType.getValue((String)boFieldVo.getValueType()).desc(), boFieldVo.getFormulaContent(), failedMsg);
            }
            case DOMAINNO: {
                return boFieldVo.getDomainNoContent();
            }
            case LOOKUP: {
                BoInfoVo toOneBo = this.boMap.get(boFieldVo.getLookupBoId());
                if (toOneBo == null) {
                    return "\u5bf9\u4e00\u5173\u7cfb\u5bf9\u8c61\u7f3a\u5931";
                }
                Optional<BoFieldVo> toOneFieldOptl = toOneBo.getFields().stream().filter(field -> field.getId().equals(boFieldVo.getLookupFieldId())).findAny();
                if (!toOneFieldOptl.isPresent()) {
                    return "\u67e5\u627e\u5b57\u6bb5\u7f3a\u5931";
                }
                return String.format("\u5bf9\u4e00\u5173\u7cfb\u5bf9\u8c61\uff1a%s(%s) \n\u67e5\u627e\u5b57\u6bb5\uff1a%s(%s)  \n", toOneBo.getName(), toOneBo.getCode(), toOneFieldOptl.get().getName(), toOneFieldOptl.get().getCode());
            }
            case AGGREGATION: {
                Optional aggreFieldOptl;
                BoInfoVo aggreBo = this.boMap.get(boFieldVo.getAggregationBoId());
                if (aggreBo == null) {
                    return "\u805a\u5408\u5bf9\u8c61\u7f3a\u5931";
                }
                AggregationType aggreType = AggregationType.fromCode((String)boFieldVo.getAggregationType());
                if (aggreType == null) {
                    return "\u805a\u5408\u7c7b\u578b\u7f3a\u5931";
                }
                String aggreFieldName = "\u65e0";
                Optional<Object> optional = aggreFieldOptl = boFieldVo.getAggregationFieldId() == null ? Optional.empty() : aggreBo.getFields().stream().filter(field -> field.getId().equals(boFieldVo.getAggregationFieldId())).findAny();
                if (aggreFieldOptl.isPresent()) {
                    aggreFieldName = String.format("%s(%s)", ((BoFieldVo)aggreFieldOptl.get()).getName(), ((BoFieldVo)aggreFieldOptl.get()).getCode());
                }
                return String.format("\u805a\u5408\u5bf9\u8c61\uff1a%s(%s) \n\u805a\u5408\u7c7b\u578b\uff1a%s(%s) \n\u8981\u805a\u5408\u7684\u5b57\u6bb5: %s  \n", aggreBo.getName(), aggreBo.getCode(), aggreType.desc(), aggreType.name().toLowerCase(), aggreFieldName);
            }
            case PHONE: {
                HashMap domainConfigPh = StringUtils.isEmpty((CharSequence)boFieldVo.getDomainConfig()) ? Maps.newHashMap() : (Map)JSON.parseObject((String)boFieldVo.getDomainConfig(), Map.class);
                String phoneType = (String)domainConfigPh.get("phoneType");
                if ("1".equals(phoneType)) {
                    return "\u624b\u673a";
                }
                if ("2".equals(phoneType)) {
                    return "\u5176\u5b83";
                }
                return "";
            }
            case EMAIL: {
                HashMap domainConfigEm = StringUtils.isEmpty((CharSequence)boFieldVo.getDomainConfig()) ? Maps.newHashMap() : (Map)JSON.parseObject((String)boFieldVo.getDomainConfig(), Map.class);
                Integer emailType = (Integer)domainConfigEm.get("emailType");
                if (emailType == null) {
                    return "";
                }
                if (emailType.equals(1)) {
                    return "\u4e0d\u9650";
                }
                if (emailType.equals(2)) {
                    ArrayList emailSuffix = domainConfigEm.get("emailSuffix") == null ? Lists.newArrayList() : ((JSONArray)domainConfigEm.get("emailSuffix")).toJavaList(String.class);
                    return emailSuffix == null ? "" : emailSuffix.stream().collect(Collectors.joining(","));
                }
                return "";
            }
            case AREAS: {
                HashMap domainConfigAr = StringUtils.isEmpty((CharSequence)boFieldVo.getDomainConfig()) ? Maps.newHashMap() : (Map)JSON.parseObject((String)boFieldVo.getDomainConfig(), Map.class);
                String areaType = (String)domainConfigAr.get("areaType");
                if ("1".equals(areaType)) {
                    return "\u7701-\u5e02-\u533a\u53bf-\u8857\u9053";
                }
                if ("2".equals(areaType)) {
                    return "\u7701-\u5e02-\u533a\u53bf";
                }
                if ("3".equals(areaType)) {
                    return "\u7701-\u5e02";
                }
                if ("4".equals(areaType)) {
                    return "\u7701";
                }
                return "";
            }
            case AMOUNT: 
            case PERCENTAGE: {
                HashMap domainConfigAP = StringUtils.isEmpty((CharSequence)boFieldVo.getDomainConfig()) ? Maps.newHashMap() : (Map)JSON.parseObject((String)boFieldVo.getDomainConfig(), Map.class);
                Integer min = (Integer)domainConfigAP.get("min");
                Integer max = (Integer)domainConfigAP.get("max");
                if (min == null && max == null) {
                    return "\u4e0d\u9650";
                }
                return String.format("\u6700\u5c0f\u503c\uff1a%s\uff0c\u6700\u5927\u503c\uff1a%s", min == null ? "\u4e0d\u9650" : min.toString(), max == null ? "\u4e0d\u9650" : max.toString());
            }
            case FILE: {
                HashMap domainConfigFile = StringUtils.isEmpty((CharSequence)boFieldVo.getDomainConfig()) ? Maps.newHashMap() : (Map)JSON.parseObject((String)boFieldVo.getDomainConfig(), Map.class);
                return String.format("\u6587\u4ef6\u6570\u91cf\u4e0a\u9650\uff1a%s \n\u5355\u4e2a\u6587\u4ef6\u5927\u5c0f\u4e0a\u9650\uff1a%smb \n\u53ef\u4e0a\u4f20\u7c7b\u578b\uff1a%s  \n", domainConfigFile.get("fileCountLimit"), domainConfigFile.get("fileSizeLimit"), domainConfigFile.get("fileAcceptType"));
            }
            case IMAGE: {
                HashMap domainConfigImage = StringUtils.isEmpty((CharSequence)boFieldVo.getDomainConfig()) ? Maps.newHashMap() : (Map)JSON.parseObject((String)boFieldVo.getDomainConfig(), Map.class);
                return String.format("\u56fe\u7247\u6570\u91cf\u4e0a\u9650\uff1a%s \n\u5355\u4e2a\u56fe\u7247\u5927\u5c0f\u4e0a\u9650\uff1a%s  \n", domainConfigImage.get("fileCountLimit"), domainConfigImage.get("fileSizeLimit"));
            }
        }
        return "";
    }
}

