/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.AggregationType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.DomainNoType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.RelationType;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.enums.SysType;
import com.xforceplus.ultraman.bocp.metadata.setting.BoFieldSetting;
import com.xforceplus.ultraman.bocp.metadata.version.query.BoVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.vo.AppErVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoErVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldReferenceVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoRelErVo;
import com.xforceplus.ultraman.bocp.metadata.web.service.IBoGraphService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldDomainAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoRelationshipService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoService;
import com.xforceplus.ultraman.metadata.repository.bocp.mapper.BoFieldDomainAttributeExMapper;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRelationshipRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.extend.BoExtendQuery;
import com.xforceplus.ultraman.metadata.repository.extend.BoFieldExtendQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BoGraphServiceImpl
implements IBoGraphService {
    private static final Logger log = LoggerFactory.getLogger(BoGraphServiceImpl.class);
    private final String regex = "\\$\\{[a-z][a-zA-Z0-9_#]*\\}";
    @Autowired
    private BoRelationshipRepository boRelationshipRepository;
    @Autowired
    private BoFieldRepository boFieldRepository;
    @Autowired
    private BoExtendQuery boExtendQuery;
    @Autowired
    private BoFieldExtendQuery boFieldExtendQuery;
    @Autowired
    private IBoService boService;
    @Autowired
    private IBoFieldService boFieldService;
    @Autowired
    private IBoRelationshipService boRelationshipService;
    @Autowired
    private IBoFieldDomainAttributeService boFieldDomainAttributeService;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private BoVersionQuery boVersionQuery;
    @Autowired
    private BoFieldDomainAttributeExMapper boFieldDomainAttributeExMapper;

    @Override
    public AppErVo getAppErs(Long appId) {
        List bos = this.boRepository.getBos(appId.longValue()).stream().filter(bo -> !SysType.SYSTEM.code().equals(bo.getSysType())).collect(Collectors.toList());
        if (bos.isEmpty()) {
            return new AppErVo();
        }
        List boIds = bos.stream().map(Bo::getId).collect(Collectors.toList());
        Map fieldMap = this.boFieldService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoField::getBoId, boIds)).eq(BoField::getDeleteFlag, (Object)"1")).stream().collect(Collectors.toMap(BoField::getId, Function.identity()));
        AppErVo appErVo = new AppErVo();
        ArrayList nodes = Lists.newArrayList();
        ArrayList edges = Lists.newArrayList();
        for (Bo bo2 : bos) {
            List boFields = this.boFieldService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoField::getBoId, (Object)bo2.getId())).eq(BoField::getDeleteFlag, (Object)"1"));
            BoErVo boEr = BoStructMapper.MAPPER.toBoErVo(bo2);
            boEr.setBoFields(boFields.stream().map(arg_0 -> ((BoFieldStructMapper)BoFieldStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList()));
            if (bo2.getParentBoId() != null) {
                BoRelErVo boRelErVo = new BoRelErVo();
                boRelErVo.setRelationName("\u7236\u7c7b");
                boRelErVo.setRelationCode("level" + bo2.getLevel());
                boRelErVo.setRelationType("PARENT");
                boRelErVo.setBoId(bo2.getId());
                boRelErVo.setJoinBoId(bo2.getParentBoId());
                boRelErVo.setLevel(bo2.getLevel());
                edges.add(boRelErVo);
                boEr.setHasRel(true);
            }
            List boRelationships = this.boRelationshipService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoRelationship::getBoId, (Object)bo2.getId())).eq(BoRelationship::getDeleteFlag, (Object)"1"));
            boRelationships.forEach(boRel -> {
                BoRelErVo boRelErVo = new BoRelErVo();
                boRelErVo.setId(boRel.getId());
                boRelErVo.setRelationCode(boRel.getRelationCode());
                boRelErVo.setRelationName(boRel.getRelationName());
                boRelErVo.setRelationType(boRel.getRelationType());
                boRelErVo.setBoId(boRel.getBoId());
                boRelErVo.setJoinBoId(boRel.getJoinBoId());
                boRelErVo.setBoFieldId(boRel.getBoField());
                boRelErVo.setJoinFieldId(boRel.getJoinField());
                if (boRel.getBoField() == null) {
                    boRelErVo.setBoFieldCode("id");
                } else {
                    Optional.ofNullable(fieldMap.get(boRel.getBoField())).ifPresent(field -> boRelErVo.setBoFieldCode(field.getCode()));
                }
                if (boRel.getJoinField() == null) {
                    boRelErVo.setJoinFieldCode("id");
                } else {
                    Optional.ofNullable(fieldMap.get(boRel.getJoinField())).ifPresent(field -> boRelErVo.setJoinFieldCode(field.getCode()));
                }
                edges.add(boRelErVo);
                boEr.setHasRel(true);
            });
            nodes.add(boEr);
        }
        appErVo.setBos((List)nodes);
        appErVo.setRelations(edges.stream().filter(boRel -> boIds.contains(boRel.getBoId()) && boIds.contains(boRel.getJoinBoId())).collect(Collectors.toList()));
        return appErVo;
    }

    @Override
    public AppErVo getBoErs(Long boId) {
        return this.buildBoEr(boId);
    }

    @Override
    public BoFieldReferenceVo getFieldLinks(Long fieldId) {
        BoField boField = (BoField)this.boFieldService.getById((Serializable)fieldId);
        Bo bo = (Bo)this.boService.getById((Serializable)boField.getBoId());
        ArrayList<String> linkKeys = new ArrayList<String>();
        String fromKey = String.format("%s-%s", this.getBoId(bo), this.getBoFieldId(boField));
        return this.buildBoFieldReferenceVo(linkKeys, fromKey, null, bo, boField);
    }

    @Override
    public BoFieldReferenceVo getPublishedFieldLinks(Long appVersionId, Long boId, Long fieldId) {
        Optional<Bo> pBoOptl = this.boVersionQuery.getBos(appVersionId).stream().filter(bo -> bo.getPublishBoId().equals(boId)).findAny();
        if (!pBoOptl.isPresent()) {
            return null;
        }
        Optional<BoField> pBoFieldOptl = this.boFieldRepository.getBoFields(pBoOptl.get().getId()).stream().filter(field -> field.getPublishFieldId().equals(fieldId)).findAny();
        if (!pBoFieldOptl.isPresent()) {
            return null;
        }
        return this.getFieldLinks(pBoFieldOptl.get().getId());
    }

    @Override
    public List<BoFieldVo> getPublishedFieldsInLink(Long appVersionId, Long boId) {
        Optional<Bo> pBoOptl = this.boVersionQuery.getBos(appVersionId).stream().filter(bo -> bo.getPublishBoId().equals(boId)).findAny();
        if (!pBoOptl.isPresent()) {
            return null;
        }
        List pBoFields = this.boFieldRepository.getBoFields(pBoOptl.get().getId());
        Map pBoFieldsMap = pBoFields.stream().collect(Collectors.toMap(BoField::getCode, Function.identity()));
        HashMap fieldsInLink = Maps.newHashMap();
        List<BoField> formulaFields = pBoFields.stream().filter(f -> FieldType.FORMULA.code().equals(f.getFieldType())).collect(Collectors.toList());
        formulaFields.forEach(f -> {
            BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)this.boFieldDomainAttributeService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldDomainAttribute::getFieldId, (Object)f.getId())).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1"), false);
            List<String> fieldCodes = this.getFieldCodes(domainAttribute.getFormulaContent());
            fieldsInLink.putIfAbsent(f.getCode(), f);
            fieldCodes.forEach(fCode -> Optional.ofNullable(pBoFieldsMap.get(fCode)).ifPresent(field -> fieldsInLink.putIfAbsent(fCode, field)));
        });
        List<BoField> aggregationFields = pBoFields.stream().filter(f -> FieldType.AGGREGATION.code().equals(f.getFieldType())).collect(Collectors.toList());
        aggregationFields.forEach(f -> fieldsInLink.putIfAbsent(f.getCode(), f));
        List<BoField> lookupFields = pBoFields.stream().filter(f -> FieldType.LOOKUP.code().equals(f.getFieldType())).collect(Collectors.toList());
        lookupFields.forEach(f -> fieldsInLink.putIfAbsent(f.getCode(), f));
        List<BoField> domainNoFields = pBoFields.stream().filter(f -> FieldType.DOMAINNO.code().equals(f.getFieldType())).collect(Collectors.toList());
        domainNoFields.forEach(f -> {
            ArrayList fieldCodes;
            BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)this.boFieldDomainAttributeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldDomainAttribute::getFieldId, (Object)f.getId())).eq(BoFieldDomainAttribute::getDomainNoSenior, (Object)DomainNoType.SENIOR.code())).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1"), false);
            List<Object> list = fieldCodes = domainAttribute == null ? Lists.newArrayList() : this.getFieldCodes(domainAttribute.getDomainNoContent());
            if (CollectionUtils.isNotEmpty((Collection)fieldCodes)) {
                fieldsInLink.putIfAbsent(f.getCode(), f);
                fieldCodes.forEach(fCode -> Optional.ofNullable(pBoFieldsMap.get(fCode)).ifPresent(field -> fieldsInLink.putIfAbsent(fCode, field)));
            }
        });
        List otherFields = pBoFields.stream().filter(f -> !fieldsInLink.keySet().contains(f.getCode())).collect(Collectors.toList());
        List boRelationships = this.boRelationshipRepository.getBoRelationships(pBoOptl.get().getId());
        if (!boRelationships.isEmpty() && !otherFields.isEmpty()) {
            List joinBoIds = boRelationships.stream().map(BoRelationship::getJoinBoId).collect(Collectors.toList());
            Map otherFieldMap = otherFields.stream().collect(Collectors.toMap(BoField::getId, Function.identity()));
            List beFieldsAggreInfo = this.boFieldDomainAttributeExMapper.findFieldsBindByAggregation(joinBoIds, pBoOptl.get().getId(), otherFieldMap.keySet().stream().collect(Collectors.toList()));
            beFieldsAggreInfo.forEach(f -> Optional.ofNullable(otherFieldMap.get(f.getAggregationFieldId())).ifPresent(field -> fieldsInLink.putIfAbsent(field.getCode(), field)));
            List beFieldsLookupInfo = this.boFieldDomainAttributeExMapper.findFieldsBindByLookup(joinBoIds, pBoOptl.get().getId(), otherFieldMap.keySet().stream().collect(Collectors.toList()));
            beFieldsLookupInfo.forEach(f -> Optional.ofNullable(otherFieldMap.get(f.getLookupFieldId())).ifPresent(field -> fieldsInLink.putIfAbsent(field.getCode(), field)));
        }
        return fieldsInLink.values().stream().map(f -> {
            f.setId(f.getPublishFieldId());
            return BoFieldStructMapper.MAPPER.toVo(f);
        }).collect(Collectors.toList());
    }

    private AppErVo buildBoEr(Long boId) {
        Bo bo = (Bo)this.boService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getId, (Object)boId)).eq(Bo::getDeleteFlag, (Object)"1"), false);
        List boFields = this.boFieldRepository.getBoFields(bo.getId());
        BoErVo boErVo = BoStructMapper.MAPPER.toBoErVo(bo);
        boErVo.setBoFields(boFields.stream().map(arg_0 -> ((BoFieldStructMapper)BoFieldStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList()));
        boErVo.setCurrent(true);
        HashMap boMap = Maps.newHashMap();
        ArrayList boRelations = Lists.newArrayList();
        if (bo.getParentBoId() != null) {
            BoRelErVo boRelErVo = new BoRelErVo();
            boRelErVo.setRelationName("\u7236\u7c7b");
            boRelErVo.setRelationCode("level0");
            boRelErVo.setRelationType("PARENT");
            boRelErVo.setBoId(bo.getId());
            boRelErVo.setJoinBoId(bo.getParentBoId());
            boRelErVo.setLevel(bo.getLevel());
            boRelations.add(boRelErVo);
        }
        this.buildBoRelEr(bo.getId(), boRelations, boMap);
        List pBos = this.boExtendQuery.getParentSimpleBos(boId).stream().map(parentBo -> {
            BoErVo pBo = new BoErVo();
            pBo.setId(parentBo.getId());
            pBo.setCode(parentBo.getCode());
            pBo.setName(parentBo.getName());
            pBo.setBoFields(parentBo.getBoFields());
            pBo.setLevel(parentBo.getLevel());
            pBo.setParent(parentBo.isParent());
            pBo.setParentBoId(parentBo.getParentBoId());
            pBo.setParent(true);
            if (pBo.getParentBoId() != null) {
                BoRelErVo pBoRelErVo = new BoRelErVo();
                pBoRelErVo.setRelationName("\u7236\u7c7b");
                pBoRelErVo.setRelationCode("level" + pBo.getLevel());
                pBoRelErVo.setRelationType("PARENT");
                pBoRelErVo.setBoId(pBo.getId());
                pBoRelErVo.setJoinBoId(pBo.getParentBoId());
                pBoRelErVo.setLevel(pBo.getLevel());
                boRelations.add(pBoRelErVo);
            }
            this.buildBoRelEr(pBo.getId(), boRelations, boMap);
            return pBo;
        }).collect(Collectors.toList());
        boMap.putAll(pBos.stream().collect(Collectors.toMap(BoErVo::getCode, Function.identity())));
        AppErVo appErVo = new AppErVo();
        appErVo.setBos(boMap.values().stream().collect(Collectors.toList()));
        appErVo.getBos().add(boErVo);
        List boIds = appErVo.getBos().stream().map(BoErVo::getId).collect(Collectors.toList());
        appErVo.setRelations(boRelations.stream().filter(boRel -> boIds.contains(boRel.getBoId()) && boIds.contains(boRel.getJoinBoId())).collect(Collectors.toList()));
        return appErVo;
    }

    private void buildBoRelEr(Long boId, List<BoRelErVo> boRelations, Map<String, BoErVo> boMap) {
        List boRelationships = this.boRelationshipService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoRelationship::getBoId, (Object)boId)).eq(BoRelationship::getDeleteFlag, (Object)"1"));
        boRelationships.forEach(boRel -> {
            BoField boField;
            BoRelErVo boRelErVo = new BoRelErVo();
            boRelErVo.setId(boRel.getId());
            boRelErVo.setRelationCode(boRel.getRelationCode());
            boRelErVo.setRelationName(boRel.getRelationName());
            boRelErVo.setRelationType(boRel.getRelationType());
            boRelErVo.setBoId(boId);
            boRelErVo.setJoinBoId(boRel.getJoinBoId());
            boRelErVo.setBoFieldId(boRel.getBoField());
            boRelErVo.setJoinFieldId(boRel.getJoinField());
            if (boRelErVo.getBoFieldId() != null) {
                boField = (BoField)this.boFieldService.getById((Serializable)boRelErVo.getBoFieldId());
                if (boField != null) {
                    boRelErVo.setBoFieldCode(boField.getCode());
                }
            } else {
                boRelErVo.setBoFieldCode("id");
            }
            if (boRelErVo.getJoinFieldId() != null) {
                boField = (BoField)this.boFieldService.getById((Serializable)boRelErVo.getJoinFieldId());
                if (boField != null) {
                    boRelErVo.setJoinFieldCode(boField.getCode());
                }
            } else {
                boRelErVo.setJoinFieldCode("id");
            }
            boRelations.add(boRelErVo);
            Bo joinBo = (Bo)this.boService.getById((Serializable)boRel.getJoinBoId());
            List joinBoFields = this.boFieldRepository.getBoFields(boRel.getJoinBoId());
            BoErVo boEr = new BoErVo();
            boEr.setId(joinBo.getId());
            boEr.setName(joinBo.getName());
            boEr.setCode(joinBo.getCode());
            boEr.setLevel(joinBo.getLevel());
            boEr.setBoFields(joinBoFields.stream().map(arg_0 -> ((BoFieldStructMapper)BoFieldStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList()));
            boMap.put(boEr.getCode(), boEr);
        });
    }

    private List<BoFieldReferenceVo> getBoFieldRefers(List<String> linkKeys, BoField boField) {
        Bo bo = (Bo)this.boService.getById((Serializable)boField.getBoId());
        String fromKey = String.format("%s-%s", this.getBoId(bo), this.getBoFieldId(boField));
        ArrayList boFieldReferVos = Lists.newArrayList();
        if (BoFieldSetting.computeFieldTypeCodes.contains(boField.getFieldType())) {
            BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)this.boFieldDomainAttributeService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldDomainAttribute::getFieldId, (Object)boField.getId())).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1"), false);
            if (FieldType.LOOKUP.code().equals(boField.getFieldType())) {
                BoFieldReferenceVo boFieldReferenceVo = this.buildBoFieldReferenceVo(linkKeys, fromKey, FieldType.LOOKUP, domainAttribute.getLookupFieldId());
                if (null != boFieldReferenceVo) {
                    boFieldReferenceVo.setValueType(domainAttribute.getValueType());
                    boFieldReferVos.add(boFieldReferenceVo);
                    BoRelationship boRelationship = (BoRelationship)this.boRelationshipService.getById((Serializable)domainAttribute.getLookupRelationId());
                    boFieldReferenceVo.setRelationCode(null == boRelationship ? null : boRelationship.getRelationCode());
                }
            } else if (FieldType.AGGREGATION.code().equals(boField.getFieldType())) {
                BoFieldReferenceVo boFieldReferenceVo = null;
                if (AggregationType.COUNT.code().equals(domainAttribute.getAggregationType())) {
                    Optional<BoField> idFieldOptl = this.boFieldExtendQuery.getAllFields(domainAttribute.getAggregationBoId()).stream().filter(f -> "id".equals(f.getCode())).findAny();
                    if (idFieldOptl.isPresent()) {
                        boFieldReferenceVo = this.buildBoFieldReferenceVo(linkKeys, fromKey, FieldType.AGGREGATION, idFieldOptl.get());
                    }
                } else {
                    boFieldReferenceVo = this.buildBoFieldReferenceVo(linkKeys, fromKey, FieldType.AGGREGATION, domainAttribute.getAggregationFieldId());
                }
                if (null != boFieldReferenceVo) {
                    boFieldReferenceVo.setValueType(domainAttribute.getValueType());
                    boFieldReferenceVo.setAggregationType(domainAttribute.getAggregationType());
                    boFieldReferenceVo.setDomainCondition(domainAttribute.getDomainCondition());
                    boFieldReferenceVo.setUiConfig(domainAttribute.getUiConfig());
                    BoRelationship boRelationship = (BoRelationship)this.boRelationshipService.getById((Serializable)domainAttribute.getAggregationRelationId());
                    boFieldReferenceVo.setRelationCode(null == boRelationship ? null : boRelationship.getRelationCode());
                    boFieldReferVos.add(boFieldReferenceVo);
                }
            } else if (FieldType.FORMULA.code().equals(boField.getFieldType()) || FieldType.DOMAINNO.code().equals(boField.getFieldType())) {
                List<String> fieldCodes = this.getFieldCodes(FieldType.FORMULA.code().equals(boField.getFieldType()) ? domainAttribute.getFormulaContent() : domainAttribute.getDomainNoContent());
                ArrayList fields = fieldCodes.isEmpty() ? Lists.newArrayList() : this.boFieldService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoField::getBoId, (Object)boField.getBoId())).in(BoField::getCode, fieldCodes)).eq(BoField::getDeleteFlag, (Object)"1"));
                boFieldReferVos.addAll(fields.stream().map(f -> {
                    BoFieldReferenceVo boFieldReferenceVo = this.buildBoFieldReferenceVo(linkKeys, fromKey, FieldType.getTrueValue((String)boField.getFieldType()), (BoField)f);
                    if (null != boFieldReferenceVo) {
                        boFieldReferenceVo.setValueType(domainAttribute.getValueType());
                        boFieldReferenceVo.setFailedPolicy(domainAttribute.getFailedPolicy());
                        boFieldReferenceVo.setFormulaContent(domainAttribute.getFormulaContent());
                    }
                    return boFieldReferenceVo;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        return boFieldReferVos.stream().collect(Collectors.toList());
    }

    private List<BoFieldReferenceVo> getBoFieldReferreds(List<String> linkKeys, BoField boField) {
        List<BoRelationship> otmRels;
        Bo bo = (Bo)this.boService.getById((Serializable)boField.getBoId());
        List rels = this.boRelationshipService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoRelationship::getBoId, (Object)bo.getId())).ne(BoRelationship::getJoinBoId, (Object)bo.getId())).eq(BoRelationship::getDeleteFlag, (Object)"1"));
        List boFields = this.boFieldRepository.getBoFields(bo.getId());
        String fromKey = String.format("%s-%s", this.getBoId(bo), this.getBoFieldId(boField));
        ArrayList boFieldReferredVos = Lists.newArrayList();
        List<BoRelationship> mtoRels = rels.stream().filter(rel -> RelationType.MTO.code().equals(rel.getRelationType())).collect(Collectors.toList());
        if (!mtoRels.isEmpty()) {
            mtoRels.forEach(rel -> {
                List aggFields = this.boFieldRepository.getBoFields(rel.getJoinBoId()).stream().filter(f -> FieldType.AGGREGATION.code().equals(f.getFieldType())).collect(Collectors.toList());
                boFieldReferredVos.addAll(aggFields.stream().map(f -> {
                    BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)this.boFieldDomainAttributeService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldDomainAttribute::getFieldId, (Object)f.getId())).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1"), false);
                    if (boField.getId().equals(domainAttribute.getAggregationFieldId())) {
                        BoFieldReferenceVo boFieldReferenceVo = this.buildBoFieldReferenceVo(linkKeys, fromKey, FieldType.AGGREGATION, (BoField)f);
                        if (null != boFieldReferenceVo) {
                            boFieldReferenceVo.setValueType(domainAttribute.getValueType());
                            boFieldReferenceVo.setAggregationType(domainAttribute.getAggregationType());
                            boFieldReferenceVo.setDomainCondition(domainAttribute.getDomainCondition());
                            boFieldReferenceVo.setUiConfig(domainAttribute.getUiConfig());
                            BoRelationship boRelationship = (BoRelationship)this.boRelationshipService.getById((Serializable)domainAttribute.getAggregationRelationId());
                            boFieldReferenceVo.setRelationCode(null == boRelationship ? null : boRelationship.getRelationCode());
                        }
                        return boFieldReferenceVo;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
            });
        }
        if (!(otmRels = rels.stream().filter(rel -> RelationType.OTM.code().equals(rel.getRelationType())).collect(Collectors.toList())).isEmpty()) {
            otmRels.forEach(rel -> {
                List lookupFields = this.boFieldRepository.getBoFields(rel.getJoinBoId()).stream().filter(f -> FieldType.LOOKUP.code().equals(f.getFieldType())).collect(Collectors.toList());
                boFieldReferredVos.addAll(lookupFields.stream().map(f -> {
                    BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)this.boFieldDomainAttributeService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldDomainAttribute::getFieldId, (Object)f.getId())).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1"), false);
                    if (boField.getId().equals(domainAttribute.getLookupFieldId())) {
                        BoFieldReferenceVo boFieldReferenceVo = this.buildBoFieldReferenceVo(linkKeys, fromKey, FieldType.LOOKUP, (BoField)f);
                        if (null != boFieldReferenceVo) {
                            boFieldReferenceVo.setValueType(domainAttribute.getValueType());
                            BoRelationship boRelationship = (BoRelationship)this.boRelationshipService.getById((Serializable)domainAttribute.getLookupRelationId());
                            boFieldReferenceVo.setRelationCode(null == boRelationship ? null : boRelationship.getRelationCode());
                        }
                        return boFieldReferenceVo;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
            });
        }
        List formulaFields = boFields.stream().filter(f -> FieldType.FORMULA.code().equals(f.getFieldType())).collect(Collectors.toList());
        boFieldReferredVos.addAll(formulaFields.stream().map(f -> {
            BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)this.boFieldDomainAttributeService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldDomainAttribute::getFieldId, (Object)f.getId())).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1"), false);
            List<String> fieldCodes = this.getFieldCodes(domainAttribute.getFormulaContent());
            if (fieldCodes.contains(boField.getCode())) {
                BoFieldReferenceVo boFieldReferenceVo = this.buildBoFieldReferenceVo(linkKeys, fromKey, FieldType.FORMULA, (BoField)f);
                if (null != boFieldReferenceVo) {
                    boFieldReferenceVo.setValueType(domainAttribute.getValueType());
                    boFieldReferenceVo.setFailedPolicy(domainAttribute.getFailedPolicy());
                    boFieldReferenceVo.setFormulaContent(domainAttribute.getFormulaContent());
                }
                return boFieldReferenceVo;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        List domainNoFields = boFields.stream().filter(f -> FieldType.DOMAINNO.code().equals(f.getFieldType())).collect(Collectors.toList());
        boFieldReferredVos.addAll(domainNoFields.stream().map(f -> {
            ArrayList fieldCodes;
            BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)this.boFieldDomainAttributeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldDomainAttribute::getFieldId, (Object)f.getId())).eq(BoFieldDomainAttribute::getDomainNoSenior, (Object)DomainNoType.SENIOR.code())).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1"), false);
            List<Object> list = fieldCodes = domainAttribute == null ? Lists.newArrayList() : this.getFieldCodes(domainAttribute.getDomainNoContent());
            if (fieldCodes.contains(boField.getCode())) {
                BoFieldReferenceVo boFieldReferenceVo = this.buildBoFieldReferenceVo(linkKeys, fromKey, FieldType.DOMAINNO, (BoField)f);
                if (null != boFieldReferenceVo) {
                    boFieldReferenceVo.setValueType(domainAttribute.getValueType());
                    boFieldReferenceVo.setNoModel(domainAttribute.getNoModel());
                    boFieldReferenceVo.setResetType(domainAttribute.getResetType());
                    boFieldReferenceVo.setDomainNoSenior(domainAttribute.getDomainNoSenior());
                    boFieldReferenceVo.setDomainNoContent(domainAttribute.getDomainNoContent());
                }
                return boFieldReferenceVo;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        return boFieldReferredVos;
    }

    private BoFieldReferenceVo buildBoFieldReferenceVo(List<String> linkKeys, String fromKey, FieldType fieldType, Long boFieldId) {
        BoField boField = (BoField)this.boFieldService.getById((Serializable)boFieldId);
        Bo bo = (Bo)this.boService.getById((Serializable)boField.getBoId());
        return this.buildBoFieldReferenceVo(linkKeys, fromKey, fieldType, bo, boField);
    }

    private BoFieldReferenceVo buildBoFieldReferenceVo(List<String> linkKeys, String fromKey, FieldType fieldType, BoField boField) {
        Bo bo = (Bo)this.boService.getById((Serializable)boField.getBoId());
        return this.buildBoFieldReferenceVo(linkKeys, fromKey, fieldType, bo, boField);
    }

    private BoFieldReferenceVo buildBoFieldReferenceVo(List<String> linkKeys, String fromKey, FieldType fieldType, Bo bo, BoField boField) {
        if (null != fieldType) {
            String linkKey = String.format("%s-%s-%s-%s", fromKey, fieldType.code(), this.getBoId(bo), this.getBoFieldId(boField));
            String rLinkKey = String.format("%s-%s-%s-%s", this.getBoId(bo), this.getBoFieldId(boField), fieldType.code(), fromKey);
            if (linkKeys.contains(linkKey) || linkKeys.contains(rLinkKey)) {
                return null;
            }
            linkKeys.add(linkKey);
        }
        BoFieldReferenceVo fieldReference = new BoFieldReferenceVo();
        fieldReference.setId(this.getBoFieldId(boField));
        fieldReference.setName(boField.getName());
        fieldReference.setCode(boField.getCode());
        fieldReference.setFieldType(boField.getFieldType());
        fieldReference.setBoId(this.getBoId(bo));
        fieldReference.setBoCode(bo.getCode());
        fieldReference.setBoName(bo.getName());
        fieldReference.setReferFields(this.getBoFieldRefers(linkKeys, boField));
        fieldReference.setReferredFields(this.getBoFieldReferreds(linkKeys, boField));
        return fieldReference;
    }

    public List<String> getFieldCodes(String content) {
        Matcher matcher = Pattern.compile("\\$\\{[a-z][a-zA-Z0-9_#]*\\}").matcher(content);
        ArrayList patternStrs = Lists.newArrayList();
        while (matcher.find()) {
            patternStrs.add(matcher.group());
        }
        return patternStrs.stream().map(pStr -> pStr.substring(2, pStr.length() - 1)).collect(Collectors.toList());
    }

    private Long getBoId(Bo bo) {
        return bo.getPublishBoId() != null ? bo.getPublishBoId() : bo.getId();
    }

    private Long getBoFieldId(BoField boField) {
        return boField.getPublishFieldId() != null ? boField.getPublishFieldId() : boField.getId();
    }
}

