/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.builder.BoFieldVoBuilder;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.SupportFileType;
import com.xforceplus.ultraman.bocp.metadata.service.IAppExService;
import com.xforceplus.ultraman.bocp.metadata.service.IAppModuleExService;
import com.xforceplus.ultraman.bocp.metadata.service.IBoExService;
import com.xforceplus.ultraman.bocp.metadata.service.IDictExService;
import com.xforceplus.ultraman.bocp.metadata.setting.BoFieldSetting;
import com.xforceplus.ultraman.bocp.metadata.system.SystemSettingsHolder;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoInfoVo;
import com.xforceplus.ultraman.bocp.metadata.vo.DictDetailVo;
import com.xforceplus.ultraman.bocp.metadata.vo.DictVo;
import com.xforceplus.ultraman.bocp.metadata.vo.ImportBoVo;
import com.xforceplus.ultraman.bocp.metadata.vo.QueryBoVo;
import com.xforceplus.ultraman.bocp.metadata.vo.QueryDictVo;
import com.xforceplus.ultraman.bocp.metadata.web.excel.AppBosExcelExporter;
import com.xforceplus.ultraman.bocp.metadata.web.service.IExportImportService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExportImportServiceImpl
implements IExportImportService {
    private static final Logger log = LoggerFactory.getLogger(ExportImportServiceImpl.class);
    private final Pattern patternForDouble = Pattern.compile(".0$");
    @Autowired
    private SystemSettingsHolder systemSettingsHolder;
    @Autowired
    private IAppModuleExService appModuleExService;
    @Autowired
    private IAppExService appExService;
    @Autowired
    private IBoExService boExService;
    @Autowired
    private IDictExService dictExService;

    @Override
    public void downloadDictTemplate(HttpServletResponse response) throws IOException {
        this.downloadTemplate("dict-import-template.xlsx", response);
    }

    @Override
    public void downloadBoTemplate(HttpServletResponse response) throws IOException {
        this.downloadTemplate("bo-import-template.xlsx", response);
    }

    @Override
    public void exportBosToExcel(Long appId, List<Long> boIds, boolean includeRefBo, boolean allSelected, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        String currentDateTime = dateFormatter.format(new Date());
        String headerKey = "Content-Disposition";
        String headerValue = String.format("attachment; filename=app-%s-bos-%s.%s", appId, currentDateTime, "xlsx");
        response.setHeader(headerKey, headerValue);
        List boInfoVos = allSelected ? this.appModuleExService.getBoInfos(new QueryBoVo().setAppId(appId).setBoType(BoType.ENTITY.code()).setIncludeRefBo(Boolean.valueOf(includeRefBo))) : (CollectionUtils.isNotEmpty(boIds) ? (includeRefBo ? this.boExService.getBoInfos((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Bo::getId, boIds)).eq(Bo::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(Bo::getDeleteFlag, (Object)"1")).or()).in(Bo::getRefBoId, boIds)).eq(Bo::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(Bo::getDeleteFlag, (Object)"1")) : this.boExService.getBoInfos((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Bo::getId, boIds)).eq(Bo::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(Bo::getDeleteFlag, (Object)"1"))) : Lists.newArrayList());
        QueryDictVo queryDictVo = new QueryDictVo();
        queryDictVo.setAppId(appId);
        List dictVos = this.dictExService.getDictsAllInfo(queryDictVo);
        AppBosExcelExporter excelExporter = new AppBosExcelExporter(boInfoVos, dictVos, this.systemSettingsHolder.getCodes());
        excelExporter.export(response);
    }

    @Override
    public ServiceResponse importDicts(Long appId, Boolean camelcase, MultipartFile file) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(file.getInputStream());
        int count = workbook.getNumberOfSheets();
        if (count <= 0) {
            return ServiceResponse.fail((String)"\u5bfc\u5165\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9");
        }
        ArrayList dictVos = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            Iterator rows = sheet.iterator();
            DictVo dictVo = null;
            ArrayList dictDetailVos = Lists.newArrayList();
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                if (row.getRowNum() == 1) {
                    dictVo = new DictVo();
                    dictVo.setCode(this.parseCell(row.getCell(0)));
                    dictVo.setName(this.parseCell(row.getCell(1)));
                    dictVo.setRemark(this.parseCell(row.getCell(1)));
                    continue;
                }
                if (row.getRowNum() < 4) continue;
                DictDetailVo dictDetailVo = new DictDetailVo();
                dictDetailVo.setValue(this.parseCell(row.getCell(0)));
                dictDetailVo.setText(this.parseCell(row.getCell(1)));
                dictDetailVos.add(dictDetailVo);
            }
            if (dictVo == null) {
                return ServiceResponse.fail((String)String.format("Sheet - %s \u6ca1\u6709\u5b57\u5178\u4fe1\u606f", sheet.getSheetName()));
            }
            if (dictDetailVos.isEmpty()) {
                return ServiceResponse.fail((String)String.format("Sheet - %s \u6ca1\u6709\u5b57\u5178\u9879\u4fe1\u606f", sheet.getSheetName()));
            }
            dictVo.setOptions((List)dictDetailVos);
            dictVos.add(dictVo);
        }
        return this.appExService.saveDicts(appId, (List)dictVos);
    }

    @Override
    public ServiceResponse importBos(Long appId, Boolean camelcase, String fileType, String boType, MultipartFile file) throws IOException {
        SupportFileType supportFileType = SupportFileType.fromCode((String)fileType);
        if (SupportFileType.XLSX.equals((Object)supportFileType)) {
            return this.importBosByXlsx(appId, camelcase, boType, file);
        }
        if (SupportFileType.JSON.equals((Object)supportFileType)) {
            return this.importBosByJson(appId, camelcase, file);
        }
        return ServiceResponse.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u77e5\u7684\u5bfc\u5165\u7c7b\u578b");
    }

    private String parseCell(Cell cell) {
        String value = null;
        switch (cell.getCellType()) {
            case STRING: {
                value = cell.getStringCellValue().trim();
                break;
            }
            case NUMERIC: {
                Double valueDouble = cell.getNumericCellValue();
                value = valueDouble.toString();
                boolean b = value.contains("E");
                int indexOfPoint = value.indexOf(".");
                if (b) {
                    int indexOfE = value.indexOf("E");
                    BigInteger xs = new BigInteger(value.substring(indexOfPoint + BigInteger.ONE.intValue(), indexOfE));
                    int pow = Integer.parseInt(value.substring(indexOfE + BigInteger.ONE.intValue()));
                    int xsLen = xs.toByteArray().length;
                    int scale = xsLen - pow > 0 ? xsLen - pow : 0;
                    String format = "%." + scale + "f";
                    value = String.format(format, valueDouble);
                    break;
                }
                Matcher m = this.patternForDouble.matcher(value);
                if (!m.find()) break;
                value = value.replace(".0", "");
                break;
            }
            case BOOLEAN: 
            case FORMULA: {
                break;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadTemplate(String filename, HttpServletResponse response) throws IOException {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment;filename=%s", filename));
        FileInputStream fis = null;
        OutputStream os = null;
        try {
            File file = new File("/" + filename);
            fis = new FileInputStream(file);
            if (fis == null) {
                log.error("\u6587\u4ef6\u627e\u4e0d\u5230");
                return;
            }
            response.setHeader("Content-Length", String.valueOf(fis.available()));
            byte[] bytes = new byte[fis.available()];
            fis.read(bytes);
            os = response.getOutputStream();
            os.write(bytes);
            os.flush();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private ServiceResponse importBosByXlsx(Long appId, Boolean camelcase, String boType, MultipartFile file) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(file.getInputStream());
        int count = workbook.getNumberOfSheets();
        if (count <= 0) {
            return ServiceResponse.fail((String)"\u5bfc\u5165\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9");
        }
        Map<String, String> fieldTypeMap = BoFieldSetting.importFieldTypes.stream().collect(Collectors.toMap(FieldType::desc, FieldType::code));
        ArrayList boInfoVos = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            Iterator rows = sheet.iterator();
            BoInfoVo boInfoVo = null;
            ArrayList boFieldVos = Lists.newArrayList();
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                if (row.getRowNum() == 1) {
                    boInfoVo = new BoInfoVo();
                    boInfoVo.setBoType(boType);
                    boInfoVo.setName(this.parseCell(row.getCell(0)));
                    boInfoVo.setCode(this.parseCell(row.getCell(1)));
                    boInfoVo.setRemark(boInfoVo.getName());
                    continue;
                }
                if (row.getRowNum() < 4) continue;
                BoFieldVo boFieldVo = new BoFieldVo();
                boFieldVo.setName(this.parseCell(row.getCell(0)));
                boFieldVo.setCode(this.parseCell(row.getCell(1)));
                boFieldVo.setType(this.parseCell(row.getCell(2)));
                boFieldVo.setType(BoFieldSetting.fieldTypeDescs((String)"boIndex").contains(boFieldVo.getType()) ? fieldTypeMap.get(boFieldVo.getType()) : boFieldVo.getType());
                if (!BoFieldSetting.fieldTypeCodes((String)"boIndex").contains(boFieldVo.getType())) {
                    return ServiceResponse.fail((String)String.format("\u5bfc\u5165\u5bf9\u8c61-{}-{}, \u5b57\u6bb5-{}-{}\u7c7b\u578b{}\u4e0d\u5728\u5141\u8bb8\u5bfc\u5165\u8303\u56f4\uff0c\u5141\u8bb8\u5bfc\u5165\u7684\u5b57\u6bb5\u7c7b\u578b\u6709{}", boInfoVo.getName(), boInfoVo.getCode(), boFieldVo.getName(), boFieldVo.getCode(), boFieldVo.getType(), BoFieldSetting.fieldTypeDescs((String)"boIndex").stream().collect(Collectors.joining(","))));
                }
                BoFieldVoBuilder.buildDefault((FieldType)FieldType.getTrueValue((String)boFieldVo.getType()), (BoFieldVo)boFieldVo);
                boFieldVos.add(boFieldVo);
            }
            if (boInfoVo == null) {
                return ServiceResponse.fail((String)String.format("Sheet - %s \u6ca1\u6709\u5bf9\u8c61\u4fe1\u606f", sheet.getSheetName()));
            }
            if (boFieldVos.isEmpty()) {
                return ServiceResponse.fail((String)String.format("Sheet - %s \u6ca1\u6709\u5b57\u6bb5\u4fe1\u606f", sheet.getSheetName()));
            }
            boInfoVo.setFields((List)boFieldVos);
            boInfoVos.add(boInfoVo);
        }
        return CollectionUtils.isEmpty((Collection)boInfoVos) ? ServiceResponse.fail((String)"\u83b7\u53d6\u5bf9\u8c61\u6570\u636e\u4e3a\u7a7a\uff0c\u5bfc\u5165\u7ec8\u6b62") : this.appModuleExService.importBoInfoVos(appId, (List)boInfoVos, camelcase);
    }

    private ServiceResponse importBosByJson(Long appId, Boolean camelcase, MultipartFile file) {
        List importBoVos = null;
        try {
            String body = IOUtils.toString((InputStream)file.getInputStream(), (String)StandardCharsets.UTF_8.name());
            importBoVos = JSON.parseArray((String)body, ImportBoVo.class);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return CollectionUtils.isEmpty(importBoVos) ? ServiceResponse.fail((String)"\u83b7\u53d6\u5bf9\u8c61\u6570\u636e\u4e3a\u7a7a\uff0c\u5bfc\u5165\u7ec8\u6b62") : this.appModuleExService.importBos(appId, importBoVos, camelcase);
    }
}

