/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.handler;

import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.exception.ValidateException;
import com.xforceplus.ultraman.bocp.metadata.service.IBoExService;
import com.xforceplus.ultraman.bocp.metadata.vo.BoInfoVo;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.QueryHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.GetBoInfosByTenantQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.tenant.BoTenantQuery;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantBoExService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetBoInfosByTenantQueryHandler
implements QueryHandler<GetBoInfosByTenantQuery, List<BoInfoVo>> {
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private BoTenantQuery boTenantQuery;
    @Autowired
    private IBoExService boExService;
    @Autowired
    private ITenantBoExService tenantBoExService;

    @Override
    public List<BoInfoVo> handleStandard(GetBoInfosByTenantQuery query) {
        return CollectionUtils.isEmpty(query.getBoIds()) ? Lists.newArrayList() : query.getBoIds().stream().map(boId -> this.boExService.getBoInfoByTenant(boId, query.getTenantCode())).collect(Collectors.toList());
    }

    @Override
    public List<BoInfoVo> handleTenant(GetBoInfosByTenantQuery query) {
        return CollectionUtils.isEmpty(query.getBoIds()) ? Lists.newArrayList() : query.getBoIds().stream().map(boId -> {
            Bo bo = this.boRepository.getBoWithValidateSkipDataAuth(boId);
            if (null == bo.getRefBoId()) {
                Bo tenantBo = this.boTenantQuery.geTenantBo(boId, query.getTenantCode());
                if (null == tenantBo) {
                    throw new ValidateException(String.format("\u6839\u636e\u5bf9\u8c61ID %s \u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61", boId));
                }
                return this.tenantBoExService.getBoInfoById(tenantBo.getId());
            }
            return this.tenantBoExService.getBoInfoById(boId);
        }).collect(Collectors.toList());
    }

    @Override
    public List<BoInfoVo> handleCustom(GetBoInfosByTenantQuery query) {
        return null;
    }
}

