/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.handler;

import com.xforceplus.ultraman.bocp.metadata.flow.vo.FlowSettingVo;
import com.xforceplus.ultraman.bocp.metadata.service.IFlowSettingExService;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.QueryHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.GetFlowsQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantFlowSettingExService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetFlowsQueryHandler
implements QueryHandler<GetFlowsQuery, List<FlowSettingVo>> {
    @Autowired
    private IFlowSettingExService flowSettingExService;
    @Autowired
    private ITenantFlowSettingExService tenantFlowSettingExService;

    @Override
    public List<FlowSettingVo> handleStandard(GetFlowsQuery query) {
        return this.flowSettingExService.getFlowVos(query.getFlowSetting()).stream().map(o -> {
            o.setAppCustomType(AppCustomType.STANDARD.code());
            return o;
        }).collect(Collectors.toList());
    }

    @Override
    public List<FlowSettingVo> handleTenant(GetFlowsQuery query) {
        FlowSetting flowSetting = query.getFlowSetting();
        List result = this.tenantFlowSettingExService.getFlowVos(flowSetting);
        if (StringUtils.isNotBlank((CharSequence)flowSetting.getFlowType())) {
            result = result.stream().filter(r -> flowSetting.getFlowType().equals(r.getFlowType())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)flowSetting.getName())) {
            result = result.stream().filter(r -> r.getName().contains(flowSetting.getName())).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<FlowSettingVo> handleCustom(GetFlowsQuery query) {
        return null;
    }
}

