/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.handler;

import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltFormStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.service.IUltFormExService;
import com.xforceplus.ultraman.bocp.metadata.view.vo.UltFormExVo;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.QueryHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.GetFormsQuery;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantUltFormExService;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetFormsQueryHandler
implements QueryHandler<GetFormsQuery, List<UltFormExVo>> {
    @Autowired
    private IUltFormExService ultFormExService;
    @Autowired
    private ITenantUltFormExService tenantUltFormExService;

    @Override
    public List<UltFormExVo> handleStandard(GetFormsQuery query) {
        return this.ultFormExService.getForms(query.getUltForm()).stream().map(o -> {
            UltFormExVo ultFormExVo = UltFormStructMapper.MAPPER.toUltFormExVo(o);
            ultFormExVo.setAppCustomType(AppCustomType.STANDARD.code());
            return ultFormExVo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<UltFormExVo> handleTenant(GetFormsQuery query) {
        UltForm ultForm = query.getUltForm();
        List result = this.tenantUltFormExService.getForms(ultForm);
        if (StringUtils.isNotBlank((CharSequence)ultForm.getCode())) {
            result = result.stream().filter(r -> r.getName().contains(ultForm.getCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)ultForm.getName())) {
            result = result.stream().filter(r -> r.getName().contains(ultForm.getName())).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<UltFormExVo> handleCustom(GetFormsQuery query) {
        return null;
    }
}

