/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.rule.util;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.rule.enums.FunctionStatus;
import com.xforceplus.ultraman.bocp.metadata.rule.mapstruct.SueFunctionStructMapper;
import com.xforceplus.ultraman.bocp.metadata.rule.request.FunctionAddRequest;
import com.xforceplus.ultraman.bocp.metadata.rule.request.FunctionParam;
import com.xforceplus.ultraman.bocp.metadata.rule.vo.FunctionTagVo;
import com.xforceplus.ultraman.bocp.metadata.rule.vo.FunctionWithParamWrapper;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueFunction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueFunctionParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Converter {
    public static List<SueFunctionParam> convertToSueFunctionList(List<FunctionParam> request, Long functionId, String appId) {
        return request.stream().map(item -> {
            SueFunctionParam param = new SueFunctionParam();
            param.setFunctionId(functionId);
            param.setAppId(appId);
            param.setId(item.getId());
            param.setParamName(item.getParamName());
            param.setParamType(item.getParamType());
            param.setParamObjCode(item.getParamObjCode());
            param.setParamDirect(item.getParamDirect());
            param.setParamSort(item.getParamSort());
            param.setRequired(item.getRequired());
            param.setParamClassification(item.getParamClassification());
            return param;
        }).collect(Collectors.toList());
    }

    public static SueFunction convertToSueFunction(FunctionAddRequest request) {
        SueFunction sueFunction = new SueFunction();
        sueFunction.setAppId(request.getAppId());
        sueFunction.setFunctionContent(request.getFunctionContent());
        sueFunction.setFunctionDesc(request.getFunctionDesc());
        sueFunction.setFunctionExample(request.getFunctionExample());
        sueFunction.setFunctionName(request.getFunctionName());
        sueFunction.setFunctionType(request.getFunctionType());
        sueFunction.setTagCode(request.getTagCode());
        sueFunction.setFunctionStatus(FunctionStatus.NORMAL.value());
        sueFunction.setId(request.getFunctionId());
        return sueFunction;
    }

    public static IPage<FunctionWithParamWrapper> convertToFunctionWrapper(final IPage<FunctionTagVo> functions, List<SueFunctionParam> params) {
        Map<Long, List<SueFunctionParam>> maps = params.stream().collect(Collectors.groupingBy(SueFunctionParam::getFunctionId));
        final List wrappers = functions.getRecords().stream().map(fun -> {
            FunctionWithParamWrapper wrapper = new FunctionWithParamWrapper();
            wrapper.setFunction(fun);
            wrapper.setParams(maps.get(fun.getId()) != null ? (List)maps.get(fun.getId()) : Lists.newArrayList());
            return wrapper;
        }).collect(Collectors.toList());
        return new IPage<FunctionWithParamWrapper>(){

            public List<OrderItem> orders() {
                return Lists.newArrayList();
            }

            public List<FunctionWithParamWrapper> getRecords() {
                return wrappers;
            }

            public IPage<FunctionWithParamWrapper> setRecords(List<FunctionWithParamWrapper> records) {
                return null;
            }

            public long getTotal() {
                return functions.getTotal();
            }

            public IPage<FunctionWithParamWrapper> setTotal(long total) {
                return null;
            }

            public long getSize() {
                return functions.getSize();
            }

            public IPage<FunctionWithParamWrapper> setSize(long size) {
                return null;
            }

            public long getCurrent() {
                return functions.getCurrent();
            }

            public IPage<FunctionWithParamWrapper> setCurrent(long current) {
                return null;
            }
        };
    }

    public static List<FunctionWithParamWrapper> convertToFunctionWrapper(List<SueFunction> functions, List<SueFunctionParam> params) {
        Map<Long, List<SueFunctionParam>> maps = params.stream().collect(Collectors.groupingBy(SueFunctionParam::getFunctionId));
        List<FunctionWithParamWrapper> wrappers = functions.stream().map(fun -> {
            FunctionWithParamWrapper wrapper = new FunctionWithParamWrapper();
            wrapper.setFunction(SueFunctionStructMapper.MAPPER.toFunctionFlagVo(fun));
            wrapper.setParams(maps.get(fun.getId()) != null ? (List)maps.get(fun.getId()) : Lists.newArrayList());
            return wrapper;
        }).collect(Collectors.toList());
        return wrappers;
    }
}

