/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.xforceplus.ultraman.bocp.metadata.enums.DataBaseType;
import com.xforceplus.ultraman.bocp.metadata.web.datasource.DBUtilErrorCode;
import com.xforceplus.ultraman.bocp.metadata.web.datasource.DbConstant;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DbUtil.class);
    private static final Integer SINGLE_THREAD_COUNT = 1;
    private static final Integer OB10_URL_PARTS = 3;
    private static final Integer TIMEOUT_SECONDS = 15;
    private static final ThreadLocal<ExecutorService> RS_EXECUTORS = ThreadLocal.withInitial(() -> Executors.newFixedThreadPool(SINGLE_THREAD_COUNT, new ThreadFactoryBuilder().setNameFormat("rsExecutors-%d").setDaemon(true).build()));

    public static Connection getConnection(DataBaseType dataBaseType, String jdbcUrl, String username, String password, String ... socketTimeout) {
        try {
            String timeout = socketTimeout.length > 0 ? socketTimeout[0] : String.valueOf(172800000);
            return DbUtil.connect(dataBaseType, jdbcUrl, username, password, timeout);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25. \u56e0\u4e3a\u6839\u636e\u60a8\u914d\u7f6e\u7684\u8fde\u63a5\u4fe1\u606f:%s\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", jdbcUrl), e);
        }
    }

    private static Connection connect(DataBaseType dataBaseType, String url, String user, String pass, String socketTimeout) {
        if (url.startsWith("||_dsc_ob10_dsc_||") && dataBaseType == DataBaseType.MySql) {
            String[] ss = url.split("\\|\\|_dsc_ob10_dsc_\\|\\|");
            if (ss.length != OB10_URL_PARTS) {
                throw new RuntimeException(DBUtilErrorCode.JDBC_OB10_ADDRESS_ERROR.getCode());
            }
            LOG.info("this is ob1_0 jdbc url.");
            user = ss[1].trim() + ":" + user;
            url = ss[2];
            LOG.info("this is ob1_0 jdbc url. user=" + user + " :url=" + url);
        }
        Properties prop = DbUtil.createProperties(user, pass, dataBaseType, socketTimeout);
        return DbUtil.connect(dataBaseType, url, prop);
    }

    private static Properties createProperties(String user, String pass, DataBaseType dataBaseType, String socketTimeout) {
        Properties prop = new Properties();
        prop.put("user", user);
        prop.put("password", pass);
        if (dataBaseType == DataBaseType.Oracle) {
            prop.put("oracle.jdbc.ReadTimeout", socketTimeout);
        }
        return prop;
    }

    private static Connection connect(DataBaseType dataBaseType, String url, Properties prop) {
        try {
            Class.forName(dataBaseType.getDriverClassName());
            DriverManager.setLoginTimeout(TIMEOUT_SECONDS);
            return DriverManager.getConnection(url, prop);
        }
        catch (Exception e) {
            throw new RuntimeException(prop.getProperty("user"), e);
        }
    }

    private static synchronized Connection connect(DataBaseType dataBaseType, String url, String user, String pass) {
        return DbUtil.connect(dataBaseType, url, user, pass, String.valueOf(172800000));
    }

    public static ResultSet query(Connection conn, String sql, int fetchSize) throws SQLException {
        return DbUtil.query(conn, sql, fetchSize, 172800);
    }

    public static ResultSet query(Connection conn, String sql, int fetchSize, int queryTimeout) throws SQLException {
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement(1003, 1007);
        stmt.setFetchSize(fetchSize);
        stmt.setQueryTimeout(queryTimeout);
        return DbUtil.query(stmt, sql);
    }

    public static ResultSet query(Statement stmt, String sql) throws SQLException {
        return stmt.executeQuery(sql);
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (null != rs) {
                Statement stmt = rs.getStatement();
                if (null != stmt) {
                    stmt.close();
                    stmt = null;
                }
                rs.close();
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void closeDBResources(ResultSet rs, Statement stmt, Connection conn) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeDBResources(Statement stmt, Connection conn) {
        DbUtil.closeDBResources(null, stmt, conn);
    }

    public static List<String> getTableColumns(DataBaseType dataBaseType, String jdbcUrl, String user, String pass, String tableName) {
        Connection conn = DbUtil.getConnection(dataBaseType, jdbcUrl, user, pass, new String[0]);
        return DbUtil.getTableColumnsByConn(dataBaseType, conn, tableName, "jdbcUrl:" + jdbcUrl);
    }

    public static List<String> getTableColumnsByConn(DataBaseType dataBaseType, Connection conn, String tableName, String basicMsg) {
        ArrayList columns = Lists.newArrayList();
        Statement statement = null;
        ResultSet rs = null;
        String queryColumnSql = null;
        try {
            statement = conn.createStatement();
            queryColumnSql = String.format("select * from %s where 1=2", tableName);
            rs = statement.executeQuery(queryColumnSql);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int len = rsMetaData.getColumnCount();
            for (int i = 0; i < len; ++i) {
                columns.add(rsMetaData.getColumnName(i + 1));
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(String.format("dataBaseType%s:querySql:%s", dataBaseType, queryColumnSql), e);
            }
            catch (Throwable throwable) {
                DbUtil.closeDBResources(rs, statement, conn);
                throw throwable;
            }
        }
        DbUtil.closeDBResources(rs, statement, conn);
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Triple<List<String>, List<Integer>, List<String>> getColumnMetaData(DataBaseType dataBaseType, String jdbcUrl, String user, String pass, String tableName, String column) {
        Triple<List<String>, List<Integer>, List<String>> triple;
        Connection conn = null;
        try {
            conn = DbUtil.getConnection(dataBaseType, jdbcUrl, user, pass, new String[0]);
            triple = DbUtil.getColumnMetaData(conn, tableName, column);
        }
        catch (Throwable throwable) {
            DbUtil.closeDBResources(null, null, conn);
            throw throwable;
        }
        DbUtil.closeDBResources(null, null, conn);
        return triple;
    }

    public static Triple<List<String>, List<Integer>, List<String>> getColumnMetaData(Connection conn, String tableName, String column) {
        ImmutableTriple immutableTriple;
        Statement statement = null;
        ResultSet rs = null;
        ImmutableTriple columnMetaData = new ImmutableTriple(new ArrayList(), new ArrayList(), new ArrayList());
        try {
            statement = conn.createStatement();
            String queryColumnSql = String.format("select %s from %s where 1=2", column, tableName);
            rs = statement.executeQuery(queryColumnSql);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int len = rsMetaData.getColumnCount();
            for (int i = 0; i < len; ++i) {
                ((List)columnMetaData.getLeft()).add(rsMetaData.getColumnName(i + 1));
                ((List)columnMetaData.getMiddle()).add(rsMetaData.getColumnType(i + 1));
                ((List)columnMetaData.getRight()).add(rsMetaData.getColumnTypeName(i + 1));
            }
            immutableTriple = columnMetaData;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(String.format("\u83b7\u53d6\u8868:%s \u7684\u5b57\u6bb5\u7684\u5143\u4fe1\u606f\u65f6\u5931\u8d25. \u8bf7\u8054\u7cfb DBA \u6838\u67e5\u8be5\u5e93\u3001\u8868\u4fe1\u606f.", tableName), e);
            }
            catch (Throwable throwable) {
                DbUtil.closeDBResources(rs, statement, null);
                throw throwable;
            }
        }
        DbUtil.closeDBResources(rs, statement, null);
        return immutableTriple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnWithoutRetry(DataBaseType dataBaseType, String url, String user, String pass, boolean checkSlave) {
        Connection connection;
        block5: {
            boolean bl;
            block6: {
                connection = null;
                connection = DbUtil.connect(dataBaseType, url, user, pass);
                if (connection == null) break block5;
                if (!dataBaseType.equals((Object)DataBaseType.MySql) || !checkSlave) break block6;
                boolean bl2 = !DbUtil.isSlaveBehind(connection);
                DbUtil.closeDBResources(null, connection);
                return bl2;
            }
            try {
                bl = true;
            }
            catch (Exception e) {
                try {
                    LOG.warn("test connection of [{}] failed, for {}.", (Object)url, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    DbUtil.closeDBResources(null, connection);
                    throw throwable;
                }
                DbUtil.closeDBResources(null, connection);
            }
            DbUtil.closeDBResources(null, connection);
            return bl;
        }
        DbUtil.closeDBResources(null, connection);
        return false;
    }

    private static boolean isSlaveBehind(Connection conn) {
        try {
            ResultSet rs = DbUtil.query(conn, "SHOW VARIABLES LIKE 'read_only'");
            if (DbUtil.asyncResultSetNext(rs)) {
                String readOnly = rs.getString("Value");
                if ("ON".equalsIgnoreCase(readOnly)) {
                    ResultSet rs1 = DbUtil.query(conn, "SHOW SLAVE STATUS");
                    if (DbUtil.asyncResultSetNext(rs1)) {
                        String ioRunning = rs1.getString("Slave_IO_Running");
                        String sqlRunning = rs1.getString("Slave_SQL_Running");
                        long secondsBehindMaster = rs1.getLong("Seconds_Behind_Master");
                        if ("Yes".equalsIgnoreCase(ioRunning) && "Yes".equalsIgnoreCase(sqlRunning)) {
                            ResultSet rs2 = DbUtil.query(conn, "SELECT TIMESTAMPDIFF(SECOND, CURDATE(), NOW())");
                            DbUtil.asyncResultSetNext(rs2);
                            long secondsOfDay = rs2.getLong(1);
                            return secondsBehindMaster > secondsOfDay;
                        }
                        return true;
                    }
                    LOG.warn("SHOW SLAVE STATUS has no result");
                }
            } else {
                LOG.warn("SHOW VARIABLES like 'read_only' has no result");
            }
        }
        catch (Exception e) {
            LOG.warn("checkSlave failed, errorMessage:[{}].", (Object)e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean testConnWithoutRetry(DataBaseType dataBaseType, String url, String user, String pass, List<String> preSql) {
        boolean bl;
        Connection connection;
        block8: {
            boolean bl2;
            connection = null;
            try {
                Iterator<String> iterator;
                connection = DbUtil.connect(dataBaseType, url, user, pass);
                if (null != connection) {
                    iterator = preSql.iterator();
                } else {
                    DbUtil.closeDBResources(null, connection);
                    return false;
                }
                while (iterator.hasNext()) {
                    String pre = iterator.next();
                    if (DbUtil.doPreCheck(connection, pre)) continue;
                    LOG.warn("doPreCheck failed.");
                    bl = false;
                    break block8;
                }
                bl2 = true;
            }
            catch (Exception e) {
                try {
                    LOG.warn("test connection of [{}] failed, for {}.", (Object)url, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    DbUtil.closeDBResources(null, connection);
                    throw throwable;
                }
                DbUtil.closeDBResources(null, connection);
                return false;
            }
            DbUtil.closeDBResources(null, connection);
            return bl2;
        }
        DbUtil.closeDBResources(null, connection);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOracleMaster(String url, String user, String pass) {
        try {
            block5: {
                boolean bl;
                Connection conn = null;
                try {
                    conn = DbUtil.connect(DataBaseType.Oracle, url, user, pass);
                    ResultSet rs = DbUtil.query(conn, "select DATABASE_ROLE from V$DATABASE");
                    if (!DbUtil.asyncResultSetNext(rs, DbConstant.ASYNC_RESULT_TIME_OUT)) break block5;
                    String role = rs.getString("DATABASE_ROLE");
                    bl = "PRIMARY".equalsIgnoreCase(role);
                }
                catch (Throwable throwable) {
                    DbUtil.closeDBResources(null, conn);
                    throw throwable;
                }
                DbUtil.closeDBResources(null, conn);
                return bl;
            }
            throw new RuntimeException(String.format("select DATABASE_ROLE from V$DATABASE failed,\u8bf7\u68c0\u67e5\u60a8\u7684jdbcUrl:%s.", url));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("select DATABASE_ROLE from V$DATABASE failed, url: %s", url), e);
        }
    }

    public static ResultSet query(Connection conn, String sql) throws SQLException {
        Statement stmt = conn.createStatement(1003, 1007);
        stmt.setQueryTimeout(172800);
        return DbUtil.query(stmt, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doPreCheck(Connection conn, String pre) {
        ResultSet rs = null;
        try {
            rs = DbUtil.query(conn, pre);
            int checkResult = -1;
            if (DbUtil.asyncResultSetNext(rs)) {
                checkResult = rs.getInt(1);
                if (DbUtil.asyncResultSetNext(rs)) {
                    LOG.warn("pre check failed. It should return one result:0, pre:[{}].", (Object)pre);
                    boolean bl = false;
                    return bl;
                }
            }
            if (0 == checkResult) {
                boolean bl = true;
                return bl;
            }
            LOG.warn("pre check failed. It should return one result:0, pre:[{}].", (Object)pre);
        }
        catch (Exception e) {
            LOG.warn("pre check failed. pre:[{}], errorMessage:[{}].", (Object)pre, (Object)e.getMessage());
        }
        finally {
            DbUtil.closeResultSet(rs);
        }
        return false;
    }

    public static boolean asyncResultSetNext(ResultSet resultSet) {
        return DbUtil.asyncResultSetNext(resultSet, 3600);
    }

    public static boolean asyncResultSetNext(ResultSet resultSet, int timeout) {
        Future<Boolean> future = RS_EXECUTORS.get().submit(resultSet::next);
        try {
            return future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5f02\u6b65\u83b7\u53d6ResultSet\u5931\u8d25", e);
        }
    }

    public static List<Map<String, Object>> resultSetToList(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                row.put(md.getColumnName(i), rs.getObject(i));
            }
            list.add(row);
        }
        return list;
    }

    public static Map<String, Object> resultSetToMap(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        HashMap<String, Object> row = new HashMap<String, Object>(columns);
        if (rs.next()) {
            for (int i = 1; i <= columns; ++i) {
                row.put(md.getColumnName(i), rs.getObject(i));
            }
        }
        return row;
    }
}

