/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.business.copy;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoApiType;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoApiDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoApiStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldAttributeStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldDomainAttributeStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldValidateStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoIndexStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoRelationshipStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.BoDataRuleDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.BoDataRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.DataRuleDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.DataRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.SysType;
import com.xforceplus.ultraman.bocp.metadata.flow.mapstruct.FlowSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.ApisStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.AppEventStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.FlowActionParamStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.FlowActionStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.SueRuleParamStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.SueRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.SueTagStructMapper;
import com.xforceplus.ultraman.bocp.metadata.sdkSetting.enums.SdkSettingType;
import com.xforceplus.ultraman.bocp.metadata.sdkSetting.mapstruct.SdkSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.service.IAppExService;
import com.xforceplus.ultraman.bocp.metadata.setting.BoFieldSetting;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.PageBoSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltFormStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.util.PageFormBoSettingParseUtil;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApiDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRuleDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldValidate;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoIndex;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DataRuleDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DictDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowActionParam;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.ModuleBo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SdkSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueRuleParam;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.SueTag;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IApisService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEventService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoApiDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoApiService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldDomainAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldValidateService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoIndexService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoRelationshipService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDataRuleDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDataRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowActionService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IFlowSettingService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IModuleBoService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISdkSettingService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleParamService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueRuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.ISueTagService;
import com.xforceplus.ultraman.metadata.global.common.util.AppDBUtil;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.ApisRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEventRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoApiDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoApiRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoDataRuleDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldAttributeRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldDomainAttributeRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldValidateRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoIndexRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRelationshipRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DataRuleRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowActionParamRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowActionRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SdkSettingRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueRuleParamRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueRuleRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.SueTagRepository;
import com.xforceplus.ultraman.metadata.repository.common.CommonService;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltPageSettingRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IPageBoSettingService;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltFormService;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageService;
import com.xforceplus.ultraman.pfcp.mybatisplus.service.IUltPageSettingService;
import io.vavr.Tuple2;
import io.vavr.Tuple4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CopyAppBusiness {
    @Autowired
    private IAppExService appExService;
    @Autowired
    private IModuleBoService moduleBoService;
    @Autowired
    private IBoService boService;
    @Autowired
    private IBoFieldService boFieldService;
    @Autowired
    private IBoFieldAttributeService boFieldAttributeService;
    @Autowired
    private IBoFieldDomainAttributeService boFieldDomainAttributeService;
    @Autowired
    private IBoFieldValidateService boFieldValidateService;
    @Autowired
    private IBoApiService boApiService;
    @Autowired
    private IBoApiDetailService boApiDetailService;
    @Autowired
    private IBoRelationshipService boRelationshipService;
    @Autowired
    private IBoIndexService boIndexService;
    @Autowired
    private IBoDataRuleService boDataRuleService;
    @Autowired
    private IBoDataRuleDetailService boDataRuleDetailService;
    @Autowired
    private IDictService dictService;
    @Autowired
    private IDictDetailService dictDetailService;
    @Autowired
    private IFlowActionService flowActionService;
    @Autowired
    private IFlowActionParamService flowActionParamService;
    @Autowired
    private IApisService apisService;
    @Autowired
    private ISueRuleService sueRuleService;
    @Autowired
    private ISueRuleParamService sueRuleParamService;
    @Autowired
    private ISueTagService sueTagService;
    @Autowired
    private IAppEventService appEventService;
    @Autowired
    private ISdkSettingService sdkSettingService;
    @Autowired
    private IFlowSettingService flowSettingService;
    @Autowired
    private IUltPageService ultPageService;
    @Autowired
    private IUltPageSettingService ultPageSettingService;
    @Autowired
    private IPageBoSettingService pageBoSettingService;
    @Autowired
    private IUltFormService ultFormService;
    @Autowired
    private IDataRuleService dataRuleService;
    @Autowired
    private IDataRuleDetailService dataRuleDetailService;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictDetailRepository dictDetailRepository;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private BoFieldRepository boFieldRepository;
    @Autowired
    private BoFieldAttributeRepository boFieldAttributeRepository;
    @Autowired
    private BoFieldDomainAttributeRepository boFieldDomainAttributeRepository;
    @Autowired
    private BoFieldValidateRepository boFieldValidateRepository;
    @Autowired
    private DataRuleRepository dataRuleRepository;
    @Autowired
    private BoDataRuleDetailRepository boDataRuleDetailRepository;
    @Autowired
    private DataRuleDetailRepository dataRuleDetailRepository;
    @Autowired
    private BoRelationshipRepository boRelationshipRepository;
    @Autowired
    private BoIndexRepository boIndexRepository;
    @Autowired
    private BoApiRepository boApiRepository;
    @Autowired
    private BoApiDetailRepository boApiDetailRepository;
    @Autowired
    private ApisRepository apisRepository;
    @Autowired
    private AppEventRepository appEventRepository;
    @Autowired
    private FlowActionRepository flowActionRepository;
    @Autowired
    private FlowActionParamRepository flowActionParamRepository;
    @Autowired
    private SueRuleRepository sueRuleRepository;
    @Autowired
    private SueRuleParamRepository sueRuleParamRepository;
    @Autowired
    private SueTagRepository sueTagRepository;
    @Autowired
    private UltPageRepository ultPageRepository;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;
    @Autowired
    private UltFormRepository ultFormRepository;
    @Autowired
    private UltPageSettingRepository ultPageSettingRepository;
    @Autowired
    private FlowSettingRepository flowSettingRepository;
    @Autowired
    private SdkSettingRepository sdkSettingRepository;
    private final ThreadLocal<Map<Long, Long>> idMapThreadLocal = new ThreadLocal();
    private final ThreadLocal<Map<Long, Long>> idMapForUpdateIdThreadLocal = new ThreadLocal();

    private void initIdMapThreadLocal() {
        if (null == this.idMapThreadLocal.get()) {
            this.idMapThreadLocal.set(Maps.newHashMap());
        }
        if (null == this.idMapForUpdateIdThreadLocal.get()) {
            this.idMapForUpdateIdThreadLocal.set(Maps.newHashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse copyApp(Long sourceAppId, Long targetAppId) {
        ServiceResponse serviceResponse;
        App sourceApp = this.appRepository.getAppWithValidate(sourceAppId.longValue());
        App targetApp = this.appRepository.getAppWithValidate(targetAppId.longValue());
        if (null == sourceApp.getCustomType() && sourceApp.getCustomType().equals(targetApp.getCustomType())) {
            throw new RuntimeException("\u590d\u5236\u5e94\u7528\u5b9a\u5236\u7c7b\u578b\u4e0d\u540c");
        }
        try {
            this.initIdMapThreadLocal();
            serviceResponse = this.doCreateDicts(sourceAppId, targetAppId);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create dicts error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.doCreateBos(sourceAppId, targetAppId, targetApp.getCode());
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create bos error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.doCreateUltForms(sourceApp, targetApp);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create forms error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.doCreateUltPages(sourceApp, targetApp);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create pages error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.doCreateFlowSettings(sourceAppId, targetAppId);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create flows error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.doCreateUltPageSettings(sourceAppId, targetAppId);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create pageSettings error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.createDataRules(sourceAppId, targetAppId);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create data rules error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.createActions(sourceAppId, targetAppId);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create actions error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.createAppEvents(sourceAppId, targetAppId);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create appEvents error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.createApis(sourceAppId, targetAppId);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create apis error, %s", serviceResponse.getMessage()));
            }
            serviceResponse = this.createSdkSettings(sourceAppId, targetApp);
            if (!serviceResponse.isSuccess()) {
                throw new RuntimeException(String.format("create sdkSettings error, %s", serviceResponse.getMessage()));
            }
        }
        finally {
            this.idMapThreadLocal.remove();
            this.idMapForUpdateIdThreadLocal.remove();
        }
        serviceResponse = this.createRules(sourceAppId, targetAppId);
        if (!serviceResponse.isSuccess()) {
            throw new RuntimeException(String.format("create rules error, %s", serviceResponse.getMessage()));
        }
        serviceResponse = this.createTags(sourceAppId, targetAppId);
        if (!serviceResponse.isSuccess()) {
            throw new RuntimeException(String.format("create tags error, %s", serviceResponse.getMessage()));
        }
        return serviceResponse;
    }

    private ServiceResponse doCreateDicts(Long sourceAppId, Long targetAppId) {
        List<Dict> sourceDicts = this.dictRepository.getDicts(sourceAppId).stream().filter(o -> SysType.USER.code().equals(o.getSystemType())).collect(Collectors.toList());
        if (sourceDicts.isEmpty()) {
            return ServiceResponse.success();
        }
        ServiceResponse serviceResponse = this.validateDicts(sourceDicts, targetAppId);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        ArrayList dicts = Lists.newArrayList();
        ArrayList dictDetails = Lists.newArrayList();
        List sourceDictsS = sourceDicts.stream().filter(s -> StringUtils.isBlank((CharSequence)s.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<Dict>> sourceDictsTMap = sourceDicts.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getTenantCode())).collect(Collectors.groupingBy(Dict::getRefDictId));
        sourceDictsS.stream().filter(s -> SysType.USER.code().equals(s.getSystemType())).forEach(s -> {
            Tuple2<Dict, List<DictDetail>> tpl = this.createDict((Dict)s, targetAppId);
            dicts.add(tpl._1);
            dictDetails.addAll((Collection)tpl._2);
            Optional.ofNullable(sourceDictsTMap.get(s.getId())).ifPresent(sourceTenantDicts -> sourceTenantDicts.forEach(t -> {
                Tuple2<Dict, List<DictDetail>> tenantTpl = this.createTenantDict((Dict)t, targetAppId, ((Dict)tpl._1).getId());
                dicts.add(tenantTpl._1);
                dictDetails.addAll((Collection)tenantTpl._2);
            }));
        });
        this.dictService.saveBatch((Collection)dicts);
        this.dictDetailService.saveBatch((Collection)dictDetails);
        return ServiceResponse.success();
    }

    private Tuple2<Dict, List<DictDetail>> createDict(Dict sourceDict, Long targetAppId) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceDict.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceDict.getId(), uid);
        Dict dict = DictStructMapper.MAPPER.clone(sourceDict);
        dict.setId(uid);
        dict.setUniqueId(uid);
        dict.setAppId(targetAppId);
        dict.setVersion("0.0.0");
        List<DictDetail> dictDetails = this.createDictDetails(sourceDict.getId(), uid);
        return new Tuple2((Object)dict, dictDetails);
    }

    private Tuple2<Dict, List<DictDetail>> createTenantDict(Dict sourceTenantDict, Long targetAppId, Long refDictId) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceTenantDict.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceTenantDict.getId(), uid);
        Dict tenantDict = DictStructMapper.MAPPER.clone(sourceTenantDict);
        tenantDict.setId(uid);
        tenantDict.setUniqueId(uid);
        tenantDict.setVersion("0.0.0");
        tenantDict.setAppId(targetAppId);
        tenantDict.setRefDictId(refDictId);
        List<DictDetail> tenantDictDetails = this.createDictDetails(sourceTenantDict.getId(), uid);
        return new Tuple2((Object)tenantDict, tenantDictDetails);
    }

    private List<DictDetail> createDictDetails(Long sourceDictId, Long targetDictId) {
        List sourceDictDetails = this.dictDetailRepository.getDictDetails(sourceDictId);
        ServiceResponse response = this.validateDictDetails(sourceDictId, sourceDictDetails);
        if (!response.isSuccess()) {
            throw new RuntimeException(response.getMessage());
        }
        return sourceDictDetails.stream().map(s -> {
            Long uid = IdWorker.getId();
            this.idMapThreadLocal.get().put(s.getId(), uid);
            this.idMapForUpdateIdThreadLocal.get().put(s.getId(), uid);
            DictDetail dictDetail = DictDetailStructMapper.MAPPER.clone(s);
            dictDetail.setDictId(targetDictId);
            dictDetail.setId(uid);
            dictDetail.setUniqueId(uid);
            dictDetail.setVersion("0.0.0");
            return dictDetail;
        }).collect(Collectors.toList());
    }

    private ServiceResponse doCreateBos(Long sourceAppId, Long targetAppId, String targetAppCode) {
        List<Bo> sourceBos = this.boRepository.getBos(sourceAppId.longValue()).stream().filter(o -> SysType.USER.code().equals(o.getSysType())).collect(Collectors.toList());
        if (sourceBos.isEmpty()) {
            return ServiceResponse.success();
        }
        ServiceResponse response = this.validateBos(sourceBos, targetAppId);
        if (!response.isSuccess()) {
            return response;
        }
        Optional targetModuleOptl = this.defaultModuleService.getModule(targetAppId.longValue());
        Long targetModuleId = ((Module)targetModuleOptl.get()).getId();
        ArrayList moduleBos = Lists.newArrayList();
        ArrayList bos = Lists.newArrayList();
        ArrayList boFields = Lists.newArrayList();
        ArrayList boFieldAttributes = Lists.newArrayList();
        ArrayList boFieldDomainAttributes = Lists.newArrayList();
        ArrayList boFieldValidates = Lists.newArrayList();
        ArrayList boRelationships = Lists.newArrayList();
        ArrayList boIndexes = Lists.newArrayList();
        ArrayList boApis = Lists.newArrayList();
        ArrayList boApiDetails = Lists.newArrayList();
        ArrayList boDataRules = Lists.newArrayList();
        ArrayList boDataRuleDetails = Lists.newArrayList();
        List sourceBoIds = sourceBos.stream().map(Bo::getId).collect(Collectors.toList());
        Map boFieldsMap = this.boFieldRepository.getBoFieldsByBoIds(sourceBoIds).stream().collect(Collectors.groupingBy(BoField::getBoId, Collectors.toList()));
        Map boIndexesMap = this.boIndexRepository.getBoIndexesByBoIds(sourceBoIds).stream().collect(Collectors.groupingBy(BoIndex::getBoId, Collectors.toList()));
        Map boRelationsMap = this.boRelationshipRepository.getBoRelationshipsByBoIds(sourceBoIds).stream().collect(Collectors.groupingBy(BoRelationship::getBoId, Collectors.toList()));
        Map boApisMap = this.boApiRepository.getBoApisByBoIds(sourceBoIds).stream().collect(Collectors.groupingBy(BoApi::getBoId, Collectors.toList()));
        Map boDataRulesMap = this.dataRuleRepository.getDefaultDataRulesByBoIds(sourceBoIds).stream().collect(Collectors.groupingBy(BoDataRule::getBoId, Collectors.toList()));
        List sourceBosS = sourceBos.stream().filter(s -> StringUtils.isBlank((CharSequence)s.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<Bo>> sourceBosTMap = sourceBos.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getTenantCode())).collect(Collectors.groupingBy(Bo::getRefBoId));
        sourceBosS.stream().filter(bo -> SysType.USER.code().equals(bo.getSysType())).forEach(s -> {
            Bo bo = this.createBo(targetAppId, (Bo)s);
            moduleBos.add(new ModuleBo().setModuleId(targetModuleId).setBoId(bo.getId()));
            bos.add(bo);
            Optional.ofNullable(boFieldsMap.get(s.getId())).ifPresent(sourceBoFields -> {
                ServiceResponse fieldResponse = this.validateBoFields(s.getId(), (List<BoField>)sourceBoFields);
                if (!fieldResponse.isSuccess()) {
                    throw new RuntimeException(fieldResponse.getMessage());
                }
                List sourceBoFieldIds = sourceBoFields.stream().map(BoField::getId).collect(Collectors.toList());
                Map boFieldAttrsMap = this.boFieldAttributeRepository.getBoFieldAttributesByFieldIds(sourceBoFieldIds).stream().collect(Collectors.toMap(BoFieldAttribute::getFieldId, Function.identity()));
                Map boFieldValidatesMap = this.boFieldValidateRepository.getBoFieldValidatesByFieldIds(sourceBoFieldIds).stream().collect(Collectors.toMap(BoFieldValidate::getFieldId, Function.identity()));
                Map boFieldDomainAttributeMap = this.boFieldDomainAttributeRepository.getBoFieldDomainAttributesByFieldIds(sourceBoFieldIds).stream().collect(Collectors.toMap(BoFieldDomainAttribute::getFieldId, Function.identity()));
                sourceBoFields.forEach(boField -> {
                    Tuple4<BoField, BoFieldAttribute, BoFieldDomainAttribute, BoFieldValidate> tpl = this.createBoField(bo.getId(), (BoField)boField, (BoFieldAttribute)boFieldAttrsMap.get(boField.getId()), (BoFieldValidate)boFieldValidatesMap.get(boField.getId()), (BoFieldDomainAttribute)boFieldDomainAttributeMap.get(boField.getId()));
                    boFields.add(tpl._1);
                    boFieldAttributes.add(tpl._2);
                    Optional.ofNullable(tpl._3).ifPresent(t3 -> boFieldDomainAttributes.add(tpl._3));
                    boFieldValidates.add(tpl._4);
                });
            });
            Optional.ofNullable(boRelationsMap.get(s.getId())).ifPresent(sourceBoRelationships -> {
                ServiceResponse relationResponse = this.validateBoRelationships(s.getId(), (List<BoRelationship>)sourceBoRelationships);
                if (!relationResponse.isSuccess()) {
                    throw new RuntimeException(relationResponse.getMessage());
                }
                sourceBoRelationships.forEach(boRelationship -> boRelationships.add(this.createBoRelationship(bo.getId(), (BoRelationship)boRelationship)));
            });
            Optional.ofNullable(boApisMap.get(s.getId())).ifPresent(sourceBoApis -> {
                boApis.addAll(this.commonService.buildDefaultBoApis(targetAppCode, bo.getId()));
                sourceBoApis.stream().filter(boApi -> BoApiType.EXTERNAL.code().equals(boApi.getApiType())).forEach(boApi -> {
                    Tuple2<BoApi, List<BoApiDetail>> tpl = this.createBoApi((BoApi)boApi, bo.getId());
                    boApis.add(tpl._1);
                    boApiDetails.addAll((Collection)tpl._2);
                });
            });
            Optional.ofNullable(boIndexesMap.get(s.getId())).ifPresent(sourceBoIndexes -> sourceBoIndexes.forEach(boIndex -> boIndexes.add(this.createBoIndex((BoIndex)boIndex, bo.getId()))));
            Optional.ofNullable(boDataRulesMap.get(s.getId())).ifPresent(sourceDataRules -> sourceDataRules.forEach(boDataRule -> {
                BoDataRule targetBoDataRule = this.createBoDataRule((BoDataRule)boDataRule, targetAppId, bo.getId());
                boDataRules.add(targetBoDataRule);
                boDataRuleDetails.addAll(this.createBoDataRuleDetails(boDataRule.getId(), targetBoDataRule.getId()));
            }));
            Optional.ofNullable(sourceBosTMap.get(s.getId())).ifPresent(tenantBos -> tenantBos.forEach(t -> {
                Bo tenantBo = this.createTenantBo(bo, (Bo)t);
                moduleBos.add(new ModuleBo().setModuleId(targetModuleId).setBoId(tenantBo.getId()));
                bos.add(tenantBo);
                Optional.ofNullable(boFieldsMap.get(t.getId())).ifPresent(sourceBoFields -> {
                    List sourceBoFieldIds = sourceBoFields.stream().map(BoField::getId).collect(Collectors.toList());
                    Map boFieldAttrsMap = this.boFieldAttributeRepository.getBoFieldAttributesByFieldIds(sourceBoFieldIds).stream().collect(Collectors.toMap(BoFieldAttribute::getFieldId, Function.identity()));
                    Map boFieldValidatesMap = this.boFieldValidateRepository.getBoFieldValidatesByFieldIds(sourceBoFieldIds).stream().collect(Collectors.toMap(BoFieldValidate::getFieldId, Function.identity()));
                    Map boFieldDomainAttributeMap = this.boFieldDomainAttributeRepository.getBoFieldDomainAttributesByFieldIds(sourceBoFieldIds).stream().collect(Collectors.toMap(BoFieldDomainAttribute::getFieldId, Function.identity()));
                    sourceBoFields.forEach(boField -> {
                        Tuple4<BoField, BoFieldAttribute, BoFieldDomainAttribute, BoFieldValidate> tpl = this.createBoField(tenantBo.getId(), (BoField)boField, (BoFieldAttribute)boFieldAttrsMap.get(boField.getId()), (BoFieldValidate)boFieldValidatesMap.get(boField.getId()), (BoFieldDomainAttribute)boFieldDomainAttributeMap.get(boField.getId()));
                        boFields.add(tpl._1);
                        boFieldAttributes.add(tpl._2);
                        Optional.ofNullable(tpl._3).ifPresent(t3 -> boFieldDomainAttributes.add(tpl._3));
                        boFieldValidates.add(tpl._4);
                    });
                });
                Optional.ofNullable(boRelationsMap.get(t.getId())).ifPresent(sourceBoRelationships -> sourceBoRelationships.forEach(boRelationship -> boRelationships.add(this.createBoRelationship(tenantBo.getId(), (BoRelationship)boRelationship))));
                Optional.ofNullable(boIndexesMap.get(t.getId())).ifPresent(sourceBoIndexes -> sourceBoIndexes.forEach(boIndex -> boIndexes.add(this.createBoIndex((BoIndex)boIndex, tenantBo.getId()))));
                Optional.ofNullable(boDataRulesMap.get(t.getId())).ifPresent(sourceBoDataRules -> sourceBoDataRules.forEach(boDataRule -> boDataRules.add(this.createBoDataRule((BoDataRule)boDataRule, targetAppId, tenantBo.getId()))));
            }));
        });
        bos.forEach(bo -> {
            if (null != bo.getParentBoId()) {
                bo.setParentBoId(this.idMapThreadLocal.get().get(bo.getParentBoId()));
            }
            if (null != bo.getSyncBoId()) {
                bo.setParentBoId(this.idMapThreadLocal.get().get(bo.getSyncBoId()));
            }
        });
        boFields.forEach(boField -> {
            if (null != boField.getDictId()) {
                boField.setDictId(this.idMapThreadLocal.get().get(boField.getDictId()));
            }
            if (null != boField.getSyncFieldId()) {
                boField.setSyncFieldId(this.idMapThreadLocal.get().get(boField.getSyncFieldId()));
            }
            if (null != boField.getRefFieldId()) {
                boField.setRefFieldId(this.idMapThreadLocal.get().get(boField.getRefFieldId()));
            }
        });
        boFieldDomainAttributes.forEach(boFieldDomainAttribute -> {
            if (null != boFieldDomainAttribute.getLookupBoId()) {
                boFieldDomainAttribute.setLookupBoId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getLookupBoId()));
            }
            if (null != boFieldDomainAttribute.getLookupFieldId()) {
                boFieldDomainAttribute.setLookupFieldId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getLookupFieldId()));
            }
            if (null != boFieldDomainAttribute.getLookupRelationId()) {
                boFieldDomainAttribute.setLookupRelationId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getLookupRelationId()));
            }
            if (null != boFieldDomainAttribute.getAggregationFieldId()) {
                boFieldDomainAttribute.setAggregationBoId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getAggregationBoId()));
            }
            if (null != boFieldDomainAttribute.getAggregationFieldId()) {
                boFieldDomainAttribute.setAggregationFieldId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getAggregationFieldId()));
            }
            if (null != boFieldDomainAttribute.getAggregationRelationId()) {
                boFieldDomainAttribute.setAggregationRelationId(this.idMapThreadLocal.get().get(boFieldDomainAttribute.getAggregationRelationId()));
            }
        });
        boRelationships.forEach(boRelationship -> {
            if (null != boRelationship.getJoinBoId()) {
                boRelationship.setJoinBoId(this.idMapThreadLocal.get().get(boRelationship.getJoinBoId()));
            }
        });
        boDataRules.forEach(boDataRule -> {
            if (null != boDataRule.getRefBoId()) {
                boDataRule.setRefBoId(this.idMapThreadLocal.get().get(boDataRule.getRefBoId()));
            }
        });
        this.moduleBoService.saveBatch((Collection)moduleBos);
        this.boService.saveBatch((Collection)bos);
        this.boFieldService.saveBatch((Collection)boFields);
        this.boFieldAttributeService.saveBatch((Collection)boFieldAttributes);
        this.boFieldDomainAttributeService.saveBatch((Collection)boFieldDomainAttributes);
        this.boFieldValidateService.saveBatch((Collection)boFieldValidates);
        this.boRelationshipService.saveBatch((Collection)boRelationships);
        this.boApiService.saveBatch((Collection)boApis);
        this.boApiDetailService.saveBatch((Collection)boApiDetails);
        this.boIndexService.saveBatch((Collection)boIndexes);
        this.boDataRuleService.saveBatch((Collection)boDataRules);
        this.boDataRuleDetailService.saveBatch((Collection)boDataRuleDetails);
        return ServiceResponse.success();
    }

    private Bo createBo(Long targetAppId, Bo sourceBo) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceBo.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceBo.getId(), uid);
        Bo bo = BoStructMapper.MAPPER.clone(sourceBo);
        bo.setId(uid);
        bo.setUniqueId(uid);
        bo.setAppId(targetAppId);
        bo.setVersion("0.0.0");
        return bo;
    }

    private Bo createTenantBo(Bo sourceBo, Bo sourceTenantBo) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceTenantBo.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceTenantBo.getId(), uid);
        Bo tenantBo = BoStructMapper.MAPPER.clone(sourceTenantBo);
        tenantBo.setId(uid);
        tenantBo.setUniqueId(uid);
        tenantBo.setRefBoId(sourceBo.getId());
        tenantBo.setVersion("0.0.0");
        return tenantBo;
    }

    public Tuple4<BoField, BoFieldAttribute, BoFieldDomainAttribute, BoFieldValidate> createBoField(Long boId, BoField sourceBoField, BoFieldAttribute sBoFieldAttribute, BoFieldValidate sBoFieldValidate, BoFieldDomainAttribute sBoFieldDomainAttribute) {
        BoFieldValidate boFieldValidate;
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceBoField.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceBoField.getId(), uid);
        BoField boField = BoFieldStructMapper.MAPPER.clone(sourceBoField);
        boField.setId(uid);
        boField.setUniqueId(uid);
        boField.setBoId(boId);
        BoFieldAttribute boFieldAttribute = BoFieldAttributeStructMapper.MAPPER.clone(sBoFieldAttribute);
        boFieldAttribute.setId(null);
        boFieldAttribute.setFieldId(uid);
        BoFieldDomainAttribute boFieldDomainAttribute = null;
        if (BoFieldSetting.computeFieldTypeCodes.contains(boField.getFieldType()) || BoFieldSetting.businessFieldTypeCodes.contains(boField.getFieldType())) {
            boFieldDomainAttribute = BoFieldDomainAttributeStructMapper.MAPPER.clone(sBoFieldDomainAttribute);
            boFieldDomainAttribute.setId(null);
            boFieldDomainAttribute.setFieldId(uid);
        }
        if (null == (boFieldValidate = BoFieldValidateStructMapper.MAPPER.clone(sBoFieldValidate))) {
            boFieldValidate = new BoFieldValidate();
        }
        boFieldValidate.setId(null);
        boFieldValidate.setUniqueId(null);
        boFieldValidate.setFieldId(uid);
        return new Tuple4((Object)boField, (Object)boFieldAttribute, (Object)boFieldDomainAttribute, (Object)boFieldValidate);
    }

    public BoRelationship createBoRelationship(Long targetBoId, BoRelationship sourceBoRelationship) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceBoRelationship.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceBoRelationship.getId(), uid);
        BoRelationship boRelationship = BoRelationshipStructMapper.MAPPER.clone(sourceBoRelationship);
        boRelationship.setId(uid);
        boRelationship.setUniqueId(uid);
        boRelationship.setBoId(targetBoId);
        return boRelationship;
    }

    public Tuple2<BoApi, List<BoApiDetail>> createBoApi(BoApi sourceBoApi, Long targetBoId) {
        Long uid = IdWorker.getId();
        BoApi boApi = BoApiStructMapper.MAPPER.clone(sourceBoApi);
        boApi.setId(uid);
        boApi.setUniqueId(uid);
        boApi.setApiVersion("0.0.0");
        boApi.setBoId(targetBoId);
        List boApiDetails = this.boApiDetailRepository.getBoApiDetailsByBoApiId(sourceBoApi.getId()).stream().map(o -> {
            BoApiDetail boApiDetail = BoApiDetailStructMapper.MAPPER.clone(o);
            boApiDetail.setId(null);
            boApiDetail.setBoApiId(uid);
            return boApiDetail;
        }).collect(Collectors.toList());
        return new Tuple2((Object)boApi, boApiDetails);
    }

    public BoIndex createBoIndex(BoIndex sourceBoIndex, Long targetBoId) {
        BoIndex boIndex = BoIndexStructMapper.MAPPER.clone(sourceBoIndex);
        boIndex.setId(null);
        boIndex.setUniqueId(null);
        boIndex.setBoId(targetBoId);
        return boIndex;
    }

    public BoDataRule createBoDataRule(BoDataRule sourceBoDataRule, Long targetAppId, Long targetBoId) {
        Long uid = IdWorker.getId();
        BoDataRule boDataRule = BoDataRuleStructMapper.MAPPER.clone(sourceBoDataRule);
        boDataRule.setId(uid);
        boDataRule.setUniqueId(uid);
        boDataRule.setVersion("0.0.0");
        boDataRule.setAppId(targetAppId);
        boDataRule.setBoId(targetBoId);
        return boDataRule;
    }

    private List<BoDataRuleDetail> createBoDataRuleDetails(Long sourceBoDataRuleId, Long targetBoDataRuleId) {
        List sourceBoDataRuleDetails = this.boDataRuleDetailRepository.getDetails(sourceBoDataRuleId);
        return sourceBoDataRuleDetails.stream().map(s -> {
            BoDataRuleDetail boDataRuleDetail = BoDataRuleDetailStructMapper.MAPPER.clone(s);
            boDataRuleDetail.setDataRuleId(targetBoDataRuleId);
            boDataRuleDetail.setId(null);
            return boDataRuleDetail;
        }).collect(Collectors.toList());
    }

    private ServiceResponse createActions(Long sourceAppId, Long targetAppId) {
        List sourceActions = this.flowActionRepository.getFlowActions(sourceAppId);
        if (sourceActions.isEmpty()) {
            return ServiceResponse.success();
        }
        ServiceResponse serviceResponse = this.validateActions(sourceActions, targetAppId);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        ArrayList flowActions = Lists.newArrayList();
        ArrayList flowActionParams = Lists.newArrayList();
        sourceActions.forEach(s -> {
            Tuple2<FlowAction, List<FlowActionParam>> tpl = this.createAction(targetAppId, (FlowAction)s);
            flowActions.add(tpl._1);
            flowActionParams.addAll((Collection)tpl._2);
        });
        this.flowActionService.saveBatch((Collection)flowActions);
        this.flowActionParamService.saveBatch((Collection)flowActionParams);
        return ServiceResponse.success();
    }

    private Tuple2<FlowAction, List<FlowActionParam>> createAction(Long targetAppId, FlowAction sourceFlowAction) {
        Long uid = IdWorker.getId();
        this.idMapForUpdateIdThreadLocal.get().put(sourceFlowAction.getId(), uid);
        FlowAction flowAction = FlowActionStructMapper.MAPPER.clone(sourceFlowAction);
        flowAction.setId(uid);
        flowAction.setVersion("0.0.0");
        flowAction.setAppId(targetAppId);
        List actionParams = this.flowActionParamRepository.getActionParams(sourceFlowAction.getId()).stream().map(s -> this.createActionParam(uid, (FlowActionParam)s)).collect(Collectors.toList());
        return new Tuple2((Object)flowAction, actionParams);
    }

    private ServiceResponse doCreateFlowSettings(Long sourceAppId, Long targetAppId) {
        List sourceFlowSettings = this.flowSettingRepository.getFlowSettings(sourceAppId);
        if (sourceFlowSettings.isEmpty()) {
            return ServiceResponse.success();
        }
        ServiceResponse serviceResponse = this.validateFlowSettings(sourceFlowSettings, targetAppId);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        ArrayList flowSettings = Lists.newArrayList();
        List<FlowSetting> sourceFlowSettingsS = sourceFlowSettings.stream().filter(s -> StringUtils.isBlank((CharSequence)s.getTenantCode())).collect(Collectors.toList());
        Map<String, List<FlowSetting>> sourceFlowSettingsTMap = sourceFlowSettings.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getTenantCode())).collect(Collectors.groupingBy(FlowSetting::getCode));
        sourceFlowSettingsS.forEach(s -> {
            FlowSetting flowSetting = this.createFlowSetting((FlowSetting)s, sourceAppId, targetAppId);
            flowSettings.add(flowSetting);
            Optional.ofNullable(sourceFlowSettingsTMap.get(s.getCode())).ifPresent(sourceTenantFlowSettings -> sourceTenantFlowSettings.forEach(t -> {
                FlowSetting tenantFlowSetting = this.createTenantFlowSetting((FlowSetting)t, flowSetting.getId(), sourceAppId, targetAppId);
                flowSettings.add(tenantFlowSetting);
            }));
        });
        this.flowSettingService.saveBatch((Collection)flowSettings, 10);
        return ServiceResponse.success();
    }

    private FlowSetting createFlowSetting(FlowSetting sourceFlowSetting, Long sourceAppId, Long targetAppId) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceFlowSetting.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceFlowSetting.getId(), uid);
        FlowSetting flowSetting = FlowSettingStructMapper.MAPPER.clone(sourceFlowSetting);
        flowSetting.setId(uid);
        flowSetting.setUniqueId(uid);
        flowSetting.setAppId(targetAppId);
        flowSetting.setVersion("0.0.0");
        this.updateFlowSetting(flowSetting, sourceAppId, targetAppId);
        return flowSetting;
    }

    private FlowSetting createTenantFlowSetting(FlowSetting sourceTenantFlowSetting, Long refFlowSettingId, Long sourceAppId, Long targetAppId) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceTenantFlowSetting.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceTenantFlowSetting.getId(), uid);
        FlowSetting tenantFlowSetting = FlowSettingStructMapper.MAPPER.clone(sourceTenantFlowSetting);
        tenantFlowSetting.setId(uid);
        tenantFlowSetting.setUniqueId(uid);
        tenantFlowSetting.setAppId(targetAppId);
        tenantFlowSetting.setVersion("0.0.0");
        tenantFlowSetting.setRefFlowId(refFlowSettingId);
        this.updateFlowSetting(tenantFlowSetting, sourceAppId, targetAppId);
        return tenantFlowSetting;
    }

    private ServiceResponse doCreateUltForms(App sourceApp, App targetApp) {
        List sourceUltForms = this.ultFormRepository.getForms(sourceApp.getId());
        if (sourceUltForms.isEmpty()) {
            return ServiceResponse.success();
        }
        ArrayList ultForms = Lists.newArrayList();
        List<UltForm> sourceUltFormsS = sourceUltForms.stream().filter(s -> StringUtils.isBlank((CharSequence)s.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<UltForm>> sourceUltFormsTMap = sourceUltForms.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getTenantCode())).collect(Collectors.groupingBy(UltForm::getRefFormId));
        sourceUltFormsS.forEach(s -> {
            UltForm ultForm = this.createUltForm((UltForm)s, sourceApp, targetApp);
            ultForms.add(ultForm);
            Optional.ofNullable(sourceUltFormsTMap.get(s.getId())).ifPresent(sourceTenantUltForms -> sourceTenantUltForms.forEach(t -> {
                UltForm tenantUltForm = this.createTenantUltForm((UltForm)t, ultForm.getId(), sourceApp, targetApp);
                ultForms.add(tenantUltForm);
            }));
        });
        ultForms.forEach(o -> {
            if (null != o.getBoId()) {
                o.setBoId(this.idMapThreadLocal.get().get(o.getBoId()));
            }
        });
        this.ultFormService.saveBatch((Collection)ultForms, 10);
        return ServiceResponse.success();
    }

    private UltForm createUltForm(UltForm sourceUltForm, App sourceApp, App targetApp) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceUltForm.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceUltForm.getId(), uid);
        UltForm ultForm = UltFormStructMapper.MAPPER.clone(sourceUltForm);
        ultForm.setId(uid);
        ultForm.setUniqueId(uid);
        ultForm.setAppId(targetApp.getId());
        ultForm.setVersion("0.0.0");
        this.updateFormSetting(ultForm, sourceApp, targetApp);
        return ultForm;
    }

    private UltForm createTenantUltForm(UltForm sourceTenantUltForm, Long refUltFormId, App sourceApp, App targetApp) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceTenantUltForm.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceTenantUltForm.getId(), uid);
        UltForm tenantUltForm = UltFormStructMapper.MAPPER.clone(sourceTenantUltForm);
        tenantUltForm.setId(uid);
        tenantUltForm.setUniqueId(uid);
        tenantUltForm.setAppId(targetApp.getId());
        tenantUltForm.setVersion("0.0.0");
        tenantUltForm.setRefFormId(refUltFormId);
        this.updateFormSetting(tenantUltForm, sourceApp, targetApp);
        return tenantUltForm;
    }

    private ServiceResponse doCreateUltPageSettings(Long sourceAppId, Long targetAppId) {
        List sourceUltPageSettings = this.ultPageSettingRepository.getPageSettings(sourceAppId);
        if (sourceUltPageSettings.isEmpty()) {
            return ServiceResponse.success();
        }
        ArrayList ultPageSettings = Lists.newArrayList();
        List<UltPageSetting> sourceUltPageSettingsS = sourceUltPageSettings.stream().filter(s -> StringUtils.isBlank((CharSequence)s.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<UltPageSetting>> sourceUltPageSettingsTMap = sourceUltPageSettings.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getTenantCode())).collect(Collectors.groupingBy(UltPageSetting::getRefPageId));
        sourceUltPageSettingsS.forEach(s -> {
            UltPageSetting ultPageSetting = this.createUltPageSetting((UltPageSetting)s, targetAppId);
            ultPageSettings.add(ultPageSetting);
            Optional.ofNullable(sourceUltPageSettingsTMap.get(s.getId())).ifPresent(sourceTenantUltPageSettings -> sourceTenantUltPageSettings.forEach(t -> {
                UltPageSetting tenantUltPageSetting = this.createTenantUltPageSetting((UltPageSetting)t, targetAppId, ultPageSetting.getId());
                ultPageSettings.add(tenantUltPageSetting);
            }));
        });
        this.ultPageSettingService.saveBatch((Collection)ultPageSettings, 10);
        return ServiceResponse.success();
    }

    private UltPageSetting createUltPageSetting(UltPageSetting sourceUltPageSetting, Long targetAppId) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceUltPageSetting.getId(), uid);
        UltPageSetting ultPageSetting = UltPageSettingStructMapper.MAPPER.clone(sourceUltPageSetting);
        ultPageSetting.setId(uid);
        ultPageSetting.setUniqueId(uid);
        ultPageSetting.setAppId(targetAppId);
        ultPageSetting.setVersion("0.0.0");
        return ultPageSetting;
    }

    private UltPageSetting createTenantUltPageSetting(UltPageSetting sourceTenantUltPageSetting, Long targetAppId, Long refUltPageSettingId) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceTenantUltPageSetting.getId(), uid);
        UltPageSetting tenantUltPageSetting = UltPageSettingStructMapper.MAPPER.clone(sourceTenantUltPageSetting);
        tenantUltPageSetting.setId(uid);
        tenantUltPageSetting.setUniqueId(uid);
        tenantUltPageSetting.setAppId(targetAppId);
        tenantUltPageSetting.setVersion("0.0.0");
        tenantUltPageSetting.setRefPageId(refUltPageSettingId);
        return tenantUltPageSetting;
    }

    private ServiceResponse doCreateUltPages(App sourceApp, App targetApp) {
        List sourceUltPages = this.ultPageRepository.getPages(sourceApp.getId());
        if (sourceUltPages.isEmpty()) {
            return ServiceResponse.success();
        }
        ArrayList ultPages = Lists.newArrayList();
        ArrayList pageBoSettings = Lists.newArrayList();
        List<UltPage> sourceUltPagesS = sourceUltPages.stream().filter(s -> StringUtils.isBlank((CharSequence)s.getTenantCode())).collect(Collectors.toList());
        Map<Long, List<UltPage>> sourceUltPagesTMap = sourceUltPages.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getTenantCode())).collect(Collectors.groupingBy(UltPage::getRefPageId));
        sourceUltPagesS.forEach(s -> {
            Tuple2<UltPage, List<PageBoSetting>> tpl = this.createUltPage((UltPage)s, sourceApp, targetApp);
            ultPages.add(tpl._1);
            pageBoSettings.addAll((Collection)tpl._2);
            Optional.ofNullable(sourceUltPagesTMap.get(s.getId())).ifPresent(sourceTenantUltPages -> sourceTenantUltPages.forEach(t -> {
                Tuple2<UltPage, List<PageBoSetting>> tenantTpl = this.createTenantUltPage((UltPage)t, sourceApp, targetApp, ((UltPage)tpl._1).getId());
                ultPages.add(tenantTpl._1);
                pageBoSettings.addAll((Collection)tenantTpl._2);
            }));
        });
        pageBoSettings.forEach(o -> {
            if (null != o.getBoId()) {
                o.setBoId(this.idMapThreadLocal.get().get(o.getBoId()));
            }
        });
        this.ultPageService.saveBatch((Collection)ultPages, 10);
        this.pageBoSettingService.saveBatch((Collection)pageBoSettings, 10);
        return ServiceResponse.success();
    }

    private Tuple2<UltPage, List<PageBoSetting>> createUltPage(UltPage sourceUltPage, App sourceApp, App targetApp) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceUltPage.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceUltPage.getId(), uid);
        UltPage ultPage = UltPageStructMapper.MAPPER.clone(sourceUltPage);
        ultPage.setId(uid);
        ultPage.setUniqueId(uid);
        ultPage.setAppId(targetApp.getId());
        ultPage.setVersion("0.0.0");
        List<PageBoSetting> pageBoSettings = this.createPageBoSettings(sourceUltPage.getId(), uid, sourceApp, targetApp);
        return new Tuple2((Object)ultPage, pageBoSettings);
    }

    private Tuple2<UltPage, List<PageBoSetting>> createTenantUltPage(UltPage sourceTenantUltPage, App sourceApp, App targetApp, Long refUltPageId) {
        Long uid = IdWorker.getId();
        this.idMapThreadLocal.get().put(sourceTenantUltPage.getId(), uid);
        this.idMapForUpdateIdThreadLocal.get().put(sourceTenantUltPage.getId(), uid);
        UltPage tenantUltPage = UltPageStructMapper.MAPPER.clone(sourceTenantUltPage);
        tenantUltPage.setId(uid);
        tenantUltPage.setUniqueId(uid);
        tenantUltPage.setAppId(targetApp.getId());
        tenantUltPage.setVersion("0.0.0");
        tenantUltPage.setRefPageId(refUltPageId);
        List<PageBoSetting> tenantPageBoSettings = this.createPageBoSettings(sourceTenantUltPage.getId(), uid, sourceApp, targetApp);
        return new Tuple2((Object)tenantUltPage, tenantPageBoSettings);
    }

    private List<PageBoSetting> createPageBoSettings(Long sourceUltPageId, Long targetUltPageId, App sourceApp, App targetApp) {
        List sourcePageBoSettings = this.pageBoSettingRepository.getPageBoSettingsByPageId(sourceUltPageId);
        return sourcePageBoSettings.stream().map(s -> {
            PageBoSetting pageBoSetting = PageBoSettingStructMapper.MAPPER.clone(s);
            pageBoSetting.setPageId(targetUltPageId);
            pageBoSetting.setId(null);
            pageBoSetting.setUniqueId(null);
            pageBoSetting.setVersion("1");
            this.updatePageBoSetting(pageBoSetting, sourceApp, targetApp);
            return pageBoSetting;
        }).collect(Collectors.toList());
    }

    public ServiceResponse createApis(Long sourceAppId, Long targetAppId) {
        List sourceApis = this.apisRepository.getApis(sourceAppId);
        if (sourceApis.isEmpty()) {
            return ServiceResponse.success();
        }
        ServiceResponse serviceResponse = this.validateApis(targetAppId, sourceApis);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        List apis = sourceApis.stream().map(s -> {
            Long uid = IdWorker.getId();
            this.idMapForUpdateIdThreadLocal.get().put(s.getId(), uid);
            Apis api = ApisStructMapper.MAPPER.clone(s);
            api.setId(uid);
            api.setUniqueId(uid);
            api.setVersion("0.0.0");
            api.setApplicationId(String.valueOf(targetAppId));
            return api;
        }).collect(Collectors.toList());
        this.apisService.saveBatch(apis);
        return ServiceResponse.success();
    }

    public ServiceResponse createRules(Long sourceAppId, Long targetAppId) {
        List sourceRules = this.sueRuleRepository.getSueRules(sourceAppId);
        if (sourceRules.isEmpty()) {
            return ServiceResponse.success();
        }
        ServiceResponse serviceResponse = this.validateRules(targetAppId, sourceRules);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        ArrayList sueRules = Lists.newArrayList();
        ArrayList sueRuleParams = Lists.newArrayList();
        sourceRules.forEach(s -> {
            Tuple2<SueRule, List<SueRuleParam>> tpl = this.createRule((SueRule)s, targetAppId);
            sueRules.add(tpl._1);
            sueRuleParams.addAll((Collection)tpl._2);
        });
        this.sueRuleService.saveBatch((Collection)sueRules);
        this.sueRuleParamService.saveBatch((Collection)sueRuleParams);
        return ServiceResponse.success();
    }

    public Tuple2<SueRule, List<SueRuleParam>> createRule(SueRule sourceSueRule, Long targetAppId) {
        Long uid = IdWorker.getId();
        SueRule sueRule = SueRuleStructMapper.MAPPER.clone(sourceSueRule);
        sueRule.setId(uid);
        sueRule.setUniqueId(uid);
        sueRule.setVersion("0.0.0");
        sueRule.setAppId(String.valueOf(targetAppId));
        List sueRuleParams = this.sueRuleParamRepository.getRuleParams(sourceSueRule.getId()).stream().map(s -> this.createRuleParam(uid, (SueRuleParam)s)).collect(Collectors.toList());
        return new Tuple2((Object)sueRule, sueRuleParams);
    }

    public ServiceResponse createTags(Long sourceAppId, Long targetAppId) {
        List sourceTags = this.sueTagRepository.getSueTags(sourceAppId);
        if (sourceTags.isEmpty()) {
            return ServiceResponse.success();
        }
        ServiceResponse serviceResponse = this.validateTags(targetAppId, sourceTags);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        List sueTags = sourceTags.stream().map(schemaEntity -> {
            SueTag sueTag = SueTagStructMapper.MAPPER.clone(schemaEntity);
            sueTag.setId(null);
            sueTag.setUniqueId(null);
            sueTag.setVersion("0.0.0");
            sueTag.setAppId(String.valueOf(targetAppId));
            return sueTag;
        }).collect(Collectors.toList());
        this.sueTagService.saveBatch(sueTags);
        return ServiceResponse.success();
    }

    public ServiceResponse createAppEvents(Long sourceAppId, Long targetAppId) {
        List sourceAppEvents = this.appEventRepository.getAppEvents(sourceAppId);
        ServiceResponse serviceResponse = this.validateAppEvents(targetAppId, sourceAppEvents);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        List appEvents = sourceAppEvents.stream().map(s -> {
            Long uid = IdWorker.getId();
            this.idMapForUpdateIdThreadLocal.get().put(s.getId(), uid);
            AppEvent appEvent = AppEventStructMapper.MAPPER.clone(s);
            appEvent.setId(uid);
            appEvent.setUniqueId(uid);
            appEvent.setVersion("0.0.0");
            appEvent.setAppId(targetAppId);
            return appEvent;
        }).collect(Collectors.toList());
        this.appEventService.saveBatch(appEvents);
        return ServiceResponse.success();
    }

    public ServiceResponse createSdkSettings(Long sourceAppId, App targetApp) {
        List sourceSdkSettings = this.sdkSettingRepository.getSdkSettings(sourceAppId);
        List entitys = sourceSdkSettings.stream().filter(s -> !SdkSettingType.SDK20.code().equals(s.getType())).map(s -> {
            SdkSetting sdkSetting = SdkSettingStructMapper.MAPPER.clone(s);
            sdkSetting.setId(null);
            sdkSetting.setUniqueId(null);
            sdkSetting.setAppId(targetApp.getId());
            sdkSetting.setVersion("0.0.0");
            return sdkSetting;
        }).collect(Collectors.toList());
        this.sdkSettingService.saveBatch(entitys);
        List sourceSdk20Settings = sourceSdkSettings.stream().filter(s -> SdkSettingType.SDK20.code().equals(s.getType())).collect(Collectors.toList());
        List targetSdk20Settings = this.sdkSettingRepository.getSdkSettings(targetApp.getId(), SdkSettingType.SDK20);
        if (sourceSdk20Settings.size() == 1 && targetSdk20Settings.size() == 1) {
            String sdk20Sett = this.buildSync20Setting(targetApp, ((SdkSetting)sourceSdk20Settings.get(0)).getSetting(), ((SdkSetting)targetSdk20Settings.get(0)).getSetting());
            ((SdkSetting)targetSdk20Settings.get(0)).setSetting(sdk20Sett);
            this.idMapForUpdateIdThreadLocal.get().forEach((key, value) -> ((SdkSetting)targetSdk20Settings.get(0)).setSetting(((SdkSetting)targetSdk20Settings.get(0)).getSetting().replace(key.toString(), value.toString())));
            this.sdkSettingService.updateById(targetSdk20Settings.get(0));
        }
        return ServiceResponse.success();
    }

    public ServiceResponse createDataRules(Long sourceAppId, Long targetAppId) {
        List sourceDataRules = this.dataRuleRepository.getCustomDataRules(sourceAppId);
        ArrayList dataRules = Lists.newArrayList();
        ArrayList dataRuleDetails = Lists.newArrayList();
        sourceDataRules.forEach(s -> {
            DataRule dataRule = this.createDataRule((DataRule)s, targetAppId);
            dataRules.add(dataRule);
            dataRuleDetails.addAll(this.createDataRuleDetails(s.getId(), dataRule.getId()));
        });
        this.dataRuleService.saveBatch((Collection)dataRules);
        this.dataRuleDetailService.saveBatch((Collection)dataRuleDetails);
        dataRules.forEach(o -> {
            o.setBoId(this.idMapThreadLocal.get().get(o.getBoId()));
            o.setRefBoId(this.idMapThreadLocal.get().get(o.getRefBoId()));
        });
        return ServiceResponse.success();
    }

    public DataRule createDataRule(DataRule sourceDataRule, Long targetAppId) {
        Long uid = IdWorker.getId();
        DataRule dataRule = DataRuleStructMapper.MAPPER.clone(sourceDataRule);
        dataRule.setId(uid);
        dataRule.setUniqueId(uid);
        dataRule.setVersion("0.0.0");
        dataRule.setAppId(targetAppId);
        return dataRule;
    }

    private List<DataRuleDetail> createDataRuleDetails(Long sourceDataRuleId, Long targetDataRuleId) {
        List sourceDictDetails = this.dataRuleDetailRepository.getCustomDetails(sourceDataRuleId);
        return sourceDictDetails.stream().map(s -> {
            DataRuleDetail dataRuleDetail = DataRuleDetailStructMapper.MAPPER.clone(s);
            dataRuleDetail.setDataRuleId(targetDataRuleId);
            dataRuleDetail.setId(null);
            return dataRuleDetail;
        }).collect(Collectors.toList());
    }

    private FlowActionParam createActionParam(Long targetActionId, FlowActionParam sourceFlowActionParam) {
        FlowActionParam flowActionParam = FlowActionParamStructMapper.MAPPER.clone(sourceFlowActionParam);
        flowActionParam.setId(null);
        flowActionParam.setActionId(targetActionId);
        return flowActionParam;
    }

    private SueRuleParam createRuleParam(Long targetRuleId, SueRuleParam sourceSueRuleParam) {
        SueRuleParam sueRuleParam = SueRuleParamStructMapper.MAPPER.clone(sourceSueRuleParam);
        sueRuleParam.setId(null);
        sueRuleParam.setUniqueId(null);
        sueRuleParam.setRuleId(targetRuleId);
        return sueRuleParam;
    }

    private ServiceResponse validateDicts(List<Dict> sourceDicts, Long targetAppId) {
        List targetDicts = this.dictRepository.getDicts(targetAppId);
        if (targetDicts.isEmpty()) {
            return ServiceResponse.success();
        }
        List sourceCodes = sourceDicts.stream().map(Dict::getCode).distinct().collect(Collectors.toList());
        List targetCodes = targetDicts.stream().map(Dict::getCode).distinct().collect(Collectors.toList());
        List exsitCodes = sourceCodes.stream().filter(targetCodes::contains).collect(Collectors.toList());
        if (!exsitCodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u5b57\u5178\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", String.join((CharSequence)",", exsitCodes)));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateDictDetails(Long sourceDictId, List<DictDetail> sourceDictDetails) {
        if (CollectionUtils.isEmpty(sourceDictDetails)) {
            return ServiceResponse.success();
        }
        List dictDetailCodes = sourceDictDetails.stream().map(DictDetail::getCode).distinct().collect(Collectors.toList());
        return sourceDictDetails.size() == dictDetailCodes.size() ? ServiceResponse.success() : ServiceResponse.fail((String)String.format("\u5b57\u5178-%s \u5b57\u5178\u9879\u4ee3\u7801\u91cd\u590d", sourceDictId));
    }

    private ServiceResponse validateBos(List<Bo> sourceBos, Long targetAppId) {
        List targetBos = this.boRepository.getBos(targetAppId.longValue());
        if (targetBos.isEmpty()) {
            return ServiceResponse.success();
        }
        List sourceBoCodes = sourceBos.stream().map(Bo::getCode).distinct().collect(Collectors.toList());
        List targetBoCodes = targetBos.stream().map(Bo::getCode).distinct().collect(Collectors.toList());
        List exsitBocodes = sourceBoCodes.stream().filter(targetBoCodes::contains).collect(Collectors.toList());
        if (!exsitBocodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u5bf9\u8c61\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", String.join((CharSequence)",", exsitBocodes)));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateBoFields(Long sourceBoId, List<BoField> sourceBoFields) {
        if (CollectionUtils.isEmpty(sourceBoFields)) {
            return ServiceResponse.success();
        }
        List codes = sourceBoFields.stream().map(BoField::getCode).distinct().collect(Collectors.toList());
        return sourceBoFields.size() == codes.size() ? ServiceResponse.success() : ServiceResponse.fail((String)String.format("\u5bf9\u8c61-%s \u5b57\u6bb5\u4ee3\u7801\u91cd\u590d", sourceBoId));
    }

    private ServiceResponse validateBoRelationships(Long boId, List<BoRelationship> boRelationships) {
        if (CollectionUtils.isEmpty(boRelationships)) {
            return ServiceResponse.success();
        }
        List schemaCodes = boRelationships.stream().map(BoRelationship::getRelationCode).distinct().collect(Collectors.toList());
        return boRelationships.size() == schemaCodes.size() ? ServiceResponse.success() : ServiceResponse.fail((String)String.format("\u5bf9\u8c61-%s \u5173\u7cfb\u4ee3\u7801\u91cd\u590d", boId));
    }

    private ServiceResponse validateActions(List<FlowAction> sourceActions, Long targetAppId) {
        List targetActions = this.flowActionRepository.getFlowActions(targetAppId);
        if (targetActions.isEmpty()) {
            return ServiceResponse.success();
        }
        List sourceCodes = sourceActions.stream().map(FlowAction::getActionCode).distinct().collect(Collectors.toList());
        List targetCodes = targetActions.stream().map(FlowAction::getActionCode).distinct().collect(Collectors.toList());
        List exsitCodes = sourceCodes.stream().filter(targetCodes::contains).collect(Collectors.toList());
        if (!exsitCodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("ACTION\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", String.join((CharSequence)",", exsitCodes)));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateFlowSettings(List<FlowSetting> sourceFlowSettings, Long targetAppId) {
        List targetFlowSettings = this.flowSettingRepository.getFlowSettings(targetAppId);
        if (targetFlowSettings.isEmpty()) {
            return ServiceResponse.success();
        }
        List sourceCodes = sourceFlowSettings.stream().map(FlowSetting::getCode).distinct().collect(Collectors.toList());
        List targetCodes = targetFlowSettings.stream().map(FlowSetting::getCode).distinct().collect(Collectors.toList());
        List exsitCodes = sourceCodes.stream().filter(targetCodes::contains).collect(Collectors.toList());
        if (!exsitCodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u6d41\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", String.join((CharSequence)",", exsitCodes)));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateApis(Long targetAppId, List<Apis> sourceApis) {
        List targetApis = this.apisRepository.getApis(targetAppId);
        if (targetApis.isEmpty()) {
            return ServiceResponse.success();
        }
        List sourceApiCodes = sourceApis.stream().map(Apis::getApiCode).distinct().collect(Collectors.toList());
        List targetApiCodes = targetApis.stream().map(Apis::getApiCode).distinct().collect(Collectors.toList());
        List exsitCodes = sourceApiCodes.stream().filter(targetApiCodes::contains).collect(Collectors.toList());
        if (!exsitCodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("API\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", String.join((CharSequence)",", exsitCodes)));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateRules(Long targetAppId, List<SueRule> sourceRules) {
        List targetRules = this.sueRuleRepository.getSueRules(targetAppId);
        if (targetRules.isEmpty()) {
            return ServiceResponse.success();
        }
        List sourceCodes = sourceRules.stream().map(SueRule::getRuleCode).distinct().collect(Collectors.toList());
        List targetCodes = targetRules.stream().map(SueRule::getRuleCode).distinct().collect(Collectors.toList());
        List exsitCodes = sourceCodes.stream().filter(targetCodes::contains).collect(Collectors.toList());
        if (!exsitCodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u89c4\u5219\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", String.join((CharSequence)",", exsitCodes)));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateTags(Long appId, List<SueTag> schemaEntitys) {
        List entitys = this.sueTagRepository.getSueTags(appId);
        if (entitys.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaEntityCodes = schemaEntitys.stream().map(SueTag::getTagCode).distinct().collect(Collectors.toList());
        List entityCodes = entitys.stream().map(SueTag::getTagCode).distinct().collect(Collectors.toList());
        List exsitSchemaEntitycodes = schemaEntityCodes.stream().filter(entityCodes::contains).collect(Collectors.toList());
        if (!exsitSchemaEntitycodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u6807\u7b7e\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", String.join((CharSequence)",", exsitSchemaEntitycodes)));
        }
        return ServiceResponse.success();
    }

    private ServiceResponse validateAppEvents(Long appId, List<AppEvent> schemaEntitys) {
        List entitys = this.appEventRepository.getAppEvents(appId);
        if (entitys.isEmpty()) {
            return ServiceResponse.success();
        }
        List schemaEntityCodes = schemaEntitys.stream().map(AppEvent::getEventCode).distinct().collect(Collectors.toList());
        List entityCodes = entitys.stream().map(AppEvent::getEventCode).distinct().collect(Collectors.toList());
        List exsitSchemaEntityCodes = schemaEntityCodes.stream().filter(entityCodes::contains).collect(Collectors.toList());
        if (!exsitSchemaEntityCodes.isEmpty()) {
            return ServiceResponse.fail((String)String.format("\u4e8b\u4ef6\u4ee3\u7801\u5df2\u5b58\u5728\uff1a%s", String.join((CharSequence)",", exsitSchemaEntityCodes)));
        }
        return ServiceResponse.success();
    }

    private void updateFormSetting(UltForm ultForm, App sourceApp, App targetApp) {
        if (StringUtils.isNotEmpty((CharSequence)ultForm.getSetting())) {
            List toManyRelationApiQueryUrls;
            ultForm.setSetting(ultForm.getSetting().replace(sourceApp.getCode(), targetApp.getCode()));
            Long boId = PageFormBoSettingParseUtil.getEntityId((String)ultForm.getSetting());
            if (null != boId) {
                Optional.ofNullable(this.idMapThreadLocal.get().get(boId)).ifPresent(boIdReplace -> ultForm.setSetting(ultForm.getSetting().replace(boId.toString(), boIdReplace.toString())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(toManyRelationApiQueryUrls = PageFormBoSettingParseUtil.getToManyRelationApiQueryUrls((String)ultForm.getSetting())))) {
                toManyRelationApiQueryUrls.forEach(url -> {
                    String[] parts = url.split("/");
                    if (parts.length >= 6 && StringUtils.isNumeric((CharSequence)parts[5])) {
                        Optional.ofNullable(this.idMapThreadLocal.get().get(Long.parseLong(parts[5]))).ifPresent(boIdReplace -> ultForm.setSetting(ultForm.getSetting().replace(parts[5], boIdReplace.toString())));
                    }
                });
            }
            List<Object> enumIdStrList = Lists.newArrayList();
            enumIdStrList.addAll(PageFormBoSettingParseUtil.getEnumFieldEnumIds((String)ultForm.getSetting()));
            enumIdStrList.addAll(PageFormBoSettingParseUtil.getToManyRelationEnumFieldEnunIds((String)ultForm.getSetting()));
            enumIdStrList = enumIdStrList.stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)enumIdStrList)) {
                enumIdStrList.forEach(enumIdStr -> Optional.ofNullable(this.idMapThreadLocal.get().get(Long.parseLong(enumIdStr))).ifPresent(boIdReplace -> ultForm.setSetting(ultForm.getSetting().replace((CharSequence)enumIdStr, boIdReplace.toString()))));
            }
        }
    }

    private void updatePageBoSetting(PageBoSetting pageBoSett, App sourceApp, App targetApp) {
        if (StringUtils.isNotEmpty((CharSequence)pageBoSett.getSetting())) {
            List toManyRelationApiQueryUrls;
            pageBoSett.setSetting(pageBoSett.getSetting().replace(sourceApp.getCode(), targetApp.getCode()));
            Long boId = PageFormBoSettingParseUtil.getEntityId((String)pageBoSett.getSetting());
            if (null != boId) {
                Optional.ofNullable(this.idMapThreadLocal.get().get(boId)).ifPresent(boIdReplace -> pageBoSett.setSetting(pageBoSett.getSetting().replace(boId.toString(), boIdReplace.toString())));
            }
            if (CollectionUtils.isNotEmpty((Collection)(toManyRelationApiQueryUrls = PageFormBoSettingParseUtil.getToManyRelationApiQueryUrls((String)pageBoSett.getSetting())))) {
                toManyRelationApiQueryUrls.forEach(url -> {
                    String[] parts = url.split("/");
                    if (parts.length >= 6 && StringUtils.isNumeric((CharSequence)parts[5])) {
                        Optional.ofNullable(this.idMapThreadLocal.get().get(Long.parseLong(parts[5]))).ifPresent(boIdReplace -> pageBoSett.setSetting(pageBoSett.getSetting().replace(parts[5], boIdReplace.toString())));
                    }
                });
            }
            List<Object> enumIdStrList = Lists.newArrayList();
            enumIdStrList.addAll(PageFormBoSettingParseUtil.getEnumFieldEnumIds((String)pageBoSett.getSetting()));
            enumIdStrList.addAll(PageFormBoSettingParseUtil.getToManyRelationEnumFieldEnunIds((String)pageBoSett.getSetting()));
            enumIdStrList = enumIdStrList.stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)enumIdStrList)) {
                enumIdStrList.forEach(enumIdStr -> Optional.ofNullable(this.idMapThreadLocal.get().get(Long.parseLong(enumIdStr))).ifPresent(boIdReplace -> pageBoSett.setSetting(pageBoSett.getSetting().replace((CharSequence)enumIdStr, boIdReplace.toString()))));
            }
        }
    }

    private void updateFlowSetting(FlowSetting flow, Long sourceAppId, Long targetAppId) {
        if (StringUtils.isNotEmpty((CharSequence)flow.getFlowSetting())) {
            flow.setFlowSetting(flow.getFlowSetting().replace(sourceAppId.toString(), targetAppId.toString()));
            this.idMapForUpdateIdThreadLocal.get().forEach((key, value) -> flow.setFlowSetting(flow.getFlowSetting().replace(key.toString(), value.toString())));
        }
        if (StringUtils.isNotEmpty((CharSequence)flow.getFlowSettingFront())) {
            flow.setFlowSettingFront(flow.getFlowSettingFront().replace(sourceAppId.toString(), targetAppId.toString()));
            this.idMapForUpdateIdThreadLocal.get().forEach((key, value) -> flow.setFlowSettingFront(flow.getFlowSettingFront().replace(key.toString(), value.toString())));
        }
    }

    private String buildSync20Setting(App targetApp, String sourceSdkSetting, String targetSdkSetting) {
        Map targetSett = Maps.newHashMap();
        try {
            if (StringUtils.isNotBlank((CharSequence)targetSdkSetting)) {
                targetSett = (Map)JSON.parseObject((String)targetSdkSetting, Map.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!targetSett.containsKey("appCodeForDB")) {
            targetSett.put("appCodeForDB", AppDBUtil.getAppCodeForDB((String)targetApp.getCode()));
        }
        try {
            HashMap sourceSett = StringUtils.isBlank((CharSequence)sourceSdkSetting) ? Maps.newHashMap() : (Map)JSON.parseObject((String)sourceSdkSetting, Map.class);
            sourceSett.remove("appCodeForDB");
            sourceSett.forEach(targetSett::putIfAbsent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JSON.toJSONString((Object)targetSett);
    }
}

