/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.datasource.impl;

import com.xforceplus.ultraman.bocp.metadata.dto.DataSourceConfig;
import com.xforceplus.ultraman.bocp.metadata.enums.DataBaseType;
import com.xforceplus.ultraman.bocp.metadata.enums.DataValueType;
import com.xforceplus.ultraman.bocp.metadata.web.datasource.impl.AbstractSchemaService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SchemaServiceDB2Impl
extends AbstractSchemaService {
    @Override
    public DataBaseType getSchemaType() {
        return DataBaseType.DB2;
    }

    @Override
    protected Map<String, DataValueType> getValueMapping() {
        return new HashMap<String, DataValueType>(){
            {
                this.put("varchar", DataValueType.STRING);
                this.put("bigint", DataValueType.LONG);
                this.put("integer", DataValueType.LONG);
                this.put("smallint", DataValueType.LONG);
                this.put("decimal", DataValueType.BIG_DECIMAL);
                this.put("double", DataValueType.BIG_DECIMAL);
                this.put("char", DataValueType.STRING);
                this.put("date", DataValueType.STRING);
                this.put("time", DataValueType.STRING);
                this.put("timestamp", DataValueType.LOCAL_DATE_TIME);
            }
        };
    }

    @Override
    protected String getQueryColumnSql() {
        return "SELECT tabname AS tableName, colname AS columnName, typename AS columnType, remarks AS columnComment FROM syscat.columns WHERE tabname = ?";
    }

    @Override
    protected String getQueryTableSql() {
        return "SELECT tabname AS tableName, remarks AS tableComment, tabschema AS databaseName FROM syscat.tables WHERE tabschema = ?";
    }

    @Override
    protected String getJdbcUrl(DataSourceConfig config) {
        String url = "jdbc:db2://" + config.getUrl() + ":" + config.getPort();
        if (config.getSchema() != null && !config.getSchema().isEmpty()) {
            url = url + "/" + config.getSchema();
        }
        return url;
    }
}

