/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.core;

import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.BaseHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.CustomTypeHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.Dispatchable;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.HandledBy;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.strategy.CustomTypeStrategy;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CustomTypeDispatcher {
    private final ApplicationContext applicationContext;
    private final CustomTypeHandler customTypeHandler;
    private final Map<AppCustomType, CustomTypeStrategy> strategyMap;

    public CustomTypeDispatcher(ApplicationContext applicationContext, CustomTypeHandler customTypeHandler, CustomTypeStrategy standardStrategy, CustomTypeStrategy tenantStrategy, CustomTypeStrategy customStrategy) {
        this.applicationContext = applicationContext;
        this.customTypeHandler = customTypeHandler;
        this.strategyMap = new HashMap<AppCustomType, CustomTypeStrategy>();
        this.strategyMap.put(AppCustomType.STANDARD, standardStrategy);
        this.strategyMap.put(AppCustomType.TENANT, tenantStrategy);
        this.strategyMap.put(AppCustomType.CUSTOM, customStrategy);
    }

    public <TResult> TResult dispatch(Dispatchable<TResult> dispatchable) {
        HandledBy handledByAnnotation = dispatchable.getClass().getAnnotation(HandledBy.class);
        if (handledByAnnotation == null) {
            throw new IllegalStateException(String.format("No @HandledBy annotation provided for dispatchable %s", dispatchable.getClass().getSimpleName()));
        }
        Class<? extends BaseHandler<? extends Dispatchable<?>, ?>> handlerType = handledByAnnotation.handler();
        Map handlers = this.applicationContext.getBeansOfType(handlerType);
        if (handlers.isEmpty()) {
            throw new IllegalStateException(String.format("Dispatchable %s has no handler", dispatchable.getClass().getSimpleName()));
        }
        if (handlers.size() > 1) {
            throw new IllegalStateException(String.format("Dispatchable %s has more than one handler", dispatchable.getClass().getSimpleName()));
        }
        BaseHandler handler = (BaseHandler)handlers.values().iterator().next();
        AppCustomType appCustomType = this.customTypeHandler.getCustomType(dispatchable);
        if (null == appCustomType) {
            throw new RuntimeException("CustomType is null");
        }
        CustomTypeStrategy strategy = this.strategyMap.get(appCustomType);
        if (strategy == null) {
            throw new RuntimeException("Unknown CustomType");
        }
        return strategy.execute(handler, dispatchable);
    }
}

