/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.handler;

import com.xforceplus.ultraman.bocp.metadata.service.IAppModuleExService;
import com.xforceplus.ultraman.bocp.metadata.vo.BoEx;
import com.xforceplus.ultraman.bocp.metadata.vo.QueryBoVo;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.QueryHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.GetBosQuery;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantBoExService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetBosQueryHandler
implements QueryHandler<GetBosQuery, List<BoEx>> {
    @Autowired
    private IAppModuleExService appModuleExService;
    @Autowired
    private ITenantBoExService tenantBoExService;

    @Override
    public List<BoEx> handleStandard(GetBosQuery query) {
        return this.appModuleExService.getBos(query.getQueryBoVo()).stream().map(o -> o.setAppCustomType(AppCustomType.STANDARD.code())).collect(Collectors.toList());
    }

    @Override
    public List<BoEx> handleTenant(GetBosQuery query) {
        QueryBoVo queryBoVo = query.getQueryBoVo();
        List<Object> result = this.tenantBoExService.getBos(queryBoVo.getAppId());
        if (null != queryBoVo.getId()) {
            result = result.stream().filter(r -> queryBoVo.getId().equals(r.getId())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryBoVo.getNameOrCode())) {
            result = result.stream().filter(r -> r.getName().contains(queryBoVo.getNameOrCode()) || r.getCode().contains(queryBoVo.getNameOrCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryBoVo.getBoType())) {
            result = result.stream().filter(r -> queryBoVo.getBoType().equals(r.getBoType())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryBoVo.getAppCustomType())) {
            result = result.stream().filter(r -> queryBoVo.getAppCustomType().equals(r.getAppCustomType())).collect(Collectors.toList());
        }
        result.forEach(o -> o.setId(o.getUniqueId()));
        return result;
    }

    @Override
    public List<BoEx> handleCustom(GetBosQuery query) {
        return null;
    }
}

